/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.SqlScriptStatement;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class SQLEditor {
    private static Class<?> PKG = SQLEditor.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("SQL Editor", LoggingObjectType.SPOON, null);
    private PropsUI props = PropsUI.getInstance();
    private Label wlScript;
    private StyledTextComp wScript;
    private FormData fdlScript;
    private FormData fdScript;
    private Label wlPosition;
    private FormData fdlPosition;
    private Button wExec;
    private Button wClear;
    private Button wCancel;
    private Listener lsExec;
    private Listener lsClear;
    private Listener lsCancel;
    private String input;
    private DatabaseMeta connection;
    private Shell shell;
    private DBCache dbcache;
    private LogChannelInterface log;
    private int style = 3312;
    private Shell parentShell;
    private VariableSpace variables;
    private List<SqlScriptStatement> statements;
    private SQLValuesHighlight highlight;

    public SQLEditor(Shell parent, int style, DatabaseMeta ci, DBCache dbc, String sql) {
        this(null, parent, style, ci, dbc, sql);
    }

    public SQLEditor(VariableSpace space, Shell parent, int style, DatabaseMeta ci, DBCache dbc, String sql) {
        this.log = new LogChannel((Object)ci);
        this.input = sql;
        this.connection = ci;
        this.dbcache = dbc;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.variables = space;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, this.style);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageConnection());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Title", (String[])new String[0]));
        int margin = 4;
        this.wlScript = new Label((Composite)this.shell, 0);
        this.wlScript.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Editor.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlScript);
        this.fdlScript = new FormData();
        this.fdlScript.left = new FormAttachment(0, 0);
        this.fdlScript.top = new FormAttachment(0, 0);
        this.wlScript.setLayoutData((Object)this.fdlScript);
        this.wScript = new StyledTextComp(this.variables, (Composite)this.shell, 19202, "");
        this.wScript.setText("");
        this.props.setLook((Control)this.wScript, 1);
        this.fdScript = new FormData();
        this.fdScript.left = new FormAttachment(0, 0);
        this.fdScript.top = new FormAttachment((Control)this.wlScript, margin);
        this.fdScript.right = new FormAttachment(100, -10);
        this.fdScript.bottom = new FormAttachment(100, -70);
        this.wScript.setLayoutData(this.fdScript);
        this.wScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SQLEditor.this.setPosition();
            }
        });
        this.wScript.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SQLEditor.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                SQLEditor.this.setPosition();
            }
        });
        this.wScript.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SQLEditor.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                SQLEditor.this.setPosition();
            }
        });
        this.wScript.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SQLEditor.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                SQLEditor.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                SQLEditor.this.setPosition();
            }
        });
        this.highlight = new SQLValuesHighlight();
        this.highlight.addKeyWords(this.connection.getReservedWords());
        this.wScript.addLineStyleListener(this.highlight);
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"SQLEditor.LineNr.Label", (String[])new String[]{"0"}));
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.top = new FormAttachment((Control)this.wScript, margin);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wExec = new Button((Composite)this.shell, 8);
        this.wExec.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.Execute", (String[])new String[0]));
        this.wClear = new Button((Composite)this.shell, 8);
        this.wClear.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.ClearCache", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wClear.setToolTipText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.ClearCache.Tooltip", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wExec, this.wClear, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SQLEditor.this.cancel();
            }
        };
        this.lsClear = new Listener(){

            public void handleEvent(Event e) {
                SQLEditor.this.clearCache();
            }
        };
        this.lsExec = new Listener(){

            public void handleEvent(Event e) {
                try {
                    SQLEditor.this.exec();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wClear.addListener(13, this.lsClear);
        this.wExec.addListener(13, this.lsExec);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SQLEditor.this.cancel();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.getData();
        this.shell.open();
    }

    public void setPosition() {
        String scr = this.wScript.getText();
        int linenr = this.wScript.getLineAtOffset(this.wScript.getCaretOffset()) + 1;
        int posnr = this.wScript.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    private void clearCache() {
        MessageBox mb = new MessageBox(this.shell, 452);
        mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.ClearWholeCache.Message", (String[])new String[]{this.connection.getName()}));
        mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.ClearWholeCache.Title", (String[])new String[0]));
        int answer = mb.open();
        switch (answer) {
            case 128: {
                DBCache.getInstance().clear(this.connection.getName());
                mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.ConnectionCacheCleared.Message", (String[])new String[]{this.connection.getName()}));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.ConnectionCacheCleared.Title", (String[])new String[0]));
                mb.open();
                break;
            }
            case 64: {
                DBCache.getInstance().clear(null);
                mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.WholeCacheCleared.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.WholeCacheCleared.Title", (String[])new String[0]));
                mb.open();
                break;
            }
            case 256: {
                break;
            }
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.input != null) {
            this.wScript.setText(this.input);
        }
    }

    private void cancel() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec() {
        DatabaseMeta ci = this.connection;
        if (ci == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        Database db = new Database(loggingObject, ci);
        boolean first = true;
        PartitionDatabaseMeta[] partitioningInformation = ci.getPartitioningInformation();
        for (int partitionNr = 0; first || partitioningInformation != null && partitionNr < partitioningInformation.length; ++partitionNr) {
            first = false;
            String partitionId = null;
            if (partitioningInformation != null && partitioningInformation.length > 0) {
                partitionId = partitioningInformation[partitionNr].getPartitionId();
            }
            try {
                db.connect(partitionId);
                String sqlScript = Utils.isEmpty((CharSequence)this.wScript.getSelectionText()) ? this.wScript.getText() : this.wScript.getSelectionText();
                this.statements = ci.getDatabaseInterface().getSqlScriptStatements(sqlScript + Const.CR);
                int nrstats = 0;
                for (SqlScriptStatement sql : this.statements) {
                    if (sql.isQuery()) {
                        this.log.logDetailed("launch SELECT statement: " + Const.CR + sql);
                        ++nrstats;
                        try {
                            List rows = db.getRows(sql.getStatement(), 1000);
                            RowMetaInterface rowMeta = db.getReturnRowMeta();
                            if (rows.size() > 0) {
                                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)ci, 0, BaseMessages.getString(PKG, (String)"SQLEditor.ResultRows.Title", (String[])new String[]{Integer.toString(nrstats)}), rowMeta, rows);
                                prd.open();
                                continue;
                            }
                            MessageBox mb = new MessageBox(this.shell, 34);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.NoRows.Message", (Object[])new Object[]{sql}));
                            mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.NoRows.Title", (String[])new String[0]));
                            mb.open();
                        }
                        catch (KettleDatabaseException dbe) {
                            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Message", (Object[])new Object[]{sql}), (Exception)((Object)dbe));
                        }
                        continue;
                    }
                    this.log.logDetailed("launch DDL statement: " + Const.CR + sql);
                    ++nrstats;
                    int startLogLine = KettleLogStore.getLastBufferLineNr();
                    try {
                        this.log.logDetailed("Executing SQL: " + Const.CR + sql);
                        db.execStatement(sql.getStatement());
                        message.append(BaseMessages.getString(PKG, (String)"SQLEditor.Log.SQLExecuted", (Object[])new Object[]{sql}));
                        message.append(Const.CR);
                        if (this.dbcache != null) {
                            this.dbcache.clear(ci.getName());
                        }
                        sql.setOk(true);
                    }
                    catch (Exception dbe) {
                        sql.setOk(false);
                        String error = BaseMessages.getString(PKG, (String)"SQLEditor.Log.SQLExecError", (Object[])new Object[]{sql, dbe.toString()});
                        message.append(error).append(Const.CR);
                        ErrorDialog dialog = new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Title", (String[])new String[0]), error, dbe, true);
                        if (!dialog.isCancelled()) continue;
                        break;
                    }
                    finally {
                        int endLogLine = KettleLogStore.getLastBufferLineNr();
                        sql.setLoggingText(KettleLogStore.getAppender().getLogBufferFromTo(db.getLogChannelId(), true, startLogLine, endLogLine).toString());
                        sql.setComplete(true);
                        this.refreshExecutionResults();
                    }
                }
                message.append(BaseMessages.getString(PKG, (String)"SQLEditor.Log.StatsExecuted", (String[])new String[]{Integer.toString(nrstats)}));
                if (partitionId != null) {
                    message.append(BaseMessages.getString(PKG, (String)"SQLEditor.Log.OnPartition", (String[])new String[]{partitionId}));
                }
                message.append(Const.CR);
                continue;
            }
            catch (KettleDatabaseException dbe) {
                MessageBox mb = new MessageBox(this.shell, 33);
                String error = BaseMessages.getString(PKG, (String)"SQLEditor.Error.CouldNotConnect.Message", (String[])new String[]{this.connection == null ? "" : this.connection.getName(), dbe.getMessage()});
                message.append(error).append(Const.CR);
                mb.setMessage(error);
                mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Error.CouldNotConnect.Title", (String[])new String[0]));
                mb.open();
                continue;
            }
            finally {
                db.disconnect();
                this.refreshExecutionResults();
            }
        }
        EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.Result.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLEditor.Result.Message", (String[])new String[0]), message.toString(), true);
        dialog.open();
    }

    protected void refreshExecutionResults() {
        this.highlight.setScriptStatements(this.statements);
        this.wScript.redraw();
    }
}

