/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.di.version.BuildVersion;

public class Splash {
    private Shell splash;
    private Image kettle_image;
    private Image kettle_icon;
    private Image exclamation_image;
    private Font verFont;
    private Font licFont;
    private Font devWarningFont;
    private Color versionWarningBackgroundColor;
    private Color versionWarningForegroundColor;
    private int licFontSize = 8;
    private static Class<?> PKG = Splash.class;
    private static LogChannelInterface log;

    public Splash(Display display) throws KettleException {
        this(display, new Shell(display, 65536));
    }

    protected Splash(final Display display, Shell splashShell) throws KettleException {
        log = new LogChannel((Object)Spoon.APP_NAME);
        Rectangle displayBounds = display.getPrimaryMonitor().getBounds();
        this.kettle_image = this.loadAsResource(display, BasePropertyHandler.getProperty((String)"splash_image"));
        this.kettle_icon = this.loadAsResource(display, BasePropertyHandler.getProperty((String)"splash_icon"));
        this.exclamation_image = this.loadAsResource(display, BasePropertyHandler.getProperty((String)"exclamation_image"));
        this.verFont = new Font((Device)display, "Helvetica", 11, 1);
        this.licFont = new Font((Device)display, "Helvetica", this.licFontSize, 0);
        this.devWarningFont = new Font((Device)display, "Helvetica", 10, 0);
        this.versionWarningBackgroundColor = new Color((Device)display, 255, 255, 255);
        this.versionWarningForegroundColor = new Color((Device)display, 220, 177, 20);
        this.splash = splashShell;
        this.splash.setImage(this.kettle_icon);
        this.splash.setText(BaseMessages.getString(PKG, (String)"SplashDialog.Title", (String[])new String[0]));
        this.splash.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StringBuilder sb = new StringBuilder();
                String line = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Splash.class.getClassLoader().getResourceAsStream("org/pentaho/di/ui/core/dialog/license/license.txt")));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line + System.getProperty("line.separator"));
                    }
                }
                catch (Exception ex) {
                    sb.append("");
                    log.logError(BaseMessages.getString((Class)PKG, (String)"SplashDialog.LicenseTextNotFound", (String[])new String[0]), (Throwable)ex);
                }
                Calendar cal = Calendar.getInstance();
                String licenseText = String.format(sb.toString(), cal);
                e.gc.drawImage(Splash.this.kettle_image, 0, 0);
                String fullVersionText = BaseMessages.getString((Class)PKG, (String)"SplashDialog.Version", (String[])new String[0]);
                String buildVersion = BuildVersion.getInstance().getVersion();
                fullVersionText = StringUtils.ordinalIndexOf((String)buildVersion, (String)".", (int)2) > 0 ? fullVersionText + " " + buildVersion.substring(0, StringUtils.ordinalIndexOf((String)buildVersion, (String)".", (int)2)) : fullVersionText + " " + buildVersion;
                e.gc.setFont(Splash.this.verFont);
                e.gc.setForeground(display.getSystemColor(1));
                e.gc.drawText(fullVersionText, 290, 205, true);
                String inputStringDate = BuildVersion.getInstance().getBuildDate();
                String outputStringDate = "";
                SimpleDateFormat inputFormat = null;
                SimpleDateFormat outputFormat = null;
                if (inputStringDate.matches("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}.\\d{3}$")) {
                    inputFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");
                }
                if (inputStringDate.matches("^\\d{4}-\\d{1,2}-\\d{1,2}\\_\\d{1,2}-\\d{2}-\\d{2}$")) {
                    inputFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
                }
                if (inputStringDate.matches("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}.\\d{2}.\\d{2}$")) {
                    inputFormat = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
                }
                outputFormat = new SimpleDateFormat("MMMM d, yyyy hh:mm:ss");
                try {
                    if (inputFormat != null) {
                        Date date = inputFormat.parse(inputStringDate);
                        outputStringDate = outputFormat.format(date);
                    } else {
                        outputStringDate = inputStringDate;
                    }
                }
                catch (ParseException pe) {
                    outputStringDate = inputStringDate;
                }
                e.gc.setFont(Splash.this.licFont);
                e.gc.setForeground(display.getSystemColor(1));
                while (!Splash.this.willLicenseTextFit(licenseText, e.gc)) {
                    Splash.this.licFontSize--;
                    if (Splash.this.licFont != null) {
                        Splash.this.licFont.dispose();
                    }
                    Splash.this.licFont = new Font((Device)e.display, "Helvetica", Splash.this.licFontSize, 0);
                    e.gc.setFont(Splash.this.licFont);
                }
                e.gc.drawText(licenseText, 290, 275, true);
                String version = buildVersion;
                if (Const.RELEASE.equals((Object)Const.ReleaseType.MILESTONE)) {
                    version = BaseMessages.getString((Class)PKG, (String)"SplashDialog.DeveloperRelease", (String[])new String[0]) + " - " + version;
                    Splash.this.drawVersionWarning(e);
                } else if (Const.RELEASE.equals((Object)Const.ReleaseType.RELEASE_CANDIDATE)) {
                    version = BaseMessages.getString((Class)PKG, (String)"SplashDialog.ReleaseCandidate", (String[])new String[0]) + " - " + version;
                } else if (Const.RELEASE.equals((Object)Const.ReleaseType.PREVIEW)) {
                    version = BaseMessages.getString((Class)PKG, (String)"SplashDialog.PreviewRelease", (String[])new String[0]) + " - " + version;
                } else if (Const.RELEASE.equals((Object)Const.ReleaseType.GA)) {
                    version = BaseMessages.getString((Class)PKG, (String)"SplashDialog.GA", (String[])new String[0]) + " - " + version;
                }
                String buildDate = BaseMessages.getString((Class)PKG, (String)"SplashDialog.BuildDate", (String[])new String[0]) + " " + outputStringDate;
                e.gc.setForeground(display.getSystemColor(1));
                e.gc.drawText(version, 290, 235, true);
                e.gc.drawText(buildDate, 290, 250, true);
            }
        });
        this.splash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Splash.this.kettle_image.dispose();
                Splash.this.kettle_icon.dispose();
                Splash.this.exclamation_image.dispose();
                Splash.this.verFont.dispose();
                Splash.this.licFont.dispose();
                Splash.this.devWarningFont.dispose();
                Splash.this.versionWarningForegroundColor.dispose();
                Splash.this.versionWarningBackgroundColor.dispose();
            }
        });
        Rectangle bounds = this.kettle_image.getBounds();
        int x = (displayBounds.width - bounds.width) / 2;
        int y = (displayBounds.height - bounds.height) / 2;
        this.splash.setSize(bounds.width, bounds.height);
        this.splash.setLocation(x, y);
        this.splash.open();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    Splash.this.splash.redraw();
                    LogChannel.UI.logBasic("Redraw!");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        final Timer timer = new Timer();
        timer.schedule(timerTask, 0L, 100L);
        this.splash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                timer.cancel();
            }
        });
    }

    private Image loadAsResource(Display display, String location) {
        SwtUniversalImage img = SwtSvgImageUtil.getImageAsResource(display, location);
        Image image = new Image((Device)display, img.getAsBitmap((Device)display), 0);
        img.dispose();
        return image;
    }

    private boolean willLicenseTextFit(String licenseText, GC gc) {
        Point splashSize = this.splash.getSize();
        Point licenseDrawLocation = new Point(290, 290);
        Point requiredSize = gc.textExtent(licenseText);
        int width = splashSize.x - licenseDrawLocation.x;
        int height = splashSize.y - licenseDrawLocation.y;
        boolean fitsVertically = width >= requiredSize.x;
        boolean fitsHorizontally = height >= requiredSize.y;
        return fitsVertically && fitsHorizontally;
    }

    private void drawVersionWarning(PaintEvent e) {
        this.drawVersionWarning(e.gc, e.display);
    }

    private void drawVersionWarning(GC gc, Display display) {
        gc.setBackground(this.versionWarningBackgroundColor);
        gc.setForeground(display.getSystemColor(1));
        gc.drawImage(this.exclamation_image, 304, 243);
        gc.setFont(this.devWarningFont);
        gc.drawText(BaseMessages.getString(PKG, (String)"SplashDialog.DevelopmentWarning", (String[])new String[0]), 335, 241, true);
    }

    public void dispose() {
        if (!this.splash.isDisposed()) {
            this.splash.dispose();
        }
    }

    public void hide() {
        if (!this.splash.isDisposed()) {
            this.splash.setVisible(false);
        }
    }

    public void show() {
        if (!this.splash.isDisposed()) {
            this.splash.setVisible(true);
        }
    }
}

