/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.MessagesStore;

public class SourceStore {
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private Map<String, MessagesStore> messagesMap;
    private String locale;
    protected LogChannelInterface log;
    private String sourceFolder;

    public SourceStore(LogChannelInterface log, String locale, String sourceFolder, Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.log = log;
        this.locale = locale;
        this.sourceFolder = sourceFolder;
        this.sourcePackageOccurrences = sourcePackageOccurrences;
        this.messagesMap = new HashMap<String, MessagesStore>();
    }

    public void read(List<String> directories) throws KettleException {
        Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(this.sourceFolder);
        for (String messagesPackage : po.keySet()) {
            MessagesStore messagesStore = new MessagesStore(this.locale, this.sourceFolder, messagesPackage, this.sourcePackageOccurrences);
            try {
                messagesStore.read(directories);
                this.messagesMap.put(messagesPackage, messagesStore);
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, MessagesStore> getMessagesMap() {
        return this.messagesMap;
    }
}

