/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.mailvalidator;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.mailvalidator.JobEntryMailValidator;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryMailValidatorDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryMailValidator.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryMailValidator jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private LabelTextVar wMailAddress;
    private FormData fdMailAddress;
    private Display display;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private Label wleMailSender;
    private TextVar weMailSender;
    private FormData fdleMailSender;
    private FormData fdeMailSender;
    private Label wlTimeOut;
    private TextVar wTimeOut;
    private FormData fdlTimeOut;
    private FormData fdTimeOut;
    private Label wlDefaultSMTP;
    private TextVar wDefaultSMTP;
    private FormData fdlDefaultSMTP;
    private FormData fdDefaultSMTP;
    private Label wlSMTPCheck;
    private FormData fdlSMTPCheck;
    private Button wSMTPCheck;
    private FormData fdSMTPCheck;

    public JobEntryMailValidatorDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryMailValidator)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryMailValidatorDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, 0);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, margin);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wMailAddress = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.MailAddress.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.MailAddress.Tooltip", (String[])new String[0]));
        this.wMailAddress.addModifyListener(lsMod);
        this.fdMailAddress = new FormData();
        this.fdMailAddress.left = new FormAttachment(0, 0);
        this.fdMailAddress.top = new FormAttachment((Control)this.wName, margin);
        this.fdMailAddress.right = new FormAttachment(100, 0);
        this.wMailAddress.setLayoutData(this.fdMailAddress);
        this.wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.Group.SettingsAddress.Label", (String[])new String[0]));
        FormLayout SettingsgroupLayout = new FormLayout();
        SettingsgroupLayout.marginWidth = 10;
        SettingsgroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)SettingsgroupLayout);
        this.wlSMTPCheck = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlSMTPCheck.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.SMTPCheck.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSMTPCheck);
        this.fdlSMTPCheck = new FormData();
        this.fdlSMTPCheck.left = new FormAttachment(0, 0);
        this.fdlSMTPCheck.top = new FormAttachment((Control)this.wMailAddress, margin);
        this.fdlSMTPCheck.right = new FormAttachment(middle, -2 * margin);
        this.wlSMTPCheck.setLayoutData((Object)this.fdlSMTPCheck);
        this.wSMTPCheck = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wSMTPCheck);
        this.wSMTPCheck.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.SMTPCheck.Tooltip", (String[])new String[0]));
        this.fdSMTPCheck = new FormData();
        this.fdSMTPCheck.left = new FormAttachment(middle, -margin);
        this.fdSMTPCheck.top = new FormAttachment((Control)this.wMailAddress, margin);
        this.wSMTPCheck.setLayoutData((Object)this.fdSMTPCheck);
        this.wSMTPCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryMailValidatorDialog.this.activeSMTPCheck();
            }
        });
        this.wlTimeOut = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlTimeOut.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.TimeOutField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTimeOut);
        this.fdlTimeOut = new FormData();
        this.fdlTimeOut.left = new FormAttachment(0, 0);
        this.fdlTimeOut.right = new FormAttachment(middle, -2 * margin);
        this.fdlTimeOut.top = new FormAttachment((Control)this.wSMTPCheck, margin);
        this.wlTimeOut.setLayoutData((Object)this.fdlTimeOut);
        this.wTimeOut = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettingsGroup, 18436);
        this.wTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.TimeOutField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        this.fdTimeOut = new FormData();
        this.fdTimeOut.left = new FormAttachment(middle, -margin);
        this.fdTimeOut.top = new FormAttachment((Control)this.wSMTPCheck, margin);
        this.fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData(this.fdTimeOut);
        this.wleMailSender = new Label((Composite)this.wSettingsGroup, 131072);
        this.wleMailSender.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.eMailSenderField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wleMailSender);
        this.fdleMailSender = new FormData();
        this.fdleMailSender.left = new FormAttachment(0, 0);
        this.fdleMailSender.right = new FormAttachment(middle, -2 * margin);
        this.fdleMailSender.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.wleMailSender.setLayoutData((Object)this.fdleMailSender);
        this.weMailSender = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettingsGroup, 18436);
        this.weMailSender.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.eMailSenderField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.weMailSender);
        this.weMailSender.addModifyListener(lsMod);
        this.fdeMailSender = new FormData();
        this.fdeMailSender.left = new FormAttachment(middle, -margin);
        this.fdeMailSender.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.fdeMailSender.right = new FormAttachment(100, 0);
        this.weMailSender.setLayoutData(this.fdeMailSender);
        this.wlDefaultSMTP = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlDefaultSMTP.setText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.DefaultSMTPField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDefaultSMTP);
        this.fdlDefaultSMTP = new FormData();
        this.fdlDefaultSMTP.left = new FormAttachment(0, 0);
        this.fdlDefaultSMTP.right = new FormAttachment(middle, -2 * margin);
        this.fdlDefaultSMTP.top = new FormAttachment((Control)this.weMailSender, margin);
        this.wlDefaultSMTP.setLayoutData((Object)this.fdlDefaultSMTP);
        this.wDefaultSMTP = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettingsGroup, 18436);
        this.wDefaultSMTP.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryMailValidatorDialog.DefaultSMTPField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDefaultSMTP);
        this.wDefaultSMTP.addModifyListener(lsMod);
        this.fdDefaultSMTP = new FormData();
        this.fdDefaultSMTP.left = new FormAttachment(middle, -margin);
        this.fdDefaultSMTP.top = new FormAttachment((Control)this.weMailSender, margin);
        this.fdDefaultSMTP.right = new FormAttachment(100, 0);
        this.wDefaultSMTP.setLayoutData(this.fdDefaultSMTP);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wMailAddress, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wSettingsGroup);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryMailValidatorDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryMailValidatorDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryMailValidatorDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryMailValidatorDialog.this.cancel();
            }
        });
        this.getData();
        this.activeSMTPCheck();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSuccessDialogSize");
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    private void activeSMTPCheck() {
        this.wlTimeOut.setEnabled(this.wSMTPCheck.getSelection());
        this.wTimeOut.setEnabled(this.wSMTPCheck.getSelection());
        this.wlDefaultSMTP.setEnabled(this.wSMTPCheck.getSelection());
        this.wDefaultSMTP.setEnabled(this.wSMTPCheck.getSelection());
        this.wleMailSender.setEnabled(this.wSMTPCheck.getSelection());
        this.weMailSender.setEnabled(this.wSMTPCheck.getSelection());
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.jobEntry.getName(), (String)""));
        this.wMailAddress.setText(Const.NVL((String)this.jobEntry.getEmailAddress(), (String)""));
        this.wTimeOut.setText(Const.NVL((String)this.jobEntry.getTimeOut(), (String)"0"));
        this.wSMTPCheck.setSelection(this.jobEntry.isSMTPCheck());
        this.wDefaultSMTP.setText(Const.NVL((String)this.jobEntry.getDefaultSMTP(), (String)""));
        this.weMailSender.setText(Const.NVL((String)this.jobEntry.geteMailSender(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setEmailAddress(this.wMailAddress.getText());
        this.jobEntry.setTimeOut(this.wTimeOut.getText());
        this.jobEntry.setDefaultSMTP(this.wDefaultSMTP.getText());
        this.jobEntry.seteMailSender(this.weMailSender.getText());
        this.jobEntry.setSMTPCheck(this.wSMTPCheck.getSelection());
        this.dispose();
    }
}

