/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Partitioner;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.trans.step.StepErrorMetaDialog;
import org.pentaho.metastore.api.IMetaStore;

public class SpoonStepsDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;

    public SpoonStepsDelegate(Spoon spoon) {
        super(spoon);
    }

    public void editStepErrorHandling(TransMeta transMeta, StepMeta stepMeta) {
        if (stepMeta != null && stepMeta.supportsErrorHandling()) {
            StepErrorMeta stepErrorMeta = stepMeta.getStepErrorMeta();
            if (stepErrorMeta == null) {
                stepErrorMeta = new StepErrorMeta((VariableSpace)transMeta, stepMeta);
            }
            List targetSteps = transMeta.findNextSteps(stepMeta);
            StepErrorMetaDialog dialog = new StepErrorMetaDialog(this.spoon.getShell(), stepErrorMeta, transMeta, targetSteps);
            if (dialog.open()) {
                stepMeta.setStepErrorMeta(stepErrorMeta);
                stepMeta.setChanged();
                this.spoon.refreshGraph();
            }
        }
    }

    public void dupeStep(TransMeta transMeta, StepMeta stepMeta) {
        this.spoon.getLog().logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"Spoon.Log.DuplicateStep", (String[])new String[0]) + stepMeta.getName()});
        StepMeta stMeta = (StepMeta)stepMeta.clone();
        if (stMeta != null) {
            String newname = transMeta.getAlternativeStepname(stepMeta.getName());
            int nr = 2;
            while (transMeta.findStep(newname) != null) {
                newname = stepMeta.getName() + " (copy " + nr + ")";
                ++nr;
            }
            stMeta.setName(newname);
            stMeta.setSelected(false);
            Point loc = stMeta.getLocation();
            stMeta.setLocation(loc.x + 20, loc.y + 20);
            transMeta.addStep(stMeta);
            this.spoon.addUndoNew((UndoInterface)transMeta, new StepMeta[]{(StepMeta)stMeta.clone()}, new int[]{transMeta.indexOfStep(stMeta)});
            this.spoon.refreshTree();
            this.spoon.refreshGraph();
        }
    }

    public void clipStep(StepMeta stepMeta) {
        try {
            String xml = stepMeta.getXML();
            GUIResource.getInstance().toClipboard(xml);
        }
        catch (Exception ex) {
            new ErrorDialog(this.spoon.getShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public String editStep(TransMeta transMeta, StepMeta stepMeta) {
        boolean refresh = false;
        String stepname = null;
        try {
            String name = stepMeta.getName();
            StepMeta before = (StepMeta)stepMeta.clone();
            StepDialogInterface dialog = this.spoon.getStepEntryDialog(stepMeta.getStepMetaInterface(), transMeta, name);
            if (dialog != null) {
                dialog.setRepository(this.spoon.getRepository());
                dialog.setMetaStore((IMetaStore)this.spoon.getMetaStore());
                stepname = dialog.open();
            }
            if (!Utils.isEmpty(stepname)) {
                stepMeta.getStepMetaInterface().resetStepIoMeta();
                String newname = stepname;
                StepMeta smeta = transMeta.findStep(newname, stepMeta);
                int nr = 2;
                while (smeta != null) {
                    newname = stepname + " " + nr;
                    smeta = transMeta.findStep(newname);
                    ++nr;
                }
                if (nr > 2) {
                    stepname = newname;
                    MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.StepnameExists.Message", (String[])new String[]{stepname}));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.StepnameExists.Title", (String[])new String[0]));
                    mb.open();
                }
                if (!stepname.equals(name)) {
                    refresh = true;
                }
                StepMeta newStepMeta = (StepMeta)stepMeta.clone();
                newStepMeta.setName(stepname);
                transMeta.notifyAllListeners(stepMeta, newStepMeta);
                stepMeta.setName(stepname);
                StepMeta after = (StepMeta)stepMeta.clone();
                this.spoon.addUndoChange((UndoInterface)transMeta, new StepMeta[]{before}, new StepMeta[]{after}, new int[]{transMeta.indexOfStep(stepMeta)});
            } else if (transMeta.haveConnectionsChanged()) {
                refresh = true;
            }
            this.spoon.refreshGraph();
        }
        catch (Throwable e) {
            if (this.spoon.getShell().isDisposed()) {
                return null;
            }
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableOpenDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableOpenDialog.Message", (String[])new String[0]), e);
        }
        if (refresh) {
            this.spoon.refreshTree();
        }
        return stepname;
    }

    public void delSteps(TransMeta transformation, StepMeta[] steps) {
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransBeforeDeleteSteps.id, (Object)steps);
        }
        catch (KettleException e) {
            return;
        }
        ArrayList<TransHopMeta> transHops = new ArrayList<TransHopMeta>();
        int[] hopIndexes = new int[transformation.nrTransHops()];
        int hopIndex = 0;
        block2: for (int i = transformation.nrTransHops() - 1; i >= 0; --i) {
            TransHopMeta hi = transformation.getTransHop(i);
            for (int j = 0; j < steps.length && hopIndex < hopIndexes.length; ++j) {
                if (!hi.getFromStep().equals((Object)steps[j]) && !hi.getToStep().equals((Object)steps[j])) continue;
                int idx = transformation.indexOfTransHop(hi);
                transHops.add((TransHopMeta)hi.clone());
                hopIndexes[hopIndex] = idx;
                transformation.removeTransHop(idx);
                this.spoon.refreshTree();
                ++hopIndex;
                continue block2;
            }
        }
        if (!transHops.isEmpty()) {
            Object[] hops = transHops.toArray(new TransHopMeta[transHops.size()]);
            this.spoon.addUndoDelete((UndoInterface)transformation, hops, hopIndexes);
        }
        int[] positions = new int[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            int pos = transformation.indexOfStep(steps[i]);
            transformation.removeStep(pos);
            positions[i] = pos;
        }
        this.spoon.addUndoDelete((UndoInterface)transformation, steps, positions);
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
    }

    public void delStep(TransMeta transMeta, StepMeta stepMeta) {
        this.delSteps(transMeta, new StepMeta[]{stepMeta});
    }

    public StepDialogInterface getStepDialog(StepMetaInterface stepMeta, TransMeta transMeta, String stepName) throws KettleException {
        String dialogClassName = stepMeta.getDialogClassName();
        Class[] paramClasses = new Class[]{Shell.class, Object.class, TransMeta.class, String.class};
        Object[] paramArgs = new Object[]{this.spoon.getShell(), stepMeta, transMeta, stepName};
        try {
            Class<?> dialogClass = stepMeta.getClass().getClassLoader().loadClass(dialogClassName);
            Constructor<?> dialogConstructor = dialogClass.getConstructor(paramClasses);
            return (StepDialogInterface)dialogConstructor.newInstance(paramArgs);
        }
        catch (Exception e) {
            Method method = null;
            try {
                Class[] sig = new Class[]{Shell.class, StepMetaInterface.class, TransMeta.class, String.class};
                method = stepMeta.getClass().getDeclaredMethod("getDialog", sig);
                if (method != null) {
                    return (StepDialogInterface)method.invoke((Object)stepMeta, this.spoon.getShell(), stepMeta, transMeta, stepName);
                }
            }
            catch (Throwable sig) {
                // empty catch block
            }
            String errorTitle = BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorCreatingStepDialog.Title", (String[])new String[0]);
            String errorMsg = BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorCreatingStepDialog.Message", (String[])new String[]{stepMeta.getDialogClassName()});
            new ErrorDialog(this.spoon.getShell(), errorTitle, errorMsg, e);
            throw new KettleException((Throwable)e);
        }
    }

    public StepDialogInterface getPartitionerDialog(StepMeta stepMeta, StepPartitioningMeta partitioningMeta, TransMeta transMeta) throws KettleException {
        Partitioner partitioner = partitioningMeta.getPartitioner();
        String dialogClassName = partitioner.getDialogClassName();
        Class[] paramClasses = new Class[]{Shell.class, StepMeta.class, StepPartitioningMeta.class, TransMeta.class};
        Object[] paramArgs = new Object[]{this.spoon.getShell(), stepMeta, partitioningMeta, transMeta};
        try {
            Class<?> dialogClass = partitioner.getClass().getClassLoader().loadClass(dialogClassName);
            Constructor<?> dialogConstructor = dialogClass.getConstructor(paramClasses);
            return (StepDialogInterface)dialogConstructor.newInstance(paramArgs);
        }
        catch (Exception e) {
            Method method = null;
            try {
                Class[] sig = new Class[]{Shell.class, StepMetaInterface.class, TransMeta.class};
                method = stepMeta.getClass().getDeclaredMethod("getDialog", sig);
                if (method != null) {
                    return (StepDialogInterface)method.invoke((Object)stepMeta, this.spoon.getShell(), stepMeta, transMeta);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new KettleException((Throwable)e);
        }
    }
}

