/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ConfigurationDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;

public class TransExecutionConfigurationDialog
extends ConfigurationDialog {
    private static Class<?> PKG = TransExecutionConfigurationDialog.class;
    private Button wExecCluster;
    private FormData fdExecCluster;
    private FormData fdExecClusterComposite;
    private Composite clusteredOptionsComposite;
    private Composite execClusterComposite;
    private Button showDialogRunCheckbox;

    public TransExecutionConfigurationDialog(Shell parent, TransExecutionConfiguration configuration, TransMeta transMeta) {
        super(parent, (ExecutionConfiguration)configuration, (AbstractMeta)transMeta);
    }

    @Override
    protected void serverOptionsComposite(Class<?> PKG, String prefix) {
        this.wlRemoteHost = new Label(this.serverOptionsComposite, 0);
        this.props.setLook((Control)this.wlRemoteHost);
        this.wlRemoteHost.setText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Label"), (String[])new String[0]));
        this.wlRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Tooltip"), (String[])new String[0]));
        FormData fdlRemoteHost = new FormData();
        fdlRemoteHost.top = new FormAttachment(0, 10);
        fdlRemoteHost.left = new FormAttachment((Control)this.environmentSeparator, 5);
        this.wlRemoteHost.setLayoutData((Object)fdlRemoteHost);
        this.wRemoteHost = new CCombo(this.serverOptionsComposite, 2048);
        this.wRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Tooltip"), (String[])new String[0]));
        this.props.setLook((Control)this.wRemoteHost);
        FormData fdRemoteHost = new FormData();
        fdRemoteHost.left = new FormAttachment((Control)this.wlRemoteHost, 0, 16384);
        fdRemoteHost.width = 170;
        fdRemoteHost.top = new FormAttachment((Control)this.wlRemoteHost, 8);
        this.wRemoteHost.setLayoutData((Object)fdRemoteHost);
        for (int i = 0; i < this.abstractMeta.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)this.abstractMeta.getSlaveServers().get(i);
            this.wRemoteHost.add(slaveServer.toString());
        }
        this.wPassExport = new Button(this.serverOptionsComposite, 32);
        this.wPassExport.setText(BaseMessages.getString(PKG, (String)(prefix + ".PassExport.Label"), (String[])new String[0]));
        this.wPassExport.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".PassExport.Tooltip"), (String[])new String[0]));
        this.props.setLook((Control)this.wPassExport);
        FormData fdPassExport = new FormData();
        fdPassExport.left = new FormAttachment((Control)this.wRemoteHost, 0, 16384);
        fdPassExport.top = new FormAttachment((Control)this.wRemoteHost, 8);
        this.wPassExport.setLayoutData((Object)fdPassExport);
    }

    protected void clusteredOptionsComposite() {
        Label clusterDescriptionLabel = new Label(this.clusteredOptionsComposite, 0);
        this.props.setLook((Control)clusterDescriptionLabel);
        clusterDescriptionLabel.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ClusterDescription.Label", (String[])new String[0]));
        FormData fd_clusterDescriptionLabel = new FormData();
        fd_clusterDescriptionLabel.top = new FormAttachment(0, 12);
        if (Const.isOSX()) {
            fd_clusterDescriptionLabel.top = new FormAttachment(0, 10);
        }
        fd_clusterDescriptionLabel.left = new FormAttachment((Control)this.environmentSeparator, 5);
        clusterDescriptionLabel.setLayoutData((Object)fd_clusterDescriptionLabel);
        this.showDialogRunCheckbox = new Button(this.clusteredOptionsComposite, 32);
        this.props.setLook((Control)this.showDialogRunCheckbox);
        FormData fd_resroucesCheckBox = new FormData();
        fd_resroucesCheckBox.top = new FormAttachment((Control)clusterDescriptionLabel, 10);
        if (Const.isOSX()) {
            fd_resroucesCheckBox.top = new FormAttachment((Control)clusterDescriptionLabel, 8);
        }
        fd_resroucesCheckBox.left = new FormAttachment((Control)clusterDescriptionLabel, 0, 16384);
        this.showDialogRunCheckbox.setLayoutData((Object)fd_resroucesCheckBox);
        this.showDialogRunCheckbox.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ShowTransformations.Label", (String[])new String[0]));
    }

    @Override
    protected void optionsSectionControls() {
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.top = new FormAttachment(0, 10);
        fdClearLog.left = new FormAttachment(0, 10);
        this.wClearLog.setLayoutData((Object)fdClearLog);
        this.wSafeMode = new Button((Composite)this.gDetails, 32);
        this.wSafeMode.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.SafeMode.Label", (String[])new String[0]));
        this.wSafeMode.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.SafeMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSafeMode);
        FormData fdSafeMode = new FormData();
        fdSafeMode.top = new FormAttachment((Control)this.wClearLog, 7);
        fdSafeMode.left = new FormAttachment(0, 10);
        this.wSafeMode.setLayoutData((Object)fdSafeMode);
        this.wGatherMetrics = new Button((Composite)this.gDetails, 32);
        this.wGatherMetrics.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.GatherMetrics.Label", (String[])new String[0]));
        this.wGatherMetrics.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.GatherMetrics.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGatherMetrics);
        FormData fdGatherMetrics = new FormData();
        fdGatherMetrics.top = new FormAttachment((Control)this.wSafeMode, 7);
        fdGatherMetrics.left = new FormAttachment(0, 10);
        fdGatherMetrics.bottom = new FormAttachment(100, -10);
        this.wGatherMetrics.setLayoutData((Object)fdGatherMetrics);
        this.wlLogLevel = new Label((Composite)this.gDetails, 0);
        this.props.setLook((Control)this.wlLogLevel);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.top = new FormAttachment(0, 10);
        fdlLogLevel.left = new FormAttachment(45, 0);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.top = new FormAttachment((Control)this.wlLogLevel, -2, 128);
        fdLogLevel.width = 180;
        fdLogLevel.left = new FormAttachment((Control)this.wlLogLevel, 6);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
    }

    public boolean open() {
        this.mainLayout(PKG, "TransExecutionConfigurationDialog", GUIResource.getInstance().getImageTransGraph());
        this.environmentTypeSectionLayout(PKG, "TransExecutionConfigurationDialog");
        TransMeta transMeta = (TransMeta)this.abstractMeta;
        if (transMeta.getClusterSchemas() == null || transMeta.getClusterSchemas().size() == 0) {
            this.execClusterComposite = new Composite((Composite)this.gLocal, 0);
            this.execClusterComposite.setLayout((Layout)new FormLayout());
            this.execClusterComposite.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ExecCluster.DisabledTooltip", (String[])new String[0]));
            this.props.setLook((Control)this.execClusterComposite);
            this.fdExecClusterComposite = new FormData();
            this.fdExecClusterComposite.left = new FormAttachment((Control)this.wExecLocal, 0, 16384);
            this.fdExecClusterComposite.top = this.abstractMeta.getSlaveServers() == null || this.abstractMeta.getSlaveServers().size() == 0 ? new FormAttachment((Control)this.composite, 7) : new FormAttachment((Control)this.wExecRemote, 7);
            this.execClusterComposite.setLayoutData((Object)this.fdExecClusterComposite);
            this.wExecCluster = new Button(this.execClusterComposite, 16);
            this.wExecCluster.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ExecCluster.Label", (String[])new String[0]));
            this.props.setLook((Control)this.wExecCluster);
            this.wExecCluster.setEnabled(false);
            this.fdExecCluster = new FormData();
            this.fdExecCluster.top = new FormAttachment(0);
            this.wExecCluster.setLayoutData((Object)this.fdExecCluster);
        } else {
            this.wExecCluster = new Button((Composite)this.gLocal, 16);
            this.wExecCluster.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ExecCluster.Label", (String[])new String[0]));
            this.wExecCluster.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ExecCluster.Tooltip", (String[])new String[0]));
            this.props.setLook((Control)this.wExecCluster);
            this.fdExecCluster = new FormData();
            this.fdExecCluster.left = new FormAttachment(0, 10);
            this.fdExecCluster.top = this.abstractMeta.getSlaveServers() == null || this.abstractMeta.getSlaveServers().size() == 0 ? new FormAttachment((Control)this.composite, 7) : new FormAttachment((Control)this.wExecRemote, 7);
            this.wExecCluster.setLayoutData((Object)this.fdExecCluster);
            this.wExecCluster.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((TransExecutionConfigurationDialog)TransExecutionConfigurationDialog.this).stackedLayout.topControl = TransExecutionConfigurationDialog.this.clusteredOptionsComposite;
                    TransExecutionConfigurationDialog.this.stackedLayoutComposite.layout();
                }
            });
        }
        this.clusteredOptionsComposite = new Composite(this.stackedLayoutComposite, 0);
        this.clusteredOptionsComposite.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)this.clusteredOptionsComposite);
        this.clusteredOptionsComposite();
        this.optionsSectionLayout(PKG, "TransExecutionConfigurationDialog");
        this.parametersSectionLayout(PKG, "TransExecutionConfigurationDialog");
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(Spoon.class, (String)"Spoon.TransExecutionConfigurationDialog.Help", (String[])new String[0]));
        String docTitle = BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.docTitle", (String[])new String[0]);
        String docHeader = BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.docHeader", (String[])new String[0]);
        this.buttonsSectionLayout(PKG, "TransExecutionConfigurationDialog", docTitle, docUrl, docHeader);
        this.getData();
        this.openDialog();
        return this.retval;
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariables().keySet());
        Collections.sort(variableNames);
        for (int i = 0; i < variableNames.size(); ++i) {
            String variableName = (String)variableNames.get(i);
            String variableValue = (String)this.configuration.getVariables().get(variableName);
            if (Const.indexOfString((String)variableName, (String[])this.abstractMeta.listParameters()) >= 0) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    public void getData() {
        this.wExecLocal.setSelection(this.configuration.isExecutingLocally());
        if (this.configuration.isExecutingLocally()) {
            this.stackedLayout.topControl = this.localOptionsComposite;
        }
        this.wExecRemote.setSelection(this.configuration.isExecutingRemotely());
        if (this.configuration.isExecutingRemotely()) {
            this.stackedLayout.topControl = this.serverOptionsComposite;
        }
        this.wExecCluster.setSelection(this.getConfiguration().isExecutingClustered());
        if (this.getConfiguration().isExecutingClustered()) {
            this.stackedLayout.topControl = this.clusteredOptionsComposite;
        }
        this.wSafeMode.setSelection(this.configuration.isSafeModeEnabled());
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        this.wRemoteHost.setText(this.configuration.getRemoteServer() == null ? "" : this.configuration.getRemoteServer().toString());
        this.wPassExport.setSelection(this.configuration.isPassingExport());
        this.wGatherMetrics.setSelection(this.configuration.isGatheringMetrics());
        this.showDialogRunCheckbox.setSelection(this.getConfiguration().isClusterShowingTransformation());
        this.wLogLevel.select(this.configuration.getLogLevel().getLevel());
        this.getParamsData();
        this.getVariablesData();
    }

    @Override
    public void getInfo() {
        try {
            this.configuration.setReplayDate(null);
            this.configuration.setExecutingLocally(this.wExecLocal.getSelection());
            this.configuration.setExecutingRemotely(this.wExecRemote.getSelection());
            this.getConfiguration().setExecutingClustered(this.wExecCluster.getSelection());
            if (this.wExecRemote.getSelection()) {
                String serverName = this.wRemoteHost.getText();
                this.configuration.setRemoteServer(this.abstractMeta.findSlaveServer(serverName));
                this.configuration.setPassingExport(this.wPassExport.getSelection());
            }
            if (this.wExecCluster.getSelection()) {
                this.getConfiguration().setClusterShowingTransformation(this.showDialogRunCheckbox.getSelection());
            }
            this.getConfiguration().setClusterPosting(this.wExecCluster.getSelection());
            this.getConfiguration().setClusterPreparing(this.wExecCluster.getSelection());
            this.getConfiguration().setClusterStarting(this.wExecCluster.getSelection());
            this.getConfiguration().setClusterShowingTransformation(this.wExecCluster.getSelection());
            this.configuration.setSafeModeEnabled(this.wSafeMode.getSelection());
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            this.configuration.setGatheringMetrics(this.wGatherMetrics.getSelection());
            this.getInfoParameters();
            this.getInfoVariables();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error in settings", "There is an error in the dialog settings", e);
        }
    }

    public TransExecutionConfiguration getConfiguration() {
        return (TransExecutionConfiguration)this.configuration;
    }
}

