/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.dbproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dbproc.DBProcMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class DBProcDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DBProcMeta.class;
    private CCombo wConnection;
    private Button wbProcName;
    private Label wlProcName;
    private TextVar wProcName;
    private FormData fdlProcName;
    private FormData fdbProcName;
    private FormData fdProcName;
    private Label wlAutoCommit;
    private Button wAutoCommit;
    private FormData fdlAutoCommit;
    private FormData fdAutoCommit;
    private Label wlResult;
    private Text wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Label wlResultType;
    private CCombo wResultType;
    private FormData fdlResultType;
    private FormData fdResultType;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wGet;
    private Listener lsGet;
    private DBProcMeta input;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public DBProcDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (DBProcMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DBProcDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DBProcDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabase() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wbProcName = new Button((Composite)this.shell, 8);
        this.wbProcName.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Finding.Button", (String[])new String[0]));
        this.fdbProcName = new FormData();
        this.fdbProcName.right = new FormAttachment(100, 0);
        this.fdbProcName.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wbProcName.setLayoutData((Object)this.fdbProcName);
        this.wbProcName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent arg0) {
                DatabaseMeta dbInfo = DBProcDialog.this.transMeta.findDatabase(DBProcDialog.this.wConnection.getText());
                if (dbInfo != null) {
                    Database db = new Database(BaseStepDialog.loggingObject, dbInfo);
                    try {
                        db.connect();
                        String[] procs = db.getProcedures();
                        if (procs != null && procs.length > 0) {
                            EnterSelectionDialog esd = new EnterSelectionDialog(DBProcDialog.this.shell, procs, BaseMessages.getString((Class)PKG, (String)"DBProcDialog.EnterSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"DBProcDialog.EnterSelection.DialogMessage", (String[])new String[0]));
                            String proc = esd.open();
                            if (proc != null) {
                                DBProcDialog.this.wProcName.setText(proc);
                            }
                        } else {
                            MessageBox mb = new MessageBox(DBProcDialog.this.shell, 34);
                            mb.setMessage(BaseMessages.getString((Class)PKG, (String)"DBProcDialog.NoProceduresFound.DialogMessage", (String[])new String[0]));
                            mb.setText(BaseMessages.getString((Class)PKG, (String)"DBProcDialog.NoProceduresFound.DialogTitle", (String[])new String[0]));
                            mb.open();
                        }
                    }
                    catch (KettleDatabaseException dbe) {
                        new ErrorDialog(DBProcDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"DBProcDialog.ErrorGettingProceduresList.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"DBProcDialog.ErrorGettingProceduresList.DialogMessage", (String[])new String[0]), (Exception)((Object)dbe));
                    }
                    finally {
                        db.disconnect();
                    }
                }
            }
        });
        this.wlProcName = new Label((Composite)this.shell, 131072);
        this.wlProcName.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.ProcedureName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProcName);
        this.fdlProcName = new FormData();
        this.fdlProcName.left = new FormAttachment(0, 0);
        this.fdlProcName.right = new FormAttachment(middle, -margin);
        this.fdlProcName.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlProcName.setLayoutData((Object)this.fdlProcName);
        this.wProcName = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wProcName);
        this.wProcName.addModifyListener(lsMod);
        this.fdProcName = new FormData();
        this.fdProcName.left = new FormAttachment(middle, 0);
        this.fdProcName.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdProcName.right = new FormAttachment((Control)this.wbProcName, -margin);
        this.wProcName.setLayoutData(this.fdProcName);
        this.wlAutoCommit = new Label((Composite)this.shell, 131072);
        this.wlAutoCommit.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Label", (String[])new String[0]));
        this.wlAutoCommit.setToolTipText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlAutoCommit);
        this.fdlAutoCommit = new FormData();
        this.fdlAutoCommit.left = new FormAttachment(0, 0);
        this.fdlAutoCommit.top = new FormAttachment((Control)this.wProcName, margin);
        this.fdlAutoCommit.right = new FormAttachment(middle, -margin);
        this.wlAutoCommit.setLayoutData((Object)this.fdlAutoCommit);
        this.wAutoCommit = new Button((Composite)this.shell, 32);
        this.wAutoCommit.setToolTipText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAutoCommit);
        this.fdAutoCommit = new FormData();
        this.fdAutoCommit.left = new FormAttachment(middle, 0);
        this.fdAutoCommit.top = new FormAttachment((Control)this.wProcName, margin);
        this.fdAutoCommit.right = new FormAttachment(100, 0);
        this.wAutoCommit.setLayoutData((Object)this.fdAutoCommit);
        this.wAutoCommit.addSelectionListener((SelectionListener)lsSelMod);
        this.wlResult = new Label((Composite)this.shell, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Result.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)this.wAutoCommit, margin * 2);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)this.wAutoCommit, margin * 2);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)this.fdResult);
        this.wlResultType = new Label((Composite)this.shell, 131072);
        this.wlResultType.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.ResultType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResultType);
        this.fdlResultType = new FormData();
        this.fdlResultType.left = new FormAttachment(0, 0);
        this.fdlResultType.right = new FormAttachment(middle, -margin);
        this.fdlResultType.top = new FormAttachment((Control)this.wResult, margin);
        this.wlResultType.setLayoutData((Object)this.fdlResultType);
        this.wResultType = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wResultType);
        String[] types = ValueMeta.getTypes();
        for (int x = 0; x < types.length; ++x) {
            this.wResultType.add(types[x]);
        }
        this.wResultType.select(0);
        this.wResultType.addModifyListener(lsMod);
        this.fdResultType = new FormData();
        this.fdResultType.left = new FormAttachment(middle, 0);
        this.fdResultType.top = new FormAttachment((Control)this.wResult, margin);
        this.fdResultType.right = new FormAttachment(100, 0);
        this.wResultType.setLayoutData((Object)this.fdResultType);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wResultType, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.input.getArgument().length;
        this.colinf = new ColumnInfo[3];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Direction", (String[])new String[0]), 2, new String[]{"IN", "OUT", "INOUT"});
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMeta.getTypes());
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = DBProcDialog.this.transMeta.findStep(DBProcDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = DBProcDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            DBProcDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        DBProcDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        DBProcDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet}, margin, (Control)this.wFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DBProcDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                DBProcDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DBProcDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DBProcDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DBProcDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = DBProcDialog.this.shell.getSize();
                DBProcDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((DBProcDialog)DBProcDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                DBProcDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"DBProcDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getArgument() != null) {
            for (int i = 0; i < this.input.getArgument().length; ++i) {
                TableItem item = this.wFields.table.getItem(i);
                if (this.input.getArgument()[i] != null) {
                    item.setText(1, this.input.getArgument()[i]);
                }
                if (this.input.getArgumentDirection()[i] != null) {
                    item.setText(2, this.input.getArgumentDirection()[i]);
                }
                item.setText(3, ValueMeta.getTypeDesc((int)this.input.getArgumentType()[i]));
            }
        }
        if (this.input.getDatabase() != null) {
            this.wConnection.setText(this.input.getDatabase().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getProcedure() != null) {
            this.wProcName.setText(this.input.getProcedure());
        }
        if (this.input.getResultName() != null) {
            this.wResult.setText(this.input.getResultName());
        }
        this.wResultType.setText(ValueMeta.getTypeDesc((int)this.input.getResultType()));
        this.wAutoCommit.setSelection(this.input.isAutoCommit());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        int nrargs = this.wFields.nrNonEmpty();
        this.input.allocate(nrargs);
        this.logDebug(BaseMessages.getString(PKG, (String)"DBProcDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(nrargs)}));
        for (int i = 0; i < nrargs; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getArgument()[i] = item.getText(1);
            this.input.getArgumentDirection()[i] = item.getText(2);
            this.input.getArgumentType()[i] = ValueMeta.getType((String)item.getText(3));
        }
        this.input.setDatabase(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setProcedure(this.wProcName.getText());
        this.input.setResultName(this.wResult.getText());
        this.input.setResultType(ValueMeta.getType((String)this.wResultType.getText()));
        this.input.setAutoCommit(this.wAutoCommit.getSelection());
        this.stepname = this.wStepname.getText();
        if (this.input.getDatabase() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DBProcDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, "IN");
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[]{3}, -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DBProcDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DBProcDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

