/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fieldsplitter;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class FieldSplitterDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FieldSplitterMeta.class;
    private Label wlSplitfield;
    private CCombo wSplitfield;
    private FormData fdlSplitfield;
    private FormData fdSplitfield;
    private Label wlDelimiter;
    private TextVar wDelimiter;
    private FormData fdlDelimiter;
    private FormData fdDelimiter;
    private TextVar wEnclosure;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private FieldSplitterMeta input;
    private boolean gotPreviousFields = false;

    public FieldSplitterDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (FieldSplitterMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldSplitterDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlSplitfield = new Label((Composite)this.shell, 131072);
        this.wlSplitfield.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.SplitField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSplitfield);
        this.fdlSplitfield = new FormData();
        this.fdlSplitfield.left = new FormAttachment(0, 0);
        this.fdlSplitfield.right = new FormAttachment(middle, -margin);
        this.fdlSplitfield.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlSplitfield.setLayoutData((Object)this.fdlSplitfield);
        this.wSplitfield = new CCombo((Composite)this.shell, 2056);
        this.wSplitfield.setText("");
        this.props.setLook((Control)this.wSplitfield);
        this.wSplitfield.addModifyListener(lsMod);
        this.fdSplitfield = new FormData();
        this.fdSplitfield.left = new FormAttachment(middle, 0);
        this.fdSplitfield.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSplitfield.right = new FormAttachment(100, 0);
        this.wSplitfield.setLayoutData((Object)this.fdSplitfield);
        this.wSplitfield.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FieldSplitterDialog.this.shell.getDisplay(), 1);
                FieldSplitterDialog.this.shell.setCursor(busy);
                FieldSplitterDialog.this.getFields();
                FieldSplitterDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlDelimiter = new Label((Composite)this.shell, 131072);
        this.wlDelimiter.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDelimiter);
        this.fdlDelimiter = new FormData();
        this.fdlDelimiter.left = new FormAttachment(0, 0);
        this.fdlDelimiter.right = new FormAttachment(middle, -margin);
        this.fdlDelimiter.top = new FormAttachment((Control)this.wSplitfield, margin);
        this.wlDelimiter.setLayoutData((Object)this.fdlDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wDelimiter.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Tooltip", (String[])new String[0]));
        this.wDelimiter.setText("");
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        this.fdDelimiter = new FormData();
        this.fdDelimiter.left = new FormAttachment(middle, 0);
        this.fdDelimiter.top = new FormAttachment((Control)this.wSplitfield, margin);
        this.fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData(this.fdDelimiter);
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wEnclosure.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData(fdEnclosure);
        this.wlFields = new Label((Composite)this.shell, 131072);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        int fieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.ID", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.RemoveID", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Format", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Nullif", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.IfNull", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.TrimType", (String[])new String[0]), 2, ValueMeta.trimTypeDesc, true)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, fieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FieldSplitterDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FieldSplitterDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FieldSplitterDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FieldSplitterDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wSplitfield.getText();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wSplitfield.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wSplitfield.setText(field);
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        if (this.input.getSplitField() != null) {
            this.wSplitfield.setText(this.input.getSplitField());
        }
        if (this.input.getDelimiter() != null) {
            this.wDelimiter.setText(this.input.getDelimiter());
        }
        if (this.input.getEnclosure() != null) {
            this.wEnclosure.setText(this.input.getEnclosure());
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.table.getItem(i);
            if (this.input.getFieldName()[i] != null) {
                ti.setText(1, this.input.getFieldName()[i]);
            }
            if (this.input.getFieldID()[i] != null) {
                ti.setText(2, this.input.getFieldID()[i]);
            }
            ti.setText(3, this.input.getFieldRemoveID()[i] ? "Y" : "N");
            ti.setText(4, ValueMetaFactory.getValueMetaName((int)this.input.getFieldType()[i]));
            if (this.input.getFieldLength()[i] >= 0) {
                ti.setText(5, "" + this.input.getFieldLength()[i]);
            }
            if (this.input.getFieldPrecision()[i] >= 0) {
                ti.setText(6, "" + this.input.getFieldPrecision()[i]);
            }
            if (this.input.getFieldFormat()[i] != null) {
                ti.setText(7, this.input.getFieldFormat()[i]);
            }
            if (this.input.getFieldGroup()[i] != null) {
                ti.setText(8, this.input.getFieldGroup()[i]);
            }
            if (this.input.getFieldDecimal()[i] != null) {
                ti.setText(9, this.input.getFieldDecimal()[i]);
            }
            if (this.input.getFieldCurrency()[i] != null) {
                ti.setText(10, this.input.getFieldCurrency()[i]);
            }
            if (this.input.getFieldNullIf()[i] != null) {
                ti.setText(11, this.input.getFieldNullIf()[i]);
            }
            if (this.input.getFieldIfNull()[i] != null) {
                ti.setText(12, this.input.getFieldIfNull()[i]);
            }
            ti.setText(13, ValueMeta.getTrimTypeDesc((int)this.input.getFieldTrimType()[i]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setSplitField(this.wSplitfield.getText());
        this.input.setDelimiter(this.wDelimiter.getText());
        this.input.setEnclosure(this.wEnclosure.getText());
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
            this.input.getFieldID()[i] = ti.getText(2);
            this.input.getFieldRemoveID()[i] = "Y".equalsIgnoreCase(ti.getText(3));
            this.input.getFieldType()[i] = ValueMetaFactory.getIdForValueMeta((String)ti.getText(4));
            this.input.getFieldLength()[i] = Const.toInt((String)ti.getText(5), (int)-1);
            this.input.getFieldPrecision()[i] = Const.toInt((String)ti.getText(6), (int)-1);
            this.input.getFieldFormat()[i] = ti.getText(7);
            this.input.getFieldGroup()[i] = ti.getText(8);
            this.input.getFieldDecimal()[i] = ti.getText(9);
            this.input.getFieldCurrency()[i] = ti.getText(10);
            this.input.getFieldNullIf()[i] = ti.getText(11);
            this.input.getFieldIfNull()[i] = ti.getText(12);
            this.input.getFieldTrimType()[i] = ValueMeta.getTrimTypeByDesc((String)ti.getText(13));
        }
        this.dispose();
    }
}

