/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.switchcase;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SwitchCaseDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SwitchCaseMeta.class;
    private Label wlFieldName;
    private CCombo wFieldName;
    private Label wlDataType;
    private CCombo wDataType;
    private Label wlConversionMask;
    private Text wConversionMask;
    private Label wlDecimalSymbol;
    private Text wDecimalSymbol;
    private Label wlGroupingSymbol;
    private Text wGroupingSymbol;
    private Label wlValues;
    private TableView wValues;
    private Label wlDefaultTarget;
    private CCombo wDefaultTarget;
    private Label wlContains;
    private Button wContains;
    private FormData fdlContains;
    private FormData fdContains;
    private SwitchCaseMeta input;
    private RowMetaInterface inputFields;

    public SwitchCaseDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (SwitchCaseMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwitchCaseDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwitchCaseDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, margin);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFieldName = new Label((Composite)this.shell, 131072);
        this.wlFieldName.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.FieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.right = new FormAttachment(middle, 0);
        fdlFieldName.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFieldName);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(middle, margin);
        fdFieldName.right = new FormAttachment(100, 0);
        fdFieldName.top = new FormAttachment((Control)this.wStepname, margin);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        this.wFieldName.addModifyListener(lsMod);
        try {
            this.inputFields = this.transMeta.getPrevStepFields(this.stepMeta);
            this.wFieldName.setItems(this.inputFields.getFieldNames());
        }
        catch (KettleStepException ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Exception.CantGetFieldsFromPreviousSteps.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Exception.CantGetFieldsFromPreviousSteps.Message", (String[])new String[0]), (Exception)((Object)ex));
        }
        this.wlContains = new Label((Composite)this.shell, 131072);
        this.wlContains.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Contains.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlContains);
        this.fdlContains = new FormData();
        this.fdlContains.left = new FormAttachment(0, 0);
        this.fdlContains.right = new FormAttachment(middle, -margin);
        this.fdlContains.top = new FormAttachment((Control)this.wFieldName, margin * 2);
        this.wlContains.setLayoutData((Object)this.fdlContains);
        this.wContains = new Button((Composite)this.shell, 32);
        this.wContains.setToolTipText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Contains.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wContains);
        this.fdContains = new FormData();
        this.fdContains.left = new FormAttachment(middle, 0);
        this.fdContains.top = new FormAttachment((Control)this.wFieldName, margin * 2);
        this.fdContains.right = new FormAttachment(100, 0);
        this.wContains.setLayoutData((Object)this.fdContains);
        this.wContains.addSelectionListener((SelectionListener)lsSel);
        this.wlDataType = new Label((Composite)this.shell, 131072);
        this.wlDataType.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DataType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDataType);
        FormData fdlDataType = new FormData();
        fdlDataType.left = new FormAttachment(0, 0);
        fdlDataType.right = new FormAttachment(middle, 0);
        fdlDataType.top = new FormAttachment((Control)this.wContains, margin);
        this.wlDataType.setLayoutData((Object)fdlDataType);
        this.wDataType = new CCombo((Composite)this.shell, 18436);
        this.wDataType.setItems(ValueMetaBase.getTypes());
        this.props.setLook((Control)this.wDataType);
        FormData fdDataType = new FormData();
        fdDataType.left = new FormAttachment(middle, margin);
        fdDataType.right = new FormAttachment(100, 0);
        fdDataType.top = new FormAttachment((Control)this.wContains, margin);
        this.wDataType.setLayoutData((Object)fdDataType);
        this.wDataType.addModifyListener(lsMod);
        this.wlConversionMask = new Label((Composite)this.shell, 131072);
        this.wlConversionMask.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ConversionMask.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlConversionMask);
        FormData fdlConversionMask = new FormData();
        fdlConversionMask.left = new FormAttachment(0, 0);
        fdlConversionMask.right = new FormAttachment(middle, 0);
        fdlConversionMask.top = new FormAttachment((Control)this.wDataType, margin);
        this.wlConversionMask.setLayoutData((Object)fdlConversionMask);
        this.wConversionMask = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wConversionMask);
        FormData fdConversionMask = new FormData();
        fdConversionMask.left = new FormAttachment(middle, margin);
        fdConversionMask.right = new FormAttachment(100, 0);
        fdConversionMask.top = new FormAttachment((Control)this.wDataType, margin);
        this.wConversionMask.setLayoutData((Object)fdConversionMask);
        this.wConversionMask.addModifyListener(lsMod);
        this.wlDecimalSymbol = new Label((Composite)this.shell, 131072);
        this.wlDecimalSymbol.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DecimalSymbol.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDecimalSymbol);
        FormData fdlDecimalSymbol = new FormData();
        fdlDecimalSymbol.left = new FormAttachment(0, 0);
        fdlDecimalSymbol.right = new FormAttachment(middle, 0);
        fdlDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        this.wlDecimalSymbol.setLayoutData((Object)fdlDecimalSymbol);
        this.wDecimalSymbol = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDecimalSymbol);
        FormData fdDecimalSymbol = new FormData();
        fdDecimalSymbol.left = new FormAttachment(middle, margin);
        fdDecimalSymbol.right = new FormAttachment(100, 0);
        fdDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        this.wDecimalSymbol.setLayoutData((Object)fdDecimalSymbol);
        this.wDecimalSymbol.addModifyListener(lsMod);
        this.wlGroupingSymbol = new Label((Composite)this.shell, 131072);
        this.wlGroupingSymbol.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.GroupingSymbol.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGroupingSymbol);
        FormData fdlGroupingSymbol = new FormData();
        fdlGroupingSymbol.left = new FormAttachment(0, 0);
        fdlGroupingSymbol.right = new FormAttachment(middle, 0);
        fdlGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        this.wlGroupingSymbol.setLayoutData((Object)fdlGroupingSymbol);
        this.wGroupingSymbol = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wGroupingSymbol);
        FormData fdGroupingSymbol = new FormData();
        fdGroupingSymbol.left = new FormAttachment(middle, margin);
        fdGroupingSymbol.right = new FormAttachment(100, 0);
        fdGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        this.wGroupingSymbol.setLayoutData((Object)fdGroupingSymbol);
        this.wGroupingSymbol.addModifyListener(lsMod);
        String[] nextStepNames = this.transMeta.getNextStepNames(this.stepMeta);
        this.wlValues = new Label((Composite)this.shell, 131072);
        this.wlValues.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ValueCases.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValues);
        FormData fdlValues = new FormData();
        fdlValues.left = new FormAttachment(0, 0);
        fdlValues.top = new FormAttachment((Control)this.wGroupingSymbol, margin);
        fdlValues.right = new FormAttachment(middle, 0);
        this.wlValues.setLayoutData((Object)fdlValues);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ColumnInfo.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ColumnInfo.TargetStep", (String[])new String[0]), 2, nextStepNames, false)};
        this.wValues = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, this.input.getStepIOMeta().getTargetStreams().size(), lsMod, this.props);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wlDefaultTarget = new Label((Composite)this.shell, 131072);
        this.wlDefaultTarget.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DefaultTarget.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDefaultTarget);
        FormData fdlDefaultTarget = new FormData();
        fdlDefaultTarget.left = new FormAttachment(0, 0);
        fdlDefaultTarget.right = new FormAttachment(middle, 0);
        fdlDefaultTarget.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        this.wlDefaultTarget.setLayoutData((Object)fdlDefaultTarget);
        this.wDefaultTarget = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDefaultTarget);
        FormData fdDefaultTarget = new FormData();
        fdDefaultTarget.left = new FormAttachment(middle, margin);
        fdDefaultTarget.right = new FormAttachment(100, 0);
        fdDefaultTarget.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        this.wDefaultTarget.setLayoutData((Object)fdDefaultTarget);
        this.wDefaultTarget.setItems(nextStepNames);
        this.wDefaultTarget.addModifyListener(lsMod);
        FormData fdValues = new FormData();
        fdValues.left = new FormAttachment(middle, margin);
        fdValues.top = new FormAttachment((Control)this.wGroupingSymbol, margin);
        fdValues.right = new FormAttachment(100, 0);
        fdValues.bottom = new FormAttachment((Control)this.wDefaultTarget, -margin);
        this.wValues.setLayoutData(fdValues);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SwitchCaseDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SwitchCaseDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SwitchCaseDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SwitchCaseDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wFieldName.setText(Const.NVL((String)this.input.getFieldname(), (String)""));
        this.wContains.setSelection(this.input.isContains());
        this.wDataType.setText(ValueMetaBase.getTypeDesc((int)this.input.getCaseValueType()));
        this.wDecimalSymbol.setText(Const.NVL((String)this.input.getCaseValueDecimal(), (String)""));
        this.wGroupingSymbol.setText(Const.NVL((String)this.input.getCaseValueGroup(), (String)""));
        this.wConversionMask.setText(Const.NVL((String)this.input.getCaseValueFormat(), (String)""));
        for (int i = 0; i < this.input.getCaseTargets().size(); ++i) {
            TableItem item = this.wValues.table.getItem(i);
            SwitchCaseTarget target = (SwitchCaseTarget)this.input.getCaseTargets().get(i);
            if (target == null) continue;
            item.setText(1, Const.NVL((String)target.caseValue, (String)""));
            item.setText(2, target.caseTargetStep == null ? "" : target.caseTargetStep.getName());
        }
        this.wValues.removeEmptyRows();
        this.wValues.setRowNums();
        this.wValues.optWidth(true);
        this.wDefaultTarget.setText(this.input.getDefaultTargetStep() == null ? "" : this.input.getDefaultTargetStep().getName());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.input.setFieldname(this.wFieldName.getText());
        this.input.setContains(this.wContains.getSelection());
        this.input.setCaseValueType(ValueMetaBase.getType((String)this.wDataType.getText()));
        this.input.setCaseValueFormat(this.wConversionMask.getText());
        this.input.setCaseValueDecimal(this.wDecimalSymbol.getText());
        this.input.setCaseValueGroup(this.wGroupingSymbol.getText());
        int nrValues = this.wValues.nrNonEmpty();
        this.input.allocate();
        for (int i = 0; i < nrValues; ++i) {
            TableItem item = this.wValues.getNonEmpty(i);
            SwitchCaseTarget target = new SwitchCaseTarget();
            target.caseValue = item.getText(1);
            target.caseTargetStep = this.transMeta.findStep(item.getText(2));
            this.input.getCaseTargets().add(target);
        }
        this.input.setDefaultTargetStep(this.transMeta.findStep(this.wDefaultTarget.getText()));
        this.stepname = this.wStepname.getText();
        this.dispose();
    }
}

