/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.transexecutor;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class TransExecutorDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = TransExecutorMeta.class;
    private TransExecutorMeta transExecutorMeta;
    private Group gTransGroup;
    private Button radioFilename;
    private Button wbbFilename;
    private TextVar wFilename;
    private Button radioByName;
    private TextVar wTransname;
    private TextVar wDirectory;
    private Button wbTrans;
    private Button radioByReference;
    private Button wbByReference;
    private TextVar wByReference;
    private Button wNewTrans;
    private Button wEditTrans;
    private CTabFolder wTabFolder;
    private TransMeta executorTransMeta = null;
    protected boolean jobModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private Button wInheritAll;
    private TableView wTransExecutorParameters;
    private Label wlGroupSize;
    private TextVar wGroupSize;
    private Label wlGroupField;
    private CCombo wGroupField;
    private Label wlGroupTime;
    private TextVar wGroupTime;
    private Label wlExecutionResultTarget;
    private Label wlExecutionTimeField;
    private Label wlExecutionResultField;
    private Label wlExecutionNrErrorsField;
    private Label wlExecutionLinesReadField;
    private Label wlExecutionLinesWrittenField;
    private Label wlExecutionLinesInputField;
    private Label wlExecutionLinesOutputField;
    private Label wlExecutionLinesRejectedField;
    private Label wlExecutionLinesUpdatedField;
    private Label wlExecutionLinesDeletedField;
    private Label wlExecutionFilesRetrievedField;
    private Label wlExecutionExitStatusField;
    private Label wlExecutionLogTextField;
    private Label wlExecutionLogChannelIdField;
    private CCombo wExecutionResultTarget;
    private TextVar wExecutionTimeField;
    private TextVar wExecutionResultField;
    private TextVar wExecutionNrErrorsField;
    private TextVar wExecutionLinesReadField;
    private TextVar wExecutionLinesWrittenField;
    private TextVar wExecutionLinesInputField;
    private TextVar wExecutionLinesOutputField;
    private TextVar wExecutionLinesRejectedField;
    private TextVar wExecutionLinesUpdatedField;
    private TextVar wExecutionLinesDeletedField;
    private TextVar wExecutionFilesRetrievedField;
    private TextVar wExecutionExitStatusField;
    private TextVar wExecutionLogTextField;
    private TextVar wExecutionLogChannelIdField;
    private String executorOutputStep;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private ColumnInfo[] parameterColumns;
    private Label wlResultFilesTarget;
    private CCombo wResultFilesTarget;
    private Label wlResultFileNameField;
    private TextVar wResultFileNameField;
    private Label wlResultRowsTarget;
    private CCombo wOutputRowsSource;
    private Label wlOutputFields;
    private TableView wOutputFields;
    private Button wGetParameters;

    public TransExecutorDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.transExecutorMeta = (TransExecutorMeta)in;
        this.jobModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.transExecutorMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransExecutorDialog.this.transExecutorMeta.setChanged();
                TransExecutorDialog.this.setFlags();
            }
        };
        this.changed = this.transExecutorMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.gTransGroup = new Group((Composite)this.shell, 16);
        this.gTransGroup.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.TransGroup.Label", (String[])new String[0]));
        this.gTransGroup.setBackground(this.shell.getBackground());
        FormLayout transGroupLayout = new FormLayout();
        transGroupLayout.marginLeft = this.margin * 2;
        transGroupLayout.marginTop = this.margin * 2;
        transGroupLayout.marginRight = this.margin * 2;
        transGroupLayout.marginBottom = this.margin * 2;
        this.gTransGroup.setLayout((Layout)transGroupLayout);
        this.radioFilename = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioFilename);
        this.radioFilename.setSelection(false);
        this.radioFilename.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioFile.Label", (String[])new String[0]));
        this.radioFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioFile.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdFileRadio = new FormData();
        fdFileRadio.left = new FormAttachment(0, 0);
        fdFileRadio.right = new FormAttachment(100, 0);
        fdFileRadio.top = new FormAttachment(0, 0);
        this.radioFilename.setLayoutData((Object)fdFileRadio);
        this.radioFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.wbbFilename = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.radioFilename, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.selectFileTrans();
            }
        });
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(0, 25);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)this.wbbFilename, 0, 0x1000000);
        this.wFilename.setLayoutData(fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.radioByName = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByName);
        this.radioByName.setSelection(false);
        this.radioByName.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioRep.Label", (String[])new String[0]));
        this.radioByName.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioRep.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRepRadio = new FormData();
        fdRepRadio.left = new FormAttachment(0, 0);
        fdRepRadio.right = new FormAttachment(100, 0);
        fdRepRadio.top = new FormAttachment((Control)this.wbbFilename, 2 * this.margin);
        this.radioByName.setLayoutData((Object)fdRepRadio);
        this.radioByName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.wbTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbTrans);
        this.wbTrans.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Select.Button", (String[])new String[0]));
        this.wbTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbTrans = new FormData();
        fdbTrans.right = new FormAttachment(100, 0);
        fdbTrans.top = new FormAttachment((Control)this.radioByName, 2 * this.margin);
        this.wbTrans.setLayoutData((Object)fdbTrans);
        this.wbTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.selectRepositoryTrans();
            }
        });
        this.wDirectory = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.addModifyListener(this.lsMod);
        FormData fdTransDir = new FormData();
        fdTransDir.left = new FormAttachment(this.middle + (100 - this.middle) / 2, 0);
        fdTransDir.right = new FormAttachment((Control)this.wbTrans, -this.margin);
        fdTransDir.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wDirectory.setLayoutData(fdTransDir);
        this.wDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.wTransname = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wTransname);
        this.wTransname.addModifyListener(this.lsMod);
        FormData fdTransName = new FormData();
        fdTransName.left = new FormAttachment(0, 25);
        fdTransName.right = new FormAttachment((Control)this.wDirectory, -this.margin);
        fdTransName.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wTransname.setLayoutData(fdTransName);
        this.wTransname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.radioByReference = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByReference);
        this.radioByReference.setSelection(false);
        this.radioByReference.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioRepByReference.Label", (String[])new String[0]));
        this.radioByReference.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RadioRepByReference.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRadioByReference = new FormData();
        fdRadioByReference.left = new FormAttachment(0, 0);
        fdRadioByReference.right = new FormAttachment(100, 0);
        fdRadioByReference.top = new FormAttachment((Control)this.wTransname, 2 * this.margin);
        this.radioByReference.setLayoutData((Object)fdRadioByReference);
        this.radioByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.wbByReference = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbByReference);
        this.wbByReference.setImage(GUIResource.getInstance().getImageTransGraph());
        this.wbByReference.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.SelectTrans.Tooltip", (String[])new String[0]));
        FormData fdbByReference = new FormData();
        fdbByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdbByReference.right = new FormAttachment(100, 0);
        this.wbByReference.setLayoutData((Object)fdbByReference);
        this.wbByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.selectTransByReference();
            }
        });
        this.wByReference = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18444);
        this.props.setLook((Control)this.wByReference);
        this.wByReference.addModifyListener(this.lsMod);
        FormData fdByReference = new FormData();
        fdByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdByReference.left = new FormAttachment(0, 25);
        fdByReference.right = new FormAttachment((Control)this.wbByReference, -this.margin);
        this.wByReference.setLayoutData(fdByReference);
        this.wByReference.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransExecutorDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                TransExecutorDialog.this.setRadioButtons();
            }
        });
        this.wNewTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wNewTrans);
        this.wNewTrans.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.New.Button", (String[])new String[0]));
        FormData fdNewTrans = new FormData();
        fdNewTrans.left = new FormAttachment(0, 0);
        fdNewTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wNewTrans.setLayoutData((Object)fdNewTrans);
        this.wNewTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.newTransformation();
            }
        });
        this.wEditTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wEditTrans);
        this.wEditTrans.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Edit.Button", (String[])new String[0]));
        this.wEditTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdEditTrans = new FormData();
        fdEditTrans.left = new FormAttachment((Control)this.wNewTrans, 2 * this.margin);
        fdEditTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wEditTrans.setLayoutData((Object)fdEditTrans);
        this.wEditTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.editTrans();
            }
        });
        FormData fdTransGroup = new FormData();
        fdTransGroup.left = new FormAttachment(0, 0);
        fdTransGroup.top = new FormAttachment((Control)this.wStepname, 2 * this.margin);
        fdTransGroup.right = new FormAttachment(100, 0);
        this.gTransGroup.setLayoutData((Object)fdTransGroup);
        Group lastControl = this.gTransGroup;
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdTabFolder.bottom = new FormAttachment(100, -75);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, this.margin, null);
        this.addParametersTab();
        this.addRowGroupTab();
        this.addExecutionResultTab();
        this.addResultRowsTab();
        this.addResultFilesTab();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TransExecutorDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TransExecutorDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TransExecutorDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wTransname.addSelectionListener(this.lsDef);
        this.wExecutionTimeField.addSelectionListener(this.lsDef);
        this.wExecutionResultField.addSelectionListener(this.lsDef);
        this.wExecutionNrErrorsField.addSelectionListener(this.lsDef);
        this.wExecutionLinesReadField.addSelectionListener(this.lsDef);
        this.wExecutionLinesWrittenField.addSelectionListener(this.lsDef);
        this.wExecutionLinesInputField.addSelectionListener(this.lsDef);
        this.wExecutionLinesOutputField.addSelectionListener(this.lsDef);
        this.wExecutionLinesRejectedField.addSelectionListener(this.lsDef);
        this.wExecutionLinesUpdatedField.addSelectionListener(this.lsDef);
        this.wExecutionLinesDeletedField.addSelectionListener(this.lsDef);
        this.wExecutionFilesRetrievedField.addSelectionListener(this.lsDef);
        this.wExecutionExitStatusField.addSelectionListener(this.lsDef);
        this.wExecutionLogTextField.addSelectionListener(this.lsDef);
        this.wExecutionLogChannelIdField.addSelectionListener(this.lsDef);
        this.wResultFileNameField.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TransExecutorDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.transExecutorMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void selectTransByReference() {
        if (this.repository != null) {
            SelectObjectDialog sod = this.getSelectObjectDialog(this.shell, this.repository, true, false);
            sod.open();
            RepositoryElementMetaInterface repositoryObject = sod.getRepositoryObject();
            if (repositoryObject != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                this.updateByReferenceField(repositoryObject);
                this.referenceObjectId = repositoryObject.getObjectId();
                this.setRadioButtons();
            }
        }
    }

    void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = this.getSelectObjectDialog(this.shell, this.repository, true, false);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                this.wTransname.setText(this.executorTransMeta.getName());
                this.wDirectory.setText(this.executorTransMeta.getRepositoryDirectory().getPath());
                this.wFilename.setText("");
                this.radioByName.setSelection(true);
                this.radioFilename.setSelection(false);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                this.setRadioButtons();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.executorTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, false, null);
        this.executorTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.wFilename.getText();
        FileObject root = null;
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fname = null;
            fname = file.getURL().getFile();
            if (fname != null) {
                this.loadFileTrans(fname);
                this.wFilename.setText(fname);
                this.wTransname.setText(Const.NVL((String)this.executorTransMeta.getName(), (String)""));
                this.wDirectory.setText("");
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                this.setRadioButtons();
            }
        }
        catch (IOException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTrans.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTrans.DialogMessage", (String[])new String[0]), e);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTrans.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTrans.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.executorTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname), this.repository);
        this.executorTransMeta.clearChanged();
    }

    private void editTrans() {
        try {
            this.loadTrans();
            SpoonInterface spoon = SpoonFactory.getInstance();
            if (spoon != null) {
                spoon.addTransGraph(this.executorTransMeta);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorShowingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorShowingTrans.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadTrans() throws KettleException {
        switch (this.specificationMethod) {
            case FILENAME: {
                this.loadFileTrans(this.wFilename.getText());
                break;
            }
            case REPOSITORY_BY_NAME: {
                String realDirectory = this.transMeta.environmentSubstitute(this.wDirectory.getText());
                String realTransname = this.transMeta.environmentSubstitute(this.wTransname.getText());
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.NoValidTransExecutorDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                if (this.referenceObjectId == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.ReferencedTransformationIdIsNull", (String[])new String[0]));
                }
                this.executorTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.executorTransMeta.clearChanged();
                break;
            }
        }
    }

    public void setActive() {
        boolean supportsReferences = this.repository != null && this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences();
        this.radioByName.setEnabled(this.repository != null);
        this.radioByReference.setEnabled(this.repository != null && supportsReferences);
        this.wFilename.setEnabled(this.radioFilename.getSelection());
        this.wbbFilename.setEnabled(this.radioFilename.getSelection());
        this.wTransname.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wDirectory.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wbTrans.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
        this.wbByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
    }

    protected void setRadioButtons() {
        this.radioFilename.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.FILENAME);
        this.radioByName.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.radioByReference.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.setActive();
    }

    private void updateByReferenceField(RepositoryElementMetaInterface element) {
        String path = this.getPathOf(element);
        if (path == null) {
            path = "";
        }
        this.wByReference.setText(path);
    }

    public void getData() {
        this.specificationMethod = this.transExecutorMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wFilename.setText(Const.NVL((String)this.transExecutorMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.wDirectory.setText(Const.NVL((String)this.transExecutorMeta.getDirectoryPath(), (String)""));
                this.wTransname.setText(Const.NVL((String)this.transExecutorMeta.getTransName(), (String)""));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.wByReference.setText("");
                if (this.transExecutorMeta.getTransObjectId() == null) break;
                this.referenceObjectId = this.transExecutorMeta.getTransObjectId();
                this.getByReferenceData(this.transExecutorMeta.getTransObjectId());
                break;
            }
        }
        this.setRadioButtons();
        try {
            Object[] prevSteps = this.transMeta.getStepNames();
            Arrays.sort(prevSteps);
            this.wExecutionResultTarget.setItems((String[])prevSteps);
            this.wResultFilesTarget.setItems((String[])prevSteps);
            this.wOutputRowsSource.setItems((String[])prevSteps);
            String[] inputFields = this.transMeta.getPrevStepFields(this.stepMeta).getFieldNames();
            this.parameterColumns[1].setComboValues(inputFields);
            this.wGroupField.setItems(inputFields);
        }
        catch (Exception e) {
            this.log.logError("couldn't get previous step list", (Throwable)e);
        }
        this.wGroupSize.setText(Const.NVL((String)this.transExecutorMeta.getGroupSize(), (String)""));
        this.wGroupTime.setText(Const.NVL((String)this.transExecutorMeta.getGroupTime(), (String)""));
        this.wGroupField.setText(Const.NVL((String)this.transExecutorMeta.getGroupField(), (String)""));
        this.wExecutionResultTarget.setText(this.transExecutorMeta.getExecutionResultTargetStepMeta() == null ? "" : this.transExecutorMeta.getExecutionResultTargetStepMeta().getName());
        this.wExecutionTimeField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionTimeField(), (String)""));
        this.wExecutionResultField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionResultField(), (String)""));
        this.wExecutionNrErrorsField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionNrErrorsField(), (String)""));
        this.wExecutionLinesReadField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesReadField(), (String)""));
        this.wExecutionLinesWrittenField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesWrittenField(), (String)""));
        this.wExecutionLinesInputField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesInputField(), (String)""));
        this.wExecutionLinesOutputField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesOutputField(), (String)""));
        this.wExecutionLinesRejectedField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesRejectedField(), (String)""));
        this.wExecutionLinesUpdatedField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesUpdatedField(), (String)""));
        this.wExecutionLinesDeletedField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLinesDeletedField(), (String)""));
        this.wExecutionFilesRetrievedField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionFilesRetrievedField(), (String)""));
        this.wExecutionExitStatusField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionExitStatusField(), (String)""));
        this.wExecutionLogTextField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLogTextField(), (String)""));
        this.wExecutionLogChannelIdField.setText(Const.NVL((String)this.transExecutorMeta.getExecutionLogChannelIdField(), (String)""));
        this.executorOutputStep = this.transExecutorMeta.getExecutorsOutputStep();
        this.wResultFilesTarget.setText(this.transExecutorMeta.getResultFilesTargetStepMeta() == null ? "" : this.transExecutorMeta.getResultFilesTargetStepMeta().getName());
        this.wResultFileNameField.setText(Const.NVL((String)this.transExecutorMeta.getResultFilesFileNameField(), (String)""));
        this.wOutputRowsSource.setText(this.transExecutorMeta.getOutputRowsSourceStepMeta() == null ? "" : this.transExecutorMeta.getOutputRowsSourceStepMeta().getName());
        for (int i = 0; i < this.transExecutorMeta.getOutputRowsField().length; ++i) {
            TableItem item = new TableItem(this.wOutputFields.table, 0);
            item.setText(1, Const.NVL((String)this.transExecutorMeta.getOutputRowsField()[i], (String)""));
            item.setText(2, ValueMeta.getTypeDesc((int)this.transExecutorMeta.getOutputRowsType()[i]));
            int length = this.transExecutorMeta.getOutputRowsLength()[i];
            item.setText(3, length < 0 ? "" : Integer.toString(length));
            int precision = this.transExecutorMeta.getOutputRowsPrecision()[i];
            item.setText(4, precision < 0 ? "" : Integer.toString(precision));
        }
        this.wOutputFields.removeEmptyRows();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        this.wTabFolder.setSelection(0);
        try {
            this.loadTrans();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void addParametersTab() {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 5;
        parameterTabLayout.marginHeight = 5;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        this.wGetParameters = new Button(wParametersComposite, 8);
        this.wGetParameters.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.GetParameters", (String[])new String[0]));
        this.props.setLook((Control)this.wGetParameters);
        FormData fdGetParameters = new FormData();
        fdGetParameters.bottom = new FormAttachment(100, 0);
        fdGetParameters.right = new FormAttachment(100, 0);
        this.wGetParameters.setLayoutData((Object)fdGetParameters);
        this.wGetParameters.setSelection(this.transExecutorMeta.getParameters().isInheritingAllVariables());
        this.wGetParameters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransExecutorDialog.this.getParametersFromTrans(null);
            }
        });
        this.wInheritAll = new Button(wParametersComposite, 32);
        this.wInheritAll.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)this.wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment((Control)this.wGetParameters, -this.margin);
        this.wInheritAll.setLayoutData((Object)fdInheritAll);
        this.wInheritAll.setSelection(this.transExecutorMeta.getParameters().isInheritingAllVariables());
        this.parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.column.Field", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Parameters.column.Input", (String[])new String[0]), 1, false, false)};
        this.parameterColumns[1].setUsingVariables(true);
        TransExecutorParameters parameters = this.transExecutorMeta.getParameters();
        this.wTransExecutorParameters = new TableView((VariableSpace)this.transMeta, wParametersComposite, 67588, this.parameterColumns, parameters.getVariable().length, this.lsMod, this.props);
        this.props.setLook((Control)this.wTransExecutorParameters);
        FormData fdTransExecutors = new FormData();
        fdTransExecutors.left = new FormAttachment(0, 0);
        fdTransExecutors.right = new FormAttachment(100, 0);
        fdTransExecutors.top = new FormAttachment(0, 0);
        fdTransExecutors.bottom = new FormAttachment((Control)this.wInheritAll, -this.margin * 2);
        this.wTransExecutorParameters.setLayoutData(fdTransExecutors);
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = this.wTransExecutorParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getField()[i], (String)""));
            tableItem.setText(3, Const.NVL((String)parameters.getInput()[i], (String)""));
        }
        this.wTransExecutorParameters.setRowNums();
        this.wTransExecutorParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
    }

    protected void getParametersFromTrans(TransMeta inputTransMeta) {
        try {
            if (inputTransMeta == null) {
                this.loadTrans();
                inputTransMeta = this.executorTransMeta;
            }
            String[] parameters = inputTransMeta.listParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i];
                String desc = inputTransMeta.getParameterDescription(name);
                TableItem item = new TableItem(this.wTransExecutorParameters.table, 0);
                item.setText(1, Const.NVL((String)name, (String)""));
                item.setText(3, Const.NVL((String)desc, (String)""));
            }
            this.wTransExecutorParameters.removeEmptyRows();
            this.wTransExecutorParameters.setRowNums();
            this.wTransExecutorParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingSpecifiedTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingSpecifiedTrans.Message", (String[])new String[0]), e);
        }
    }

    private void addRowGroupTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RowGroup.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.RowGroup.Tooltip", (String[])new String[0]));
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 5;
        tabLayout.marginHeight = 5;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlGroupSize = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupSize);
        this.wlGroupSize.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.GroupSize.Label", (String[])new String[0]));
        FormData fdlGroupSize = new FormData();
        fdlGroupSize.top = new FormAttachment(0, 0);
        fdlGroupSize.left = new FormAttachment(0, 0);
        fdlGroupSize.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupSize.setLayoutData((Object)fdlGroupSize);
        this.wGroupSize = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupSize);
        this.wGroupSize.addModifyListener(this.lsMod);
        FormData fdGroupSize = new FormData();
        fdGroupSize.top = new FormAttachment(0, 0);
        fdGroupSize.left = new FormAttachment(this.middle, 0);
        fdGroupSize.right = new FormAttachment(100, 0);
        this.wGroupSize.setLayoutData(fdGroupSize);
        TextVar lastControl = this.wGroupSize;
        this.wlGroupField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupField);
        this.wlGroupField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.GroupField.Label", (String[])new String[0]));
        FormData fdlGroupField = new FormData();
        fdlGroupField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlGroupField.left = new FormAttachment(0, 0);
        fdlGroupField.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupField.setLayoutData((Object)fdlGroupField);
        this.wGroupField = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupField);
        this.wGroupField.addModifyListener(this.lsMod);
        FormData fdGroupField = new FormData();
        fdGroupField.top = new FormAttachment((Control)lastControl, this.margin);
        fdGroupField.left = new FormAttachment(this.middle, 0);
        fdGroupField.right = new FormAttachment(100, 0);
        this.wGroupField.setLayoutData((Object)fdGroupField);
        lastControl = this.wGroupField;
        this.wlGroupTime = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupTime);
        this.wlGroupTime.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.GroupTime.Label", (String[])new String[0]));
        FormData fdlGroupTime = new FormData();
        fdlGroupTime.top = new FormAttachment((Control)lastControl, this.margin);
        fdlGroupTime.left = new FormAttachment(0, 0);
        fdlGroupTime.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupTime.setLayoutData((Object)fdlGroupTime);
        this.wGroupTime = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupTime);
        this.wGroupTime.addModifyListener(this.lsMod);
        FormData fdGroupTime = new FormData();
        fdGroupTime.top = new FormAttachment((Control)lastControl, this.margin);
        fdGroupTime.left = new FormAttachment(this.middle, 0);
        fdGroupTime.right = new FormAttachment(100, 0);
        this.wGroupTime.setLayoutData(fdGroupTime);
        wTab.setControl((Control)wInputComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addExecutionResultTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionResults.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionResults.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 5;
        tabLayout.marginHeight = 5;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlExecutionResultTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionResultTarget);
        this.wlExecutionResultTarget.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionResultTarget.Label", (String[])new String[0]));
        FormData fdlExecutionResultTarget = new FormData();
        fdlExecutionResultTarget.top = new FormAttachment(0, 0);
        fdlExecutionResultTarget.left = new FormAttachment(0, 0);
        fdlExecutionResultTarget.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionResultTarget.setLayoutData((Object)fdlExecutionResultTarget);
        this.wExecutionResultTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionResultTarget);
        this.wExecutionResultTarget.addModifyListener(this.lsMod);
        FormData fdExecutionResultTarget = new FormData();
        fdExecutionResultTarget.top = new FormAttachment(0, 0);
        fdExecutionResultTarget.left = new FormAttachment(this.middle, 0);
        fdExecutionResultTarget.right = new FormAttachment(100, 0);
        this.wExecutionResultTarget.setLayoutData((Object)fdExecutionResultTarget);
        Object lastControl = this.wExecutionResultTarget;
        this.wlExecutionTimeField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionTimeField);
        this.wlExecutionTimeField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionTimeField.Label", (String[])new String[0]));
        FormData fdlExecutionTimeField = new FormData();
        fdlExecutionTimeField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionTimeField.left = new FormAttachment(0, 0);
        fdlExecutionTimeField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionTimeField.setLayoutData((Object)fdlExecutionTimeField);
        this.wExecutionTimeField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionTimeField);
        this.wExecutionTimeField.addModifyListener(this.lsMod);
        FormData fdExecutionTimeField = new FormData();
        fdExecutionTimeField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionTimeField.left = new FormAttachment(this.middle, 0);
        fdExecutionTimeField.right = new FormAttachment(100, 0);
        this.wExecutionTimeField.setLayoutData(fdExecutionTimeField);
        lastControl = this.wExecutionTimeField;
        this.wlExecutionResultField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionResultField);
        this.wlExecutionResultField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionResultField.Label", (String[])new String[0]));
        FormData fdlExecutionResultField = new FormData();
        fdlExecutionResultField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionResultField.left = new FormAttachment(0, 0);
        fdlExecutionResultField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionResultField.setLayoutData((Object)fdlExecutionResultField);
        this.wExecutionResultField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionResultField);
        this.wExecutionResultField.addModifyListener(this.lsMod);
        FormData fdExecutionResultField = new FormData();
        fdExecutionResultField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionResultField.left = new FormAttachment(this.middle, 0);
        fdExecutionResultField.right = new FormAttachment(100, 0);
        this.wExecutionResultField.setLayoutData(fdExecutionResultField);
        lastControl = this.wExecutionResultField;
        this.wlExecutionNrErrorsField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionNrErrorsField);
        this.wlExecutionNrErrorsField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionNrErrorsField.Label", (String[])new String[0]));
        FormData fdlExecutionNrErrorsField = new FormData();
        fdlExecutionNrErrorsField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionNrErrorsField.left = new FormAttachment(0, 0);
        fdlExecutionNrErrorsField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionNrErrorsField.setLayoutData((Object)fdlExecutionNrErrorsField);
        this.wExecutionNrErrorsField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionNrErrorsField);
        this.wExecutionNrErrorsField.addModifyListener(this.lsMod);
        FormData fdExecutionNrErrorsField = new FormData();
        fdExecutionNrErrorsField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionNrErrorsField.left = new FormAttachment(this.middle, 0);
        fdExecutionNrErrorsField.right = new FormAttachment(100, 0);
        this.wExecutionNrErrorsField.setLayoutData(fdExecutionNrErrorsField);
        lastControl = this.wExecutionNrErrorsField;
        this.wlExecutionLinesReadField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesReadField);
        this.wlExecutionLinesReadField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesReadField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesReadField = new FormData();
        fdlExecutionLinesReadField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesReadField.left = new FormAttachment(0, 0);
        fdlExecutionLinesReadField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesReadField.setLayoutData((Object)fdlExecutionLinesReadField);
        this.wExecutionLinesReadField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesReadField);
        this.wExecutionLinesReadField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesReadField = new FormData();
        fdExecutionLinesReadField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesReadField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesReadField.right = new FormAttachment(100, 0);
        this.wExecutionLinesReadField.setLayoutData(fdExecutionLinesReadField);
        lastControl = this.wExecutionLinesReadField;
        this.wlExecutionLinesWrittenField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesWrittenField);
        this.wlExecutionLinesWrittenField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesWrittenField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesWrittenField = new FormData();
        fdlExecutionLinesWrittenField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesWrittenField.left = new FormAttachment(0, 0);
        fdlExecutionLinesWrittenField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesWrittenField.setLayoutData((Object)fdlExecutionLinesWrittenField);
        this.wExecutionLinesWrittenField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesWrittenField);
        this.wExecutionLinesWrittenField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesWrittenField = new FormData();
        fdExecutionLinesWrittenField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesWrittenField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesWrittenField.right = new FormAttachment(100, 0);
        this.wExecutionLinesWrittenField.setLayoutData(fdExecutionLinesWrittenField);
        lastControl = this.wExecutionLinesWrittenField;
        this.wlExecutionLinesInputField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesInputField);
        this.wlExecutionLinesInputField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesInputField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesInputField = new FormData();
        fdlExecutionLinesInputField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesInputField.left = new FormAttachment(0, 0);
        fdlExecutionLinesInputField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesInputField.setLayoutData((Object)fdlExecutionLinesInputField);
        this.wExecutionLinesInputField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesInputField);
        this.wExecutionLinesInputField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesInputField = new FormData();
        fdExecutionLinesInputField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesInputField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesInputField.right = new FormAttachment(100, 0);
        this.wExecutionLinesInputField.setLayoutData(fdExecutionLinesInputField);
        lastControl = this.wExecutionLinesInputField;
        this.wlExecutionLinesOutputField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesOutputField);
        this.wlExecutionLinesOutputField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesOutputField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesOutputField = new FormData();
        fdlExecutionLinesOutputField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesOutputField.left = new FormAttachment(0, 0);
        fdlExecutionLinesOutputField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesOutputField.setLayoutData((Object)fdlExecutionLinesOutputField);
        this.wExecutionLinesOutputField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesOutputField);
        this.wExecutionLinesOutputField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesOutputField = new FormData();
        fdExecutionLinesOutputField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesOutputField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesOutputField.right = new FormAttachment(100, 0);
        this.wExecutionLinesOutputField.setLayoutData(fdExecutionLinesOutputField);
        lastControl = this.wExecutionLinesOutputField;
        this.wlExecutionLinesRejectedField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesRejectedField);
        this.wlExecutionLinesRejectedField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesRejectedField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesRejectedField = new FormData();
        fdlExecutionLinesRejectedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesRejectedField.left = new FormAttachment(0, 0);
        fdlExecutionLinesRejectedField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesRejectedField.setLayoutData((Object)fdlExecutionLinesRejectedField);
        this.wExecutionLinesRejectedField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesRejectedField);
        this.wExecutionLinesRejectedField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesRejectedField = new FormData();
        fdExecutionLinesRejectedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesRejectedField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesRejectedField.right = new FormAttachment(100, 0);
        this.wExecutionLinesRejectedField.setLayoutData(fdExecutionLinesRejectedField);
        lastControl = this.wExecutionLinesRejectedField;
        this.wlExecutionLinesUpdatedField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesUpdatedField);
        this.wlExecutionLinesUpdatedField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesUpdatedField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesUpdatedField = new FormData();
        fdlExecutionLinesUpdatedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesUpdatedField.left = new FormAttachment(0, 0);
        fdlExecutionLinesUpdatedField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesUpdatedField.setLayoutData((Object)fdlExecutionLinesUpdatedField);
        this.wExecutionLinesUpdatedField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesUpdatedField);
        this.wExecutionLinesUpdatedField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesUpdatedField = new FormData();
        fdExecutionLinesUpdatedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesUpdatedField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesUpdatedField.right = new FormAttachment(100, 0);
        this.wExecutionLinesUpdatedField.setLayoutData(fdExecutionLinesUpdatedField);
        lastControl = this.wExecutionLinesUpdatedField;
        this.wlExecutionLinesDeletedField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLinesDeletedField);
        this.wlExecutionLinesDeletedField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLinesDeletedField.Label", (String[])new String[0]));
        FormData fdlExecutionLinesDeletedField = new FormData();
        fdlExecutionLinesDeletedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLinesDeletedField.left = new FormAttachment(0, 0);
        fdlExecutionLinesDeletedField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLinesDeletedField.setLayoutData((Object)fdlExecutionLinesDeletedField);
        this.wExecutionLinesDeletedField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLinesDeletedField);
        this.wExecutionLinesDeletedField.addModifyListener(this.lsMod);
        FormData fdExecutionLinesDeletedField = new FormData();
        fdExecutionLinesDeletedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLinesDeletedField.left = new FormAttachment(this.middle, 0);
        fdExecutionLinesDeletedField.right = new FormAttachment(100, 0);
        this.wExecutionLinesDeletedField.setLayoutData(fdExecutionLinesDeletedField);
        lastControl = this.wExecutionLinesDeletedField;
        this.wlExecutionFilesRetrievedField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionFilesRetrievedField);
        this.wlExecutionFilesRetrievedField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionFilesRetrievedField.Label", (String[])new String[0]));
        FormData fdlExecutionFilesRetrievedField = new FormData();
        fdlExecutionFilesRetrievedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionFilesRetrievedField.left = new FormAttachment(0, 0);
        fdlExecutionFilesRetrievedField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionFilesRetrievedField.setLayoutData((Object)fdlExecutionFilesRetrievedField);
        this.wExecutionFilesRetrievedField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionFilesRetrievedField);
        this.wExecutionFilesRetrievedField.addModifyListener(this.lsMod);
        FormData fdExecutionFilesRetrievedField = new FormData();
        fdExecutionFilesRetrievedField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionFilesRetrievedField.left = new FormAttachment(this.middle, 0);
        fdExecutionFilesRetrievedField.right = new FormAttachment(100, 0);
        this.wExecutionFilesRetrievedField.setLayoutData(fdExecutionFilesRetrievedField);
        lastControl = this.wExecutionFilesRetrievedField;
        this.wlExecutionExitStatusField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionExitStatusField);
        this.wlExecutionExitStatusField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionExitStatusField.Label", (String[])new String[0]));
        FormData fdlExecutionExitStatusField = new FormData();
        fdlExecutionExitStatusField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionExitStatusField.left = new FormAttachment(0, 0);
        fdlExecutionExitStatusField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionExitStatusField.setLayoutData((Object)fdlExecutionExitStatusField);
        this.wExecutionExitStatusField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionExitStatusField);
        this.wExecutionExitStatusField.addModifyListener(this.lsMod);
        FormData fdExecutionExitStatusField = new FormData();
        fdExecutionExitStatusField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionExitStatusField.left = new FormAttachment(this.middle, 0);
        fdExecutionExitStatusField.right = new FormAttachment(100, 0);
        this.wExecutionExitStatusField.setLayoutData(fdExecutionExitStatusField);
        lastControl = this.wExecutionExitStatusField;
        this.wlExecutionLogTextField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLogTextField);
        this.wlExecutionLogTextField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLogTextField.Label", (String[])new String[0]));
        FormData fdlExecutionLogTextField = new FormData();
        fdlExecutionLogTextField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLogTextField.left = new FormAttachment(0, 0);
        fdlExecutionLogTextField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLogTextField.setLayoutData((Object)fdlExecutionLogTextField);
        this.wExecutionLogTextField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLogTextField);
        this.wExecutionLogTextField.addModifyListener(this.lsMod);
        FormData fdExecutionLogTextField = new FormData();
        fdExecutionLogTextField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLogTextField.left = new FormAttachment(this.middle, 0);
        fdExecutionLogTextField.right = new FormAttachment(100, 0);
        this.wExecutionLogTextField.setLayoutData(fdExecutionLogTextField);
        lastControl = this.wExecutionLogTextField;
        this.wlExecutionLogChannelIdField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionLogChannelIdField);
        this.wlExecutionLogChannelIdField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ExecutionLogChannelIdField.Label", (String[])new String[0]));
        FormData fdlExecutionLogChannelIdField = new FormData();
        fdlExecutionLogChannelIdField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExecutionLogChannelIdField.left = new FormAttachment(0, 0);
        fdlExecutionLogChannelIdField.right = new FormAttachment(this.middle, -this.margin);
        this.wlExecutionLogChannelIdField.setLayoutData((Object)fdlExecutionLogChannelIdField);
        this.wExecutionLogChannelIdField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionLogChannelIdField);
        this.wExecutionLogChannelIdField.addModifyListener(this.lsMod);
        FormData fdExecutionLogChannelIdField = new FormData();
        fdExecutionLogChannelIdField.top = new FormAttachment((Control)lastControl, this.margin);
        fdExecutionLogChannelIdField.left = new FormAttachment(this.middle, 0);
        fdExecutionLogChannelIdField.right = new FormAttachment(100, 0);
        this.wExecutionLogChannelIdField.setLayoutData(fdExecutionLogChannelIdField);
        lastControl = this.wExecutionLogChannelIdField;
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultFilesTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultFiles.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultFiles.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 5;
        tabLayout.marginHeight = 5;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultFilesTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFilesTarget);
        this.wlResultFilesTarget.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultFilesTarget.Label", (String[])new String[0]));
        FormData fdlResultFilesTarget = new FormData();
        fdlResultFilesTarget.top = new FormAttachment(0, 0);
        fdlResultFilesTarget.left = new FormAttachment(0, 0);
        fdlResultFilesTarget.right = new FormAttachment(this.middle, -this.margin);
        this.wlResultFilesTarget.setLayoutData((Object)fdlResultFilesTarget);
        this.wResultFilesTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFilesTarget);
        this.wResultFilesTarget.addModifyListener(this.lsMod);
        FormData fdResultFilesTarget = new FormData();
        fdResultFilesTarget.top = new FormAttachment(0, 0);
        fdResultFilesTarget.left = new FormAttachment(this.middle, 0);
        fdResultFilesTarget.right = new FormAttachment(100, 0);
        this.wResultFilesTarget.setLayoutData((Object)fdResultFilesTarget);
        Object lastControl = this.wResultFilesTarget;
        this.wlResultFileNameField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFileNameField);
        this.wlResultFileNameField.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultFileNameField.Label", (String[])new String[0]));
        FormData fdlResultFileNameField = new FormData();
        fdlResultFileNameField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlResultFileNameField.left = new FormAttachment(0, 0);
        fdlResultFileNameField.right = new FormAttachment(this.middle, -this.margin);
        this.wlResultFileNameField.setLayoutData((Object)fdlResultFileNameField);
        this.wResultFileNameField = new TextVar((VariableSpace)this.transMeta, wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFileNameField);
        this.wResultFileNameField.addModifyListener(this.lsMod);
        FormData fdResultFileNameField = new FormData();
        fdResultFileNameField.top = new FormAttachment((Control)lastControl, this.margin);
        fdResultFileNameField.left = new FormAttachment(this.middle, 0);
        fdResultFileNameField.right = new FormAttachment(100, 0);
        this.wResultFileNameField.setLayoutData(fdResultFileNameField);
        lastControl = this.wResultFileNameField;
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultRowsTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultRows.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultRows.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 5;
        tabLayout.marginHeight = 5;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultRowsTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultRowsTarget);
        this.wlResultRowsTarget.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.OutputRowsSource.Label", (String[])new String[0]));
        FormData fdlResultRowsTarget = new FormData();
        fdlResultRowsTarget.top = new FormAttachment(0, 0);
        fdlResultRowsTarget.left = new FormAttachment(0, 0);
        fdlResultRowsTarget.right = new FormAttachment(this.middle, -this.margin);
        this.wlResultRowsTarget.setLayoutData((Object)fdlResultRowsTarget);
        this.wOutputRowsSource = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wOutputRowsSource);
        this.wOutputRowsSource.addModifyListener(this.lsMod);
        FormData fdResultRowsTarget = new FormData();
        fdResultRowsTarget.top = new FormAttachment(0, 0);
        fdResultRowsTarget.left = new FormAttachment(this.middle, 0);
        fdResultRowsTarget.right = new FormAttachment(100, 0);
        this.wOutputRowsSource.setLayoutData((Object)fdResultRowsTarget);
        CCombo lastControl = this.wOutputRowsSource;
        this.wlOutputFields = new Label(wInputComposite, 0);
        this.wlOutputFields.setText(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ResultFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputFields);
        FormData fdlResultFields = new FormData();
        fdlResultFields.left = new FormAttachment(0, 0);
        fdlResultFields.top = new FormAttachment((Control)lastControl, this.margin);
        this.wlOutputFields.setLayoutData((Object)fdlResultFields);
        int nrRows = this.transExecutorMeta.getOutputRowsField() != null ? this.transExecutorMeta.getOutputRowsField().length : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ColumnInfo.Field", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransExecutorDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wInputComposite, 68354, ciResultFields, nrRows, this.lsMod, this.props);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment((Control)this.wlOutputFields, this.margin);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, 0);
        this.wOutputFields.setLayoutData(fdResultFields);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void setFlags() {
        if (this.wlGroupSize == null || this.wlGroupSize == null || this.wlGroupField == null || this.wGroupField == null || this.wlGroupTime == null || this.wGroupTime == null) {
            return;
        }
        boolean enableSize = Const.toInt((String)this.transMeta.environmentSubstitute(this.wGroupSize.getText()), (int)-1) >= 0;
        boolean enableField = !Utils.isEmpty((CharSequence)this.wGroupField.getText());
        this.wlGroupSize.setEnabled(true);
        this.wGroupSize.setEnabled(true);
        this.wlGroupField.setEnabled(!enableSize);
        this.wGroupField.setEnabled(!enableSize);
        this.wlGroupTime.setEnabled(!enableSize && !enableField);
        this.wGroupTime.setEnabled(!enableSize && !enableField);
    }

    private void cancel() {
        this.stepname = null;
        this.transExecutorMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTrans();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingSpecifiedTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingSpecifiedTrans.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.transExecutorMeta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                this.transExecutorMeta.setFileName(this.wFilename.getText());
                this.transExecutorMeta.setDirectoryPath(null);
                this.transExecutorMeta.setTransName(null);
                this.transExecutorMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.transExecutorMeta.setDirectoryPath(this.wDirectory.getText());
                this.transExecutorMeta.setTransName(this.wTransname.getText());
                this.transExecutorMeta.setFileName(null);
                this.transExecutorMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.transExecutorMeta.setFileName(null);
                this.transExecutorMeta.setDirectoryPath(null);
                this.transExecutorMeta.setTransName(null);
                this.transExecutorMeta.setTransObjectId(this.referenceObjectId);
                break;
            }
        }
        this.collectInformation();
        this.transExecutorMeta.searchInfoAndTargetSteps(this.transMeta.getSteps());
        this.transExecutorMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        TransExecutorParameters parameters = this.transExecutorMeta.getParameters();
        int nrLines = this.wTransExecutorParameters.nrNonEmpty();
        String[] variables = new String[nrLines];
        String[] fields = new String[nrLines];
        String[] input = new String[nrLines];
        parameters.setVariable(variables);
        parameters.setField(fields);
        parameters.setInput(input);
        for (int i = 0; i < nrLines; ++i) {
            TableItem item = this.wTransExecutorParameters.getNonEmpty(i);
            variables[i] = item.getText(1);
            fields[i] = item.getText(2);
            input[i] = item.getText(3);
        }
        parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        this.transExecutorMeta.setGroupSize(this.wGroupSize.getText());
        this.transExecutorMeta.setGroupField(this.wGroupField.getText());
        this.transExecutorMeta.setGroupTime(this.wGroupTime.getText());
        this.transExecutorMeta.setExecutionResultTargetStep(this.wExecutionResultTarget.getText());
        this.transExecutorMeta.setExecutionResultTargetStepMeta(this.transMeta.findStep(this.wExecutionResultTarget.getText()));
        this.transExecutorMeta.setExecutionTimeField(this.wExecutionTimeField.getText());
        this.transExecutorMeta.setExecutionResultField(this.wExecutionResultField.getText());
        this.transExecutorMeta.setExecutionNrErrorsField(this.wExecutionNrErrorsField.getText());
        this.transExecutorMeta.setExecutionLinesReadField(this.wExecutionLinesReadField.getText());
        this.transExecutorMeta.setExecutionLinesWrittenField(this.wExecutionLinesWrittenField.getText());
        this.transExecutorMeta.setExecutionLinesInputField(this.wExecutionLinesInputField.getText());
        this.transExecutorMeta.setExecutionLinesOutputField(this.wExecutionLinesOutputField.getText());
        this.transExecutorMeta.setExecutionLinesRejectedField(this.wExecutionLinesRejectedField.getText());
        this.transExecutorMeta.setExecutionLinesUpdatedField(this.wExecutionLinesUpdatedField.getText());
        this.transExecutorMeta.setExecutionLinesDeletedField(this.wExecutionLinesDeletedField.getText());
        this.transExecutorMeta.setExecutionFilesRetrievedField(this.wExecutionFilesRetrievedField.getText());
        this.transExecutorMeta.setExecutionExitStatusField(this.wExecutionExitStatusField.getText());
        this.transExecutorMeta.setExecutionLogTextField(this.wExecutionLogTextField.getText());
        this.transExecutorMeta.setExecutionLogChannelIdField(this.wExecutionLogChannelIdField.getText());
        this.transExecutorMeta.setResultFilesTargetStep(this.wResultFilesTarget.getText());
        this.transExecutorMeta.setResultFilesTargetStepMeta(this.transMeta.findStep(this.wResultFilesTarget.getText()));
        this.transExecutorMeta.setResultFilesFileNameField(this.wResultFileNameField.getText());
        if (!Utils.isEmpty((CharSequence)this.executorOutputStep)) {
            this.transExecutorMeta.setExecutorsOutputStep(this.executorOutputStep);
            this.transExecutorMeta.setExecutorsOutputStepMeta(this.transMeta.findStep(this.executorOutputStep));
        }
        this.transExecutorMeta.setOutputRowsSourceStep(this.wOutputRowsSource.getText());
        this.transExecutorMeta.setOutputRowsSourceStepMeta(this.transMeta.findStep(this.wOutputRowsSource.getText()));
        int nrFields = this.wOutputFields.nrNonEmpty();
        this.transExecutorMeta.setOutputRowsField(new String[nrFields]);
        this.transExecutorMeta.setOutputRowsType(new int[nrFields]);
        this.transExecutorMeta.setOutputRowsLength(new int[nrFields]);
        this.transExecutorMeta.setOutputRowsPrecision(new int[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wOutputFields.getNonEmpty(i);
            this.transExecutorMeta.getOutputRowsField()[i] = item.getText(1);
            this.transExecutorMeta.getOutputRowsType()[i] = ValueMeta.getType((String)item.getText(2));
            this.transExecutorMeta.getOutputRowsLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.transExecutorMeta.getOutputRowsPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
    }

    protected void newTransformation() {
        TransMeta newTransMeta = new TransMeta();
        newTransMeta.getDatabases().addAll(this.transMeta.getDatabases());
        newTransMeta.setRepository(this.transMeta.getRepository());
        newTransMeta.setRepositoryDirectory(this.transMeta.getRepositoryDirectory());
        newTransMeta.setUsingUniqueConnections(this.transMeta.isUsingUniqueConnections());
        TransDialog transDialog = new TransDialog(this.shell, 0, newTransMeta, this.repository);
        if (transDialog.open() != null) {
            Spoon spoon = Spoon.getInstance();
            spoon.addTransGraph(newTransMeta);
            boolean saved = false;
            try {
                if (this.repository != null) {
                    if (!Utils.isEmpty((CharSequence)newTransMeta.getName())) {
                        this.wStepname.setText(newTransMeta.getName());
                    }
                    saved = spoon.saveToRepository((EngineMetaInterface)newTransMeta, false);
                    this.specificationMethod = this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences() ? ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE : ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                } else {
                    saved = spoon.saveToFile((EngineMetaInterface)newTransMeta);
                    this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error saving new transformation", e);
            }
            if (saved) {
                this.setRadioButtons();
                switch (this.specificationMethod) {
                    case FILENAME: {
                        this.wFilename.setText(Const.NVL((String)newTransMeta.getFilename(), (String)""));
                        break;
                    }
                    case REPOSITORY_BY_NAME: {
                        this.wTransname.setText(Const.NVL((String)newTransMeta.getName(), (String)""));
                        this.wDirectory.setText(newTransMeta.getRepositoryDirectory().getPath());
                        break;
                    }
                    case REPOSITORY_BY_REFERENCE: {
                        this.getByReferenceData(newTransMeta.getObjectId());
                        break;
                    }
                }
                this.getParametersFromTrans(newTransMeta);
            }
        }
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.TRANSFORMATION);
            this.updateByReferenceField((RepositoryElementMetaInterface)transInf);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    SelectObjectDialog getSelectObjectDialog(Shell parent, Repository rep, boolean showTransformations, boolean showJobs) {
        return new SelectObjectDialog(parent, rep, showTransformations, showJobs);
    }
}

