/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.xul.swt.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabListener;

public class TabSet
implements SelectionListener,
CTabFolder2Listener {
    protected CTabFolder tabfolder;
    protected List<TabItem> tabList = new ArrayList<TabItem>();
    protected int selectedIndex = -1;
    protected Font changedFont;
    protected Font unchangedFont;
    private List<TabListener> listeners = new ArrayList<TabListener>();
    public List<TabItem> lastUsedTabs = new ArrayList<TabItem>();

    public TabSet(Composite parent) {
        this.tabfolder = this.createTabFolder(parent);
        this.tabfolder.setSimple(false);
        this.tabfolder.setUnselectedImageVisible(true);
        this.tabfolder.setUnselectedCloseVisible(true);
        this.tabfolder.addSelectionListener((SelectionListener)this);
        this.tabfolder.addCTabFolder2Listener((CTabFolder2Listener)this);
    }

    public void widgetSelected(SelectionEvent event) {
        TabItem deSelectedTabItem = this.tabList.get(this.selectedIndex);
        if (deSelectedTabItem != null) {
            this.notifyDeselectListeners(deSelectedTabItem);
        }
        for (int i = 0; i < this.tabList.size(); ++i) {
            TabItem item = this.tabList.get(i);
            if (!event.item.equals(item.getSwtTabItem())) continue;
            this.selectedIndex = i;
            this.notifySelectListeners(item);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void close(CTabFolderEvent event) {
        for (int i = 0; i < this.tabList.size(); ++i) {
            TabItem item = this.tabList.get(i);
            if (!event.item.equals(item.getSwtTabItem())) continue;
            event.doit = this.notifyCloseListeners(item);
        }
    }

    public void maximize(CTabFolderEvent event) {
    }

    public void minimize(CTabFolderEvent event) {
    }

    public void showList(CTabFolderEvent event) {
    }

    public void restore(CTabFolderEvent event) {
    }

    public void notifySelectListeners(TabItem item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tabSelected(item);
        }
        this.addItemToHistory(item);
    }

    protected CTabFolder createTabFolder(Composite parent) {
        return new CTabFolder(parent, 2);
    }

    private void addItemToHistory(TabItem item) {
        if (this.lastUsedTabs.size() == 0 || this.lastUsedTabs.lastIndexOf(item) != this.lastUsedTabs.size() - 1) {
            this.lastUsedTabs.add(item);
        }
    }

    private void removeItemFromHistory(TabItem item) {
        boolean removed;
        while (removed = this.lastUsedTabs.remove(item)) {
        }
    }

    public void notifyDeselectListeners(TabItem item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tabDeselected(item);
        }
    }

    public boolean notifyCloseListeners(TabItem item) {
        boolean doit = item.notifyCloseListeners();
        for (int i = 0; i < this.listeners.size(); ++i) {
            doit &= this.listeners.get(i).tabClose(item);
        }
        if (doit) {
            this.removeItemFromHistory(item);
            this.selectLastUsedTab();
        }
        return doit;
    }

    private void selectLastUsedTab() {
        int historySize = this.lastUsedTabs.size();
        if (historySize > 0) {
            TabItem lastItem = this.lastUsedTabs.get(historySize - 1);
            this.setSelected(lastItem);
        }
    }

    public CTabFolder getSwtTabset() {
        return this.tabfolder;
    }

    public void addTab(TabItem item) {
        this.tabList.add(item);
    }

    public void addKeyListener(KeyAdapter keys) {
        this.tabfolder.addKeyListener((KeyListener)keys);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public TabItem getSelected() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.tabList.size()) {
            return this.tabList.get(this.selectedIndex);
        }
        return null;
    }

    public int indexOf(TabItem item) {
        return this.tabList.indexOf(item);
    }

    public void setSelected(int index) {
        if (index >= 0 && index < this.tabList.size()) {
            TabItem item = this.tabList.get(index);
            this.tabfolder.setSelection(item.getSwtTabItem());
            this.selectedIndex = index;
            this.notifySelectListeners(this.tabList.get(index));
        }
    }

    public void setSelected(TabItem item) {
        this.selectedIndex = this.indexOf(item);
        if (this.selectedIndex != -1) {
            this.setSelected(this.selectedIndex);
        }
    }

    public void remove(TabItem item) {
        int itemIndex = this.tabList.indexOf(item);
        if (itemIndex >= 0 && itemIndex < this.selectedIndex) {
            --this.selectedIndex;
        }
        this.tabList.remove(item);
        item.dispose();
    }

    public Font getChangedFont() {
        return this.changedFont;
    }

    public void setChangedFont(Font changedFont) {
        this.changedFont = changedFont;
    }

    public Font getUnchangedFont() {
        return this.tabfolder.getDisplay().getSystemFont();
    }

    public void addListener(TabListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TabListener listener) {
        this.listeners.remove(listener);
    }
}

