/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ISessionContainer;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.BaseSession;

public class StandaloneSession
extends BaseSession {
    private static final long serialVersionUID = -1614831602086304014L;
    private static final Log logger = LogFactory.getLog(StandaloneSession.class);
    private HashMap attributes = new HashMap();

    @Override
    public Log getLogger() {
        return logger;
    }

    public StandaloneSession() {
        this("unknown");
    }

    public StandaloneSession(String name) {
        this(name, name);
    }

    public StandaloneSession(String name, String id) {
        this(name, id, Locale.getDefault());
    }

    public StandaloneSession(String name, String id, Locale locale) {
        super(name, id, locale);
    }

    public Iterator getAttributeNames() {
        if (this.attributes == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("StandaloneSession.ERROR_0001_ACCESSING_DESTROYED_SESSION", String.valueOf(Thread.currentThread().getId())));
        }
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String attributeName) {
        if (this.attributes == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("StandaloneSession.ERROR_0001_ACCESSING_DESTROYED_SESSION", String.valueOf(Thread.currentThread().getId())));
        }
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        if (this.attributes == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("StandaloneSession.ERROR_0001_ACCESSING_DESTROYED_SESSION", String.valueOf(Thread.currentThread().getId())));
        }
        this.attributes.put(attributeName, value);
    }

    public Object removeAttribute(String attributeName) {
        if (this.attributes == null) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("StandaloneSession.ERROR_0001_ACCESSING_DESTROYED_SESSION", String.valueOf(Thread.currentThread().getId())));
        }
        Object result = this.getAttribute(attributeName);
        this.attributes.remove(attributeName);
        return result;
    }

    @Override
    public void destroy() {
        if (this.attributes != null) {
            for (Object o : this.attributes.values()) {
                if (!(o instanceof ISessionContainer)) continue;
                ISessionContainer c = (ISessionContainer)o;
                c.setSession(null);
            }
            this.attributes = null;
        }
        super.destroy();
    }
}

