/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringPentahoObjectReference;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class PublishedBeanRegistry {
    private static Map<Object, Map<Class<?>, List<String>>> classToBeanMap = Collections.synchronizedMap(new WeakHashMap());
    private static Map<ListableBeanFactory, Object> factoryMarkerCache = Collections.synchronizedMap(new WeakHashMap());
    private static Map<ListableBeanFactory, List<IPentahoObjectRegistration>> handleRegistry = Collections.synchronizedMap(new WeakHashMap());

    public static void registerBean(String beanName, Class<?> clazz, Object factoryMarker) {
        List<String> beansImplementingType;
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (factoryMarker == null) {
            throw new IllegalArgumentException("factoryMarker cannot be null");
        }
        Map<Class<?>, List<String>> registryMap = classToBeanMap.get(factoryMarker);
        if (registryMap == null) {
            registryMap = new WeakHashMap();
            classToBeanMap.put(factoryMarker, registryMap);
        }
        if ((beansImplementingType = registryMap.get(clazz)) == null) {
            beansImplementingType = Collections.synchronizedList(new ArrayList());
            registryMap.put(clazz, beansImplementingType);
        }
        beansImplementingType.add(beanName);
    }

    public static void registerFactory(ApplicationContext applicationContext) {
        Object markerBean = null;
        try {
            markerBean = applicationContext.getBean("PublishedBeanRegistryMarker");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (markerBean == null) {
            return;
        }
        factoryMarkerCache.put((ListableBeanFactory)applicationContext, markerBean);
        final ConfigurableApplicationContext listableBeanFactory = (ConfigurableApplicationContext)applicationContext;
        ArrayList<IPentahoObjectRegistration> registrationList = new ArrayList<IPentahoObjectRegistration>();
        handleRegistry.put((ListableBeanFactory)listableBeanFactory, registrationList);
        Map<Class<?>, List<String>> classListMap = classToBeanMap.get(markerBean);
        for (Map.Entry<Class<?>, List<String>> classListEntry : classListMap.entrySet()) {
            Class<?> clazz = classListEntry.getKey();
            for (String beanName : classListEntry.getValue()) {
                IPentahoObjectRegistration iPentahoObjectRegistration = PentahoSystem.registerReference(new SpringPentahoObjectReference(listableBeanFactory, beanName, clazz, null, listableBeanFactory.getBeanFactory().getBeanDefinition(beanName)));
                registrationList.add(iPentahoObjectRegistration);
            }
        }
        listableBeanFactory.addApplicationListener(new ApplicationListener(){

            public void onApplicationEvent(ApplicationEvent applicationEvent) {
                if (applicationEvent instanceof ContextClosedEvent) {
                    for (IPentahoObjectRegistration iPentahoObjectRegistration : (List)handleRegistry.get(listableBeanFactory)) {
                        iPentahoObjectRegistration.remove();
                    }
                }
            }
        });
    }

    public static Set<ListableBeanFactory> getRegisteredFactories() {
        return factoryMarkerCache.keySet();
    }

    public static void reset() {
        factoryMarkerCache.clear();
    }
}

