/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.osgi;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

public class OsgiPentahoObjectReference<T>
implements IPentahoObjectReference<T> {
    private Class<T> type;
    private ServiceReference osgiRef;
    private Map<String, Object> attributes;
    private BundleContext bundleContext;

    public OsgiPentahoObjectReference(BundleContext bundleContext, Class<T> type, ServiceReference ref) {
        this.bundleContext = bundleContext;
        this.type = type;
        this.osgiRef = ref;
    }

    public Class<?> getObjectClass() {
        return this.type;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        this.attributes = new HashMap<String, Object>();
        for (String key : this.osgiRef.getPropertyKeys()) {
            this.attributes.put(key, this.osgiRef.getProperty(key));
        }
        return this.attributes;
    }

    public T getObject() {
        Object service = this.bundleContext.getService(this.osgiRef);
        if (service instanceof IPentahoInitializer) {
            ((IPentahoInitializer)service).init(PentahoSessionHolder.getSession());
        }
        return (T)service;
    }

    public Integer getRanking() {
        Object property = this.osgiRef.getProperty("service.ranking");
        if (property == null) {
            return 0;
        }
        try {
            return Integer.parseInt(property.toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int compareTo(IPentahoObjectReference<T> o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof OsgiPentahoObjectReference) {
            OsgiPentahoObjectReference ref = (OsgiPentahoObjectReference)o;
            return this.osgiRef.compareTo((Object)ref.osgiRef);
        }
        Integer ourRank = this.getRanking();
        Integer theirRanking = o.getRanking();
        return ourRank.compareTo(theirRanking);
    }
}

