/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;

public class PentahoSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static InheritableThreadLocal context = new InheritableThreadLocal();

    public SecurityContext getContext() {
        if (context.get() == null) {
            context.set(new PentahoSecurityContextImpl());
        }
        return (SecurityContext)context.get();
    }

    public void setContext(SecurityContext sContext) {
        context.set(sContext);
    }

    public void clearContext() {
        context.remove();
    }

    public SecurityContext createEmptyContext() {
        return new PentahoSecurityContextImpl();
    }

    public static final class PentahoSecurityContextImpl
    extends SecurityContextImpl {
        InheritableThreadLocal<Authentication> authentication = new InheritableThreadLocal();

        public Authentication getAuthentication() {
            return (Authentication)this.authentication.get();
        }

        public void setAuthentication(Authentication a) {
            this.authentication.set(a);
        }

        public int hashCode() {
            if (this.getAuthentication() == null) {
                return -1;
            }
            return this.getAuthentication().hashCode();
        }

        public String toString() {
            return "Authentication: " + this.getAuthentication();
        }
    }
}

