/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.List;
import org.pentaho.platform.api.engine.ActionSequenceException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class PentahoMessenger
extends PentahoBase {
    private static final long serialVersionUID = 1617348282619161790L;
    private List messages;
    DateFormat dateFormat = LocaleHelper.getFullDateFormat(true, true);

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    @Override
    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", message, this.getClass().getName()));
            }
            super.trace(message);
        }
    }

    @Override
    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", message, this.getClass().getName()));
            }
            super.debug(message);
        }
    }

    @Override
    public void info(String message) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_INFO", message, this.getClass().getName()));
            }
            super.info(message);
        }
    }

    @Override
    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_WARNING", message, this.getClass().getName()));
            }
            super.warn(message);
        }
    }

    public void error(ActionSequenceException exception) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(exception);
            }
            CharArrayWriter charWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charWriter);
            printWriter.println(this.getLogId() + Messages.getInstance().getString("MessageFormatter.ACTION_SEQUENCE_EXECUTION_FAILED"));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_TIME", this.dateFormat.format(exception.getDate())));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_SESSION_ID", exception.getSessionId() == null ? "" : exception.getSessionId()));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_INSTANCE_ID", exception.getInstanceId() == null ? "" : exception.getInstanceId()));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_ACTION_SEQUENCE", exception.getActionSequenceName() == null ? "" : exception.getActionSequenceName()));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_ACTION_SEQUENCE_EXECUTION_STACK"));
            exception.printActionExecutionStack(printWriter);
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_ACTION_CLASS", exception.getActionClass() == null ? Messages.getInstance().getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getActionClass()));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_ACTION_DESC", exception.getStepDescription() == null ? "" : exception.getStepDescription()));
            printWriter.println(Messages.getInstance().getString("MessageFormatter.LOG_EXCEPTION_LOOP_INDEX", exception.getLoopIndex() == null ? Messages.getInstance().getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getLoopIndex().toString()));
            printWriter.print(Messages.getInstance().getString("MessageFormatter.EXCEPTION_STACK_TRACE"));
            exception.printStackTrace(printWriter);
            this.getLogger().error((Object)charWriter.toString());
        }
    }

    @Override
    public void error(String message) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", message, this.getClass().getName()));
            }
            super.error(message);
        }
    }

    @Override
    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", message, this.getClass().getName()));
            }
            super.fatal(message);
        }
    }

    @Override
    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", message, this.getClass().getName()));
            }
            super.trace(message, error);
        }
    }

    @Override
    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", message, this.getClass().getName()));
            }
            super.debug(message, error);
        }
    }

    @Override
    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_INFO", message, this.getClass().getName()));
            }
            super.info(message, error);
        }
    }

    @Override
    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_WARNING", message, this.getClass().getName()));
            }
            super.warn(message, error);
        }
    }

    @Override
    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR_EX", message, this.getClass().getName(), error.toString()));
            }
            super.error(message, error);
        }
    }

    @Override
    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR_EX", message, this.getClass().getName(), error.toString()));
            }
            super.fatal(message, error);
        }
    }

    public static String getUserString(String type) {
        return Messages.getInstance().getString("Message.USER_" + type);
    }
}

