/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.xml.sax.InputSource;

public class SolutionURIResolver
implements URIResolver,
IDocumentResourceLoader {
    public InputSource resolveEntity(String publicId, String systemId) {
        InputStream xslIS = null;
        try {
            if (systemId.toLowerCase().indexOf(".dtd") >= 0) {
                return this.resolveDTDEntity(publicId, systemId);
            }
            ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", systemId);
            xslIS = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
            return new InputSource(xslIS);
        }
        catch (IOException e) {
            Logger.error(this, e.getLocalizedMessage());
            return null;
        }
    }

    public InputSource resolveDTDEntity(String publicId, String systemId) throws IOException {
        int idx = systemId.lastIndexOf(47);
        String dtdName = systemId.substring(idx + 1);
        String fullPath = PentahoSystem.getApplicationContext().getSolutionPath("system/dtd/" + dtdName);
        File theFile = new File(fullPath);
        if (theFile.canRead()) {
            BufferedInputStream xslIS = new BufferedInputStream(new FileInputStream(theFile));
            InputSource source = new InputSource(xslIS);
            return source;
        }
        return null;
    }

    @Override
    public Source resolve(String href, String base) {
        StreamSource xslSrc = null;
        InputStream xslIS = null;
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", href);
        xslIS = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
        xslSrc = new StreamSource(xslIS);
        return xslSrc;
    }

    public InputStream loadXsl(String name) {
        InputStream xslIS = null;
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", name);
        xslIS = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
        return xslIS;
    }
}

