/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.engine.ActionExecutionException;
import org.pentaho.platform.api.engine.ActionInitializationException;
import org.pentaho.platform.api.engine.ActionSequenceException;
import org.pentaho.platform.api.engine.ActionSequencePromptException;
import org.pentaho.platform.api.engine.ActionValidationException;
import org.pentaho.platform.api.engine.IActionCompleteListener;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.api.engine.IConditionalExecution;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.ICreateFeedbackParameterCallback;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IExecutionListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterManager;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISelectionMapper;
import org.pentaho.platform.api.engine.ISolutionActionDefinition;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.InvalidParameterException;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.engine.UnresolvedParameterException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IRuntimeElement;
import org.pentaho.platform.api.repository.IRuntimeRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.output.MultiContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionParameter;
import org.pentaho.platform.engine.services.actionsequence.ActionParameterSource;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceParameterMgr;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResourceWrapper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.runtime.ParameterManager;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ActionDelegate;
import org.pentaho.platform.engine.services.solution.PojoComponent;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.XForm;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class RuntimeContext
extends PentahoMessenger
implements IRuntimeContext {
    private static final long serialVersionUID = -1179016850860938879L;
    private IRuntimeElement runtimeData;
    private static final String LOG_NAME = "RUNTIME";
    private static final String PLUGIN_BUNDLE_NAME = "org.pentaho.platform.engine.services.runtime.plugins";
    protected static final String PARAMETER_FORM = "actionparam";
    private String logId;
    private IPentahoSession session;
    protected ISolutionEngine solutionEngine;
    protected StringBuffer xformHeader;
    protected StringBuffer xformBody;
    protected Map<String, String> xformFields;
    private static final String DEFAULT_PARAMETER_XSL = "DefaultParameterForm.xsl";
    protected String parameterXsl = "DefaultParameterForm.xsl";
    protected String parameterTemplate = null;
    protected String parameterTarget;
    private String instanceId;
    private String processId;
    private String handle;
    protected IPentahoUrlFactory urlFactory;
    protected Map parameterProviders;
    protected static Map componentClassMap;
    protected IActionSequence actionSequence;
    public static final boolean debug = true;
    private boolean audit = true;
    private int status;
    protected IOutputHandler outputHandler;
    protected IParameterManager paramManager;
    private String currentComponent;
    private int promptStatus = 0;
    private int contentSequenceNumber;
    private static final byte[] PATTERN_COMPILE_LOCK;
    private static final Log logger;
    private ICreateFeedbackParameterCallback createFeedbackParameterCallback;
    private IPluginManager pluginManager;
    private List<IContentItem> generatedContentItems;

    @Override
    public Log getLogger() {
        return logger;
    }

    public RuntimeContext(String instanceId, ISolutionEngine solutionEngine, String solutionName, IRuntimeElement runtimeData, IPentahoSession session, IOutputHandler outputHandler, String processId, IPentahoUrlFactory urlFactory, Map parameterProviders, List messages, ICreateFeedbackParameterCallback createFeedbackParameterCallback) {
        this.createFeedbackParameterCallback = createFeedbackParameterCallback;
        this.instanceId = instanceId;
        this.solutionEngine = solutionEngine;
        this.session = session;
        this.outputHandler = outputHandler;
        this.processId = processId;
        this.urlFactory = urlFactory;
        this.parameterProviders = parameterProviders;
        this.setMessages(messages);
        this.xformHeader = new StringBuffer();
        this.xformBody = new StringBuffer();
        this.xformFields = new HashMap<String, String>();
        this.currentComponent = "";
        this.status = 3;
        this.runtimeData = runtimeData;
        if (runtimeData != null) {
            this.instanceId = runtimeData.getInstanceId();
        }
        this.handle = "context-" + this.hashCode() + "-" + new Date().getTime();
        this.logId = (instanceId != null ? instanceId : solutionName) + ":" + LOG_NAME + ":" + this.handle + " ";
        this.paramManager = new ParameterManager();
        String defaultParameterXsl = PentahoSystem.getSystemSetting("default-parameter-xsl", null);
        if (defaultParameterXsl != null && defaultParameterXsl.length() > 0) {
            this.setParameterXsl(defaultParameterXsl);
        }
        if (PentahoSystem.getObjectFactory().objectDefined(IPluginManager.class.getSimpleName())) {
            this.pluginManager = PentahoSystem.get(IPluginManager.class, session);
        }
        this.generatedContentItems = new ArrayList<IContentItem>();
    }

    private IRuntimeElement createChild(boolean persisted) {
        IRuntimeElement childRuntimeData = null;
        IRuntimeRepository runtimeRepository = PentahoSystem.get(IRuntimeRepository.class, this.session);
        if (runtimeRepository != null) {
            runtimeRepository.setLoggingLevel(this.loggingLevel);
            childRuntimeData = runtimeRepository.newRuntimeElement(this.instanceId, "instance", !persisted);
            String childInstanceId = childRuntimeData.getInstanceId();
            AuditHelper.audit(this.instanceId, this.session.getName(), this.getActionName(), this.getObjectName(), this.processId, "instance_start", childInstanceId, "", 0.0f, this);
        }
        return childRuntimeData;
    }

    public String createNewInstance(boolean persisted) {
        String childInstanceId = null;
        IRuntimeElement childRuntimeData = this.createChild(persisted);
        if (childRuntimeData != null) {
            childInstanceId = childRuntimeData.getInstanceId();
        }
        return childInstanceId;
    }

    public String createNewInstance(boolean persisted, Map parameters) {
        return this.createNewInstance(persisted, parameters, false);
    }

    public String createNewInstance(boolean persisted, Map parameters, boolean forceImmediateWrite) {
        String childInstanceId = null;
        IRuntimeElement childRuntimeData = this.createChild(persisted);
        if (childRuntimeData != null) {
            if (parameters != null) {
                for (String parameterName : parameters.keySet()) {
                    Object parameterValue = parameters.get(parameterName);
                    if (parameterValue instanceof String) {
                        childRuntimeData.setStringProperty(parameterName, (String)parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof BigDecimal) {
                        childRuntimeData.setBigDecimalProperty(parameterName, (BigDecimal)parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof Date) {
                        childRuntimeData.setDateProperty(parameterName, (Date)parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof List) {
                        childRuntimeData.setListProperty(parameterName, (List)parameterValue);
                        continue;
                    }
                    if (!(parameterValue instanceof Long)) continue;
                    childRuntimeData.setLongProperty(parameterName, (Long)parameterValue);
                }
            }
            childInstanceId = childRuntimeData.getInstanceId();
            if (forceImmediateWrite) {
                childRuntimeData.forceSave();
            }
        }
        return childInstanceId;
    }

    public int getStatus() {
        return this.status;
    }

    public void promptNow() {
        this.promptStatus = 2;
    }

    public void promptNeeded() {
        if (this.promptStatus < 1) {
            this.promptStatus = 1;
        }
    }

    public boolean isPromptPending() {
        return this.promptStatus != 0;
    }

    public IPentahoUrlFactory getUrlFactory() {
        return this.urlFactory;
    }

    public boolean feedbackAllowed() {
        return this.outputHandler != null && this.outputHandler.allowFeedback();
    }

    public IContentItem getFeedbackContentItem() {
        return this.outputHandler.getFeedbackContentItem();
    }

    private int getContentSequenceNumber() {
        return this.contentSequenceNumber++;
    }

    public IContentItem getOutputItem(String outputName, String mimeType, String extension) {
        IActionParameter outputParameter = this.getOutputParameter(outputName);
        if (outputParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0021_INVALID_OUTPUT_REQUEST", outputName, this.actionSequence.getSequenceName()));
            return null;
        }
        String filePath = "~/workspace/" + FilenameUtils.getBaseName((String)this.getSolutionPath()) + extension;
        String contentName = "contentrepo:" + filePath;
        if (!"content".equals(outputParameter.getType())) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0023_INVALID_OUTPUT_STREAM", outputName));
            return null;
        }
        try {
            IContentOutputHandler output = PentahoSystem.getOutputDestinationFromContentRef(contentName, this.session);
            if (output != null) {
                output.setInstanceId(this.instanceId);
                output.setSolutionPath(filePath);
                output.setMimeType(mimeType);
                output.setSession(this.session);
                IContentItem contentItem = output.getFileOutputContentItem();
                this.setOutputValue(outputName, contentItem);
                return contentItem;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IContentItem getOutputContentItem(String mimeType) {
        return this.outputHandler.getOutputContentItem("response", "content", this.instanceId, mimeType);
    }

    public IContentItem getOutputContentItem(String outputName, String mimeType) {
        MultiContentItem contentItem = null;
        IActionParameter parameter = (IActionParameter)this.actionSequence.getOutputDefinitions().get(outputName);
        if (parameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0021_INVALID_OUTPUT_REQUEST", outputName, this.actionSequence.getSequenceName()));
        } else {
            List destinationsList = parameter.getVariables();
            Iterator destinationsIterator = destinationsList.iterator();
            if (destinationsList.size() > 1) {
                contentItem = new MultiContentItem();
            }
            while (destinationsIterator.hasNext()) {
                ActionParameterSource destination = (ActionParameterSource)destinationsIterator.next();
                String objectName = destination.getSourceName();
                String contentName = destination.getValue();
                contentName = TemplateUtil.applyTemplate(contentName, this);
                this.outputHandler.setSession(this.session);
                IContentItem tmpContentItem = this.outputHandler.getOutputContentItem(objectName, contentName, this.instanceId, mimeType);
                this.addOutputContentItem(tmpContentItem);
                if (contentItem instanceof MultiContentItem) {
                    contentItem.addContentItem(tmpContentItem);
                    continue;
                }
                contentItem = tmpContentItem;
                break;
            }
        }
        return contentItem;
    }

    public String getHandle() {
        return this.handle;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public String getSolutionPath() {
        return this.actionSequence != null ? this.actionSequence.getSolutionPath() : null;
    }

    public String getCurrentComponentName() {
        if ("".equals(this.currentComponent)) {
            return this.getClass().getName();
        }
        return this.currentComponent;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getErrorLevel() {
        return this.status;
    }

    public void setActionSequence(IActionSequence sequence) {
        this.actionSequence = sequence;
        this.paramManager = new ParameterManager(sequence);
    }

    public void validateSequence(String sequenceName, IExecutionListener execListener) throws ActionValidationException {
        this.paramManager.resetParameters();
        this.logId = this.instanceId + ":" + LOG_NAME + ":" + this.handle + ":" + sequenceName + " ";
        if (this.audit) {
            this.audit("action_sequence_start", "start", "", 0L);
        }
        if (this.status != 3) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0001_RUNTIME_RUNNING"));
        }
        this.initFromActionSequenceDefinition();
        try {
            this.validateComponents(this.actionSequence, execListener);
            this.status = 1;
        }
        catch (ActionValidationException ex) {
            this.status = 0;
            throw ex;
        }
    }

    private void validateComponents(IActionSequence sequence, IExecutionListener execListener) throws ActionValidationException {
        List defList = sequence.getActionDefinitionsAndSequences();
        for (Object listItem : defList) {
            if (listItem instanceof IActionSequence) {
                this.validateComponents((IActionSequence)listItem, execListener);
                continue;
            }
            if (!(listItem instanceof ISolutionActionDefinition)) continue;
            ISolutionActionDefinition actionDef = (ISolutionActionDefinition)listItem;
            this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_VALIDATING_COMPONENT", actionDef.getComponentName()));
            IComponent component = null;
            try {
                component = this.resolveComponent(actionDef, this.instanceId, this.processId, this.session);
                component.setLoggingLevel(this.loggingLevel);
                actionDef.setComponent(component);
                this.paramManager.setCurrentParameters(actionDef);
            }
            catch (Throwable ex) {
                ActionDefinition actionDefinition = new ActionDefinition((Element)actionDef.getNode(), null);
                throw new ActionValidationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0009_COULD_NOT_CREATE_COMPONENT", actionDef.getComponentName().trim()), ex, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), actionDefinition.getDescription(), actionDefinition.getComponentName());
            }
            int validateResult = 1;
            try {
                validateResult = component.validate();
            }
            catch (Throwable t) {
                throw new ActionValidationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0035_ACTION_VALIDATION_FAILED"), t, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), component.getActionDefinition());
            }
            if (validateResult != 1) {
                throw new ActionValidationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0035_ACTION_VALIDATION_FAILED"), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), component.getActionDefinition());
            }
            this.paramManager.addOutputParameters(actionDef);
            this.setCurrentComponent("");
            this.setCurrentActionDef(null);
        }
        if (execListener != null) {
            execListener.validated((IRuntimeContext)this);
        }
    }

    public IPentahoStreamSource getDataSource(String parameterName) {
        IPentahoStreamSource dataSource = null;
        IActionParameter actionParameter = this.paramManager.getCurrentInput(parameterName);
        if (actionParameter == null) {
            throw new InvalidParameterException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0019_INVALID_INPUT_REQUEST", parameterName, this.actionSequence.getSequenceName()));
        }
        Object locObj = actionParameter.getValue();
        if (locObj != null && locObj instanceof IContentItem) {
            dataSource = ((IContentItem)locObj).getDataSource();
        }
        return dataSource;
    }

    protected static Map getComponentClassMap() {
        if (componentClassMap == null) {
            componentClassMap = Collections.synchronizedMap(RuntimeContext.createComponentClassMap());
        }
        return componentClassMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map createComponentClassMap() {
        Properties knownComponents = new Properties();
        try {
            ResourceBundle pluginBundle = ResourceBundle.getBundle(PLUGIN_BUNDLE_NAME);
            if (pluginBundle != null) {
                Enumeration<String> keyEnum = pluginBundle.getKeys();
                String bundleKey = null;
                while (keyEnum.hasMoreElements()) {
                    bundleKey = keyEnum.nextElement();
                    knownComponents.put(bundleKey, pluginBundle.getString(bundleKey));
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)Messages.getInstance().getString("RuntimeContext.WARN_NO_PLUGIN_PROPERTIES_BUNDLE"));
        }
        InputStream is = null;
        try {
            File f = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin.properties"));
            if (f.exists()) {
                is = new FileInputStream(f);
                Properties overrideComponents = new Properties();
                overrideComponents.load(is);
                knownComponents.putAll((Map<?, ?>)overrideComponents);
            }
        }
        catch (FileNotFoundException ignored) {
            logger.warn((Object)Messages.getInstance().getString("RuntimeContext.WARN_NO_PLUGIN_PROPERTIES"));
        }
        catch (IOException ignored) {
            logger.warn((Object)Messages.getInstance().getString("RuntimeContext.WARN_BAD_PLUGIN_PROPERTIES"), (Throwable)ignored);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignored) {}
        }
        return knownComponents;
    }

    protected void setCurrentComponent(String componentClassName) {
        this.currentComponent = componentClassName;
    }

    protected void setCurrentActionDef(ISolutionActionDefinition actionDefinition) {
    }

    protected static String getComponentClassName(String rawClassName, IRuntimeContext runtime) {
        String mappedClassName = (String)RuntimeContext.getComponentClassMap().get(rawClassName);
        if (mappedClassName != null) {
            if (mappedClassName.charAt(0) == '!') {
                mappedClassName = mappedClassName.substring(1);
                runtime.warn(Messages.getInstance().getString("RuntimeContext.WARN_DEPRECATED_COMPONENT_CLASS", rawClassName, mappedClassName));
                runtime.audit("deprecated", rawClassName, mappedClassName, 0L);
            }
            return mappedClassName;
        }
        return rawClassName;
    }

    protected IComponent resolveComponent(ISolutionActionDefinition actionDefinition, String currentInstanceId, String currentProcessId, IPentahoSession currentSession) throws ClassNotFoundException, PluginBeanException, InstantiationException, IllegalAccessException {
        String componentAlias = actionDefinition.getComponentName().trim();
        String componentClassName = RuntimeContext.getComponentClassName(componentAlias, this);
        Element componentDefinition = (Element)actionDefinition.getComponentSection();
        this.setCurrentComponent(componentClassName);
        this.setCurrentActionDef(actionDefinition);
        IComponent component = null;
        Class<?> componentClass = null;
        Object componentTmp = null;
        if (this.pluginManager != null && this.pluginManager.isBeanRegistered(componentAlias)) {
            this.debug("Component alias " + componentAlias + " will be resolved by the plugin manager.");
            componentTmp = this.pluginManager.getBean(componentAlias);
            this.debug("Component found in a plugin, class is: " + componentTmp.getClass().getName());
        }
        this.debug("Component alias " + componentAlias + " will be resolved by the platform");
        if (componentTmp == null) {
            componentClass = Class.forName(componentClassName);
            componentTmp = componentClass.newInstance();
        }
        if (componentTmp instanceof IComponent) {
            component = (IComponent)componentTmp;
        } else if (componentTmp instanceof IAction) {
            component = new ActionDelegate(componentTmp);
        } else {
            PojoComponent pc = new PojoComponent();
            pc.setPojo(componentTmp);
            component = pc;
        }
        component.setInstanceId(currentInstanceId);
        component.setActionName(this.getActionName());
        component.setProcessId(currentProcessId);
        if (component instanceof IParameterResolver) {
            component.setActionDefinition((IActionDefinition)ActionFactory.getActionDefinition((Element)((Element)actionDefinition.getNode()), (IActionParameterMgr)new ActionSequenceParameterMgr(this, currentSession, (IParameterResolver)component)));
        } else {
            component.setActionDefinition((IActionDefinition)ActionFactory.getActionDefinition((Element)((Element)actionDefinition.getNode()), (IActionParameterMgr)new ActionSequenceParameterMgr(this, currentSession)));
        }
        HashMap<String, String> componentDefinitionMap = new HashMap<String, String>();
        List elements = componentDefinition.elements();
        String customXsl = null;
        for (int idx = 0; idx < elements.size(); ++idx) {
            Element element = (Element)elements.get(idx);
            String name = element.getName();
            String value = element.getText();
            if ("target".equals(name)) {
                this.setParameterTarget(value);
            } else if ("xsl".equals(name)) {
                customXsl = value;
            }
            componentDefinitionMap.put(element.getName(), element.getText());
        }
        if (customXsl != null) {
            this.setParameterXsl(customXsl);
        }
        component.setComponentDefinitionMap(componentDefinitionMap);
        component.setComponentDefinition((Node)componentDefinition);
        component.setRuntimeContext((IRuntimeContext)this);
        component.setSession(currentSession);
        component.setLoggingLevel(this.getLoggingLevel());
        component.setMessages(this.getMessages());
        return component;
    }

    public void executeSequence(IActionCompleteListener doneListener, IExecutionListener execListener, boolean async) throws ActionSequenceException {
        this.paramManager.resetParameters();
        long start = new Date().getTime();
        this.status = 5;
        List actionDefinitions = this.actionSequence.getActionDefinitionsAndSequences();
        if (actionDefinitions == null) {
            this.audit("action_sequence_failed", "validation", Messages.getInstance().getErrorString("RuntimeContext.ERROR_0011_NO_VALID_ACTIONS"), 0L);
            this.status = 7;
            throw new ActionValidationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0011_NO_VALID_ACTIONS"), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), null);
        }
        this.setLoggingLevel(this.loggingLevel);
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_EXECUTING_ACTIONS"));
        this.paramManager.setCurrentParameters(null);
        try {
            this.resolveParameters();
            if (execListener != null) {
                execListener.loaded((IRuntimeContext)this);
            }
            this.executeSequence(this.actionSequence, doneListener, execListener, async);
            if (this.feedbackAllowed() && (this.promptStatus != 0 || this.xformBody.length() > 0 || this.parameterTemplate != null)) {
                this.sendFeedbackForm();
            }
            this.paramManager.setCurrentParameters(null);
            if (this.audit) {
                this.audit("action_sequence_end", "end", "", (int)(new Date().getTime() - start));
            }
            if (!this.isPromptPending()) {
                Map returnParamMap = this.paramManager.getReturnParameters();
                for (Map.Entry mapEntry : returnParamMap.entrySet()) {
                    String paramName = (String)mapEntry.getKey();
                    ParameterManager.ReturnParameter returnParam = (ParameterManager.ReturnParameter)mapEntry.getValue();
                    if (returnParam == null) {
                        this.error(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0029_SAVE_PARAM_NOT_FOUND", paramName));
                        continue;
                    }
                    if ("session".equals(returnParam.destinationName)) {
                        this.session.setAttribute(returnParam.destinationParameter, returnParam.value);
                        this.debug(paramName + " - session - " + returnParam.destinationParameter);
                        continue;
                    }
                    if ("response".equals(returnParam.destinationName)) {
                        if (this.outputHandler != null) {
                            this.outputHandler.setOutput(returnParam.destinationParameter, returnParam.value);
                        } else {
                            this.info(Messages.getInstance().getString("RuntimeContext.INFO_NO_OUTPUT_HANDLER"));
                        }
                        this.debug(paramName + " - response - " + returnParam.destinationParameter);
                        continue;
                    }
                    if ("global".equals(returnParam.destinationName)) {
                        PentahoSystem.putInGlobalAttributesMap(returnParam.destinationParameter, returnParam.value);
                        this.debug(paramName + " - global - " + returnParam.destinationParameter);
                        continue;
                    }
                    this.warn(Messages.getInstance().getString("RuntimeContext.WARN_UNRECOGNIZED_SCOPE", returnParam.destinationName, returnParam.destinationParameter));
                }
            }
        }
        catch (UnresolvedParameterException ex) {
            this.status = 7;
            this.audit("action_sequence_failed", "validation", Messages.getInstance().getErrorString("RuntimeContext.ERROR_0013_BAD_PARAMETERS"), 0L);
            throw ex;
        }
        catch (ActionSequenceException ex) {
            this.status = 7;
            this.audit("action_sequence_failed", "execution", "", (int)(new Date().getTime() - start));
            throw ex;
        }
        catch (IOException ex) {
            this.status = 7;
            this.audit("action_sequence_failed", "execution", "", (int)(new Date().getTime() - start));
            throw new ActionSequenceException((Throwable)ex);
        }
    }

    public void setPromptStatus(int status) {
        this.promptStatus = status;
    }

    public void executeSequence(IActionSequence sequence, IActionCompleteListener doneListener, IExecutionListener execListener, boolean async) throws ActionSequenceException {
        Object loopList;
        String loopParamName = sequence.getLoopParameter();
        boolean peekOnly = sequence.getLoopUsingPeek();
        IActionParameter loopParm = null;
        if (loopParamName == null) {
            loopList = new ArrayList<Integer>();
            ((ArrayList)loopList).add(new Integer(0));
        } else {
            loopParm = this.getLoopParameter(loopParamName);
            loopList = loopParm.getValue();
            if (loopList instanceof Object[]) {
                loopList = Arrays.asList((Object[])loopList);
            }
        }
        if (loopList instanceof List) {
            this.executeLoop(loopParm, (List)loopList, sequence, doneListener, execListener, async);
            if (loopParm != null) {
                this.addInputParameter(loopParm.getName(), loopParm);
            }
        } else if (loopList instanceof IPentahoResultSet) {
            this.executeLoop(loopParm, (IPentahoResultSet)loopList, sequence, doneListener, execListener, async, peekOnly);
        }
    }

    private void executeLoop(IActionParameter loopParm, IPentahoResultSet loopSet, IActionSequence sequence, IActionCompleteListener doneListener, IExecutionListener execListener, boolean async, boolean peekOnly) throws ActionSequenceException {
        int loopCount = -1;
        if (loopSet.isScrollable()) {
            loopSet.beforeFirst();
        }
        if (peekOnly && !(loopSet instanceof IPeekable)) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0033_NOT_PEEKABLE"), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), null);
        }
        Object[] row = peekOnly ? ((IPeekable)loopSet).peek() : loopSet.next();
        Object[][] headerSet = loopSet.getMetaData().getColumnHeaders();
        Object[] headers = headerSet[0];
        while (row != null) {
            this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_EXECUTING_ACTION", Integer.toString(++loopCount)));
            if (execListener != null) {
                execListener.loop((IRuntimeContext)this, (long)loopCount);
            }
            if (loopParm != null) {
                for (int columnNo = 0; columnNo < headers.length; ++columnNo) {
                    String name = headers[columnNo].toString();
                    Object value = row[columnNo];
                    String type = null;
                    if (value instanceof String) {
                        type = "string";
                    } else if (value instanceof Date) {
                        type = "date";
                    } else if (value instanceof Long || value instanceof Integer) {
                        type = "integer";
                    } else if (value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
                        type = "bigdecimal";
                    } else if (value instanceof String[]) {
                        type = "string";
                    } else if (value == null) {
                        this.warn(Messages.getInstance().getString("RuntimeContext.WARN_VARIABLE_IN_LOOP_IS_NULL", name));
                    } else {
                        type = "object";
                        this.warn(Messages.getInstance().getString("RuntimeContext.WARN_VARIABLE_IN_LOOP_NOT_RECOGNIZED", name, value.getClass().toString()));
                    }
                    IActionParameter ap = this.paramManager.getInput(name);
                    if (ap == null) {
                        ap = new ActionParameter(name, type, value, null, null);
                        this.addInputParameter(name, ap);
                        continue;
                    }
                    ap.dispose();
                    ap.setValue(value);
                }
            }
            try {
                this.performActions(sequence, doneListener, execListener, async);
            }
            catch (ActionSequenceException e) {
                e.setLoopIndex(Integer.valueOf(loopCount));
                throw e;
            }
            row = peekOnly ? ((IPeekable)loopSet).peek() : loopSet.next();
        }
        this.status = 6;
    }

    private void executeLoop(IActionParameter loopParm, List loopList, IActionSequence sequence, IActionCompleteListener doneListener, IExecutionListener execListener, boolean async) throws ActionSequenceException {
        int loopCount = -1;
        Iterator it = loopList.iterator();
        while (it.hasNext()) {
            this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_EXECUTING_ACTION", Integer.toString(++loopCount)));
            if (execListener != null) {
                execListener.loop((IRuntimeContext)this, (long)loopCount);
            }
            Object loopVar = it.next();
            if (loopParm != null) {
                ActionParameter ap = loopVar instanceof Map ? new ActionParameter(loopParm.getName(), "property-map", loopVar, null, null) : new ActionParameter(loopParm.getName(), "string", loopVar, null, null);
                this.addInputParameter(loopParm.getName(), ap);
            }
            try {
                this.performActions(sequence, doneListener, execListener, async);
            }
            catch (ActionSequenceException e) {
                e.setLoopIndex(Integer.valueOf(loopCount));
                throw e;
            }
            if (this.promptStatus != 2) continue;
            return;
        }
        this.status = 6;
    }

    private void performActions(IActionSequence sequence, IActionCompleteListener doneListener, IExecutionListener execListener, boolean async) throws ActionSequenceException {
        IConditionalExecution conditional = sequence.getConditionalExecution();
        if (conditional != null) {
            try {
                if (!conditional.shouldExecute(this.paramManager.getAllParameters(), logger)) {
                    this.debug(Messages.getInstance().getString("RuntimeContext.INFO_ACTION_NOT_EXECUTED"));
                    this.status = 6;
                    return;
                }
            }
            catch (Exception ex) {
                this.currentComponent = "";
                this.status = 7;
                throw new ActionExecutionException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0032_CONDITIONAL_EXECUTION_FAILED"), (Throwable)ex, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), null);
            }
        }
        List defList = sequence.getActionDefinitionsAndSequences();
        for (Object listItem : defList) {
            if (listItem instanceof IActionSequence) {
                this.executeSequence((IActionSequence)listItem, doneListener, execListener, async);
            } else if (listItem instanceof ISolutionActionDefinition) {
                ISolutionActionDefinition actionDef = (ISolutionActionDefinition)listItem;
                this.currentComponent = actionDef.getComponentName();
                this.paramManager.setCurrentParameters(actionDef);
                try {
                    this.executeAction(actionDef, this.parameterProviders, doneListener, execListener, async);
                    this.paramManager.addOutputParameters(actionDef);
                }
                catch (ActionSequenceException ex) {
                    this.currentComponent = "";
                    this.status = 7;
                    throw ex;
                }
            }
            if (this.promptStatus == 2) break;
            this.currentComponent = "";
        }
        this.status = 6;
    }

    private void executeAction(ISolutionActionDefinition actionDefinition, Map pParameterProviders, IActionCompleteListener doneListener, IExecutionListener execListener, boolean async) throws ActionInitializationException, ActionExecutionException, UnresolvedParameterException {
        this.parameterProviders = pParameterProviders;
        long start = new Date().getTime();
        if (this.audit) {
            this.audit("component_execution_start", "start", "", 0L);
        }
        try {
            this.resolveParameters();
        }
        catch (UnresolvedParameterException ex) {
            this.audit("component_execution_failed", "validation", Messages.getInstance().getErrorString("RuntimeContext.ERROR_0013_BAD_PARAMETERS"), 0L);
            if (doneListener != null) {
                doneListener.actionComplete((IRuntimeContext)this);
            }
            this.status = 7;
            ex.setActionClass(actionDefinition.getComponentName());
            ex.setStepDescription(actionDefinition.getDescription());
            throw ex;
        }
        this.status = 2;
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_PRE-EXECUTE_AUDIT"));
        List auditPre = actionDefinition.getPreExecuteAuditList();
        this.audit(auditPre);
        IComponent component = actionDefinition.getComponent();
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_SETTING_LOGGING", Logger.getLogLevelName(this.loggingLevel)));
        component.setLoggingLevel(this.loggingLevel);
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_INITIALIZING_COMPONENT"));
        boolean initResult = false;
        try {
            initResult = component.init();
        }
        catch (Throwable t) {
            throw new ActionInitializationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0016_COMPONENT_INITIALIZE_FAILED"), t, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), component.getActionDefinition());
        }
        if (!initResult) {
            this.status = 8;
            this.audit("component_execution_failed", "validation", Messages.getInstance().getErrorString("RuntimeContext.ERROR_0016_COMPONENT_INITIALIZE_FAILED"), 0L);
            if (doneListener != null) {
                doneListener.actionComplete((IRuntimeContext)this);
            }
            throw new ActionInitializationException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0016_COMPONENT_INITIALIZE_FAILED"), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), component.getActionDefinition());
        }
        try {
            this.executeComponent(actionDefinition);
        }
        catch (ActionExecutionException ex) {
            if (doneListener != null) {
                doneListener.actionComplete((IRuntimeContext)this);
            }
            throw ex;
        }
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_POST-EXECUTE_AUDIT"));
        List auditPost = actionDefinition.getPostExecuteAuditList();
        this.audit(auditPost);
        if (this.audit) {
            long end = new Date().getTime();
            this.audit("component_execution_end", "end", "", (int)(end - start));
        }
        if (doneListener != null) {
            doneListener.actionComplete((IRuntimeContext)this);
        }
        if (execListener != null) {
            execListener.action((IRuntimeContext)this, actionDefinition);
        }
    }

    protected void executeComponent(ISolutionActionDefinition actionDefinition) throws ActionExecutionException {
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_STARTING_COMPONENT_EXECUTE"));
        try {
            this.status = this.getOutputPreference() == 1 && actionDefinition.getComponentName().contains("SecureFilterComponent") ? actionDefinition.getComponent().execute() : (this.getOutputPreference() != 1 ? actionDefinition.getComponent().execute() : 6);
            actionDefinition.getComponent().done();
            this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_FINISHED_COMPONENT_EXECUTE"));
        }
        catch (Throwable e) {
            this.status = 7;
            this.audit("component_execution_failed", "failed", e.getLocalizedMessage(), 0L);
            throw new ActionExecutionException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0017_COMPONENT_EXECUTE_FAILED"), e, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), actionDefinition.getComponent().getActionDefinition());
        }
        if (this.status != 6) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0017_COMPONENT_EXECUTE_FAILED"), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), actionDefinition.getComponent().getActionDefinition());
        }
    }

    private void initFromActionSequenceDefinition() {
        int actionLogLevel = this.actionSequence.getLoggingLevel();
        int instanceLogLevel = this.runtimeData.getLoggingLevel();
        int actionSequenceLoggingLevel = instanceLogLevel != 100 ? instanceLogLevel : (actionLogLevel != 100 ? actionLogLevel : this.solutionEngine.getLoggingLevel());
        this.setLoggingLevel(actionSequenceLoggingLevel);
    }

    private void resolveParameters() throws UnresolvedParameterException {
        Set inputNames = this.getInputNames();
        Iterator inputNamesIterator = inputNames.iterator();
        Object variableValue = null;
        while (inputNamesIterator.hasNext()) {
            variableValue = null;
            String inputName = (String)inputNamesIterator.next();
            IActionParameter actionParameter = this.paramManager.getCurrentInput(inputName);
            if (actionParameter == null) {
                throw new UnresolvedParameterException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0031_INPUT_NOT_FOUND", inputName), this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), null);
            }
            List variables = actionParameter.getVariables();
            for (ActionParameterSource variable : variables) {
                String sourceName = variable.getSourceName();
                String sourceValue = variable.getValue();
                variableValue = null;
                if ("runtime".equals(sourceName)) {
                    variableValue = this.getStringParameter(sourceValue, null);
                    if (variableValue == null) {
                        variableValue = this.runtimeData.getStringProperty(sourceValue, null);
                    }
                    if (variableValue == null) continue;
                    break;
                }
                IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get(sourceName);
                if (parameterProvider == null) {
                    this.warn(Messages.getInstance().getString("RuntimeContext.WARN_REQUESTED_PARAMETER_SOURCE_NOT_AVAILABLE", sourceName, inputName));
                    continue;
                }
                variableValue = parameterProvider.getParameter(sourceValue);
                if (variableValue == null) continue;
            }
            if (variableValue == null) {
                if (actionParameter.getValue() != null) {
                    if (!actionParameter.hasDefaultValue()) continue;
                    continue;
                }
                if (!"content".equals(actionParameter.getType())) continue;
                variableValue = "";
                continue;
            }
            actionParameter.setValue(variableValue);
        }
    }

    public void dispose() {
        this.paramManager.dispose();
    }

    public void dispose(List actionParameters) {
        this.paramManager.dispose(actionParameters);
    }

    public String getStringParameter(String name, String defaultValue) {
        if ("instance-id".equals(name)) {
            return this.instanceId;
        }
        if ("solution-id".equals(name)) {
            return "";
        }
        return defaultValue;
    }

    public Object getInputParameterValue(String name) {
        Object value = null;
        IActionParameter actionParameter = this.paramManager.getCurrentInput(name);
        if (actionParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0019_INVALID_INPUT_REQUEST", name, this.actionSequence.getSequenceName()));
        } else {
            value = actionParameter.getValue();
        }
        return value;
    }

    public String getInputParameterStringValue(String name) {
        String value = null;
        IActionParameter actionParameter = this.paramManager.getCurrentInput(name);
        if (actionParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0019_INVALID_INPUT_REQUEST", name, this.actionSequence.getSequenceName()));
        } else {
            value = actionParameter.getStringValue();
        }
        return value;
    }

    private IActionParameter getLoopParameter(String name) {
        IActionParameter actionParameter = this.paramManager.getLoopParameter(name);
        if (actionParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0020_INVALID_LOOP_PARAMETER", name, this.actionSequence.getSequenceName()));
        }
        return actionParameter;
    }

    public IActionParameter getInputParameter(String name) {
        IActionParameter actionParameter = this.paramManager.getCurrentInput(name);
        if (actionParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0019_INVALID_INPUT_REQUEST", name, this.actionSequence.getSequenceName()));
        }
        return actionParameter;
    }

    public IActionParameter getOutputParameter(String name) {
        IActionParameter actionParameter = this.paramManager.getCurrentOutput(name);
        if (actionParameter == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0021_INVALID_OUTPUT_REQUEST", name, this.actionSequence.getSequenceName()));
        }
        return actionParameter;
    }

    public IActionSequenceResource getResourceDefintion(String name) {
        IActionSequenceResource actionResource = this.paramManager.getCurrentResource(name);
        if (actionResource == null) {
            this.warn(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0022_INVALID_RESOURCE_REQUEST", name, this.actionSequence.getSequenceName()));
        }
        return actionResource;
    }

    public Set getInputNames() {
        return this.paramManager.getCurrentInputNames();
    }

    public void addTempParameter(String name, IActionParameter param) {
        this.paramManager.addToCurrentInputs(name, param);
    }

    public void setOutputValue(String name, Object output) {
        IActionParameter actionParameter = this.paramManager.getCurrentOutput(name);
        if (actionParameter == null) {
            throw new InvalidParameterException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0021_INVALID_OUTPUT_REQUEST", name, this.actionSequence.getSequenceName()));
        }
        actionParameter.setValue(output);
        if (output instanceof String) {
            this.runtimeData.setStringProperty(name, (String)output);
        } else if (output instanceof Date) {
            this.runtimeData.setDateProperty(name, (Date)output);
        } else if (output instanceof Long) {
            this.runtimeData.setLongProperty(name, (Long)output);
        } else if (output instanceof List) {
            this.runtimeData.setListProperty(name, (List)output);
        } else if (output instanceof Map) {
            this.runtimeData.setMapProperty(name, (Map)output);
        } else if (output instanceof IContentItem) {
            this.runtimeData.setStringProperty(name, ((IContentItem)output).getPath());
        }
    }

    public InputStream getInputStream(String parameterName) {
        InputStream inputStream = null;
        IActionParameter inputParameter = this.getInputParameter(parameterName);
        if (inputParameter == null) {
            throw new InvalidParameterException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0019_INVALID_INPUT_REQUEST", parameterName, this.actionSequence.getSequenceName()));
        }
        Object value = inputParameter.getValue();
        if (value instanceof IContentItem) {
            IContentItem contentItem = (IContentItem)value;
            inputStream = contentItem.getInputStream();
        }
        return inputStream;
    }

    public Set getOutputNames() {
        return this.paramManager.getCurrentOutputNames();
    }

    public Set getResourceNames() {
        return this.paramManager.getCurrentResourceNames();
    }

    public InputStream getResourceInputStream(IActionSequenceResource actionResource) throws FileNotFoundException {
        return actionResource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
    }

    public String getResourceAsString(IActionSequenceResource actionResource) throws IOException {
        if (this.isEmbeddedResource(actionResource)) {
            return this.getEmbeddedResource(actionResource);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)actionResource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale()));
        return new String(bytes, LocaleHelper.getSystemEncoding());
    }

    public Document getResourceAsDocument(IActionSequenceResource actionResource) throws IOException {
        if (this.isEmbeddedResource(actionResource)) {
            try {
                return XmlDom4JHelper.getDocFromString(this.getEmbeddedResource(actionResource), null);
            }
            catch (XmlParseException e) {
                this.error(Messages.getInstance().getString("RuntimeContext.ERROR_UNABLE_TO_GET_RESOURCE_AS_DOCUMENT"), e);
                return null;
            }
        }
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)((Object)new SolutionURIResolver()));
            document = reader.read(actionResource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return document;
    }

    public IPentahoStreamSource getResourceDataSource(IActionSequenceResource actionResource) throws FileNotFoundException {
        return new ActionSequenceResourceWrapper(actionResource, actionResource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale()));
    }

    private boolean isEmbeddedResource(IActionSequenceResource actionResource) {
        int type = actionResource.getSourceType();
        return type == 5 || type == 6;
    }

    private String getEmbeddedResource(IActionSequenceResource actionResource) {
        String s = actionResource.getAddress();
        return s == null ? "" : s;
    }

    public String getId() {
        return this.handle;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActionName() {
        return this.actionSequence != null ? this.actionSequence.getSequenceName() : Messages.getInstance().getString("RuntimeContext.DEBUG_NO_ACTION");
    }

    public String getActionTitle() {
        return this.actionSequence != null ? this.actionSequence.getTitle() : Messages.getInstance().getString("RuntimeContext.DEBUG_NO_ACTION");
    }

    public void audit(List auditList) {
        if (auditList == null || auditList.size() == 0) {
            return;
        }
        for (Element auditNode : auditList) {
            String name = auditNode.getText();
            String value = this.getStringParameter(name, "");
            AuditHelper.audit(this, this.session, "instance_attribute", name, value, 0.0f, this);
        }
    }

    public void audit(String messageType, String message, String value, long duration) {
        if (!this.audit) {
            return;
        }
        this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_AUDIT", this.instanceId, this.getCurrentComponentName(), messageType));
        AuditHelper.audit(this, this.session, messageType, message, value, (float)duration / 1000.0f, this);
    }

    public void addInputParameter(String name, IActionParameter param) {
        this.paramManager.addToAllInputs(name, param);
    }

    public String applyInputsToFormat(String format) {
        return TemplateUtil.applyTemplate(format, this);
    }

    public String applyInputsToFormat(String format, IParameterResolver resolver) {
        return TemplateUtil.applyTemplate(format, (IRuntimeContext)this, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFeedbackForm() throws ActionSequencePromptException {
        block13: {
            try {
                String html;
                if (!this.feedbackAllowed()) {
                    return;
                }
                this.createFeedbackParameter("path", "path", "", this.getSolutionPath(), false);
                IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get("PRO_EDIT_SUBSCRIPTION");
                if (parameterProvider == null) {
                    parameterProvider = (IParameterProvider)this.parameterProviders.get("request");
                } else {
                    parameterProvider.getStringParameter("subscribe-id", null);
                }
                Iterator parameterNameIterator = parameterProvider.getParameterNames();
                while (parameterNameIterator.hasNext()) {
                    Object value;
                    String name = (String)parameterNameIterator.next();
                    if ("path".equals(name) || this.xformFields.get(name) != null || (value = parameterProvider.getParameter(name)) == null) continue;
                    this.createFeedbackParameter(name, name, "", value, false);
                }
                SolutionURIResolver resolver = new SolutionURIResolver();
                if (this.parameterXsl == null) {
                    this.xformBody.append("<tr><td>");
                    XForm.createXFormSubmit(PARAMETER_FORM, this.xformBody, Messages.getInstance().getString("RuntimeContext.USER_PARAMETER_FORM_SUBMIT"));
                    this.xformBody.append("</td></tr></table></body>");
                    html = XForm.completeXForm(3, PARAMETER_FORM, this.xformHeader, this.xformBody, this.getSession(), resolver);
                    this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_PARAMETER_HTML", html));
                    this.outputHandler.getFeedbackContentItem().setMimeType("text/html");
                    OutputStream os = this.outputHandler.getFeedbackContentItem().getOutputStream(this.getActionName());
                    os.write(html.getBytes());
                    break block13;
                }
                if (this.parameterTemplate != null) {
                    html = XForm.completeXForm(3, PARAMETER_FORM, this.xformHeader, new StringBuffer(this.parameterTemplate), this.getSession(), resolver);
                    this.debug(Messages.getInstance().getString("RuntimeContext.DEBUG_PARAMETER_HTML", html));
                    IContentItem contentItem = this.outputHandler.getFeedbackContentItem();
                    contentItem.setMimeType("text/html");
                    OutputStream os = contentItem.getOutputStream(this.getActionName());
                    os.write(html.getBytes(LocaleHelper.getSystemEncoding()));
                    os.close();
                    break block13;
                }
                if (!this.parameterXsl.endsWith(".xsl")) break block13;
                String id = this.actionSequence.getSequenceName();
                int pos = id.indexOf(46);
                if (pos > -1) {
                    id = id.substring(0, pos);
                }
                id = id.replace('-', '_');
                id = id.replace(' ', '_');
                String actionUrl = this.urlFactory.getActionUrlBuilder().getUrl();
                String displayUrl = this.urlFactory.getDisplayUrlBuilder().getUrl();
                XForm.completeXFormHeader(PARAMETER_FORM, this.xformHeader);
                Document document = XmlDom4JHelper.getDocFromString("<?xml version=\"1.0\" encoding=\"" + LocaleHelper.getSystemEncoding() + "\" ?><filters xmlns:xf=\"http://www.w3.org/2002/xforms\">" + this.xformHeader + "<id><![CDATA[" + id + "]]></id><title><![CDATA[" + Messages.getInstance().getEncodedString(this.actionSequence.getTitle()) + "]]></title><description><![CDATA[" + Messages.getInstance().getEncodedString(this.actionSequence.getDescription()) + "]]></description><icon><![CDATA[" + this.actionSequence.getIcon() + "]]></icon><help><![CDATA[" + Messages.getInstance().getEncodedString(this.actionSequence.getHelp()) + "]]></help><action><![CDATA[" + actionUrl + "]]></action><display><![CDATA[" + displayUrl + "]]></display>" + (this.parameterTarget != null ? "<target>" + this.parameterTarget + "</target>" : "") + this.xformBody.toString() + "</filters>", null);
                Element root = document.getRootElement();
                root.addAttribute("parameterView", this.getOutputPreference() == 1 ? "true" : "false");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("baseUrl", PentahoSystem.getApplicationContext().getBaseUrl());
                parameters.put("actionUrl", this.getUrlFactory().getActionUrlBuilder().getUrl());
                parameters.put("displayUrl", this.getUrlFactory().getDisplayUrlBuilder().getUrl());
                StringBuffer content = XmlHelper.transformXml(this.parameterXsl, this.getSolutionPath(), document.asXML(), parameters, (IDocumentResourceLoader)resolver);
                IContentItem contentItem = this.outputHandler.getFeedbackContentItem();
                contentItem.setMimeType("text/html");
                try (OutputStream os = contentItem.getOutputStream(this.getActionName());){
                    os.write(content.toString().getBytes(LocaleHelper.getSystemEncoding()));
                }
            }
            catch (Throwable e) {
                throw new ActionSequencePromptException(Messages.getInstance().getErrorString("RuntimeContext.ERROR_0030_SEND_FEEDBACKFORM"), e, this.session.getName(), this.instanceId, this.getActionSequence().getSequenceName(), null);
            }
        }
    }

    private void addXFormHeader() {
        XForm.createXFormHeader(PARAMETER_FORM, this.xformHeader);
        IActionSequenceResource resource = this.paramManager.getCurrentResource(this.parameterXsl);
        if (!this.parameterXsl.endsWith(".xsl") && resource != null) {
            try {
                this.parameterTemplate = this.getResourceAsString(resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void createFeedbackParameter(IActionParameter actionParam) {
        if (actionParam.hasSelections()) {
            this.createFeedbackParameter(actionParam.getName(), actionParam.getSelectionDisplayName(), "", actionParam.getStringValue(), actionParam.getSelectionValues(), actionParam.getSelectionNameMap(), null);
        }
    }

    public void createFeedbackParameter(ISelectionMapper selMap, String fieldName, Object defaultValues) {
        this.createFeedbackParameter(selMap, fieldName, defaultValues, false);
    }

    public void createFeedbackParameter(ISelectionMapper selMap, String fieldName, Object defaultValues, boolean optional) {
        if (selMap != null) {
            this.createFeedbackParameter(fieldName, selMap.getSelectionDisplayName(), "", defaultValues, selMap.getSelectionValues(), selMap.getSelectionNameMap(), selMap.getDisplayStyle(), optional);
        }
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle) {
        this.createFeedbackParameter(fieldName, displayName, hint, defaultValues, values, dispNames, displayStyle, false);
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle, boolean optional) {
        int type;
        IParameterProvider parameterProvider;
        if (this.createFeedbackParameterCallback != null) {
            this.createFeedbackParameterCallback.createFeedbackParameter((IRuntimeContext)this, fieldName, displayName, hint, defaultValues, values, dispNames, displayStyle, optional, true);
        }
        if ((parameterProvider = (IParameterProvider)this.parameterProviders.get("PRO_EDIT_SUBSCRIPTION")) != null) {
            defaultValues = parameterProvider.getParameter(this.paramManager.getActualRequestParameterName(fieldName));
        }
        if (values == null) {
            return;
        }
        if (this.xformHeader == null || this.xformHeader.length() == 0) {
            this.addXFormHeader();
        }
        if (this.checkForFieldInTemplate(fieldName)) {
            return;
        }
        int n = type = values.size() < 6 ? 1 : 2;
        if (displayStyle != null) {
            if ("text-box".equals(displayStyle)) {
                type = 10;
            } else if ("radio".equals(displayStyle)) {
                type = 1;
            } else if ("select".equals(displayStyle)) {
                type = 2;
            } else if ("list".equals(displayStyle)) {
                type = 3;
            } else if ("list-multi".equals(displayStyle)) {
                type = 4;
            } else if ("check-multi".equals(displayStyle)) {
                type = 5;
            } else if ("check-multi-scroll".equals(displayStyle)) {
                type = 6;
            } else if ("check-multi-scroll-2-column".equals(displayStyle)) {
                type = 7;
            } else if ("check-multi-scroll-3-column".equals(displayStyle)) {
                type = 8;
            } else if ("check-multi-scroll-4-column".equals(displayStyle)) {
                type = 9;
            }
        }
        fieldName = this.paramManager.getActualRequestParameterName(fieldName);
        if (hint == null) {
            hint = "";
        }
        if (this.parameterXsl == null) {
            this.xformBody.append(Messages.getInstance().getString("RuntimeContext.CODE_XFORM_CONTROL_LABEL_START", displayName));
            XForm.createXFormControl(type, fieldName, defaultValues, values, dispNames, PARAMETER_FORM, this.xformHeader, this.xformBody);
            this.xformBody.append(Messages.getInstance().getString("RuntimeContext.CODE_XFORM_CONTROL_LABEL_END"));
        } else if (this.parameterTemplate != null) {
            StringBuffer body = new StringBuffer();
            XForm.createXFormControl(type, fieldName, defaultValues, values, dispNames, PARAMETER_FORM, this.xformHeader, body);
            this.parameterTemplate = this.parameterTemplate.replaceAll("\\{" + fieldName + "\\}", body.toString());
        } else if (this.parameterXsl.endsWith(".xsl")) {
            StringBuffer body = new StringBuffer();
            XForm.createXFormControl(type, fieldName, defaultValues, values, dispNames, PARAMETER_FORM, this.xformHeader, body);
            this.xformBody.append("<filter");
            if (optional) {
                this.xformBody.append(" optional=\"true\"");
            }
            this.xformBody.append("><id><![CDATA[" + fieldName + "]]></id>").append("<title><![CDATA[" + displayName + "]]></title>").append("<help><![CDATA[" + hint + "]]></help><control>").append(body).append("</control></filter>");
        }
        this.xformFields.put(fieldName, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForFieldInTemplate(String fieldName) {
        if (this.parameterTemplate == null || this.parameterTemplate.length() == 0) {
            return false;
        }
        String regex = "[iI][dD]=['\"]" + fieldName + "['\"]";
        Pattern pattern = null;
        byte[] byArray = PATTERN_COMPILE_LOCK;
        synchronized (PATTERN_COMPILE_LOCK) {
            pattern = Pattern.compile(regex);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Matcher matcher = pattern.matcher(this.parameterTemplate);
            return matcher.find();
        }
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValue, boolean visible) {
        this.createFeedbackParameter(fieldName, displayName, hint, defaultValue, visible, false);
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValue, boolean visible, boolean optional) {
        StringBuffer body;
        IParameterProvider parameterProvider = (IParameterProvider)this.parameterProviders.get("PRO_EDIT_SUBSCRIPTION");
        if (parameterProvider != null) {
            Object newValue = parameterProvider.getParameter(this.paramManager.getActualRequestParameterName(fieldName));
            Object object = defaultValue = newValue == null ? defaultValue : newValue;
        }
        if (this.createFeedbackParameterCallback != null) {
            this.createFeedbackParameterCallback.createFeedbackParameter((IRuntimeContext)this, fieldName, displayName, hint, defaultValue, null, null, null, optional, visible);
        }
        if (this.xformHeader == null || this.xformHeader.length() == 0) {
            this.addXFormHeader();
        }
        if (this.parameterTemplate != null && this.checkForFieldInTemplate(fieldName)) {
            return;
        }
        if (hint == null) {
            hint = "";
        }
        fieldName = this.paramManager.getActualRequestParameterName(fieldName);
        if (this.parameterXsl == null) {
            if (visible) {
                this.xformBody.append(Messages.getInstance().getString("RuntimeContext.CODE_XFORM_CONTROL_LABEL_START", displayName));
            }
            XForm.createXFormControl(fieldName, defaultValue, PARAMETER_FORM, this.xformHeader, this.xformBody, visible);
            if (visible) {
                this.xformBody.append(Messages.getInstance().getString("RuntimeContext.CODE_XFORM_CONTROL_LABEL_END"));
            }
        } else if (this.parameterTemplate != null) {
            body = new StringBuffer();
            if (visible) {
                XForm.createXFormControl(fieldName, defaultValue, PARAMETER_FORM, this.xformHeader, body, visible);
            } else {
                try {
                    if (defaultValue instanceof Object[]) {
                        this.setObjectArrayParameters(fieldName, (Object[])defaultValue);
                    }
                    String value = StringEscapeUtils.escapeXml((String)defaultValue.toString());
                    body.append("<input type=\"hidden\" name=\"" + fieldName + "\" value=\"" + value + "\"></input>");
                }
                catch (Exception e) {
                    body.append("<input type=\"hidden\" name=\"" + fieldName + "\" value=\"" + defaultValue + "\"></input>");
                }
            }
            this.parameterTemplate = this.parameterTemplate.replaceAll("\\{" + fieldName + "\\}", Matcher.quoteReplacement(body.toString()));
        } else if (visible) {
            body = new StringBuffer();
            XForm.createXFormControl(fieldName, defaultValue, PARAMETER_FORM, this.xformHeader, body, visible);
            this.xformBody.append("<filter");
            if (optional) {
                this.xformBody.append(" optional=\"true\"");
            }
            this.xformBody.append("><id><![CDATA[" + fieldName + "]]></id>").append("<title><![CDATA[" + displayName + "]]></title>").append("<help><![CDATA[" + hint + "]]></help><control>").append(body).append("</control></filter>");
        } else {
            try {
                if (defaultValue instanceof Object[]) {
                    this.setObjectArrayParameters(fieldName, (Object[])defaultValue);
                } else {
                    String value = defaultValue.toString().replaceAll("&", "&amp;");
                    value = value.replaceAll("\"", "''");
                    this.xformBody.append("<input type=\"hidden\" name=\"" + fieldName + "\" value=\"" + value + "\"></input>");
                }
            }
            catch (Exception e) {
                this.xformBody.append("<input type=\"hidden\" name=\"" + fieldName + "\" value=\"" + defaultValue + "\"></input>");
            }
        }
        this.xformFields.put(fieldName, fieldName);
    }

    private void setObjectArrayParameters(String fieldName, Object[] values) {
        for (Object element : values) {
            String value = element.toString().replaceAll("&", "&amp;");
            value = value.replaceAll("\"", "''");
            this.xformBody.append("<input type=\"hidden\" name=\"" + fieldName + "\" value=\"" + value + "\"></input>");
        }
    }

    public void setParameterXsl(String xsl) {
        this.parameterXsl = xsl;
    }

    public void setParameterTarget(String target) {
        this.parameterTarget = target;
    }

    @Override
    public String getLogId() {
        return this.logId;
    }

    public void forceSaveRuntimeData() {
        if (this.runtimeData != null) {
            this.runtimeData.forceSave();
        }
    }

    public int getOutputPreference() {
        if (this.outputHandler != null) {
            return this.outputHandler.getOutputPreference();
        }
        return 3;
    }

    public void setOutputHandler(IOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public IActionSequence getActionSequence() {
        return this.actionSequence;
    }

    public IParameterManager getParameterManager() {
        return this.paramManager;
    }

    public Map getParameterProviders() {
        return null;
    }

    public void setCreateFeedbackParameterCallback(ICreateFeedbackParameterCallback callback) {
        this.createFeedbackParameterCallback = callback;
    }

    public List<IContentItem> getOutputContentItems() {
        return this.generatedContentItems;
    }

    private void addOutputContentItem(IContentItem contentItem) {
        this.generatedContentItems.add(contentItem);
    }

    static {
        PATTERN_COMPILE_LOCK = new byte[0];
        logger = LogFactory.getLog(RuntimeContext.class);
        RuntimeContext.getComponentClassMap();
    }
}

