/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.Messages;

public class HttpUtil {
    public static HttpClient getClient() {
        int connectionTimeout = 3000;
        int pageTimeout = 7000;
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
        HttpConnectionManagerParams connectionParams = connectionManager.getParams();
        connectionParams.setConnectionTimeout(connectionTimeout);
        connectionParams.setSoTimeout(pageTimeout);
        HttpClient httpClient = null;
        if (connectionManager != null) {
            httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        }
        return httpClient;
    }

    public static boolean getURLContent(String url, StringBuffer content) throws MalformedURLException, IOException {
        block8: {
            HttpClient httpClient = HttpUtil.getClient();
            try {
                GetMethod call;
                int status;
                HostConfiguration hostConfig = null;
                if (StringUtils.isNotEmpty((String)System.getProperty("http.proxyHost"))) {
                    hostConfig = new HostConfiguration(){

                        public synchronized String getProxyHost() {
                            return System.getProperty("http.proxyHost");
                        }

                        public synchronized int getProxyPort() {
                            return Integer.parseInt(System.getProperty("http.proxyPort"));
                        }
                    };
                    httpClient.setHostConfiguration(hostConfig);
                    if (System.getProperty("http.proxyUser") != null && System.getProperty("http.proxyUser").trim().length() > 0) {
                        httpClient.getState().setProxyCredentials(new AuthScope(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort"))), (Credentials)new UsernamePasswordCredentials(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
                    }
                }
                if ((status = httpClient.executeMethod(hostConfig, (HttpMethod)(call = new GetMethod(url)))) != 200) break block8;
                InputStream response = call.getResponseBodyAsStream();
                try {
                    byte[] buffer = new byte[2048];
                    int size = response.read(buffer);
                    while (size > 0) {
                        for (int idx = 0; idx < size; ++idx) {
                            content.append((char)buffer[idx]);
                        }
                        size = response.read(buffer);
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable e) {
                StringWriter writer = new StringWriter();
                PrintWriter writer2 = new PrintWriter(writer);
                e.printStackTrace(writer2);
                content.append(writer.getBuffer());
                return false;
            }
        }
        return true;
    }

    public static void getURLContent_old(String uri, StringBuffer content) throws MalformedURLException, IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        InputStream in = connection.getInputStream();
        byte[] buffer = new byte[300];
        int n = buffer.length;
        while (n > 0) {
            n = in.read(buffer);
            for (int i = 0; i < n; ++i) {
                content.append((char)buffer[i]);
            }
        }
        n = in.read(buffer);
    }

    public static String getURLContent(String uri) {
        try {
            StringBuffer content = new StringBuffer();
            HttpUtil.getURLContent(uri, content);
            return content.toString();
        }
        catch (Exception e) {
            Logger.error("org.pentaho.platform.util.web.HttpUtil", Messages.getInstance().getErrorString("HttpUtil.ERROR_0001_URL_ERROR", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static InputStream getURLInputStream(String uri) {
        try {
            URL url = new URL(uri);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            InputStream in = connection.getInputStream();
            return in;
        }
        catch (Exception e) {
            Logger.error("org.pentaho.platform.util.web.HttpUtil", Messages.getInstance().getErrorString("HttpUtil.ERROR_0001_URL_ERROR", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static Reader getURLReader(String uri) {
        try {
            URL url = new URL(uri);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            InputStream in = connection.getInputStream();
            return new InputStreamReader(in);
        }
        catch (Exception e) {
            Logger.error(HttpUtil.class.getName(), Messages.getInstance().getErrorString("HttpUtil.ERROR_0001_URL_ERROR", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static Map parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String[]> rtn = new HashMap<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtil.parseName(pair.substring(0, pos), sb);
            String val = HttpUtil.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (rtn.containsKey(key)) {
                String[] oldVals = (String[])rtn.get(key);
                valArray = new String[oldVals.length + 1];
                System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            rtn.put(key, valArray);
        }
        return rtn;
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberformatexception) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException oob) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

