/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.XmlHelper;

public class XForm {
    public static final int TYPE_RADIO = 1;
    public static final int TYPE_SELECT = 2;
    public static final int TYPE_LIST = 3;
    public static final int TYPE_LIST_MULTI = 4;
    public static final int TYPE_CHECK_MULTI = 5;
    public static final int TYPE_CHECK_MULTI_SCROLL = 6;
    public static final int TYPE_CHECK_MULTI_SCROLL_2_COLUMN = 7;
    public static final int TYPE_CHECK_MULTI_SCROLL_3_COLUMN = 8;
    public static final int TYPE_CHECK_MULTI_SCROLL_4_COLUMN = 9;
    public static final int TYPE_TEXT = 10;
    public static final int OUTPUT_XFORM = 1;
    public static final int OUTPUT_HTML = 2;
    public static final int OUTPUT_HTML_PAGE = 3;

    public static String transformSnippet(Node xForm, IPentahoSession session, IDocumentResourceLoader loader) throws TransformerException {
        return XForm.transformSnippet(xForm.asXML(), null, session, loader);
    }

    public static String transformSnippet(String xFormSnippet, String method, IPentahoSession session, IDocumentResourceLoader loader) throws TransformerException {
        int pos1;
        StringBuffer xForm = null;
        xForm = new StringBuffer().append("<?xml version=\"1.0\" encoding=\"" + LocaleHelper.getSystemEncoding() + "\" ?>").append("<pho:snippet xmlns:xf=\"http://www.w3.org/2002/xforms\"  xmlns:pho=\"http://www.w3.org/1999/homl\">").append(xFormSnippet).append("</pho:snippet>");
        String html = XForm.transform(xForm.toString(), method, session, loader);
        int pos2 = html.indexOf("enctype=\"application/x-www-form-urlencoded\">", pos1 = html.indexOf("<form name=\"pentaho-form\""));
        if (pos2 > 0 && (pos2 = (html = html.substring(pos2 + 44)).indexOf("</form>")) > 0) {
            html = html.substring(0, pos2);
        }
        return html;
    }

    public static String transform(String xForm, String method, IPentahoSession session, IDocumentResourceLoader loader) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (method != null) {
            parameters.put("form-method", method);
        } else {
            parameters.put("form-method", "GET");
        }
        return XmlHelper.transformXml("html4.xsl", null, xForm, null, loader).toString();
    }

    public static void createXFormHeader(String formName, StringBuffer xformHeader) {
        xformHeader.append("<head>").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"/pentaho-style/active/default.css\" />").append("<xf:model id=\"").append(formName).append("\">").append("<xf:instance>");
    }

    public static void completeXFormHeader(String formName, StringBuffer xformHeader) {
        xformHeader.append("</xf:instance>").append("<xf:submission action=\"\" separator=\"&amp;\" method=\"urlencoded-get\" id=\"").append(formName).append("\" />").append("</xf:model>").append("</head>");
    }

    public static void createXFormSubmit(String formName, StringBuffer xformBody, String buttonText) {
        xformBody.append("<xf:submit id=\"").append(formName).append("\" submission=\"").append(formName).append("\">").append("<xf:label>").append(buttonText).append("</xf:label>").append("</xf:submit>");
    }

    public static String completeXForm(int outputType, String formName, StringBuffer xformHeader, StringBuffer xformBody, IPentahoSession session, IDocumentResourceLoader loader) throws TransformerException {
        xformHeader.append("</xf:instance>").append("<xf:submission action=\"\" separator=\"&amp;\" method=\"urlencoded-get\" id=\"").append(formName).append("\" />").append("</xf:model>").append("</head>");
        if (outputType == 1) {
            xformHeader.append(xformBody);
            return xformHeader.toString();
        }
        if (outputType == 2) {
            xformHeader.append("<body dir=\"").append(LocaleHelper.getTextDirection()).append("\">");
            xformHeader.append(xformBody);
            xformHeader.append("</body>");
            return XForm.transformSnippet(xformHeader.toString(), "GET", session, loader);
        }
        if (outputType == 3) {
            StringBuffer xForm = new StringBuffer();
            xForm.append("<html xmlns=\"http://www.w3.org/2002/06/xhtml2\" xmlns:xf=\"http://www.w3.org/2002/xforms\" xmlns:pho=\"http://www.w3.org/2002/xhoml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
            if (xformBody.indexOf("{xform-header}") > -1) {
                String header = xformHeader.toString();
                header = header.replaceFirst("<head>", "");
                header = header.replaceFirst("</head>", "");
                String tmp = xformBody.toString();
                tmp = tmp.replaceFirst("\\{xform-header\\}", header);
                String html = XForm.transform(tmp, "GET", session, loader);
                return html;
            }
            xForm.append(xformHeader);
            xForm.append(xformBody);
            xForm.append("</html>");
            String html = XForm.transform(xForm.toString(), "GET", session, loader);
            return "<html><body dir=\"" + LocaleHelper.getTextDirection() + "\">" + html + "</body></html>";
        }
        return null;
    }

    public static void createXFormControl(String fieldName, Object defaultValues, String formName, StringBuffer xformHeader, StringBuffer xformBody, boolean visible) {
        if (xformHeader.length() == 0) {
            XForm.createXFormHeader(formName, xformHeader);
        }
        XForm.setDefaultValues(fieldName, defaultValues, xformHeader);
        if (visible) {
            xformBody.append("<xf:input model=\"").append(formName).append("\" id=\"").append(fieldName).append("\" ref=\"").append(fieldName).append("\"></xf:input>");
        }
    }

    private static void setDefaultValues(String fieldName, Object defaultValues, StringBuffer xformHeader) {
        xformHeader.append("<data xmlns=\"\">");
        if (defaultValues instanceof String) {
            xformHeader.append("<").append(fieldName).append(">").append(XmlHelper.encode((String)defaultValues)).append("</").append(fieldName).append(">");
        } else if (defaultValues instanceof String[]) {
            String[] values;
            for (String element : values = (String[])defaultValues) {
                xformHeader.append("<").append(fieldName).append(">").append(XmlHelper.encode(element)).append("</").append(fieldName).append(">");
            }
        } else if (defaultValues instanceof Object[]) {
            String[] values;
            for (String element : values = (String[])defaultValues) {
                xformHeader.append("<").append(fieldName).append(">").append(XmlHelper.encode(element.toString())).append("</").append(fieldName).append(">");
            }
        } else if (defaultValues == null) {
            xformHeader.append("<").append(fieldName).append("></").append(fieldName).append(">");
        } else {
            xformHeader.append("<").append(fieldName).append(">").append(XmlHelper.encode(defaultValues.toString())).append("</").append(fieldName).append(">");
        }
        xformHeader.append("</data>");
    }

    public static void createXFormControl(int type, String fieldName, Object defaultValues, List values, Map displayNames, String formName, StringBuffer xformHeader, StringBuffer xformBody) {
        if (type != 10 && values == null) {
            return;
        }
        if (xformHeader.length() == 0) {
            XForm.createXFormHeader(formName, xformHeader);
        }
        if (values != null && values.size() == 1) {
            defaultValues = XmlHelper.encode(values.get(0).toString());
        }
        XForm.setDefaultValues(fieldName, defaultValues, xformHeader);
        String appearance = "";
        if (type == 10) {
            xformBody.append("<xf:input model=\"").append(formName).append("\" id=\"").append(fieldName).append("\" ref=\"").append(fieldName).append("\"></xf:input>");
        } else if (type == 1 || type == 2 || type == 3) {
            switch (type) {
                case 1: {
                    appearance = "appearance=\"full\"";
                    break;
                }
                case 2: {
                    appearance = "";
                    break;
                }
                case 3: {
                    appearance = "appearance=\"compact\"";
                }
            }
            xformBody.append("<xf:select1 ").append(appearance).append(" model=\"").append(formName).append("\" id=\"").append(fieldName).append("\" ref=\"").append(fieldName).append("\">");
            if (values != null) {
                Iterator listIterator = values.iterator();
                while (listIterator.hasNext()) {
                    String displayValue;
                    String value = XmlHelper.encode(listIterator.next().toString());
                    String string = displayValue = displayNames != null ? XmlHelper.encode((String)displayNames.get(value)) : value;
                    if (displayValue == null) {
                        displayValue = value;
                    }
                    xformBody.append("<xf:item><xf:label>").append(displayValue).append("</xf:label><xf:value>").append(value).append("</xf:value></xf:item>");
                }
            }
            xformBody.append("</xf:select1>");
        } else if (type == 4 || type == 5 || type == 6 || type == 7 || type == 8 || type == 9) {
            switch (type) {
                case 5: {
                    appearance = "appearance=\"full\"";
                    break;
                }
                case 4: {
                    appearance = "appearance=\"compact\"";
                    break;
                }
                case 6: {
                    appearance = "appearance=\"full-scroll\" columns=\"1\"";
                    break;
                }
                case 7: {
                    appearance = "appearance=\"full-scroll\" columns=\"2\"";
                    break;
                }
                case 8: {
                    appearance = "appearance=\"full-scroll\" columns=\"3\"";
                    break;
                }
                case 9: {
                    appearance = "appearance=\"full-scroll\" columns=\"4\"";
                }
            }
            xformBody.append("<xf:select ").append(appearance).append(" model=\"").append(formName).append("\" id=\"").append(fieldName).append("\" ref=\"").append(fieldName).append("\">");
            if (values != null) {
                Iterator listIterator = values.iterator();
                while (listIterator.hasNext()) {
                    String displayValue;
                    String value = XmlHelper.encode(listIterator.next().toString());
                    String string = displayValue = displayNames != null ? XmlHelper.encode((String)displayNames.get(value)) : value;
                    if (displayValue == null) {
                        displayValue = value;
                    }
                    xformBody.append("<xf:item><xf:label>").append(displayValue).append("</xf:label><xf:value>").append(value).append("</xf:value></xf:item>");
                }
            }
            xformBody.append("</xf:select>");
        }
    }
}

