/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;
import org.pentaho.agilebi.modeler.geo.GeoContextFactory;
import org.pentaho.agilebi.modeler.models.annotations.CreateAttribute;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.refinery.model.GeoContextBlueprintConfigProvider;
import org.pentaho.di.core.refinery.model.RefineryModelerWorkspaceHelper;
import org.pentaho.di.core.refinery.model.RefineryValueMetaStrategy;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.metadata.automodel.AutoModeler;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.automodel.SchemaTable;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.pms.core.exception.PentahoMetadataException;

public class DswModeler {
    private static final Class<?> PKG = JobEntryBuildModel.class;
    private LogChannelInterface log;
    private static final String MONDRIAN_CATALOG_REF = "MondrianCatalogRef";
    private GeoContextConfigProvider geoContextConfigProvider;
    private boolean useJndi = true;

    public DswModeler() {
    }

    public DswModeler(LogChannelInterface log) {
        this.log = log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public void setUseJndi(boolean useJndi) {
        this.useJndi = useJndi;
    }

    public Domain createModel(String modelName, TableModelerSource source, DatabaseMeta dbMeta, PhysicalTableImporter.ImportStrategy importStrategy, ModelAnnotationGroup modelAnnotations, IMetaStore metaStore) throws ModelerException {
        Domain domain = source.generateDomain(importStrategy);
        if (((LogicalTable)((LogicalModel)domain.getLogicalModels().get(0)).getLogicalTables().get(0)).getLogicalColumns().size() == 0) {
            throw new ModelerException(BaseMessages.getString(PKG, (String)"BuildModelJob.Error.NoData", (String[])new String[0]));
        }
        GeoContext geoContext = this.initGeoContext();
        ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new RefineryModelerWorkspaceHelper(geoContext), geoContext);
        model.setModelSource((IModelerSource)source);
        model.setDomain(domain);
        model.setModelName(modelName);
        model.getWorkspaceHelper().autoModelFlat(model);
        if (this.hasGeoDimConflict(geoContext, modelAnnotations)) {
            this.removeAutoGeo(model);
        }
        model.getWorkspaceHelper().populateDomain(model);
        this.enableDswModel(domain, model);
        this.setReportModelName(modelName, model);
        this.applyAnnotations(model, modelAnnotations, metaStore);
        Domain modeledDomain = model.getDomain();
        if (this.useJndi) {
            this.updateDatasourceAccess(modeledDomain, dbMeta);
        }
        return modeledDomain;
    }

    private boolean hasGeoDimConflict(GeoContext geoContext, ModelAnnotationGroup annotations) {
        if (geoContext == null || StringUtils.isEmpty((String)geoContext.getDimensionName())) {
            return false;
        }
        String geoDim = geoContext.getDimensionName();
        for (ModelAnnotation annotation : annotations) {
            if (!annotation.getType().equals((Object)ModelAnnotation.Type.CREATE_ATTRIBUTE) || !geoDim.equalsIgnoreCase(((CreateAttribute)annotation.getAnnotation()).getDimension())) continue;
            return true;
        }
        return false;
    }

    private void removeAutoGeo(ModelerWorkspace workspace) {
        DimensionMetaDataCollection dimensions = workspace.getModel().getDimensions();
        DimensionMetaData toRemove = null;
        GeoContext geoContext = workspace.getGeoContext();
        for (DimensionMetaData dimensionMetaData : dimensions) {
            if (geoContext == null || !dimensionMetaData.getName().equals(geoContext.getDimensionName())) continue;
            block1: for (HierarchyMetaData hierarchyMetaData : dimensionMetaData) {
                if (!hierarchyMetaData.getName().equals(geoContext.getDimensionName())) continue;
                for (LevelMetaData levelMetaData : hierarchyMetaData) {
                    if (levelMetaData.getMemberAnnotations().get("Data.Role") == null) continue;
                    toRemove = dimensionMetaData;
                    continue block1;
                }
            }
        }
        if (toRemove != null) {
            dimensions.remove(toRemove);
        }
    }

    private GeoContext initGeoContext() {
        try {
            GeoContextConfigProvider config = this.getGeoContextConfigProvider();
            return GeoContextFactory.create((GeoContextConfigProvider)config);
        }
        catch (Throwable e) {
            this.log.logDebug("unable to locate geoRoles properties");
            return null;
        }
    }

    private void applyAnnotations(ModelerWorkspace model, ModelAnnotationGroup modelAnnotations, IMetaStore metaStore) throws ModelerException {
        Map statusMap = modelAnnotations.applyAnnotations(model, metaStore);
        if (this.log.isBasic()) {
            this.logBasic((List)statusMap.get(ModelAnnotationGroup.ApplyStatus.SUCCESS), "ModelAnnotation.log.AnnotationSuccess");
            this.logBasic((List)statusMap.get(ModelAnnotationGroup.ApplyStatus.FAILED), "ModelAnnotation.log.AnnotationFailure");
        }
        this.logDebug((List)statusMap.get(ModelAnnotationGroup.ApplyStatus.NULL_ANNOTATION), "Ignoring a null annotation");
    }

    private void logBasic(List<ModelAnnotation> modelAnnotations, String msgKey) {
        for (ModelAnnotation modelAnnotation : modelAnnotations) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)msgKey, (String[])new String[]{modelAnnotation.getAnnotation().getSummary()}));
        }
    }

    private void logDebug(List<ModelAnnotation> modelAnnotations, String msg) {
        for (ModelAnnotation modelAnnotation : modelAnnotations) {
            this.log.logDebug(msg);
        }
    }

    private PhysicalTableImporter.ImportStrategy valueMetaStrategy(StepMetaDataCombi stepMetaDataCombi) throws ModelerException {
        return new RefineryValueMetaStrategy(stepMetaDataCombi);
    }

    public Domain updateModel(String modelName, Domain domain, DatabaseMeta dbMeta, String schemaName, String tableName) throws ColumnMismatchException, UnsupportedModelException, PentahoMetadataException {
        String dswId = modelName + ".xmi";
        domain.setId(dswId);
        SqlPhysicalModel physicalModel = this.createPhysicalModel(modelName, dbMeta, schemaName, tableName);
        this.updatePhysicalModel(domain, physicalModel);
        this.updateDatasourceAccess(domain, dbMeta);
        this.updateModelName(modelName, domain);
        return domain;
    }

    private void updateModelName(String modelName, Domain domain) throws UnsupportedModelException {
        for (LogicalModel model : domain.getLogicalModels()) {
            this.updateConceptName(modelName, (Concept)model);
            if (model.getProperty(MONDRIAN_CATALOG_REF) != null) {
                model.setProperty(MONDRIAN_CATALOG_REF, (Object)modelName);
                List cubes = (List)model.getProperty("olap_cubes");
                if (cubes != null && cubes.size() == 1) {
                    ((OlapCube)cubes.get(0)).setName(modelName);
                } else {
                    throw new UnsupportedModelException();
                }
            }
            for (Category category : model.getCategories()) {
                if (model.getCategories().size() == 1) {
                    category.setId(modelName);
                }
                this.updateConceptName(modelName, (Concept)category);
            }
        }
    }

    private void updateConceptName(String newName, Concept concept) {
        LocalizedString name = (LocalizedString)concept.getProperty(Concept.NAME_PROPERTY);
        for (String locale : name.getLocales()) {
            name.setString(locale, newName);
        }
    }

    private void enableDswModel(Domain domain, ModelerWorkspace model) {
        domain.setId(model.getModelName() + ".xmi");
        LogicalModel lModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (lModel == null) {
            lModel = model.getLogicalModel(ModelerPerspective.REPORTING);
        }
        lModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
        lModel.setProperty("WIZARD_GENERATED_SCHEMA", (Object)"TRUE");
        String catName = lModel.getName(Locale.getDefault().toString());
        catName = catName.replace("_OLAP", "");
        lModel.setProperty(MONDRIAN_CATALOG_REF, (Object)catName);
    }

    private void setReportModelName(String modelName, ModelerWorkspace model) {
        LogicalModel reportModel = model.getLogicalModel(ModelerPerspective.REPORTING);
        for (Category category : reportModel.getCategories()) {
            this.updateConceptName(modelName, (Concept)category);
        }
    }

    public void updateDatasourceAccess(Domain domain, DatabaseMeta databaseMeta) {
        SqlDataSource sqlDataSource = ((SqlPhysicalModel)domain.getPhysicalModels().get(0)).getDatasource();
        if (sqlDataSource != null) {
            sqlDataSource.setType(SqlDataSource.DataSourceType.JNDI);
            sqlDataSource.setDatabaseName(databaseMeta.getName());
            sqlDataSource.setPort(null);
            sqlDataSource.setUsername(null);
            sqlDataSource.setPassword(null);
            sqlDataSource.setHostname(null);
        }
    }

    private void updatePhysicalModel(Domain domain, SqlPhysicalModel pModel) throws ColumnMismatchException, UnsupportedModelException {
        ArrayList<SqlPhysicalModel> physicalModels = new ArrayList<SqlPhysicalModel>(1);
        physicalModels.add(pModel);
        domain.setPhysicalModels(physicalModels);
        for (LogicalModel lModel : domain.getLogicalModels()) {
            this.checkIfStarModel(lModel);
            this.updatePhysicalModel(lModel, pModel);
        }
    }

    private void updatePhysicalModel(LogicalModel logicalModel, SqlPhysicalModel physicalModel) throws ColumnMismatchException, UnsupportedModelException {
        SqlPhysicalTable theTable = (SqlPhysicalTable)physicalModel.getPhysicalTables().get(0);
        HashMap<ColumnKey, IPhysicalColumn> columns = new HashMap<ColumnKey, IPhysicalColumn>();
        for (IPhysicalColumn column : theTable.getPhysicalColumns()) {
            columns.put(new ColumnKey((IPhysicalColumn)((SqlPhysicalColumn)column)), column);
        }
        logicalModel.setPhysicalModel((IPhysicalModel)physicalModel);
        for (LogicalTable logicalTable : logicalModel.getLogicalTables()) {
            logicalTable.setPhysicalTable((IPhysicalTable)theTable);
            for (LogicalColumn column : logicalTable.getLogicalColumns()) {
                ColumnKey prevColumn = new ColumnKey(column.getPhysicalColumn());
                IPhysicalColumn physicalColumn = (IPhysicalColumn)columns.get(prevColumn);
                if (physicalColumn != null) {
                    column.setPhysicalColumn(physicalColumn);
                    continue;
                }
                throw new ColumnMismatchException(prevColumn);
            }
        }
    }

    private void checkIfStarModel(LogicalModel existingModel) throws UnsupportedModelException {
        if (existingModel.getLogicalTables().size() > 1) {
            throw new UnsupportedModelException();
        }
    }

    public GeoContextConfigProvider getGeoContextConfigProvider() {
        if (this.geoContextConfigProvider == null) {
            this.geoContextConfigProvider = new GeoContextBlueprintConfigProvider();
        }
        return this.geoContextConfigProvider;
    }

    public void setGeoContextConfigProvider(GeoContextConfigProvider geoContextConfigProvider) {
        this.geoContextConfigProvider = geoContextConfigProvider;
    }

    private SqlPhysicalModel createPhysicalModel(String modelName, DatabaseMeta dbMeta, String schema, String table) throws PentahoMetadataException {
        SchemaTable schemaTable = new SchemaTable(schema, table);
        AutoModeler autoModeler = new AutoModeler("en_US", modelName, dbMeta, new SchemaTable[]{schemaTable});
        Domain newDomain = autoModeler.generateDomain();
        return (SqlPhysicalModel)newDomain.getPhysicalModels().get(0);
    }

    public static class ColumnMismatchException
    extends ModelingException {
        private static final long serialVersionUID = 1L;
        private ColumnKey columnKey;

        public ColumnMismatchException(ColumnKey unmatchedColumn) {
            this.columnKey = unmatchedColumn;
        }

        public String getColumnName() {
            return this.columnKey.getColumnName();
        }

        public String getDataType() {
            return this.columnKey.getColumnDataType().getName();
        }
    }

    public static class UnsupportedModelException
    extends ModelingException {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private static class ColumnKey {
        private DataType dataType;
        private String columnName;

        ColumnKey(IPhysicalColumn column) throws UnsupportedModelException {
            this.dataType = column.getDataType();
            if (!(column instanceof SqlPhysicalColumn)) {
                throw new UnsupportedModelException();
            }
            this.columnName = ((SqlPhysicalColumn)column).getTargetColumn().toLowerCase();
            assert (this.dataType != null && this.columnName != null);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ColumnKey) {
                return this.equals((ColumnKey)obj);
            }
            return false;
        }

        public boolean equals(ColumnKey other) {
            return this.dataType.equals((Object)other.dataType) && this.columnName.equals(other.columnName);
        }

        public int hashCode() {
            return this.columnName.hashCode() + 31 * this.dataType.hashCode();
        }

        public String getColumnName() {
            return this.columnName;
        }

        public DataType getColumnDataType() {
            return this.dataType;
        }
    }
}

