/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class DataSourceAclModel {
    private List<String> users;
    private List<String> roles;

    public void addUser(String user) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(user);
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public String toXml() {
        if (!(this.users != null && this.users.size() != 0 || this.roles != null && this.roles.size() != 0)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<repositoryFileAclDto>");
        if (this.users != null) {
            for (String user : this.users) {
                builder.append("  <aces>");
                builder.append("    <recipient>").append(StringEscapeUtils.escapeXml((String)user)).append("</recipient>");
                builder.append("    <recipientType>0</recipientType>");
                builder.append("    <permissions>4</permissions>");
                builder.append("    <modifiable>false</modifiable>");
                builder.append("  </aces>");
            }
        }
        if (this.roles != null) {
            for (String role : this.roles) {
                builder.append("  <aces>");
                builder.append("    <recipient>").append(StringEscapeUtils.escapeXml((String)role)).append("</recipient>");
                builder.append("    <recipientType>1</recipientType>");
                builder.append("    <permissions>4</permissions>");
                builder.append("    <modifiable>false</modifiable>");
                builder.append("  </aces>");
            }
        }
        builder.append("  <entriesInheriting>false</entriesInheriting>");
        builder.append("  <id></id>");
        builder.append("  <owner></owner>");
        builder.append("  <ownerType></ownerType>");
        builder.append("</repositoryFileAclDto>");
        return builder.toString();
    }
}

