/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.BlankAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.CreateAttribute;
import org.pentaho.agilebi.modeler.models.annotations.CreateCalculatedMember;
import org.pentaho.agilebi.modeler.models.annotations.CreateDimensionKey;
import org.pentaho.agilebi.modeler.models.annotations.CreateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.LinkDimension;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.steps.annotation.ModelAnnotationActionDialog;
import org.pentaho.di.ui.trans.steps.annotation.OptionsResolver;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metastore.api.IMetaStore;

public class ModelAnnotationActionPropertiesDialog
extends ModelAnnotationActionDialog {
    protected Composite contentPanel;
    private Label wField;
    private CCombo wActionList;
    private ColumnInfo[] ciFields;
    private ComboValuesSelectionListener comboValuesSelectionListener;
    private TableView wProperties;
    private AnnotationType annotationType;
    private OptionsResolver optionsResolver = new OptionsResolver();

    public ModelAnnotationActionPropertiesDialog(Shell parent, BaseAnnotationMeta baseStepMeta, TransMeta transMeta, String stepname, IMetaStore metaStore) {
        super(parent, baseStepMeta, transMeta, stepname, metaStore);
    }

    @Override
    protected void initializeListeners() {
        super.initializeListeners();
        this.comboValuesSelectionListener = new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                try {
                    String name = tableItem.getText(1);
                    if (StringUtils.isNotBlank((String)name)) {
                        AnnotationType at = ModelAnnotationActionPropertiesDialog.this.annotationType;
                        Class propertyClassType = at.getModelPropertyNameClassType(name);
                        if (name.equals("Parent Attribute")) {
                            ArrayList<String> names = new ArrayList<String>();
                            for (ModelAnnotation m : ModelAnnotationActionPropertiesDialog.this.getModifiedModelAnnotations()) {
                                if (!ModelAnnotation.Type.CREATE_ATTRIBUTE.equals((Object)m.getType()) || !StringUtils.isNotBlank((String)m.getAnnotation().getName()) || StringUtils.equals((String)at.getName(), (String)m.getAnnotation().getName())) continue;
                                names.add(m.getAnnotation().getName());
                            }
                            return names.toArray(new String[names.size()]);
                        }
                        if (name.equals("Dimension")) {
                            LinkedHashSet<String> names = new LinkedHashSet<String>();
                            for (ModelAnnotation m : ModelAnnotationActionPropertiesDialog.this.getModifiedModelAnnotations()) {
                                if (m.getAnnotation() == null || !StringUtils.isNotBlank((String)m.getAnnotation().getName()) || at.equals((Object)m.getAnnotation())) continue;
                                String dimensionName = null;
                                if (ModelAnnotation.Type.CREATE_ATTRIBUTE.equals((Object)m.getType())) {
                                    dimensionName = ((CreateAttribute)m.getAnnotation()).getDimension();
                                    if (!StringUtils.isNotBlank((String)dimensionName)) continue;
                                    names.add(dimensionName);
                                    continue;
                                }
                                if (!ModelAnnotation.Type.CREATE_DIMENSION_KEY.equals((Object)m.getType()) || !StringUtils.isNotBlank((String)(dimensionName = ((CreateDimensionKey)m.getAnnotation()).getDimension()))) continue;
                                names.add(dimensionName);
                            }
                            return names.toArray(new String[names.size()]);
                        }
                        if (name.equals("Hierarchy")) {
                            LinkedHashSet<String> names = new LinkedHashSet<String>();
                            for (ModelAnnotation m : ModelAnnotationActionPropertiesDialog.this.getModifiedModelAnnotations()) {
                                String hierarchy;
                                if (!ModelAnnotation.Type.CREATE_ATTRIBUTE.equals((Object)m.getType()) || !StringUtils.isNotBlank((String)m.getAnnotation().getName()) || StringUtils.equals((String)at.getName(), (String)m.getAnnotation().getName()) || !StringUtils.isNotBlank((String)(hierarchy = ((CreateAttribute)m.getAnnotation()).getHierarchy()))) continue;
                                names.add(hierarchy);
                            }
                            return names.toArray(new String[names.size()]);
                        }
                        if (name.equals("Time Level Type") && propertyClassType != null && propertyClassType.equals(ModelAnnotation.TimeType.class)) {
                            return ModelAnnotation.TimeType.names();
                        }
                        if (name.equals("Geo Type") && propertyClassType != null && propertyClassType.equals(ModelAnnotation.GeoType.class)) {
                            return ModelAnnotation.GeoType.names();
                        }
                        if (name.equals("Time Source Format")) {
                            String timeType = StringUtils.defaultIfBlank((String)ModelAnnotationActionPropertiesDialog.this.findTableItemValue("Time Level Type"), (String)"");
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveTimeSourceFormatOptions(timeType);
                        }
                        if (name.equals("Ordinal Field")) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveOrdinalFieldOptions(ModelAnnotationActionPropertiesDialog.this.transMeta, ModelAnnotationActionPropertiesDialog.this.stepname, ModelAnnotationActionPropertiesDialog.this.getModelAnnotation());
                        }
                        if (name.equals("Format") && ModelAnnotation.Type.CREATE_MEASURE.equals((Object)at.getType())) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveMeasureFormatOptions();
                        }
                        if (name.equals("Format") && ModelAnnotation.Type.CREATE_ATTRIBUTE.equals((Object)at.getType())) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveAttributeFormatOptions(ModelAnnotationActionPropertiesDialog.this.applyToType(ModelAnnotationActionPropertiesDialog.this.getValueMeta()));
                        }
                        if (name.equals("Aggregation Type") && propertyClassType != null && propertyClassType.equals(AggregationType.class)) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveAggregationTypeOptions(ModelAnnotationActionPropertiesDialog.this.getValueMeta(), at);
                        }
                        if (propertyClassType != null && (propertyClassType.equals(Boolean.class) || propertyClassType.equals(Boolean.TYPE))) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveBooleanOptions();
                        }
                        if (name.equals("Shared Dimension")) {
                            return ModelAnnotationActionPropertiesDialog.this.optionsResolver.resolveSharedDimensions(new ModelAnnotationManager(true), ModelAnnotationActionPropertiesDialog.this.getMetaStore());
                        }
                    }
                }
                catch (Exception e) {
                    ModelAnnotationActionPropertiesDialog.this.logError(e.getMessage());
                }
                return new String[0];
            }
        };
    }

    private void createContentPanel(Composite parent) {
        this.contentPanel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.wBottomHorizontalSeparator, 0);
        this.contentPanel.setLayoutData((Object)fd);
        this.contentPanel.setLayout((Layout)new FormLayout());
        PropsUI.getInstance().setLook((Control)this.contentPanel);
    }

    protected Composite getMainComposite() {
        return this.shell;
    }

    @Override
    public void createWidgets() {
        this.createContentPanel(this.getMainComposite());
        Label wlField = new Label(this.contentPanel, 16384);
        wlField.setText(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.AnnotateField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlField);
        FormData fdlField = new FormData();
        fdlField.left = new FormAttachment(0, 10);
        fdlField.top = new FormAttachment(0, 4);
        wlField.setLayoutData((Object)fdlField);
        this.wField = new Label(this.contentPanel, 16384);
        this.props.setLook((Control)this.wField);
        FormData fdwField = new FormData();
        fdwField.width = 500;
        fdwField.left = new FormAttachment(0, 10);
        fdwField.top = new FormAttachment((Control)wlField, 4);
        this.wField.setLayoutData((Object)fdwField);
        Label wlActionList = new Label(this.contentPanel, 131072);
        wlActionList.setText(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.Actions.Label", (String[])new String[0]));
        this.props.setLook((Control)wlActionList);
        FormData fdlActionList = new FormData();
        fdlActionList.left = new FormAttachment(0, 10);
        fdlActionList.top = new FormAttachment((Control)this.wField, 4);
        wlActionList.setLayoutData((Object)fdlActionList);
        this.wActionList = new CCombo(this.contentPanel, 18432);
        this.wActionList.setText(ModelAnnotation.Type.CREATE_ATTRIBUTE.description());
        this.wActionList.setToolTipText(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.Actions.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wActionList);
        FormData fdActionList = new FormData();
        fdActionList.left = new FormAttachment(0, 10);
        fdActionList.top = new FormAttachment((Control)wlActionList, 4);
        this.wActionList.setLayoutData((Object)fdActionList);
        this.createPropertiesTable((Control)this.wActionList);
        this.wActionList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (StringUtils.isBlank((String)ModelAnnotationActionPropertiesDialog.this.wActionList.getText())) {
                    return;
                }
                if (ModelAnnotationActionPropertiesDialog.this.getModelAnnotation().getAnnotation() != null && ModelAnnotationActionPropertiesDialog.this.getModelAnnotation().getAnnotation().getType().description().equals(ModelAnnotationActionPropertiesDialog.this.wActionList.getText())) {
                    ModelAnnotationActionPropertiesDialog.this.loadAnnotationProperties(ModelAnnotationActionPropertiesDialog.this.getModelAnnotation().getAnnotation());
                } else {
                    AnnotationType annotationType = ModelAnnotationActionPropertiesDialog.this.createAnnotationType();
                    if (annotationType != null) {
                        ModelAnnotationActionPropertiesDialog.this.loadAnnotationProperties(annotationType);
                    }
                }
            }
        });
    }

    private void createPropertiesTable(Control topWidget) {
        int tableCols = 2;
        int rowCount = 0;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.PropertiesTable.Column.Name", (String[])new String[0]), 1, new String[]{""}, true);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.PropertiesTable.Column.Value", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1].setComboValuesSelectionListener(this.comboValuesSelectionListener);
        this.wProperties = new TableView((VariableSpace)this.transMeta, this.contentPanel, 68354, this.ciFields, rowCount, this.lsMod, this.props);
        FormData fdProperties = new FormData();
        fdProperties.top = new FormAttachment(topWidget, 14);
        fdProperties.left = new FormAttachment(0, 12);
        fdProperties.right = new FormAttachment(100, -10);
        fdProperties.bottom = new FormAttachment(100, -10);
        this.wProperties.setLayoutData((Object)fdProperties);
        this.wProperties.getTable().setSize(500, 400);
        int width = (500 - this.wProperties.getTable().getColumn(0).getWidth()) / 2;
        this.wProperties.getTable().getColumn(0).setWidth(0);
        this.wProperties.getTable().getColumn(1).setWidth(width - 10);
        this.wProperties.getTable().getColumn(2).setWidth(width - 10);
    }

    private void populateActionList() {
        this.wActionList.removeAll();
        for (ModelAnnotation.Type annotationType : this.getAnnotationTypes()) {
            this.wActionList.add(annotationType.description());
            this.wActionList.setData(annotationType.description(), (Object)annotationType);
        }
    }

    @Override
    public void populateDialog() {
        this.populateActionList();
        if (this.getModelAnnotation() == null) {
            return;
        }
        this.wField.setText(StringUtils.defaultIfBlank((String)this.getModelAnnotation().getField(), (String)""));
        if (this.getModelAnnotation().getAnnotation() != null) {
            this.wActionList.setText(this.getModelAnnotation().getAnnotation().getType().description());
            if (this.wActionList.getData(this.wActionList.getText()) == null) {
                this.wActionList.setText("");
            }
        } else {
            this.wActionList.setText("");
        }
        this.loadAnnotationProperties(this.getModelAnnotation().getAnnotation());
    }

    private void loadAnnotationProperties(AnnotationType annotationType) {
        this.wProperties.clearAll();
        if (annotationType == null) {
            return;
        }
        this.annotationType = annotationType;
        for (ModelProperty prop : annotationType.getModelProperties()) {
            String name = prop.name();
            TableItem item = new TableItem(this.wProperties.table, 0);
            if (this.getModelAnnotation() == null || prop.hideUI() || !this.applies(prop)) continue;
            item.setText(1, name);
            try {
                Object object = annotationType.getModelPropertyValueByName(name);
                if (object == null) continue;
                String value = object.toString();
                if (StringUtils.equals((String)name, (String)"Is Unique") || StringUtils.equals((String)name, (String)"Hidden") || StringUtils.equals((String)name, (String)"Hidden")) {
                    value = StringUtils.capitalize((String)value);
                }
                item.setText(2, value);
            }
            catch (Exception e) {
                this.logError(e.getMessage());
            }
        }
        this.wProperties.removeEmptyRows();
        this.wProperties.setRowNums();
    }

    private boolean applies(ModelProperty prop) {
        return Arrays.asList(prop.appliesTo()).contains(this.applyToType(this.getValueMeta()));
    }

    private ModelProperty.AppliesTo applyToType(ValueMetaInterface valueMeta) {
        int type = valueMeta.getType();
        switch (type) {
            case 1: 
            case 5: 
            case 6: {
                return ModelProperty.AppliesTo.Numeric;
            }
            case 3: 
            case 9: {
                return ModelProperty.AppliesTo.Time;
            }
        }
        return ModelProperty.AppliesTo.String;
    }

    protected AnnotationType createAnnotationType() {
        if (StringUtils.isBlank((String)this.wActionList.getText())) {
            BlankAnnotation blankAnnotation = new BlankAnnotation();
            blankAnnotation.setField(this.getModelAnnotation().getField());
            return blankAnnotation;
        }
        switch ((ModelAnnotation.Type)this.wActionList.getData(this.wActionList.getText())) {
            case CREATE_MEASURE: {
                CreateMeasure cm = new CreateMeasure();
                cm.setField(this.getModelAnnotation().getField());
                cm.setName(this.getModelAnnotation().getField());
                ValueMetaInterface vmi = this.getValueMeta();
                if (vmi != null && !vmi.isNumeric()) {
                    cm.setAggregateType(AggregationType.COUNT);
                }
                return cm;
            }
            case CREATE_ATTRIBUTE: {
                CreateAttribute createAttribute = new CreateAttribute();
                createAttribute.setField(this.getModelAnnotation().getField());
                createAttribute.setName(this.getModelAnnotation().getField());
                return createAttribute;
            }
            case CREATE_DIMENSION_KEY: {
                CreateDimensionKey createKey = new CreateDimensionKey();
                createKey.setField(this.getModelAnnotation().getField());
                createKey.setName(this.wField.getText());
                return createKey;
            }
            case LINK_DIMENSION: {
                LinkDimension linkDimension = new LinkDimension();
                linkDimension.setField(this.getModelAnnotation().getField());
                return linkDimension;
            }
            case CREATE_CALCULATED_MEMBER: {
                CreateCalculatedMember createCalculatedMember = new CreateCalculatedMember();
                return createCalculatedMember;
            }
        }
        return null;
    }

    @Override
    protected void persistAnnotationProperties() throws ModelerException {
        if (this.getModelAnnotation() == null) {
            return;
        }
        AnnotationType annotationType = this.createAnnotationType();
        this.getModelAnnotation().setAnnotation(annotationType);
        for (int i = 0; i < this.wProperties.getItemCount(); ++i) {
            String name = this.wProperties.getItem(i, 1);
            String value = this.wProperties.getItem(i, 2);
            if (value.equals("")) {
                value = null;
            }
            try {
                this.getModelAnnotation().getAnnotation().setModelPropertyByName(name, (Object)value);
                continue;
            }
            catch (Exception e) {
                this.logError(e.getMessage());
            }
        }
        if (annotationType != null) {
            annotationType.validate();
            if (!this.getModifiedModelAnnotations().contains(this.getModelAnnotation())) {
                this.getModifiedModelAnnotations().add(this.getModelAnnotation());
            }
        }
    }

    private Iterable<ModelAnnotation.Type> getAnnotationTypes() {
        ArrayList<ModelAnnotation.Type> types = new ArrayList<ModelAnnotation.Type>();
        for (ModelAnnotation.Type type : ModelAnnotation.Type.values()) {
            if (!type.isApplicable(this.getModelAnnotations(), this.getModelAnnotation(), this.getValueMeta())) continue;
            types.add(type);
        }
        return types;
    }

    private ValueMetaInterface getValueMeta() {
        if (StringUtils.isNotBlank((String)this.getModelAnnotation().getField())) {
            try {
                RowMetaInterface rowMeta = this.transMeta.getPrevStepFields(this.stepname);
                for (ValueMetaInterface valueMeta : rowMeta.getValueMetaList()) {
                    if (!this.getModelAnnotation().getField().equals(valueMeta.getName())) continue;
                    return valueMeta;
                }
            }
            catch (KettleStepException e) {
                this.log.logError(e.getLocalizedMessage());
            }
        }
        return null;
    }

    private String findTableItemValue(String propertyName) {
        if (StringUtils.isNotBlank((String)propertyName) && this.wProperties.getTable() != null) {
            for (int i = 0; i < this.wProperties.getTable().getItemCount(); ++i) {
                TableItem item = this.wProperties.getTable().getItem(i);
                if (item == null || !StringUtils.equals((String)propertyName, (String)item.getText(1))) continue;
                return item.getText(2);
            }
        }
        return null;
    }
}

