/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.common;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.CreateCalculatedMember;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.di.core.refinery.UIBuilder;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.trans.steps.annotation.OptionsResolver;
import org.pentaho.di.ui.trans.steps.common.BaseComposite;

public class CalculatedMeasureComposite
extends BaseComposite {
    private static String DEFAULT_DIMENSION = "Measures";
    private Label wlMeasureAction;
    private Label wMeasureAction;
    private Label wlMeasureName;
    private Text wMeasureName;
    private Label wlFormat;
    private CCombo wFormat;
    private Label wlFormula;
    private Text wFormula;
    private Button wCalculateSubtotals;
    private Button wHidden;
    private OptionsResolver optionsResolver = new OptionsResolver();

    public CalculatedMeasureComposite(Composite composite) {
        super(composite, 0);
    }

    public void createWidgets() {
        this.wlMeasureAction = new Label((Composite)this, 16384);
        this.wlMeasureAction.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.ModelAction.Label", (String[])new String[0]));
        this.setLook((Control)this.wlMeasureAction);
        UIBuilder.positionControlBelow((Control)this.wlMeasureAction, null, 10, 10);
        this.wMeasureAction = new Label((Composite)this, 16384);
        this.wMeasureAction.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.ModelAction.Text", (String[])new String[0]));
        this.setLook((Control)this.wMeasureAction);
        UIBuilder.positionControlBelow((Control)this.wMeasureAction, (Control)this.wlMeasureAction, 5, 10);
        this.wlMeasureName = new Label((Composite)this, 16384);
        this.wlMeasureName.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.Name.Label", (String[])new String[0]));
        this.setLook((Control)this.wlMeasureName);
        UIBuilder.positionControlBelow((Control)this.wlMeasureName, (Control)this.wMeasureAction, 10, 10);
        this.wMeasureName = new Text((Composite)this, 18436);
        this.setLook((Control)this.wMeasureName);
        UIBuilder.positionControlBelow((Control)this.wMeasureName, (Control)this.wlMeasureName, 5, 10);
        this.setLength((Control)this.wMeasureName, 250);
        this.wlFormat = new Label((Composite)this, 16384);
        this.wlFormat.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.Format.Label", (String[])new String[0]));
        this.setLook((Control)this.wlFormat);
        UIBuilder.positionControlBelow((Control)this.wlFormat, (Control)this.wMeasureName, 10, 10);
        this.wFormat = new CCombo((Composite)this, 18432);
        this.wFormat.setItems(this.optionsResolver.resolveMeasureFormatOptions());
        this.setLook((Control)this.wFormat);
        UIBuilder.positionControlBelow((Control)this.wFormat, (Control)this.wlFormat, 5, 10);
        this.setLength((Control)this.wFormat, 125);
        this.wlFormula = new Label((Composite)this, 16384);
        this.wlFormula.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.Formula.Label", (String[])new String[0]));
        this.setLook((Control)this.wlFormula);
        UIBuilder.positionControlBelow((Control)this.wlFormula, (Control)this.wFormat, 10, 10);
        this.wHidden = new Button((Composite)this, 32);
        this.wHidden.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.Hidden.Label", (String[])new String[0]));
        this.setLook((Control)this.wHidden);
        FormData fdHidden = new FormData();
        fdHidden.left = new FormAttachment(0, 10);
        fdHidden.right = new FormAttachment(100, -10);
        fdHidden.bottom = new FormAttachment(100, -10);
        this.wHidden.setLayoutData((Object)fdHidden);
        this.wCalculateSubtotals = new Button((Composite)this, 32);
        this.wCalculateSubtotals.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"CalculatedMeasure.Composite.Subtotal.Label", (String[])new String[0]));
        this.setLook((Control)this.wCalculateSubtotals);
        FormData fdCalculateSubtotals = new FormData();
        fdCalculateSubtotals.left = new FormAttachment(0, 10);
        fdCalculateSubtotals.right = new FormAttachment(100, -10);
        fdCalculateSubtotals.bottom = new FormAttachment((Control)this.wHidden, -10);
        this.wCalculateSubtotals.setLayoutData((Object)fdCalculateSubtotals);
        this.wFormula = new Text((Composite)this, 2114);
        this.setLook((Control)this.wFormula);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.wlFormula, 5);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        formData.bottom = new FormAttachment((Control)this.wCalculateSubtotals, -10);
        this.wFormula.setLayoutData((Object)formData);
    }

    public void load(ModelAnnotation<?> modelAnnotation) {
        if (modelAnnotation == null || modelAnnotation.getAnnotation() == null || modelAnnotation.getType() != ModelAnnotation.Type.CREATE_CALCULATED_MEMBER) {
            return;
        }
        CreateCalculatedMember calculatedMember = (CreateCalculatedMember)modelAnnotation.getAnnotation();
        this.wMeasureName.setText(StringUtils.defaultIfBlank((String)calculatedMember.getName(), (String)""));
        this.wFormat.setText(StringUtils.defaultIfBlank((String)calculatedMember.getFormatString(), (String)""));
        this.wFormula.setText(StringUtils.defaultIfBlank((String)calculatedMember.getFormula(), (String)""));
        this.wCalculateSubtotals.setSelection(calculatedMember.isCalculateSubtotals());
        this.wHidden.setSelection(calculatedMember.isHidden());
    }

    public void save(AnnotationType annotationType) {
        if (annotationType == null || annotationType.getType() != ModelAnnotation.Type.CREATE_CALCULATED_MEMBER) {
            return;
        }
        CreateCalculatedMember calculatedMember = (CreateCalculatedMember)annotationType;
        calculatedMember.setName(StringUtils.defaultIfBlank((String)this.wMeasureName.getText(), null));
        calculatedMember.setFormatString(StringUtils.defaultIfBlank((String)this.wFormat.getText(), null));
        calculatedMember.setFormula(StringUtils.defaultIfBlank((String)this.wFormula.getText(), null));
        calculatedMember.setDimension(DEFAULT_DIMENSION);
        calculatedMember.setCalculateSubtotals(this.wCalculateSubtotals.getSelection());
        calculatedMember.setHidden(this.wHidden.getSelection());
    }

    public ModelAnnotation<?> get() {
        return null;
    }

    private void setLength(Control control, int width) {
        ((FormData)control.getLayoutData()).width = width;
    }
}

