/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.common;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.trans.steps.annotation.SharedDimensionGroupValidation;
import org.pentaho.di.trans.util.TransUtil;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.trans.steps.common.BaseComposite;
import org.pentaho.di.ui.trans.steps.common.GroupComposite;
import org.pentaho.metastore.api.IMetaStore;

public class SharedDimensionComposite
extends BaseComposite {
    private ComboVar wOutputSteps;
    private GroupComposite groupComposite;

    public SharedDimensionComposite(Composite composite, int i) {
        super(composite, i);
    }

    public void createWidgets() {
        this.setDefaultRowLayout();
        Label wlSharedDimension = new Label((Composite)this, 16384);
        wlSharedDimension.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"SharedDimension.Dialog.SharedDimension.Label", (String[])new String[0]));
        this.setLook((Control)wlSharedDimension);
        this.groupComposite = new GroupComposite((Composite)this, this.getVariables());
        this.groupComposite.setLocalizationPkg(this.getLocalizationPkg());
        this.groupComposite.setLog(this.getLog());
        this.groupComposite.createWidgets();
        this.groupComposite.setAddGroupTooltip(BaseMessages.getString(this.getLocalizationPkg(), (String)"SharedDimension.AddGroup.ToolTip", (String[])new String[0]));
        this.groupComposite.setCopyGroupTooltip(BaseMessages.getString(this.getLocalizationPkg(), (String)"SharedDimension.CopyGroup.ToolTip", (String[])new String[0]));
        Label spacer = new Label((Composite)this, 0);
        spacer.setLayoutData((Object)new RowData(0, 4));
        Label wlOutputSteps = new Label((Composite)this, 16384);
        wlOutputSteps.setText(BaseMessages.getString(this.getLocalizationPkg(), (String)"SharedDimension.Dialog.DataProvider.Label", (String[])new String[0]));
        this.setLook((Control)wlOutputSteps);
        this.wOutputSteps = new ComboVar(this.getVariables(), (Composite)this, 2048);
        RowData rowData = new RowData();
        rowData.width = 300;
        this.wOutputSteps.setLayoutData((Object)rowData);
        this.setLook((Control)this.wOutputSteps);
    }

    public void setEnabled(boolean enabled) {
        this.wOutputSteps.setEnabled(enabled);
        this.groupComposite.setEnabled(enabled);
    }

    public void populateOutputSteps(BaseAnnotationMeta input, TransMeta transMeta, Repository repository, IMetaStore metaStore) {
        try {
            for (String key : TransUtil.collectOutputStepInTrans(transMeta, repository, metaStore).keySet()) {
                this.wOutputSteps.add(key);
            }
            this.wOutputSteps.getCComboWidget().setEnabled(true);
            this.selectOutputStep(input);
        }
        catch (KettleException e) {
            this.logError("error collecting output steps", (Exception)((Object)e));
        }
    }

    private void selectOutputStep(BaseAnnotationMeta input) {
        String[] items = this.wOutputSteps.getItems();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (!StringUtils.equals((String)item, (String)input.getTargetOutputStep())) continue;
            this.wOutputSteps.select(i);
            return;
        }
        if (!StringUtil.isEmpty((String)input.getTargetOutputStep())) {
            this.wOutputSteps.setText(input.getTargetOutputStep());
        }
    }

    public String getOutputStepName() {
        return this.wOutputSteps.getText();
    }

    public boolean setFocus() {
        return this.wOutputSteps.setFocus();
    }

    public boolean validateAnnotationGroup(ModelAnnotationGroup mag) {
        SharedDimensionGroupValidation validation;
        if (mag != null && (validation = new SharedDimensionGroupValidation(mag, (LogChannelInterface)this.getLog())).hasErrors()) {
            StringBuilder str = new StringBuilder();
            for (String msg : validation.getErrorSummary()) {
                str.append(msg);
                str.append(Const.CR);
            }
            this.showError(BaseMessages.getString(this.getLocalizationPkg(), (String)"ModelAnnotation.SharedDimension.ValidationError.Title", (String[])new String[0]), str.toString());
            return false;
        }
        return true;
    }

    public ComboVar getGroupComboWidget() {
        return this.groupComposite.getGroupComboWidget();
    }

    public String getGroupName() {
        return this.groupComposite.getGroupComboWidget().getText();
    }

    public void setAddGroupListener(Listener listener) {
        this.groupComposite.setAddGroupListener(listener);
    }

    public void setCopyGroupListener(Listener listener) {
        this.groupComposite.setCopyGroupListener(listener);
    }

    public void setEnableAddCopyButtons(boolean enable) {
        this.groupComposite.setEnableAddCopyButtons(enable);
    }

    public ComboVar getOutputStepsWidget() {
        return this.wOutputSteps;
    }
}

