/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.JavaKeyStoreProvider;

public final class ProviderUtils {
    @VisibleForTesting
    public static final String NO_PASSWORD_WARN = "WARNING: You have accepted the use of the default provider password\nby not configuring a password in one of the two following locations:\n";
    @VisibleForTesting
    public static final String NO_PASSWORD_ERROR = "ERROR: The provider cannot find a password in the expected locations.\nPlease supply a password using one of the following two mechanisms:\n";
    @VisibleForTesting
    public static final String NO_PASSWORD_CONT = "Continuing with the default provider password.\n";
    @VisibleForTesting
    public static final String NO_PASSWORD_INSTRUCTIONS_DOC = "Please review the documentation regarding provider passwords in\nthe keystore passwords section of the Credential Provider API\n";

    public static Path unnestUri(URI nestedUri) {
        String[] parts = nestedUri.getAuthority().split("@", 2);
        StringBuilder result = new StringBuilder(parts[0]);
        result.append("://");
        if (parts.length == 2) {
            result.append(parts[1]);
        }
        result.append(nestedUri.getPath());
        if (nestedUri.getQuery() != null) {
            result.append("?");
            result.append(nestedUri.getQuery());
        }
        if (nestedUri.getFragment() != null) {
            result.append("#");
            result.append(nestedUri.getFragment());
        }
        return new Path(result.toString());
    }

    public static URI nestURIForLocalJavaKeyStoreProvider(URI localFile) throws URISyntaxException {
        if (!"file".equals(localFile.getScheme())) {
            throw new IllegalArgumentException("passed URI had a scheme other than file.");
        }
        if (localFile.getAuthority() != null) {
            throw new IllegalArgumentException("passed URI must not have an authority component. For non-local keystores, please use " + JavaKeyStoreProvider.class.getName());
        }
        return new URI("localjceks", "//file" + localFile.getSchemeSpecificPart(), localFile.getFragment());
    }

    public static char[] locatePassword(String envWithPass, String fileWithPass) throws IOException {
        char[] pass = null;
        if (System.getenv().containsKey(envWithPass)) {
            pass = System.getenv(envWithPass).toCharArray();
        }
        if (pass == null && fileWithPass != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL pwdFile = cl.getResource(fileWithPass);
            if (pwdFile == null) {
                throw new IOException("Password file does not exist");
            }
            try (InputStream is = pwdFile.openStream();){
                pass = IOUtils.toString((InputStream)is).trim().toCharArray();
            }
        }
        return pass;
    }

    private static String noPasswordInstruction(String envKey, String fileKey) {
        return "    * In the environment variable " + envKey + "\n" + "    * In a file referred to by the configuration entry\n" + "      " + fileKey + ".\n" + NO_PASSWORD_INSTRUCTIONS_DOC;
    }

    public static String noPasswordWarning(String envKey, String fileKey) {
        return NO_PASSWORD_WARN + ProviderUtils.noPasswordInstruction(envKey, fileKey) + NO_PASSWORD_CONT;
    }

    public static String noPasswordError(String envKey, String fileKey) {
        return NO_PASSWORD_ERROR + ProviderUtils.noPasswordInstruction(envKey, fileKey);
    }
}

