/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.model.PartitionDatabaseMeta;

@XmlRootElement
public class DatabaseConnection
implements Serializable,
IDatabaseConnection {
    private static final long serialVersionUID = -3816140282186728714L;
    public static final String EMPTY_OPTIONS_STRING = "><EMPTY><";
    public static final String ATTRIBUTE_CUSTOM_URL = "CUSTOM_URL";
    public static final String ATTRIBUTE_CUSTOM_DRIVER_CLASS = "CUSTOM_DRIVER_CLASS";
    public static final String ATTRIBUTE_PREFIX_EXTRA_OPTION = "EXTRA_OPTION_";
    String id;
    String name;
    String databaseName;
    String databasePort;
    String hostname;
    String username;
    String password;
    String dataTablespace;
    String indexTablespace;
    boolean streamingResults;
    boolean quoteAllFields;
    boolean changed;
    boolean usingDoubleDecimalAsSchemaTableSeparator;
    String informixServername;
    boolean forcingIdentifiersToLowerCase;
    boolean forcingIdentifiersToUpperCase;
    String connectSql;
    boolean usingConnectionPool;
    String accessTypeValue = null;
    DatabaseAccessType accessType = null;
    IDatabaseType databaseType = null;
    Map<String, String> extraOptions = new HashMap<String, String>();
    Map<String, String> extraOptionsOrder = new HashMap<String, String>();
    Map<String, String> attributes = new HashMap<String, String>();
    Map<String, String> connectionPoolingProperties = new HashMap<String, String>();
    List<PartitionDatabaseMeta> partitioningInformation;
    int initialPoolSize;
    int maxPoolSize;
    boolean partitioned;

    @Override
    public void setAccessType(DatabaseAccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public DatabaseAccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessTypeValue(String value) {
        this.accessTypeValue = value;
    }

    public String getAccessTypeValue() {
        return this.accessType == null ? this.accessTypeValue : this.accessType.toString();
    }

    @Override
    @XmlElement(type=DatabaseType.class)
    public void setDatabaseType(IDatabaseType driver) {
        this.databaseType = driver;
    }

    @Override
    public IDatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public void setExtraOptions(Map<String, String> extraOptions) {
        this.extraOptions = extraOptions;
    }

    @Override
    public Map<String, String> getExtraOptions() {
        return this.extraOptions;
    }

    @Override
    public void setExtraOptionsOrder(Map<String, String> extraOptionsOrder) {
        this.extraOptionsOrder = extraOptionsOrder;
    }

    @Override
    public Map<String, String> getExtraOptionsOrder() {
        return this.extraOptionsOrder;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getDatabaseName() {
        if (this.getDatabaseType() != null && (this.databaseName == null || this.databaseName.trim().length() == 0)) {
            return this.getDatabaseType().getDefaultDatabaseName();
        }
        return this.databaseName;
    }

    @Override
    public void setDatabasePort(String databasePort) {
        this.databasePort = databasePort;
    }

    @Override
    public String getDatabasePort() {
        return this.databasePort;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setStreamingResults(boolean streamingResults) {
        this.streamingResults = streamingResults;
    }

    @Override
    public boolean isStreamingResults() {
        return this.streamingResults;
    }

    @Override
    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    @Override
    public String getDataTablespace() {
        return this.dataTablespace;
    }

    @Override
    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Override
    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    @Override
    public void setSQLServerInstance(String sqlServerInstance) {
        this.addExtraOption("MSSQL", "instance", sqlServerInstance);
    }

    @Override
    public String getSQLServerInstance() {
        return this.getExtraOptions().get("MSSQL.instance");
    }

    @Override
    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean usingDoubleDecimalAsSchemaTableSeparator) {
        this.usingDoubleDecimalAsSchemaTableSeparator = usingDoubleDecimalAsSchemaTableSeparator;
    }

    @Override
    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        return this.usingDoubleDecimalAsSchemaTableSeparator;
    }

    @Override
    public void setInformixServername(String informixServername) {
        this.informixServername = informixServername;
    }

    @Override
    public String getInformixServername() {
        return this.informixServername;
    }

    @Override
    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.extraOptions.put(databaseTypeCode + "." + option, value);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean getChanged() {
        return this.changed;
    }

    @Override
    public void setQuoteAllFields(boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
    }

    @Override
    public boolean isQuoteAllFields() {
        return this.quoteAllFields;
    }

    @Override
    public void setForcingIdentifiersToLowerCase(boolean forcingIdentifiersToLowerCase) {
        this.forcingIdentifiersToLowerCase = forcingIdentifiersToLowerCase;
    }

    @Override
    public boolean isForcingIdentifiersToLowerCase() {
        return this.forcingIdentifiersToLowerCase;
    }

    @Override
    public void setForcingIdentifiersToUpperCase(boolean forcingIdentifiersToUpperCase) {
        this.forcingIdentifiersToUpperCase = forcingIdentifiersToUpperCase;
    }

    @Override
    public boolean isForcingIdentifiersToUpperCase() {
        return this.forcingIdentifiersToUpperCase;
    }

    @Override
    public void setConnectSql(String connectSql) {
        this.connectSql = connectSql;
    }

    @Override
    public String getConnectSql() {
        return this.connectSql;
    }

    @Override
    public void setUsingConnectionPool(boolean usingConnectionPool) {
        this.usingConnectionPool = usingConnectionPool;
    }

    @Override
    public boolean isUsingConnectionPool() {
        return this.usingConnectionPool;
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    @Override
    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public Map<String, String> getConnectionPoolingProperties() {
        return this.connectionPoolingProperties;
    }

    @Override
    public void setConnectionPoolingProperties(Map<String, String> connectionPoolingProperties) {
        this.connectionPoolingProperties = connectionPoolingProperties;
    }

    @Override
    public void setPartitioningInformation(List<PartitionDatabaseMeta> partitioningInformation) {
        this.partitioningInformation = partitioningInformation;
    }

    @Override
    public List<PartitionDatabaseMeta> getPartitioningInformation() {
        return this.partitioningInformation;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "DatabaseConnection [id=" + this.id + ", name=" + this.name + ", databaseName=" + this.databaseName + ", databasePort=" + this.databasePort + ", hostname=" + this.hostname + ", username=" + this.username + ", password=" + this.password + ", dataTablespace=" + this.dataTablespace + ", indexTablespace=" + this.indexTablespace + ", streamingResults=" + this.streamingResults + ", quoteAllFields=" + this.quoteAllFields + ", changed=" + this.changed + ", usingDoubleDecimalAsSchemaTableSeparator=" + this.usingDoubleDecimalAsSchemaTableSeparator + ", informixServername=" + this.informixServername + ", forcingIdentifiersToLowerCase=" + this.forcingIdentifiersToLowerCase + ", forcingIdentifiersToUpperCase=" + this.forcingIdentifiersToUpperCase + ", connectSql=" + this.connectSql + ", usingConnectionPool=" + this.usingConnectionPool + ", accessTypeValue=" + this.accessTypeValue + ", accessType=" + (Object)((Object)this.accessType) + ", databaseType=" + this.databaseType + ", extraOptions=" + this.extraOptions + ", attributes=" + this.attributes + ", connectionPoolingProperties=" + this.connectionPoolingProperties + ", partitioningInformation=" + this.partitioningInformation + ", initialPoolSize=" + this.initialPoolSize + ", maxPoolSize=" + this.maxPoolSize + ", partitioned=" + this.partitioned + "]";
    }
}

