/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.springdm.extender;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public class PentahoOsgiBundleXmlApplicationContext
extends OsgiBundleXmlApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(PentahoOsgiBundleXmlApplicationContext.class);

    public PentahoOsgiBundleXmlApplicationContext(String[] configurationLocations) {
        super(configurationLocations);
    }

    public Resource getResource(String location) {
        int index = location.indexOf("plugin:");
        if (index != 0) {
            return super.getResource(location);
        }
        location = location.substring("plugin:".length());
        String pluginPath = this.getBundle().getSymbolicName() + "/";
        Resource resourceByPath = super.getResource("osgibundlejar:/" + pluginPath + location);
        if (resourceByPath != null) {
            return resourceByPath;
        }
        return null;
    }

    protected Resource getResourceByPath(String path) {
        int index = path.indexOf("plugin:");
        if (index != 0) {
            return super.getResourceByPath(path);
        }
        path = path.substring("plugin:".length());
        String pluginPath = "";
        try {
            Enumeration resources = this.getBundle().getResources("/");
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                if (url.getPath().endsWith("-INF")) continue;
                pluginPath = url.getPath();
                break;
            }
        }
        catch (IOException e) {
            log.error("Error getting resources by path", (Throwable)e);
        }
        Resource resourceByPath = super.getResourceByPath("classpath:" + pluginPath + "/" + path);
        if (resourceByPath != null) {
            return resourceByPath;
        }
        return null;
    }
}

