/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.main.Main;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.osgi.ExceptionBasedClientTypeProvider;
import org.pentaho.platform.osgi.KarafInstance;
import org.pentaho.platform.osgi.KarafInstanceResolverException;
import org.pentaho.platform.osgi.SystemPackageExtrapolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class KarafBoot
implements IPentahoSystemListener {
    public static final String CLEAN_KARAF_CACHE = "org.pentaho.clean.karaf.cache";
    private Main main;
    private KarafInstance karafInstance;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PENTAHO_KARAF_ROOT_COPY_DEST_FOLDER = "pentaho.karaf.root.copy.dest.folder";
    public static final String PENTAHO_KARAF_ROOT_TRANSIENT = "pentaho.karaf.root.transient";
    public static final String PENTAHO_KARAF_ROOT_TRANSIENT_DIRECTORY_ATTEMPTS = "pentaho.karaf.root.transient.directory.attempts";
    public static final String PENTAHO_KARAF_ROOT_COPY_FOLDER_SYMLINK_FILES = "pentaho.karaf.root.copy.folder.symlink.files";
    public static final String PENTAHO_KARAF_ROOT_COPY_FOLDER_EXCLUDE_FILES = "pentaho.karaf.root.copy.folder.exclude.files";
    public static final String ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA = "org.osgi.framework.system.packages.extra";
    public static final String PENTAHO_KARAF_INSTANCE_RESOLVER_CLASS = "pentaho.karaf.instance.resolver.class";
    private static final String SYSTEM_PROP_OSX_APP_ROOT_DIR = "osx.app.root.dir";
    protected static final String KARAF_DIR = "/system/karaf";
    private static FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public boolean startup(IPentahoSession session) {
        try {
            File destDir;
            String solutionRootPath = PentahoSystem.getApplicationContext().getSolutionRootPath();
            File karafDir = new File(solutionRootPath + KARAF_DIR);
            if (!karafDir.exists()) {
                this.logger.warn("Karaf not found in standard dir of '" + solutionRootPath + KARAF_DIR + "' ");
                String osxAppRootDir = System.getProperty(SYSTEM_PROP_OSX_APP_ROOT_DIR);
                if (!StringUtils.isEmpty((String)osxAppRootDir)) {
                    this.logger.warn("Given that the system property 'osx.app.root.dir' is set, we are in a OSX .app context; we'll try looking for Karaf in the app's root dir '" + osxAppRootDir + "' ");
                    File osxAppKarafDir = new File(osxAppRootDir + KARAF_DIR);
                    if (osxAppKarafDir.exists()) {
                        karafDir = osxAppKarafDir;
                    }
                }
            }
            String root = karafDir.toURI().getPath();
            String rootCopyFolderString = System.getProperty(PENTAHO_KARAF_ROOT_COPY_DEST_FOLDER);
            boolean transientRoot = Boolean.parseBoolean(System.getProperty(PENTAHO_KARAF_ROOT_TRANSIENT, "false"));
            if (rootCopyFolderString == null && !this.canOpenConfigPropertiesForEdit(root)) {
                transientRoot = true;
            }
            if (transientRoot) {
                if (rootCopyFolderString == null) {
                    destDir = Files.createTempDirectory("karaf", new FileAttribute[0]).toFile();
                } else {
                    int directoryAttempts = Integer.parseInt(System.getProperty(PENTAHO_KARAF_ROOT_TRANSIENT_DIRECTORY_ATTEMPTS, "250"));
                    File candidate = new File(rootCopyFolderString);
                    int i = 1;
                    while (candidate.exists() || !candidate.mkdirs()) {
                        if (i > directoryAttempts) {
                            candidate = Files.createTempDirectory("karaf", new FileAttribute[0]).toFile();
                            this.logger.warn("Unable to create " + rootCopyFolderString + " after " + i + " attempts, using temp dir " + candidate);
                            break;
                        }
                        candidate = new File(rootCopyFolderString + i++);
                    }
                    destDir = candidate;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (KarafBoot.this.main != null) {
                                KarafBoot.this.main.destroy();
                            }
                            if (KarafBoot.this.karafInstance != null) {
                                KarafBoot.this.karafInstance.close();
                            }
                            KarafBoot.deleteRecursiveIfExists(destDir);
                        }
                        catch (IOException e) {
                            KarafBoot.this.logger.error("Unable to delete karaf directory " + destDir, (Throwable)e);
                        }
                        catch (Exception e) {
                            KarafBoot.this.logger.error("Error stopping Karaf", (Throwable)e);
                        }
                    }
                }));
            } else {
                destDir = rootCopyFolderString != null ? new File(rootCopyFolderString) : null;
            }
            if (destDir != null && (transientRoot || !destDir.exists())) {
                final HashSet<String> symlinks = new HashSet<String>();
                String symlinkFiles = System.getProperty(PENTAHO_KARAF_ROOT_COPY_FOLDER_SYMLINK_FILES, "lib,system");
                if (symlinkFiles != null) {
                    for (String symlink : symlinkFiles.split(",")) {
                        symlinks.add(symlink.trim());
                    }
                }
                final HashSet<String> excludes = new HashSet<String>();
                String excludeFiles = System.getProperty(PENTAHO_KARAF_ROOT_COPY_FOLDER_EXCLUDE_FILES, "caches");
                if (excludeFiles != null) {
                    for (String exclude : excludeFiles.split(",")) {
                        excludes.add(exclude.trim());
                    }
                }
                final Path karafDirPath = Paths.get(karafDir.toURI());
                FileUtils.copyDirectory((File)karafDir, (File)destDir, (FileFilter)new AbstractFileFilter(){

                    public boolean accept(File file) {
                        Path filePath = Paths.get(file.toURI());
                        String relativePath = karafDirPath.relativize(filePath).toString();
                        if (excludes.contains(relativePath)) {
                            return false;
                        }
                        if (symlinks.contains(relativePath)) {
                            File linkFile = new File(destDir, relativePath);
                            linkFile.getParentFile().mkdirs();
                            Path link = Paths.get(linkFile.toURI());
                            try {
                                if (Files.createSymbolicLink(link, filePath, new FileAttribute[0]) != null) {
                                    return false;
                                }
                            }
                            catch (IOException e) {
                                KarafBoot.this.logger.warn("Unable to create symlink " + linkFile.getAbsolutePath() + " -> " + file.getAbsolutePath());
                            }
                        }
                        return true;
                    }
                });
            }
            if (destDir != null) {
                root = destDir.toURI().getPath();
            }
            this.configureSystemProperties(solutionRootPath, root);
            String customLocation = root + "/etc/custom.properties";
            this.expandSystemPackages(customLocation);
            this.cleanCachesIfFlagSet(root);
            this.karafInstance = this.createAndProcessKarafInstance(root);
            Thread karafThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)UUID.randomUUID().toString(), (Object)""));
                    KarafBoot.this.main = new Main(new String[0]);
                    try {
                        KarafBoot.this.main.launch();
                    }
                    catch (Exception e) {
                        KarafBoot.this.main = null;
                        KarafBoot.this.logger.error("Error starting Karaf", (Throwable)e);
                    }
                }
            });
            karafThread.setDaemon(true);
            karafThread.run();
            karafThread.join();
        }
        catch (Exception e) {
            this.main = null;
            this.logger.error("Error starting Karaf", (Throwable)e);
        }
        return this.main != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cleanCachesIfFlagSet(String root) throws IOException {
        File[] clientCacheFolders;
        String cleanCache;
        Properties customProps;
        String customLocation;
        block13: {
            customLocation = root + "/etc/custom.properties";
            this.logger.info("Checking to see if org.pentaho.clean.karaf.cache is enabled");
            customProps = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(customLocation));
                customProps.load(fileInputStream);
                if (fileInputStream == null) break block13;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        if (!"true".equals(cleanCache = customProps.getProperty(CLEAN_KARAF_CACHE, "false"))) return;
        this.logger.info("org.pentaho.clean.karaf.cache is enabled. Karaf data directories will be deleted");
        File cacheParent = new File(root + "/caches");
        for (File clientCacheFolder : clientCacheFolders = cacheParent.listFiles(directoryFilter)) {
            File[] cacheDirs;
            for (File cacheDir : cacheDirs = clientCacheFolder.listFiles(directoryFilter)) {
                File lockFile = new File(cacheDir, ".lock");
                FileOutputStream fileOutputStream = new FileOutputStream(lockFile);
                try {
                    FileLock fileLock = fileOutputStream.getChannel().tryLock();
                    fileLock.release();
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    FileUtils.deleteDirectory((File)cacheDir);
                }
                catch (Exception exception) {
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
            }
        }
        customProps.setProperty(CLEAN_KARAF_CACHE, "false");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(customLocation);
            this.logger.info("Setting org.pentaho.clean.karaf.cache back to false as this is a one-time action");
            customProps.store(out, "Turning of one-time cache clean setting");
            return;
        }
        finally {
            if (out != null) {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    public static void deleteRecursiveIfExists(File item) {
        if (!item.exists()) {
            return;
        }
        if (!Files.isSymbolicLink(item.toPath()) && item.isDirectory()) {
            File[] subitems;
            for (File subitem : subitems = item.listFiles()) {
                KarafBoot.deleteRecursiveIfExists(subitem);
            }
        }
        item.delete();
    }

    protected KarafInstance createAndProcessKarafInstance(String root) throws FileNotFoundException, KarafInstanceResolverException {
        String clientType = new ExceptionBasedClientTypeProvider().getClientType();
        KarafInstance karafInstance = new KarafInstance(root, clientType);
        karafInstance.assignPortsAndCreateCache();
        return karafInstance;
    }

    protected void configureSystemProperties(String solutionRootPath, String root) {
        this.fillMissedSystemProperty("karaf.home", root);
        this.fillMissedSystemProperty("karaf.base", root);
        this.fillMissedSystemProperty("karaf.history", root + "/data/history.txt");
        this.fillMissedSystemProperty("karaf.instances", root + "/instances");
        this.fillMissedSystemProperty("karaf.startLocalConsole", "false");
        this.fillMissedSystemProperty("karaf.startRemoteShell", "true");
        this.fillMissedSystemProperty("karaf.lock", "false");
        this.fillMissedSystemProperty("karaf.etc", root + "/etc");
        KettleClientEnvironment.ClientType clientType = this.getClientType();
        String extraKettleEtc = this.translateToExtraKettleEtc(clientType);
        if (extraKettleEtc != null) {
            System.setProperty("felix.fileinstall.dir", root + "/etc," + root + extraKettleEtc);
        } else {
            System.setProperty("felix.fileinstall.dir", root + "/etc");
        }
        System.setProperty("embedded.karaf.mode", "true");
        File file = new File(solutionRootPath + "/system/osgi/log4j.xml");
        if (file.exists()) {
            System.setProperty("log4j.configuration", file.toURI().toString());
        } else {
            this.logger.warn(file.toURI().toString() + " file not exist");
        }
        System.setProperty("log4j.ignoreTCL", "true");
    }

    protected void fillMissedSystemProperty(String propertyName, String propertyValue) {
        if (System.getProperty(propertyName) == null) {
            System.setProperty(propertyName, propertyValue);
        }
    }

    protected String translateToExtraKettleEtc(KettleClientEnvironment.ClientType clientType) {
        String extraKettleEtc = null;
        if (clientType != null) {
            switch (clientType) {
                case SPOON: {
                    extraKettleEtc = "/etc-spoon";
                    break;
                }
                case PAN: {
                    extraKettleEtc = "/etc-pan";
                    break;
                }
                case KITCHEN: {
                    extraKettleEtc = "/etc-kitchen";
                    break;
                }
                case CARTE: {
                    extraKettleEtc = "/etc-carte";
                    break;
                }
                default: {
                    extraKettleEtc = "/etc-default";
                }
            }
        }
        return extraKettleEtc;
    }

    protected KettleClientEnvironment.ClientType getClientType() {
        return KettleClientEnvironment.getInstance().getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canOpenConfigPropertiesForEdit(String directory) {
        String testFile = directory + "/etc/config.properties";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(testFile, true);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandSystemPackages(String s) {
        File customFile = new File(s);
        if (!customFile.exists()) {
            this.logger.warn("No custom.properties file for in karaf distribution.");
            return;
        }
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(customFile);
            properties.load(inStream);
        }
        catch (IOException e) {
            try {
                this.logger.error("Not able to expand system.packages.extra properties due to an error loading custom.properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStream);
            return;
        }
        IOUtils.closeQuietly((InputStream)inStream);
        properties = new SystemPackageExtrapolator().expandProperties(properties);
        System.setProperty(ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA, properties.getProperty(ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA));
    }

    public void shutdown() {
        try {
            if (this.main != null) {
                this.main.destroy();
            }
        }
        catch (Exception e) {
            this.logger.error("Error stopping Karaf", (Throwable)e);
        }
    }
}

