/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.osgi.IKarafInstanceResolver;
import org.pentaho.platform.osgi.KarafInstancePort;
import org.pentaho.platform.osgi.KarafInstanceResolverException;
import org.pentaho.platform.osgi.ServerSocketBasedKarafInstanceResolver;
import org.pentaho.platform.settings.PortFileManager;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;
import org.pentaho.platform.settings.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class KarafInstance {
    private static final String YAML_FILE_NAME = "KarafPorts.yaml";
    private static Logger logger = LoggerFactory.getLogger(KarafInstance.class);
    private int instanceNumber = 0;
    private ServerSocket instanceSocket;
    private String cachePath;
    private final String cacheParentFolder;
    private HashMap<String, KarafInstancePort> instancePorts = new HashMap();
    private static final int BANNER_WIDTH = 79;
    private static final String USED_PORT_FILENAME = "PortsAssigned.txt";
    private boolean started;
    private StringBuilder banner = new StringBuilder();
    private String instanceFilePath;
    private String clientType;
    private FileLock cacheLock;
    protected static IKarafInstanceResolver resolver;

    public KarafInstance(String root, String clientType) {
        this(root, System.getProperty("karaf.etc") + "/" + YAML_FILE_NAME, "default");
        this.clientType = clientType;
    }

    public KarafInstance(String root, String instanceFilePath, String clientType) {
        this.cacheParentFolder = root + "/caches";
        this.instanceFilePath = instanceFilePath;
        try {
            this.processConfigFile();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Port Config file (" + this.instanceFilePath + ") not found", e);
        }
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
        System.setProperty("karaf.data", cachePath);
    }

    public void processConfigFile() throws FileNotFoundException {
        try (FileInputStream input = new FileInputStream(new File(this.instanceFilePath));){
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load((InputStream)input);
            List serviceList = (List)map.get("Service");
            for (Map serviceMap : serviceList) {
                Service service = new Service(serviceMap.get("serviceName").toString(), serviceMap.get("serviceDescription").toString());
                ServerPortRegistry.addService(service);
            }
            List portList = (List)map.get("ServerPort");
            for (Map portMap : portList) {
                KarafInstancePort karafPort = new KarafInstancePort(this, portMap.get("id").toString(), portMap.get("property").toString(), portMap.get("friendlyName").toString(), (Integer)portMap.get("startPort"), portMap.get("serviceName").toString());
                this.registerPort(karafPort);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("File " + this.instanceFilePath + " does not exist.  Could not determine karaf port assignment");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse file " + this.instanceFilePath + ".", e);
        }
    }

    protected static IKarafInstanceResolver getResolver() {
        if (resolver == null) {
            String clazz = System.getProperty("pentaho.karaf.instance.resolver.class");
            if (clazz != null) {
                try {
                    resolver = (IKarafInstanceResolver)Class.forName(clazz).newInstance();
                }
                catch (Exception e) {
                    logger.error("Error instantiating user defined Karaf Instance Resolver: " + clazz, (Throwable)e);
                }
            }
            if (resolver == null) {
                resolver = new ServerSocketBasedKarafInstanceResolver();
            }
        }
        return resolver;
    }

    public void assignPortsAndCreateCache() throws KarafInstanceResolverException {
        KarafInstance.getResolver().resolveInstance(this);
        if (this.started) {
            throw new IllegalStateException("Attempt to start a karaf instance that is already started");
        }
        this.started = true;
        this.banner.append("\n").append(StringUtils.repeat((String)"*", (int)79));
        this.bannerLine("Karaf Instance Number: " + this.instanceNumber + " at " + this.cachePath);
        TreeSet<String> ids = new TreeSet<String>(this.instancePorts.keySet());
        for (String id : ids) {
            ServerPort propertyInstance = this.instancePorts.get(id);
            this.bannerLine(propertyInstance.getFriendlyName() + ":" + propertyInstance.getAssignedPort());
        }
        this.banner.append("\n").append(StringUtils.repeat((String)"*", (int)79));
        logger.info(this.banner.toString());
        String usedPortFilePath = this.cachePath + "/" + USED_PORT_FILENAME;
        try {
            PortFileManager.getInstance().writeUsedPortFile(usedPortFilePath);
        }
        catch (Exception e) {
            logger.warn("Could not write " + usedPortFilePath + ".", (Throwable)e);
        }
    }

    private void bannerLine(String line) {
        if (line.length() > 71) {
            this.bannerLine(line.substring(0, 71));
            line = "  " + line.substring(71);
        }
        this.banner.append("\n*** ").append(line).append(StringUtils.repeat((String)" ", (int)(79 - line.length() - 7))).append("***");
    }

    public void close() throws IOException {
        this.instanceSocket.close();
        this.cacheLock.acquiredBy().close();
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public void registerPort(KarafInstancePort instancePort) {
        if (this.started) {
            throw new IllegalStateException("Ports must be added Before the Karaf instance is started");
        }
        if (this.instancePorts.containsKey(instancePort.getId())) {
            throw new IllegalStateException("Id " + instancePort.getId() + " already defined.");
        }
        this.instancePorts.put(instancePort.getId(), instancePort);
        ServerPortRegistry.addPort(instancePort);
    }

    public KarafInstancePort getPort(String id) {
        return this.instancePorts.get(id);
    }

    public Set<String> getPortIds() {
        return this.instancePorts.keySet();
    }

    public List<KarafInstancePort> getPorts() {
        return new ArrayList<KarafInstancePort>(this.instancePorts.values());
    }

    @VisibleForTesting
    String getCacheParentFolder() {
        return this.cacheParentFolder;
    }

    public void setInstanceNumber(Integer instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public void setInstanceSocket(ServerSocket instanceSocket) {
        this.instanceSocket = instanceSocket;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setCacheLock(FileLock cacheLock) {
        this.cacheLock = cacheLock;
    }
}

