/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.versionchecker;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.versionchecker.PentahoVersionCheckReflectHelper;

public class PentahoVersionCheckComponent
extends ComponentBase {
    private static final long serialVersionUID = 8178713714323100555L;
    private static final String DOCUMENT = "document";

    public Log getLogger() {
        return LogFactory.getLog(PentahoVersionCheckComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() {
        String output = null;
        boolean ignoreExistingUpdates = this.getInputBooleanValue("ignoreExistingUpdates", true);
        int versionRequestFlags = -1;
        try {
            Object releaseFlagsObj = this.getInputValue("releaseFlags");
            String releaseFlags = "";
            if (releaseFlagsObj instanceof String[]) {
                String[] arr = (String[])releaseFlagsObj;
                if (arr.length > 0) {
                    releaseFlags = releaseFlags + arr[0];
                    for (int i = 1; i < arr.length; ++i) {
                        releaseFlags = releaseFlags + "," + arr[i];
                    }
                }
            } else {
                releaseFlags = releaseFlagsObj.toString();
            }
            if (releaseFlags != null) {
                boolean requestMajorReleases = (releaseFlags = releaseFlags.toLowerCase()).indexOf("major") >= 0;
                boolean requestMinorReleases = releaseFlags.indexOf("minor") >= 0;
                boolean requestRCReleases = releaseFlags.indexOf("rc") >= 0;
                boolean requestGAReleases = releaseFlags.indexOf("ga") >= 0;
                boolean requestMilestoneReleases = releaseFlags.indexOf("milestone") >= 0;
                versionRequestFlags = (requestMajorReleases ? 4 : 0) + (requestMinorReleases ? 8 : 0) + (requestRCReleases ? 16 : 0) + (requestGAReleases ? 32 : 0) + (requestMilestoneReleases ? 64 : 0);
            }
        }
        catch (Exception releaseFlagsObj) {
            // empty catch block
        }
        if (PentahoVersionCheckReflectHelper.isVersionCheckerAvailable()) {
            List results = PentahoVersionCheckReflectHelper.performVersionCheck((boolean)ignoreExistingUpdates, (int)versionRequestFlags);
            output = PentahoVersionCheckReflectHelper.logVersionCheck((List)results, (Log)this.getLogger());
        } else {
            output = "<vercheck><error><[!CDATA[" + Messages.getInstance().getString("VersionCheck.VERSION_CHECK_DISABLED") + "]]></error></vercheck>";
        }
        if (this.isDefinedOutput(DOCUMENT)) {
            this.setOutputValue(DOCUMENT, output);
        }
        return true;
    }

    public boolean init() {
        return true;
    }
}

