/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.mondrian;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import mondrian.olap.Util;
import mondrian.parser.TokenMgrError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.OlapConnection;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;
import org.pentaho.platform.plugin.services.messages.Messages;

public class MDXOlap4jConnection
implements IPentahoConnection {
    static final Log log = LogFactory.getLog(MDXOlap4jConnection.class);
    protected OlapConnection connection = null;

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean connect(Properties props) {
        String url = props.getProperty("url");
        String driver = props.getProperty("driver");
        String user = props.getProperty("user", null);
        String password = props.getProperty("password", null);
        try {
            ClassLoader contextClassLoader;
            if (this.connection != null) {
                this.connection.close();
            }
            if (url.startsWith("jdbc:mondrian")) {
                Util.PropertyList connectProperties = Util.parseConnectString((String)url);
                MDXConnection.mapPlatformRolesToMondrianRolesHelper(connectProperties);
                url = connectProperties.toString();
            }
            if ((contextClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
                contextClassLoader = this.getClass().getClassLoader();
            }
            contextClassLoader.loadClass(driver);
            Connection sqlConnection = DriverManager.getConnection(url, user, password);
            this.connection = sqlConnection.unwrap(OlapConnection.class);
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getErrorString("MDXConnection.ERROR_0002_INVALID_CONNECTION", new Object[]{"driver=" + driver + ";url=" + url}), (Throwable)e);
            return false;
        }
        catch (TokenMgrError e) {
            log.error((Object)Messages.getInstance().getErrorString("MDXConnection.ERROR_0002_INVALID_CONNECTION", new Object[]{"driver=" + driver + ";url=" + url}), (Throwable)e);
            return false;
        }
        return true;
    }

    public IPentahoResultSet executeQuery(String arg0) {
        throw new UnsupportedOperationException();
    }

    public IPentahoResultSet getResultSet() {
        throw new UnsupportedOperationException();
    }

    public boolean initialized() {
        return this.connection != null;
    }

    public boolean isClosed() {
        if (this.connection == null) {
            throw new IllegalStateException();
        }
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadOnly() {
        if (this.connection == null) {
            throw new IllegalStateException();
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public IPentahoResultSet prepareAndExecuteQuery(String arg0, List arg1) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean preparedQueriesSupported() {
        return false;
    }

    public void setFetchSize(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void setMaxRows(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void setProperties(Properties props) {
        this.connect(props);
    }

    public void clearWarnings() {
    }

    public String getDatasourceType() {
        return "MDXOlap4j";
    }

    public String getLastQuery() {
        throw new UnsupportedOperationException();
    }

    public OlapConnection getConnection() {
        return this.connection;
    }
}

