/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.pentaho.platform.util.xml.XMLParserFactoryProducer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XActionImportHandler
extends RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    public XActionImportHandler(List<IMimeType> mimeTypes) {
        super(mimeTypes);
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException {
        try {
            RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
            byte[] bytes = IOUtils.toByteArray((InputStream)bundle.getInputStream());
            importBundle.setInputStream(new ByteArrayInputStream(bytes));
            Document document = this.getImportBundleDocument(new ByteArrayInputStream(bytes));
            NodeList resultTypes = document.getElementsByTagName("result-type");
            if (resultTypes.getLength() > 0) {
                Node resultType = resultTypes.item(0);
                boolean isHidden = "none".equals(resultType.getTextContent());
                importBundle.setHidden(isHidden);
            }
            this.importBundle(importBundle);
        }
        catch (Exception e) {
            throw new PlatformImportException(e.getMessage(), e);
        }
    }

    protected void importBundle(RepositoryFileImportBundle importBundle) throws PlatformImportException {
        super.importFile(importBundle);
    }

    @VisibleForTesting
    Document getImportBundleDocument(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = XMLParserFactoryProducer.createSecureDocBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }
}

