/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.config.PropertiesFileConfiguration;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.plugin.services.pluginmgr.IAdminContentConditionalLogic;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.Cube;
import org.pentaho.platform.web.http.api.resources.Setting;
import org.pentaho.platform.web.http.api.resources.SystemResource;
import org.pentaho.platform.web.http.api.resources.services.UserConsoleService;

@Path(value="/mantle/")
public class UserConsoleResource
extends AbstractJaxRSResource {
    private static final Log logger = LogFactory.getLog(UserConsoleResource.class);
    protected static UserConsoleService userConsoleService;
    private static ISystemConfig systemConfig;
    private static List<String> setSessionVarWhiteList;
    private static List<String> getSessionVarWhiteList;
    private static PropertiesFileConfiguration config;
    private static boolean isInitialized;

    public UserConsoleResource() {
        userConsoleService = new UserConsoleService();
        if (!isInitialized) {
            systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
            String solutionRootPath = PentahoSystem.getApplicationContext().getSolutionRootPath();
            config = new PropertiesFileConfiguration("rest", new File(solutionRootPath + "/system/restConfig.properties"));
            try {
                systemConfig.registerConfiguration((IConfiguration)config);
                setSessionVarWhiteList = Arrays.asList(systemConfig.getProperty("rest.userConsoleResource.setSessionVarWhiteList").split(","));
                getSessionVarWhiteList = Arrays.asList(systemConfig.getProperty("rest.userConsoleResource.getSessionVarWhiteList").split(","));
            }
            catch (IOException e) {
                setSessionVarWhiteList.add("scheduler_folder");
                setSessionVarWhiteList.add("showOverrideDialog");
                getSessionVarWhiteList.add("scheduler_folder");
                getSessionVarWhiteList.add("showOverrideDialog");
            }
            isInitialized = true;
        }
    }

    @GET
    @Path(value="/isAdministrator")
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns the boolean response")})
    public Response isAdministrator() {
        return this.buildOkResponse(String.valueOf(userConsoleService.isAdministrator()));
    }

    @GET
    @Path(value="/isAuthenticated")
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns the boolean response"), @ResponseCode(code=401, condition="User is not authenticated")})
    public Response isAuthenticated() {
        return this.buildOkResponse(String.valueOf(userConsoleService.isAuthenticated()));
    }

    @GET
    @Path(value="/getAdminContent")
    @Facet(name="Unsupported")
    @Produces(value={"application/json", "application/xml"})
    public List<Setting> getAdminContent() {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        try {
            IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)UserConsoleService.getPentahoSession());
            List pluginIds = pluginManager.getRegisteredPlugins();
            block2: for (String pluginId : pluginIds) {
                String adminContentInfo = (String)pluginManager.getPluginSetting(pluginId, "admin-content-info", null);
                String exceptionMessage = (String)pluginManager.getPluginSetting(pluginId, "exception-message", null);
                if (adminContentInfo == null) continue;
                StringTokenizer nameValuePairs = new StringTokenizer(adminContentInfo, ";");
                while (nameValuePairs.hasMoreTokens()) {
                    String currentToken = nameValuePairs.nextToken().trim();
                    if (!currentToken.startsWith("conditional-logic-validator=")) continue;
                    String validatorName = currentToken.substring("conditional-logic-validator=".length());
                    Class<?> validatorClass = pluginManager.getClassLoader(pluginId).loadClass(validatorName);
                    IAdminContentConditionalLogic validator = (IAdminContentConditionalLogic)validatorClass.newInstance();
                    int status = validator.validate();
                    if (status == 0) {
                        settings.add(new Setting("admin-content-info", adminContentInfo));
                    }
                    if (status == 2 && exceptionMessage != null) {
                        settings.add(new Setting("exception-message", exceptionMessage));
                    }
                    if (status != 1) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return settings;
    }

    @GET
    @Path(value="/settings")
    @Produces(value={"application/json", "application/xml"})
    @Facet(name="Unsupported")
    public List<Setting> getMantleSettings() {
        IPluginManager pluginManager;
        ArrayList<Setting> settings = new ArrayList<Setting>();
        settings.add(new Setting("login-show-users-list", PentahoSystem.getSystemSetting((String)"login-show-users-list", (String)"")));
        settings.add(new Setting("documentation-url", PentahoSystem.getSystemSetting((String)"documentation-url", (String)"")));
        settings.add(new Setting("submit-on-enter-key", PentahoSystem.getSystemSetting((String)"submit-on-enter-key", (String)"true")));
        settings.add(new Setting("user-console-revision", PentahoSystem.getSystemSetting((String)"user-console-revision", (String)"")));
        settings.add(new Setting("startupPerspective", PentahoSystem.getSystemSetting((String)"startup-perspective", (String)"")));
        settings.add(new Setting("showOnlyPerspective", PentahoSystem.getSystemSetting((String)"show-only-perspective", (String)"")));
        int startupUrls = Integer.parseInt(PentahoSystem.getSystemSetting((String)"num-startup-urls", (String)"0"));
        settings.add(new Setting("num-startup-urls", PentahoSystem.getSystemSetting((String)"num-startup-urls", (String)"0")));
        for (int i = 1; i <= startupUrls; ++i) {
            settings.add(new Setting("startup-url-" + i, PentahoSystem.getSystemSetting((String)("startup-url-" + i), (String)"")));
            settings.add(new Setting("startup-name-" + i, PentahoSystem.getSystemSetting((String)("startup-name-" + i), (String)"")));
        }
        String overrideNewAnalysisViewCommmand = PentahoSystem.getSystemSetting((String)"new-analysis-view/command-url", null);
        String overrideNewAnalysisViewTitle = PentahoSystem.getSystemSetting((String)"new-analysis-view/command-title", null);
        if (overrideNewAnalysisViewCommmand != null && overrideNewAnalysisViewTitle != null) {
            settings.add(new Setting("new-analysis-view-command-url", overrideNewAnalysisViewCommmand));
            settings.add(new Setting("new-analysis-view-command-title", overrideNewAnalysisViewTitle));
        }
        String overrideNewReportCommmand = PentahoSystem.getSystemSetting((String)"new-report/command-url", null);
        String overrideNewReportTitle = PentahoSystem.getSystemSetting((String)"new-report/command-title", null);
        if (overrideNewReportCommmand != null && overrideNewReportTitle != null) {
            settings.add(new Setting("new-report-command-url", overrideNewReportCommmand));
            settings.add(new Setting("new-report-command-title", overrideNewReportTitle));
        }
        if ((pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)UserConsoleService.getPentahoSession())) != null) {
            int i = 0;
            for (String contentType : pluginManager.getContentTypes()) {
                IContentInfo info = pluginManager.getContentTypeInfo(contentType);
                if (info == null) continue;
                settings.add(new Setting("plugin-content-type-" + i, "." + contentType));
                settings.add(new Setting("plugin-content-type-icon-" + i, info.getIconUrl()));
                int j = 0;
                for (IPluginOperation operation : info.getOperations()) {
                    settings.add(new Setting("plugin-content-type-" + i + "-command-" + j, operation.getId()));
                    settings.add(new Setting("plugin-content-type-" + i + "-command-perspective-" + j, operation.getPerspective()));
                    ++j;
                }
                ++i;
            }
        }
        return settings;
    }

    @GET
    @Path(value="/cubes")
    @Facet(name="Unsupported")
    @Produces(value={"application/json", "application/xml"})
    public List<Cube> getMondrianCatalogs() {
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)UserConsoleService.getPentahoSession());
        List<MondrianCatalog> catalogs = catalogService.listCatalogs(UserConsoleService.getPentahoSession(), true);
        for (MondrianCatalog cat : catalogs) {
            for (MondrianCube cube : cat.getSchema().getCubes()) {
                cubes.add(new Cube(cat.getName(), cube.getName(), cube.getId()));
            }
        }
        return cubes;
    }

    @POST
    @Path(value="/locale")
    @Facet(name="Unsupported")
    public Response setLocaleOverride(String locale) {
        return new SystemResource().setLocaleOverride(locale);
    }

    @GET
    @Path(value="/locale")
    @Facet(name="Unsupported")
    public Response getLocale() {
        return new SystemResource().getLocale();
    }

    @POST
    @Path(value="/session-variable")
    @Facet(name="Unsupported")
    public Response setSessionVariable(@QueryParam(value="key") String key, @QueryParam(value="value") String value) {
        if (setSessionVarWhiteList.contains(key)) {
            IPentahoSession session = UserConsoleService.getPentahoSession();
            session.setAttribute(key, (Object)value);
            return Response.ok((Object)session.getAttribute(key)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="/session-variable")
    @Facet(name="Unsupported")
    public Response getSessionVariable(@QueryParam(value="key") String key) {
        if (getSessionVarWhiteList.contains(key)) {
            return Response.ok((Object)UserConsoleService.getPentahoSession().getAttribute(key)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @DELETE
    @Path(value="/session-variable")
    @Facet(name="Unsupported")
    public Response clearSessionVariable(@QueryParam(value="key") String key) {
        return Response.ok((Object)UserConsoleService.getPentahoSession().removeAttribute(key)).build();
    }

    @GET
    @Path(value="/registeredPlugins")
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns a list of registerd plugins as a list string")})
    @Facet(name="Unsupported")
    public Response registeredPlugins() {
        List<String> registeredPlugins = userConsoleService.getRegisteredPlugins();
        return this.buildOkResponse(registeredPlugins.toString());
    }

    protected Response buildOkResponse(Object entity) {
        return Response.ok((Object)entity).build();
    }

    static {
        isInitialized = false;
    }
}

