/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.operations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.pentaho.platform.web.http.api.resources.utils.RepositoryFileHelper;
import org.pentaho.platform.web.http.messages.Messages;

public class CopyFilesOperation {
    private RepositoryFile destDir;
    private List<String> sourceFileIds;
    private String path;
    private int mode;
    private IUnifiedRepository repository;
    private DefaultUnifiedRepositoryWebService defaultUnifiedRepositoryWebService;
    private static final Log logger = LogFactory.getLog(FileService.class);
    public static final Integer DEFAULT_DEEPNESS = 10;

    public CopyFilesOperation(List<String> sourceFileIds, String destDirPath, int overrideMode) {
        this((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class), new DefaultUnifiedRepositoryWebService(), sourceFileIds, destDirPath, overrideMode);
    }

    public CopyFilesOperation(IUnifiedRepository repository, DefaultUnifiedRepositoryWebService defaultUnifiedRepositoryWebService, List<String> sourceFileIds, String destDirPath, int overrideMode) {
        if (repository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.repository = repository;
        if (defaultUnifiedRepositoryWebService == null) {
            throw new IllegalArgumentException("defaultUnifiedRepositoryWebService  cannot be null");
        }
        this.defaultUnifiedRepositoryWebService = defaultUnifiedRepositoryWebService;
        if (sourceFileIds == null) {
            throw new IllegalArgumentException("sourceFileIds cannot be null");
        }
        if (sourceFileIds.isEmpty()) {
            throw new IllegalArgumentException("Nothing to copy, list of files shouldn't be empty");
        }
        this.sourceFileIds = sourceFileIds;
        if (destDirPath == null) {
            throw new IllegalArgumentException("destDirPath cannot be null");
        }
        this.destDir = this.getRepository().getFile(destDirPath);
        if (this.destDir == null) {
            throw new IllegalArgumentException("Directory with destPath: " + destDirPath + " doesn't exist");
        }
        if (!this.destDir.isFolder()) {
            throw new IllegalArgumentException(destDirPath + " should be a folder");
        }
        this.mode = overrideMode;
        this.path = destDirPath;
    }

    public void execute() {
        for (String sourceFileId : this.getSourceFileIds()) {
            RepositoryFile sourceFile = this.getRepository().getFileById((Serializable)((Object)sourceFileId));
            if (sourceFile == null) {
                logger.warn((Object)("File with id: " + sourceFileId + " is not found"));
                continue;
            }
            if (this.mode == FileService.MODE_OVERWRITE) {
                this.copyOverrideMode(sourceFile);
                continue;
            }
            if (this.mode == FileService.MODE_NO_OVERWRITE) {
                this.copyNoOverrideMode(sourceFile);
                continue;
            }
            this.copyRenameMode(sourceFile);
        }
    }

    private void copyOverrideMode(RepositoryFile file) {
        if (this.sourceAndDestDirAreSame(file.getPath())) {
            return;
        }
        RepositoryFileAcl acl = this.getRepository().getAcl(file.getId());
        RepositoryFile destFile = this.getRepository().getFile(this.destDir.getPath() + "/" + file.getName());
        if (destFile == null) {
            RepositoryFile duplicateFile = new RepositoryFile.Builder(file.getName()).hidden(file.isHidden()).versioned(file.isVersioned()).build();
            RepositoryFile repositoryFile = this.getRepository().createFile(this.destDir.getId(), duplicateFile, RepositoryFileHelper.getFileData(file), acl, null);
            this.getRepository().setFileMetadata(repositoryFile.getId(), this.getRepository().getFileMetadata(file.getId()));
            return;
        }
        RepositoryFileDto destFileDto = this.toFileDto(destFile, null, false);
        destFileDto.setHidden(file.isHidden());
        destFile = this.toFile(destFileDto);
        RepositoryFile repositoryFile = this.getRepository().updateFile(destFile, RepositoryFileHelper.getFileData(file), null);
        this.getRepository().updateAcl(acl);
        this.getRepository().setFileMetadata(repositoryFile.getId(), this.getRepository().getFileMetadata(file.getId()));
    }

    private void copyNoOverrideMode(RepositoryFile repoFile) {
        RepositoryFile repositoryFile;
        if (this.sourceAndDestDirAreSame(repoFile.getPath())) {
            return;
        }
        RepositoryFile destFile = this.getRepository().getFile(this.destDir.getPath() + "/" + repoFile.getName());
        if (destFile != null) {
            return;
        }
        if (repoFile.isFolder()) {
            RepositoryFile duplicateFile = repoFile.clone();
            repositoryFile = this.getRepository().createFolder(this.destDir.getId(), duplicateFile, this.getRepository().getAcl(repoFile.getId()), null);
            this.performFolderDeepCopy(repoFile, repositoryFile, DEFAULT_DEEPNESS);
        } else {
            RepositoryFile duplicateFile = new RepositoryFile.Builder(repoFile.getName()).hidden(repoFile.isHidden()).folder(repoFile.isFolder()).versioned(repoFile.isVersioned()).build();
            repositoryFile = this.getRepository().createFile(this.destDir.getId(), duplicateFile, RepositoryFileHelper.getFileData(repoFile), this.getRepository().getAcl(repoFile.getId()), null);
        }
        this.getRepository().setFileMetadata(repositoryFile.getId(), this.getRepository().getFileMetadata(repoFile.getId()));
    }

    private void copyRenameMode(RepositoryFile repoFile) {
        RepositoryFile repositoryFile;
        RepositoryFileDto testFile;
        String repoFileName = repoFile.getName();
        String copyText = "";
        String rootCopyText = "";
        String nameNoExtension = repoFileName;
        String extension = "";
        int indexOfDot = repoFileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            nameNoExtension = repoFileName.substring(0, indexOfDot);
            extension = repoFileName.substring(indexOfDot);
        }
        if ((testFile = this.getRepoWs().getFile(this.path + "/" + nameNoExtension + extension)) != null && !nameNoExtension.endsWith(Messages.getInstance().getString("FileResource.COPY_PREFIX"))) {
            copyText = rootCopyText = Messages.getInstance().getString("FileResource.COPY_PREFIX");
            repoFileName = nameNoExtension + copyText + extension;
            testFile = this.getRepoWs().getFile(this.path + "/" + repoFileName);
        }
        Integer nameCount = 1;
        while (testFile != null) {
            Integer n = nameCount;
            Integer n2 = nameCount = Integer.valueOf(nameCount + 1);
            copyText = rootCopyText + Messages.getInstance().getString("FileResource.DUPLICATE_INDICATOR", new Object[]{nameCount});
            repoFileName = nameNoExtension + copyText + extension;
            testFile = this.getRepoWs().getFile(this.path + "/" + repoFileName);
        }
        IRepositoryFileData data = RepositoryFileHelper.getFileData(repoFile);
        RepositoryFileAcl acl = this.getRepository().getAcl(repoFile.getId());
        RepositoryFile duplicateFile = null;
        if (repoFile.isFolder()) {
            duplicateFile = !repoFile.getName().equals(repoFile.getTitle()) ? new RepositoryFile.Builder(repoFileName).title("default", repoFile.getTitle() + copyText).hidden(repoFile.isHidden()).versioned(repoFile.isVersioned()).folder(true).build() : new RepositoryFile.Builder(repoFileName).hidden(repoFile.isHidden()).folder(true).build();
            repositoryFile = this.getRepository().createFolder(this.destDir.getId(), duplicateFile, acl, null);
            this.performFolderDeepCopy(repoFile, repositoryFile, DEFAULT_DEEPNESS);
        } else {
            duplicateFile = !repoFile.getName().equals(repoFile.getTitle()) ? new RepositoryFile.Builder(repoFileName).title("default", repoFile.getTitle() + copyText).hidden(repoFile.isHidden()).versioned(repoFile.isVersioned()).build() : new RepositoryFile.Builder(repoFileName).hidden(repoFile.isHidden()).build();
            repositoryFile = this.getRepository().createFile(this.destDir.getId(), duplicateFile, data, acl, null);
        }
        this.getRepository().setFileMetadata(repositoryFile.getId(), this.getRepository().getFileMetadata(repoFile.getId()));
    }

    private boolean sourceAndDestDirAreSame(String path) {
        String pathWithoutFileName = path.substring(0, path.lastIndexOf("/"));
        return pathWithoutFileName.equals(this.destDir.getPath());
    }

    protected void performFolderDeepCopy(RepositoryFile from, RepositoryFile to, Integer deepness) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Folder should not be null");
        }
        if (!from.isFolder()) {
            throw new IllegalArgumentException(from.getPath() + " is not a folder");
        }
        if (!to.isFolder()) {
            throw new IllegalArgumentException(to.getPath() + " is not a folder");
        }
        if (deepness == null || deepness < 0) {
            deepness = DEFAULT_DEEPNESS;
        }
        List children = this.getRepository().getChildren(this.createRepoRequest(from, deepness));
        for (RepositoryFile repoFile : children) {
            if (repoFile.isFolder()) {
                RepositoryFile childFolder = this.getRepository().createFolder(to.getId(), repoFile, this.getRepository().getAcl(repoFile.getId()), null);
                this.performFolderDeepCopy(repoFile, childFolder, deepness);
                continue;
            }
            this.getRepository().createFile(to.getId(), repoFile, RepositoryFileHelper.getFileData(repoFile), null);
        }
    }

    protected IUnifiedRepository getRepository() {
        if (this.repository == null) {
            this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        }
        return this.repository;
    }

    protected DefaultUnifiedRepositoryWebService getRepoWs() {
        if (this.defaultUnifiedRepositoryWebService == null) {
            this.defaultUnifiedRepositoryWebService = new DefaultUnifiedRepositoryWebService();
        }
        return this.defaultUnifiedRepositoryWebService;
    }

    public List<String> getSourceFileIds() {
        return new ArrayList<String>(this.sourceFileIds);
    }

    protected RepositoryRequest createRepoRequest(RepositoryFile repoFile, int deepness) {
        return new RepositoryRequest(String.valueOf(repoFile.getId()), Boolean.valueOf(true), Integer.valueOf(deepness), null);
    }

    protected RepositoryFileDto toFileDto(RepositoryFile repositoryFile, Set<String> memberSet, boolean exclude) {
        return RepositoryFileAdapter.toFileDto((RepositoryFile)repositoryFile, memberSet, (boolean)exclude);
    }

    protected RepositoryFile toFile(RepositoryFileDto repositoryFileDto) {
        return RepositoryFileAdapter.toFile((RepositoryFileDto)repositoryFileDto);
    }
}

