/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.web.servlet.UploadFileUtils;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class UploadFileServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 8305367618713715640L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            IPentahoSession session = PentahoSessionHolder.getSession();
            UploadFileUtils utils = new UploadFileUtils(session);
            response.setContentType("text/plain");
            Map standardRequestParameters = request.getParameterMap();
            Map<String, FileItem> parsedMultiPartRequestParameters = this.getParsedRequestParameters(request, session);
            FileItem uploadItem = parsedMultiPartRequestParameters.get("uploadFormElement");
            if (uploadItem == null) {
                String error = Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0001_NO_FILE_TO_UPLOAD");
                response.getWriter().write(error);
                return;
            }
            String unzip = this.getRequestParameter(standardRequestParameters, parsedMultiPartRequestParameters, "unzip");
            String temporary = this.getRequestParameter(standardRequestParameters, parsedMultiPartRequestParameters, "mark_temporary");
            String fileName = this.getRequestParameter(standardRequestParameters, parsedMultiPartRequestParameters, "file_name");
            if (StringUtils.isEmpty((String)fileName)) {
                fileName = UUIDUtil.getUUID().toString();
            }
            boolean isTemporary = false;
            if (temporary != null) {
                isTemporary = Boolean.valueOf(temporary);
            }
            boolean shouldUnzip = false;
            if (unzip != null) {
                shouldUnzip = Boolean.valueOf(unzip);
            }
            utils.setShouldUnzip(shouldUnzip);
            utils.setTemporary(isTemporary);
            utils.setFileName(fileName);
            utils.setWriter(response.getWriter());
            utils.setUploadedFileItem(uploadItem);
            boolean bl = utils.process();
        }
        catch (Exception e) {
            String error = Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0005_UNKNOWN_ERROR", new Object[]{e.getLocalizedMessage()});
            response.getWriter().write(error);
        }
    }

    protected String getRequestParameter(Map primary, Map secondary, String parameterName) {
        String rtn = this.getRequestParameter(primary, parameterName);
        return rtn != null ? rtn : this.getRequestParameter(secondary, parameterName);
    }

    protected String getRequestParameter(Map requestParameters, String parameterName) {
        Object obj = requestParameters.get(parameterName);
        if (obj != null) {
            if (obj instanceof FileItem) {
                return ((FileItem)obj).getString();
            }
            if (obj instanceof String[]) {
                String[] a = (String[])obj;
                if (a.length > 0) {
                    return a[0];
                }
            } else {
                return obj.toString();
            }
        }
        return null;
    }

    private Map<String, FileItem> getParsedRequestParameters(HttpServletRequest request, IPentahoSession session) {
        HashMap<String, FileItem> rtn = new HashMap<String, FileItem>();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                String fName = item.getFieldName();
                rtn.put(fName, item);
            }
        }
        catch (FileUploadException e) {
            return null;
        }
        return rtn;
    }
}

