/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.DefaultFileAccess;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.MiniSparkOnYARNCluster;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.shims.ZeroCopyShims;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.test.MiniTezCluster;

public class Hadoop23Shims
extends HadoopShimsSecure {
    HadoopShims.MiniDFSShim cluster = null;
    final boolean zeroCopy;
    final boolean storagePolicy;
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;
    protected static final Method accessMethod;
    protected static final Method getPasswordMethod;
    private static Boolean hdfsEncryptionSupport;

    public Hadoop23Shims() {
        boolean zcr = false;
        boolean storage = false;
        try {
            Class.forName("org.apache.hadoop.fs.CacheFlag", false, ShimLoader.class.getClassLoader());
            zcr = true;
        }
        catch (ClassNotFoundException ce) {
            // empty catch block
        }
        if (zcr) {
            try {
                Class.forName("org.apache.hadoop.hdfs.protocol.BlockStoragePolicy", false, ShimLoader.class.getClassLoader());
                storage = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.storagePolicy = storage;
        this.zeroCopy = zcr;
    }

    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new HadoopShimsSecure.CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }

            protected List<FileStatus> listStatus(org.apache.hadoop.mapreduce.JobContext job) throws IOException {
                List result = super.listStatus(job);
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    FileStatus stat = (FileStatus)it.next();
                    if (stat.isFile()) continue;
                    it.remove();
                }
                return result;
            }
        };
    }

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR1 mode.");
        return null;
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)conf.get("mapreduce.task.attempt.id"));
        if (taskAttemptId == null) {
            taskAttemptId = new TaskAttemptID();
        }
        return new TaskAttemptContextImpl(conf, taskAttemptId){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    public void startPauseMonitor(Configuration conf) {
        try {
            Class.forName("org.apache.hadoop.util.JvmPauseMonitor");
            JvmPauseMonitor pauseMonitor = new JvmPauseMonitor(conf);
            pauseMonitor.start();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
        }
    }

    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    protected boolean isExtendedAclEnabled(Configuration conf) {
        return Objects.equal((Object)conf.get("dfs.namenode.acls.enabled"), (Object)"true");
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public void refreshDefaultQueue(Configuration conf, String userName) throws IOException {
        if (StringUtils.isNotBlank((String)userName) && this.isFairScheduler(conf)) {
            ShimLoader.getSchedulerShims().refreshDefaultQueue(conf, userName);
        }
    }

    private boolean isFairScheduler(Configuration conf) {
        return "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler".equalsIgnoreCase(conf.get("yarn.resourcemanager.scheduler.class"));
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniTezShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    private void configureImpersonation(Configuration conf) {
        String user;
        try {
            user = Utils.getUGI().getShortUserName();
        }
        catch (Exception e) {
            String msg = "Cannot obtain username: " + e;
            throw new IllegalStateException(msg, e);
        }
        conf.set("hadoop.proxyuser." + user + ".groups", "*");
        conf.set("hadoop.proxyuser." + user + ".hosts", "*");
    }

    public MiniMrShim getMiniSparkCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniSparkShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this.configureImpersonation(conf);
        MiniDFSCluster miniDFSCluster = new MiniDFSCluster(conf, numDataNodes, format, racks);
        KeyProviderCryptoExtension keyProvider = miniDFSCluster.getNameNode().getNamesystem().getProvider();
        if (keyProvider != null) {
            try {
                Hadoop23Shims.setKeyProvider(miniDFSCluster.getFileSystem().getClient(), keyProvider);
            }
            catch (Exception err) {
                throw new IOException(err);
            }
        }
        this.cluster = new MiniDFSShim(miniDFSCluster);
        return this.cluster;
    }

    private static void setKeyProvider(DFSClient dfsClient, KeyProviderCryptoExtension provider) throws Exception {
        Method setKeyProviderHadoop27Method = null;
        try {
            setKeyProviderHadoop27Method = DFSClient.class.getMethod("setKeyProvider", KeyProvider.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (setKeyProviderHadoop27Method != null) {
            setKeyProviderHadoop27Method.invoke((Object)dfsClient, provider);
        } else {
            dfsClient.setKeyProvider((KeyProvider)provider);
        }
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        if (status instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)status).getBlockLocations();
        }
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem fs, FileStatus status) throws IOException {
        BlockLocation[] locations;
        TreeMap<Long, BlockLocation> offsetBlockMap = new TreeMap<Long, BlockLocation>();
        for (BlockLocation location : locations = this.getLocations(fs, status)) {
            offsetBlockMap.put(location.getOffset(), location);
        }
        return offsetBlockMap;
    }

    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.hflush();
    }

    public HadoopShims.HdfsFileStatus getFullFileStatus(Configuration conf, FileSystem fs, Path file) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(file);
        AclStatus aclStatus = null;
        if (this.isExtendedAclEnabled(conf)) {
            try {
                aclStatus = fs.getAclStatus(file);
            }
            catch (Exception e) {
                LOG.info((Object)("Skipping ACL inheritance: File system for path " + file + " " + "does not support ACLs but dfs.namenode.acls.enabled is set to true: " + e), (Throwable)e);
            }
        }
        return new Hadoop23FileStatus(fileStatus, aclStatus);
    }

    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, FileSystem fs, Path target) throws IOException {
        block9: {
            String group = sourceStatus.getFileStatus().getGroup();
            try {
                FsShell fsShell = new FsShell();
                fsShell.setConf(conf);
                this.run(fsShell, new String[]{"-chgrp", "-R", group, target.toString()});
                if (this.isExtendedAclEnabled(conf)) {
                    try {
                        AclStatus aclStatus = ((Hadoop23FileStatus)sourceStatus).getAclStatus();
                        if (aclStatus != null) {
                            List aclEntries = aclStatus.getEntries();
                            this.removeBaseAclEntries(aclEntries);
                            FsPermission sourcePerm = sourceStatus.getFileStatus().getPermission();
                            aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, sourcePerm.getUserAction()));
                            aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, sourcePerm.getGroupAction()));
                            aclEntries.add(this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, sourcePerm.getOtherAction()));
                            String aclEntry = Joiner.on((String)",").join((Iterable)aclStatus.getEntries());
                            this.run(fsShell, new String[]{"-setfacl", "-R", "--set", aclEntry, target.toString()});
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        LOG.info((Object)("Skipping ACL inheritance: File system for path " + target + " " + "does not support ACLs but dfs.namenode.acls.enabled is set to true: " + e), (Throwable)e);
                    }
                    break block9;
                }
                String permission = Integer.toString(sourceStatus.getFileStatus().getPermission().toShort(), 8);
                this.run(fsShell, new String[]{"-chmod", "-R", permission, target.toString()});
            }
            catch (Exception e) {
                throw new IOException("Unable to set permissions of " + target, e);
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                this.getFullFileStatus(conf, fs, target).debugLog();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private AclEntry newAclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    private void removeBaseAclEntries(List<AclEntry> entries) {
        Iterables.removeIf(entries, (Predicate)new Predicate<AclEntry>(){

            public boolean apply(AclEntry input) {
                return input.getName() == null;
            }
        });
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.defaultFS");
        ret.put("HADOOPMAPFILENAME", "mapreduce.map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapreduce.input.fileinputformat.inputdir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapreduce.input.fileinputformat.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapreduce.input.fileinputformat.split.maxsize");
        ret.put("MAPREDMINSPLITSIZE", "mapreduce.input.fileinputformat.split.minsize");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapreduce.input.fileinputformat.split.minsize.per.node");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapreduce.input.fileinputformat.split.minsize.per.rack");
        ret.put("HADOOPNUMREDUCERS", "mapreduce.job.reduces");
        ret.put("HADOOPJOBNAME", "mapreduce.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapreduce.reduce.speculative");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapreduce.job.committer.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        if (this.zeroCopy) {
            return ZeroCopyShims.getZeroCopyReader(in, pool);
        }
        return null;
    }

    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        if (this.zeroCopy) {
            return ZeroCopyShims.getDirectDecompressor(codec);
        }
        return null;
    }

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    public JobConf getJobConf(JobContext context) {
        return context.getJobConf();
    }

    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        return FileSystem.newInstance((URI)uri, (Configuration)conf);
    }

    public void getMergedCredentials(JobConf jobConf) throws IOException {
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    public void mergeCredentials(JobConf dest, JobConf src) throws IOException {
        dest.getCredentials().mergeAll(src.getCredentials());
    }

    public void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action) throws IOException, AccessControlException, Exception {
        try {
            if (accessMethod == null) {
                DefaultFileAccess.checkFileAccess((FileSystem)fs, (FileStatus)stat, (FsAction)action);
            } else {
                accessMethod.invoke((Object)fs, stat.getPath(), action);
            }
        }
        catch (Exception err) {
            throw Hadoop23Shims.wrapAccessException(err);
        }
    }

    private static Exception wrapAccessException(Exception err) {
        int maxDepth = 20;
        Throwable curErr = err;
        for (int idx = 0; curErr != null && idx < 20; curErr = curErr.getCause(), ++idx) {
            if (!(curErr instanceof org.apache.hadoop.security.AccessControlException) && !curErr.getClass().getName().equals("org.apache.hadoop.fs.permission.AccessControlException")) continue;
            AccessControlException newErr = new AccessControlException(curErr.getMessage());
            newErr.initCause(err);
            return newErr;
        }
        return err;
    }

    public String getPassword(Configuration conf, String name) throws IOException {
        if (getPasswordMethod == null) {
            return conf.get(name);
        }
        try {
            char[] pw = (char[])getPasswordMethod.invoke((Object)conf, name);
            if (pw == null) {
                return null;
            }
            return new String(pw);
        }
        catch (Exception err) {
            throw new IOException(err.getMessage(), err);
        }
    }

    public boolean supportStickyBit() {
        return true;
    }

    public boolean hasStickyBit(FsPermission permission) {
        return permission.getStickyBit();
    }

    public boolean supportTrashFeature() {
        return true;
    }

    public Path getCurrentTrashPath(Configuration conf, FileSystem fs) {
        TrashPolicy tp = TrashPolicy.getInstance((Configuration)conf, (FileSystem)fs, (Path)fs.getHomeDirectory());
        return tp.getCurrentTrashDir();
    }

    public KerberosNameShim getKerberosNameShim(String name) throws IOException {
        return new KerberosNameShim(name);
    }

    public boolean isDirectory(FileStatus fileStatus) {
        return fileStatus.isDirectory();
    }

    public HadoopShims.StoragePolicyShim getStoragePolicyShim(FileSystem fs) {
        if (!this.storagePolicy) {
            return null;
        }
        try {
            return new StoragePolicyShim((DistributedFileSystem)fs);
        }
        catch (ClassCastException ce) {
            return null;
        }
    }

    public boolean runDistCp(Path src, Path dst, Configuration conf) throws IOException {
        DistCpOptions options = new DistCpOptions(Collections.singletonList(src), dst);
        options.setSyncFolder(true);
        options.setSkipCRC(true);
        options.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        try {
            conf.setBoolean("mapred.mapper.new-api", true);
            DistCp distcp = new DistCp(conf, options);
            distcp.execute();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new IOException("Cannot execute DistCp process: " + e, e);
        }
        finally {
            conf.setBoolean("mapred.mapper.new-api", false);
        }
    }

    public static boolean isHdfsEncryptionSupported() {
        if (hdfsEncryptionSupport == null) {
            Method m = null;
            try {
                m = HdfsAdmin.class.getMethod("getEncryptionZoneForPath", Path.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            hdfsEncryptionSupport = m != null;
        }
        return hdfsEncryptionSupport;
    }

    public HadoopShims.HdfsEncryptionShim createHdfsEncryptionShim(FileSystem fs, Configuration conf) throws IOException {
        URI uri;
        if (Hadoop23Shims.isHdfsEncryptionSupported() && "hdfs".equals((uri = fs.getUri()).getScheme())) {
            return new HdfsEncryptionShim(uri, conf);
        }
        return new HadoopShims.NoopHdfsEncryptionShim();
    }

    public Path getPathWithoutSchemeAndAuthority(Path path) {
        return Path.getPathWithoutSchemeAndAuthority((Path)path);
    }

    public int readByteBuffer(FSDataInputStream file, ByteBuffer dest) throws IOException {
        int pos = dest.position();
        int result = file.read(dest);
        if (result > 0) {
            dest.position(pos + result);
        }
        return result;
    }

    public void addDelegationTokens(FileSystem fs, Credentials cred, String uname) throws IOException {
        fs.addDelegationTokens(uname, cred);
    }

    public void setHadoopCallerContext(String callerContext) {
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder(callerContext).build());
    }

    public void setHadoopQueryContext(String callerContext) {
        this.setHadoopCallerContext("HIVE_QUERY_ID:" + callerContext);
    }

    public void setHadoopSessionContext(String sessionId) {
        this.setHadoopCallerContext("HIVE_SSN_ID:" + sessionId);
    }

    public String getHadoopCallerContext() {
        if (CallerContext.getCurrent() == null) {
            return "";
        }
        return CallerContext.getCurrent().getContext();
    }

    static {
        Method m = null;
        try {
            m = FileSystem.class.getMethod("access", Path.class, FsAction.class);
        }
        catch (NoSuchMethodException err) {
            // empty catch block
        }
        accessMethod = m;
        try {
            m = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException err) {
            m = null;
        }
        getPasswordMethod = m;
    }

    public class HdfsEncryptionShim
    implements HadoopShims.HdfsEncryptionShim {
        private final String HDFS_SECURITY_DEFAULT_CIPHER = "AES/CTR/NoPadding";
        private HdfsAdmin hdfsAdmin = null;
        private KeyProvider keyProvider = null;
        private final Configuration conf;

        public HdfsEncryptionShim(URI uri, Configuration conf) throws IOException {
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            this.conf = conf;
            this.keyProvider = dfs.getClient().getKeyProvider();
            this.hdfsAdmin = new HdfsAdmin(uri, conf);
        }

        public boolean isPathEncrypted(Path path) throws IOException {
            Path fullPath = path.isAbsolute() ? path : path.getFileSystem(this.conf).makeQualified(path);
            if (!"hdfs".equalsIgnoreCase(path.toUri().getScheme())) {
                return false;
            }
            return this.hdfsAdmin.getEncryptionZoneForPath(fullPath) != null;
        }

        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2) throws IOException {
            EncryptionZone zone1 = this.hdfsAdmin.getEncryptionZoneForPath(path1);
            EncryptionZone zone2 = this.hdfsAdmin.getEncryptionZoneForPath(path2);
            if (zone1 == null && zone2 == null) {
                return true;
            }
            if (zone1 == null || zone2 == null) {
                return false;
            }
            return zone1.equals((Object)zone2);
        }

        public int comparePathKeyStrength(Path path1, Path path2) throws IOException {
            EncryptionZone zone1 = this.hdfsAdmin.getEncryptionZoneForPath(path1);
            EncryptionZone zone2 = this.hdfsAdmin.getEncryptionZoneForPath(path2);
            if (zone1 == null && zone2 == null) {
                return 0;
            }
            if (zone1 == null) {
                return -1;
            }
            if (zone2 == null) {
                return 1;
            }
            return this.compareKeyStrength(zone1.getKeyName(), zone2.getKeyName());
        }

        public void createEncryptionZone(Path path, String keyName) throws IOException {
            this.hdfsAdmin.createEncryptionZone(path, keyName);
        }

        public void createKey(String keyName, int bitLength) throws IOException, NoSuchAlgorithmException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) != null) {
                throw new IOException("key '" + keyName + "' already exists");
            }
            KeyProvider.Options options = new KeyProvider.Options(this.conf);
            options.setCipher("AES/CTR/NoPadding");
            options.setBitLength(bitLength);
            this.keyProvider.createKey(keyName, options);
            this.keyProvider.flush();
        }

        public void deleteKey(String keyName) throws IOException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) == null) {
                throw new IOException("key '" + keyName + "' does not exist.");
            }
            this.keyProvider.deleteKey(keyName);
            this.keyProvider.flush();
        }

        public List<String> getKeys() throws IOException {
            this.checkKeyProvider();
            return this.keyProvider.getKeys();
        }

        private void checkKeyProvider() throws IOException {
            if (this.keyProvider == null) {
                throw new IOException("HDFS security key provider is not configured on your server.");
            }
        }

        private int compareKeyStrength(String keyname1, String keyname2) throws IOException {
            if (this.keyProvider == null) {
                throw new IOException("HDFS security key provider is not configured on your server.");
            }
            KeyProvider.Metadata meta1 = this.keyProvider.getMetadata(keyname1);
            KeyProvider.Metadata meta2 = this.keyProvider.getMetadata(keyname2);
            if (meta1.getBitLength() < meta2.getBitLength()) {
                return -1;
            }
            if (meta1.getBitLength() == meta2.getBitLength()) {
                return 0;
            }
            return 1;
        }
    }

    public static class StoragePolicyShim
    implements HadoopShims.StoragePolicyShim {
        private final DistributedFileSystem dfs;

        public StoragePolicyShim(DistributedFileSystem fs) {
            this.dfs = fs;
        }

        public void setStoragePolicy(Path path, HadoopShims.StoragePolicyValue policy) throws IOException {
            switch (policy) {
                case MEMORY: {
                    this.dfs.setStoragePolicy(path, "LAZY_PERSIST");
                    break;
                }
                case SSD: {
                    this.dfs.setStoragePolicy(path, "ALL_SSD");
                    break;
                }
                case DEFAULT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown storage policy " + policy);
                }
            }
        }
    }

    public class KerberosNameShim
    implements HadoopShims.KerberosNameShim {
        private final KerberosName kerberosName;

        public KerberosNameShim(String name) {
            this.kerberosName = new KerberosName(name);
        }

        public String getDefaultRealm() {
            return this.kerberosName.getDefaultRealm();
        }

        public String getServiceName() {
            return this.kerberosName.getServiceName();
        }

        public String getHostName() {
            return this.kerberosName.getHostName();
        }

        public String getRealm() {
            return this.kerberosName.getRealm();
        }

        public String getShortName() throws IOException {
            return this.kerberosName.getShortName();
        }
    }

    class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs) {
            super(fs);
        }

        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private final RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }

        public void access(Path path, FsAction action) throws AccessControlException, FileNotFoundException, IOException {
            Path underlyingFsPath = this.swizzleParamPath(path);
            FileStatus underlyingFsStatus = this.fs.getFileStatus(underlyingFsPath);
            try {
                if (accessMethod != null) {
                    accessMethod.invoke((Object)this.fs, underlyingFsPath, action);
                } else {
                    DefaultFileAccess.checkFileAccess((FileSystem)this.fs, (FileStatus)underlyingFsStatus, (FsAction)action);
                }
            }
            catch (AccessControlException err) {
                throw err;
            }
            catch (FileNotFoundException err) {
                throw err;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Exception err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }
    }

    public class Hadoop23FileStatus
    implements HadoopShims.HdfsFileStatus {
        private final FileStatus fileStatus;
        private final AclStatus aclStatus;

        public Hadoop23FileStatus(FileStatus fileStatus, AclStatus aclStatus) {
            this.fileStatus = fileStatus;
            this.aclStatus = aclStatus;
        }

        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        public AclStatus getAclStatus() {
            return this.aclStatus;
        }

        public void debugLog() {
            if (this.fileStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.fileStatus.toString());
            }
            if (this.aclStatus != null) {
                HadoopShimsSecure.LOG.debug((Object)this.aclStatus.toString());
            }
        }
    }

    private final class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims23() {
        }

        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        public TaskAttemptID createTaskAttemptID() {
            return new TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, org.apache.hadoop.mapred.TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, org.apache.hadoop.mapred.TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            return new org.apache.hadoop.mapred.JobContextImpl(new JobConf((Configuration)conf), jobId, progressable);
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapreduce.job.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapreduce.job.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapreduce.job.cache.symlink.create";
                }
                case CLASSPATH_ARCHIVES: {
                    return "mapreduce.job.classpath.archives";
                }
                case CLASSPATH_FILES: {
                    return "mapreduce.job.classpath.files";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniSparkShim
    extends MiniMrShim {
        private final MiniSparkOnYARNCluster mr;
        private final Configuration conf;

        public MiniSparkShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniSparkOnYARNCluster("sparkOnYarn");
            conf.set("fs.defaultFS", nameNode);
            conf.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
            Hadoop23Shims.this.configureImpersonation(conf);
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            Path jarPath = new Path("hdfs:///user/hive");
            Path hdfsPath = new Path("hdfs:///user/");
            try {
                FileSystem fs = Hadoop23Shims.this.cluster.getFileSystem();
                jarPath = fs.makeQualified(jarPath);
                conf.set("hive.jar.directory", jarPath.toString());
                fs.mkdirs(jarPath);
                hdfsPath = fs.makeQualified(hdfsPath);
                conf.set("hive.user.install.directory", hdfsPath.toString());
                fs.mkdirs(hdfsPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class MiniTezShim
    extends MiniMrShim {
        private final MiniTezCluster mr;
        private final Configuration conf;

        public MiniTezShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniTezCluster("hive", numberOfTaskTrackers);
            conf.set("fs.defaultFS", nameNode);
            conf.set("tez.am.log.level", "DEBUG");
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            Path jarPath = new Path("hdfs:///user/hive");
            Path hdfsPath = new Path("hdfs:///user/");
            try {
                FileSystem fs = Hadoop23Shims.this.cluster.getFileSystem();
                jarPath = fs.makeQualified(jarPath);
                conf.set("hive.jar.directory", jarPath.toString());
                fs.mkdirs(jarPath);
                hdfsPath = fs.makeQualified(hdfsPath);
                conf.set("hive.user.install.directory", hdfsPath.toString());
                fs.mkdirs(hdfsPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim() {
            this.mr = null;
            this.conf = null;
        }

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

