/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPOStreamVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPOUserFuncVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

public class TezOperPlan
extends OperatorPlan<TezOperator> {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Path> extraResources = new HashMap<String, Path>();
    private int estimatedTotalParallelism = -1;
    private transient Credentials creds = new Credentials();

    public Credentials getCredentials() {
        return this.creds;
    }

    public int getEstimatedTotalParallelism() {
        return this.estimatedTotalParallelism;
    }

    public void setEstimatedParallelism(int estimatedTotalParallelism) {
        this.estimatedTotalParallelism = estimatedTotalParallelism;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TezPrinter printer = new TezPrinter(ps, this);
        printer.setVerbose(true);
        try {
            printer.visit();
        }
        catch (VisitorException e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }

    public void addExtraResource(URL url) throws IOException {
        Path resourcePath = new Path(url.getFile());
        String resourceName = resourcePath.getName();
        if (!this.extraResources.containsKey(resourceName)) {
            Path remoteFsPath;
            try {
                remoteFsPath = TezResourceManager.getInstance().addTezResource(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            this.extraResources.put(resourceName, remoteFsPath);
        }
    }

    public void addExtraResource(String resourceName, Path remoteFsPath) throws IOException {
        if (!this.extraResources.containsKey(resourceName)) {
            TezResourceManager.getInstance().addTezResource(resourceName, remoteFsPath);
            this.extraResources.put(resourceName, remoteFsPath);
        }
    }

    public Map<String, LocalResource> getExtraResources() throws Exception {
        TezPOStreamVisitor streamVisitor = new TezPOStreamVisitor(this);
        streamVisitor.visit();
        this.addShipResources(streamVisitor.getShipFiles());
        this.addCacheResources(streamVisitor.getCacheFiles());
        TezPOUserFuncVisitor udfVisitor = new TezPOUserFuncVisitor(this);
        udfVisitor.visit();
        this.addShipResources(udfVisitor.getShipFiles());
        this.addCacheResources(udfVisitor.getCacheFiles());
        return TezResourceManager.getInstance().getTezResources(this.extraResources.keySet());
    }

    private void addShipResources(Set<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            if ((fileName = fileName.trim()).length() <= 0) continue;
            URL url = new File(fileName).toURI().toURL();
            this.addExtraResource(url);
        }
    }

    private void addCacheResources(Set<String> fileNames) throws Exception {
        for (String fileName : fileNames) {
            if ((fileName = fileName.trim()).length() <= 0) continue;
            URI resourceURI = new URI(fileName);
            String fragment = resourceURI.getFragment();
            Path remoteFsPath = new Path(resourceURI.getPath());
            String resourceName = fragment != null && fragment.length() > 0 ? fragment : remoteFsPath.getName();
            this.addExtraResource(resourceName, remoteFsPath);
        }
    }

    @Override
    public void remove(TezOperator op) {
        for (OperatorKey opKey : op.outEdges.keySet()) {
            ((TezOperator)this.getOperator((OperatorKey)opKey)).inEdges.remove(op.getOperatorKey());
        }
        for (OperatorKey opKey : op.inEdges.keySet()) {
            ((TezOperator)this.getOperator((OperatorKey)opKey)).outEdges.remove(op.getOperatorKey());
        }
        super.remove(op);
    }

    @Override
    public boolean disconnect(TezOperator from, TezOperator to) {
        from.outEdges.remove(to.getOperatorKey());
        to.inEdges.remove(from.getOperatorKey());
        return super.disconnect(from, to);
    }

    public void moveTree(TezOperator root, TezOperPlan newPlan) throws PlanException {
        ArrayList<TezOperator> list = new ArrayList<TezOperator>();
        list.add(root);
        int prevSize = 0;
        int pos = 0;
        while (list.size() > prevSize) {
            prevSize = list.size();
            TezOperator node = (TezOperator)list.get(pos);
            if (this.getSuccessors(node) != null) {
                for (TezOperator tezOperator : this.getSuccessors(node)) {
                    if (list.contains(tezOperator)) continue;
                    list.add(tezOperator);
                }
            }
            if (this.getPredecessors(node) != null) {
                for (TezOperator tezOperator : this.getPredecessors(node)) {
                    if (list.contains(tezOperator)) continue;
                    list.add(tezOperator);
                }
            }
            ++pos;
        }
        for (TezOperator node : list) {
            newPlan.add(node);
        }
        HashSet<Pair<TezOperator, TezOperator>> toReconnect = new HashSet<Pair<TezOperator, TezOperator>>();
        for (TezOperator tezOperator : this.mFromEdges.keySet()) {
            List tos = this.mFromEdges.get(tezOperator);
            for (TezOperator to : tos) {
                if (!list.contains(tezOperator) && !list.contains(to)) continue;
                toReconnect.add(new Pair<TezOperator, TezOperator>(tezOperator, to));
            }
        }
        for (Pair pair : toReconnect) {
            if (!list.contains(pair.first) || !list.contains(pair.second)) continue;
            TezEdgeDescriptor edge = ((TezOperator)pair.second).inEdges.get(((TezOperator)pair.first).getOperatorKey());
            TezCompilerUtil.connectNoLRReconnect(newPlan, (TezOperator)pair.first, (TezOperator)pair.second, edge);
        }
        for (TezOperator tezOperator : list) {
            super.remove(tezOperator);
        }
    }

    public static List<TezOperator> getGrandParentsForGraceParallelism(TezOperPlan tezPlan, TezOperator op) {
        ArrayList<TezOperator> grandParents = new ArrayList<TezOperator>();
        List<TezOperator> preds = tezPlan.getPredecessors(op);
        if (preds != null) {
            for (TezOperator pred : preds) {
                if (pred.isVertexGroup()) {
                    grandParents.clear();
                    return grandParents;
                }
                List<TezOperator> predPreds = tezPlan.getPredecessors(pred);
                if (predPreds != null) {
                    for (TezOperator predPred : predPreds) {
                        if (predPred.isVertexGroup()) {
                            grandParents.clear();
                            return grandParents;
                        }
                        if (grandParents.contains(predPred)) continue;
                        grandParents.add(predPred);
                    }
                    continue;
                }
                grandParents.clear();
                break;
            }
            if (!grandParents.isEmpty()) {
                for (TezOperator pred : preds) {
                    if (!grandParents.contains(pred)) continue;
                    grandParents.remove(pred);
                }
            }
        }
        return grandParents;
    }
}

