/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POSimpleTezLoad
extends POLoad
implements TezInput {
    private static final long serialVersionUID = 1L;
    private String inputKey;
    private MRInput input;
    private KeyValueReader reader;
    private transient Configuration conf;
    private transient boolean finished = false;

    public POSimpleTezLoad(OperatorKey k, FileSpec lfile) {
        super(k, lfile);
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        LogicalInput logInput = inputs.get(this.inputKey);
        if (logInput == null || !(logInput instanceof MRInput)) {
            throw new ExecException("POSimpleTezLoad only accepts MRInputs");
        }
        this.input = (MRInput)logInput;
        try {
            this.reader = this.input.getReader();
            if (this.reader instanceof MRReader) {
                int splitIndex = ((PigSplit)((Object)((MRReader)this.reader).getSplit())).getSplitIndex();
                PigMapReduce.sJobContext.getConfiguration().setInt("pig.split.index", splitIndex);
            }
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            Result res = new Result();
            if (!this.reader.next()) {
                res.result = null;
                res.returnStatus = (byte)3;
                if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                    this.parentPlan.endOfAllInput = true;
                }
                this.finished = true;
            } else {
                Tuple next = (Tuple)this.reader.getCurrentValue();
                res.result = next;
                res.returnStatus = 0;
            }
            return res;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }
}

