/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;

@InterfaceAudience.Private
public class MRToTezHelper {
    private static final Log LOG = LogFactory.getLog(MRToTezHelper.class);
    private static final String JOB_SPLIT_RESOURCE_NAME = "job.split";
    private static final String JOB_SPLIT_METAINFO_RESOURCE_NAME = "job.splitmetainfo";
    private static List<String> mrSettingsToRetain = new ArrayList<String>();
    private static List<String> mrSettingsToRemove = new ArrayList<String>();

    private MRToTezHelper() {
    }

    private static void populateMRSettingsToRetain() {
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.inputdir");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.split.maxsize");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.split.minsize");
        mrSettingsToRetain.add("mapreduce.input.pathFilter.class");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.numinputfiles");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.input.dir.recursive");
        mrSettingsToRetain.add("mapreduce.output.basename");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress.codec");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress.type");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.outputdir");
        mrSettingsToRetain.add("mapreduce.fileoutputcommitter.marksuccessfuljobs");
    }

    private static void populateMRSettingsToRemove() {
        mrSettingsToRemove.add("mapreduce.job.credentials.binary");
    }

    private static void removeUnwantedMRSettings(Configuration tezConf) {
        Iterator iter = tezConf.iterator();
        block0: while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            for (String mrSetting : mrSettingsToRemove) {
                if (!((String)next.getKey()).equals(mrSetting)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    public static TezConfiguration getDAGAMConfFromMRConf(Configuration tezConf) {
        TezConfiguration dagAMConf = new TezConfiguration(tezConf);
        Map mrParamToDAGParamMap = DeprecatedKeys.getMRToDAGParamMap();
        for (Map.Entry entry : mrParamToDAGParamMap.entrySet()) {
            if (dagAMConf.get((String)entry.getKey()) == null) continue;
            dagAMConf.setIfUnset((String)entry.getValue(), dagAMConf.get((String)entry.getKey()));
            dagAMConf.unset((String)entry.getKey());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("MR->DAG Translating MR key: " + (String)entry.getKey() + " to Tez key: " + (String)entry.getValue() + " with value " + dagAMConf.get((String)entry.getValue())));
        }
        String env = tezConf.get("yarn.app.mapreduce.am.admin.user.env");
        if (tezConf.get("yarn.app.mapreduce.am.env") != null) {
            String string = env = env == null ? tezConf.get("yarn.app.mapreduce.am.env") : env + "," + tezConf.get("yarn.app.mapreduce.am.env");
        }
        if (env != null) {
            dagAMConf.setIfUnset("tez.am.launch.env", env);
        }
        dagAMConf.setIfUnset("tez.am.launch.cmd-opts", MRHelpers.getJavaOptsForMRAM((Configuration)tezConf));
        String queueName = tezConf.get("mapreduce.job.queuename", "default");
        dagAMConf.setIfUnset("tez.queue.name", queueName);
        int amMemMB = tezConf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        int amCores = tezConf.getInt("yarn.app.mapreduce.am.resource.cpu-vcores", 1);
        dagAMConf.setIfUnset("tez.am.resource.memory.mb", "" + amMemMB);
        dagAMConf.setIfUnset("tez.am.resource.cpu.vcores", "" + amCores);
        dagAMConf.setIfUnset("tez.am.view-acls", tezConf.get("mapreduce.job.acl-view-job", " "));
        dagAMConf.setIfUnset("tez.am.modify-acls", tezConf.get("mapreduce.job.acl-modify-job", " "));
        dagAMConf.setIfUnset("tez.am.max.app.attempts", "" + dagAMConf.getInt("mapreduce.am.max-attempts", 2));
        if (tezConf.get("mapreduce.job.credentials.binary") != null) {
            dagAMConf.setIfUnset("tez.credentials.path", tezConf.get("mapreduce.job.credentials.binary"));
        }
        if (tezConf.get("mapreduce.job.complete.cancel.delegation.tokens") != null) {
            dagAMConf.setIfUnset("tez.cancel.delegation.tokens.on.completion", tezConf.get("mapreduce.job.complete.cancel.delegation.tokens"));
        }
        MRToTezHelper.removeUnwantedMRSettings((Configuration)dagAMConf);
        return dagAMConf;
    }

    public static void processMRSettings(Configuration conf, Configuration mrConf) {
        for (String mrSetting : mrSettingsToRetain) {
            if (mrConf.get(mrSetting) == null) continue;
            conf.set(mrSetting, mrConf.get(mrSetting));
        }
        JobControlCompiler.configureCompression(conf);
        MRToTezHelper.convertMRToTezRuntimeConf(conf, mrConf);
        MRToTezHelper.removeUnwantedMRSettings(conf);
    }

    private static void convertMRToTezRuntimeConf(Configuration conf, Configuration mrConf) {
        for (Map.Entry dep : DeprecatedKeys.getMRToTezRuntimeParamMap().entrySet()) {
            if (mrConf.get((String)dep.getKey()) == null) continue;
            conf.unset((String)dep.getKey());
            LOG.info((Object)("Setting " + (String)dep.getValue() + " to " + mrConf.get((String)dep.getKey()) + " from MR setting " + (String)dep.getKey()));
            conf.setIfUnset((String)dep.getValue(), mrConf.get((String)dep.getKey()));
        }
    }

    public static InputSplitInfoDisk writeInputSplitInfoToDisk(InputSplitInfoMem infoMem, Path inputSplitsDir, JobConf jobConf, FileSystem fs) throws IOException, InterruptedException {
        InputSplit[] splits = infoMem.getNewFormatSplits();
        JobSplitWriter.createSplitFiles((Path)inputSplitsDir, (Configuration)jobConf, (FileSystem)fs, (InputSplit[])splits);
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitsDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitsDir), splits.length, infoMem.getTaskLocationHints(), jobConf.getCredentials());
    }

    public static void updateLocalResourcesForInputSplits(FileSystem fs, InputSplitInfo inputSplitInfo, Map<String, LocalResource> localResources) throws IOException {
        if (localResources.containsKey(JOB_SPLIT_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.split");
        }
        if (localResources.containsKey(JOB_SPLIT_METAINFO_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.splitmetainfo");
        }
        FileStatus splitFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsFile());
        FileStatus metaInfoFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsMetaInfoFile());
        localResources.put(JOB_SPLIT_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)splitFileStatus.getLen(), (long)splitFileStatus.getModificationTime()));
        localResources.put(JOB_SPLIT_METAINFO_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsMetaInfoFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)metaInfoFileStatus.getLen(), (long)metaInfoFileStatus.getModificationTime()));
    }

    static {
        MRToTezHelper.populateMRSettingsToRetain();
        MRToTezHelper.populateMRSettingsToRemove();
    }
}

