/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class NodeIdGenerator {
    private Map<String, Long> scopeToIdMap = new HashMap<String, Long>();
    private static NodeIdGenerator theGenerator = new NodeIdGenerator();

    private NodeIdGenerator() {
    }

    public static NodeIdGenerator getGenerator() {
        return theGenerator;
    }

    public long getNextNodeId(String scope) {
        Long val = this.scopeToIdMap.get(scope);
        long nextId = 0L;
        if (val != null) {
            nextId = val;
        }
        this.scopeToIdMap.put(scope, nextId + 1L);
        return nextId;
    }

    @VisibleForTesting
    public static void reset(String scope) {
        NodeIdGenerator.theGenerator.scopeToIdMap.put(scope, 0L);
    }

    @VisibleForTesting
    public static void reset() {
        NodeIdGenerator.theGenerator.scopeToIdMap.clear();
    }
}

