/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.List;
import org.apache.pig.Expression;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.FilterExtractor;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UnaryExpression;

public class PredicatePushDownFilterExtractor
extends FilterExtractor {
    private List<String> predicateCols;
    private List<Expression.OpType> supportedOpTypes;

    public PredicatePushDownFilterExtractor(LogicalExpressionPlan plan, List<String> predicateCols, List<Expression.OpType> supportedOpTypes) {
        super(plan);
        this.predicateCols = predicateCols;
        this.supportedOpTypes = supportedOpTypes;
    }

    @Override
    public void visit() throws FrontendException {
        super.visit();
        if (this.supportedOpTypes.contains((Object)Expression.OpType.OP_BETWEEN) || this.supportedOpTypes.contains((Object)Expression.OpType.OP_IN)) {
            // empty if block
        }
    }

    @Override
    protected FilterExtractor.KeyState checkPushDown(ProjectExpression project) throws FrontendException {
        String fieldName = project.getFieldSchema().alias;
        FilterExtractor.KeyState state = new FilterExtractor.KeyState();
        if (this.predicateCols.contains(fieldName)) {
            state.filterExpr = null;
            state.pushdownExpr = project;
        } else {
            state.filterExpr = this.addToFilterPlan(project);
            state.pushdownExpr = null;
        }
        return state;
    }

    @Override
    protected boolean isSupportedOpType(BinaryExpression binOp) {
        if (binOp instanceof AddExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_PLUS);
        }
        if (binOp instanceof SubtractExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_MINUS);
        }
        if (binOp instanceof MultiplyExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_TIMES);
        }
        if (binOp instanceof DivideExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_DIV);
        }
        if (binOp instanceof ModExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_MOD);
        }
        if (binOp instanceof AndExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_AND);
        }
        if (binOp instanceof OrExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_OR);
        }
        if (binOp instanceof EqualExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_EQ);
        }
        if (binOp instanceof NotEqualExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_NE);
        }
        if (binOp instanceof GreaterThanExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_GT);
        }
        if (binOp instanceof GreaterThanEqualExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_GE);
        }
        if (binOp instanceof LessThanExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_LT);
        }
        if (binOp instanceof LessThanEqualExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_LE);
        }
        if (binOp instanceof RegexExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_MATCH);
        }
        return false;
    }

    @Override
    protected boolean isSupportedOpType(UnaryExpression unaryOp) {
        if (unaryOp instanceof CastExpression) {
            return true;
        }
        if (unaryOp instanceof IsNullExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_NULL);
        }
        if (unaryOp instanceof NotExpression) {
            return this.supportedOpTypes.contains((Object)Expression.OpType.OP_NOT);
        }
        return false;
    }
}

