/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.js;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.js.JsFunction;
import org.apache.pig.tools.pigstats.PigStats;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;

public class JsScriptEngine
extends ScriptEngine {
    private static final Log LOG = LogFactory.getLog(JsScriptEngine.class);
    private static JsScriptEngine clientInstance;
    private ThreadLocal<Context> cx = new ThreadLocal();
    private Scriptable scope;
    private String scriptPath;
    private static final String printSource = "function print(str) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }\n    java.lang.System.out.print(String(str));\n}\nfunction println(str) {                       \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }\n    java.lang.System.out.println(String(str));\n}";

    public static JsScriptEngine getInstance() {
        JsScriptEngine instance = Holder.instance;
        UDFContext.getUDFContext().getUDFProperties(JsFunction.class).put(JsScriptEngine.class.getName() + ".scriptFile", instance.scriptPath);
        return instance;
    }

    private Context getContext() {
        Context context = this.cx.get();
        if (context == null) {
            context = Context.enter();
            this.cx.set(context);
        }
        return context;
    }

    public Object jsEval(String name, String script) {
        try {
            return this.getContext().evaluateString(this.scope, script, name, 1, null);
        }
        catch (EcmaError e) {
            throw new RuntimeException("can't evaluate " + name + ": " + script, e);
        }
    }

    public Object jsEval(String name, Reader scriptReader) {
        try {
            return this.getContext().evaluateReader(this.scope, scriptReader, name, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void jsPut(String name, Object value) {
        this.scope.put(name, this.scope, value);
    }

    public Object jsCall(String functionName, Object[] passedParams) {
        Function f = (Function)this.scope.get(functionName, this.scope);
        Object result = f.call(this.getContext(), this.scope, this.scope, passedParams);
        return result;
    }

    Scriptable getScope() {
        return this.scope;
    }

    public Scriptable jsNewObject() {
        return this.getContext().newObject(this.scope);
    }

    public Scriptable jsNewArray(long size) {
        return this.getContext().newArray(this.scope, (int)size);
    }

    public JsScriptEngine() {
        Context context = this.getContext();
        this.scope = new ImporterTopLevel(context);
        context.evaluateString(this.scope, printSource, "print", 1, null);
    }

    protected Object eval(String expr) {
        return this.jsEval(expr, "new String(" + expr + ")");
    }

    protected void load(String name, InputStream script) {
        this.jsEval(name, new InputStreamReader(script));
    }

    @Override
    protected Map<String, List<PigStats>> main(PigContext pigContext, String scriptFile) throws IOException {
        File f = new File(scriptFile);
        if (!f.canRead()) {
            throw new IOException("Can't read file: " + scriptFile);
        }
        this.registerFunctions(scriptFile, null, pigContext);
        this.jsEval("main", "main();");
        return this.getPigStatsMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        Object[] ids;
        this.scriptPath = path;
        clientInstance = this;
        pigContext.addScriptJar(JsScriptEngine.getJarPath(Context.class));
        namespace = namespace == null ? "" : namespace + ".";
        FileInputStream fis = new FileInputStream(path);
        try {
            this.load(path, fis);
        }
        finally {
            fis.close();
        }
        for (Object id : ids = this.scope.getIds()) {
            String name;
            Object value;
            if (!(id instanceof String) || !((value = this.scope.get(name = (String)id, this.scope)) instanceof Function) || name.equals("print") || name.equals("println")) continue;
            FuncSpec funcspec = new FuncSpec(JsFunction.class.getCanonicalName() + "('" + name + "')");
            LOG.info((Object)("Register scripting UDF: " + name));
            pigContext.registerFunction(namespace + name, funcspec);
        }
        pigContext.addScriptFile(path);
    }

    @Override
    protected Map<String, Object> getParamsFromVariables() throws IOException {
        Object[] ids;
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Object id : ids = this.scope.getIds()) {
            String name;
            Object value;
            if (!(id instanceof String) || (value = this.scope.get(name = (String)id, this.scope)) instanceof NativeFunction) continue;
            LOG.debug((Object)("Registering parameter " + name + " => " + this.scope.get(name, this.scope)));
            params.put(name, this.eval(name).toString());
        }
        return params;
    }

    @Override
    protected String getScriptingLang() {
        return "javascript";
    }

    private static final class Holder {
        static JsScriptEngine instance;

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            if (clientInstance != null) {
                instance = clientInstance;
            } else {
                instance = new JsScriptEngine();
                String scriptPath = (String)UDFContext.getUDFContext().getUDFProperties(JsFunction.class).get(JsScriptEngine.class.getName() + ".scriptFile");
                instance.scriptPath = scriptPath;
                if (scriptPath == null) {
                    throw new IllegalStateException("could not get script path from UDFContext");
                }
                InputStream is = ScriptEngine.getScriptAsStream(scriptPath);
                try {
                    instance.load(scriptPath, is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Could not close stream for file " + scriptPath), (Throwable)e);
                    }
                }
            }
        }
    }
}

