/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NullNode;

public class TypeInfoToSchema {
    private long recordCounter = 0L;

    public Schema convert(List<String> columnNames, List<TypeInfo> columnTypes, List<String> columnComments, String namespace, String name, String doc) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (int i = 0; i < columnNames.size(); ++i) {
            String comment = columnComments.size() > i ? columnComments.get(i) : null;
            Schema.Field avroField = this.createAvroField(columnNames.get(i), columnTypes.get(i), comment);
            fields.addAll(this.getFields(avroField));
        }
        if (name == null || name.isEmpty()) {
            name = "baseRecord";
        }
        Schema avroSchema = Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)false);
        avroSchema.setFields(fields);
        return avroSchema;
    }

    private Schema.Field createAvroField(String name, TypeInfo typeInfo, String comment) {
        return new Schema.Field(name, this.createAvroSchema(typeInfo), comment, null);
    }

    private Schema createAvroSchema(TypeInfo typeInfo) {
        Schema schema = null;
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                schema = this.createAvroPrimitive(typeInfo);
                break;
            }
            case LIST: {
                schema = this.createAvroArray(typeInfo);
                break;
            }
            case MAP: {
                schema = this.createAvroMap(typeInfo);
                break;
            }
            case STRUCT: {
                schema = this.createAvroRecord(typeInfo);
                break;
            }
            case UNION: {
                schema = this.createAvroUnion(typeInfo);
            }
        }
        return this.wrapInUnionWithNull(schema);
    }

    private Schema createAvroPrimitive(TypeInfo typeInfo) {
        Schema schema;
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case STRING: {
                schema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case CHAR: {
                schema = AvroSerdeUtils.getSchemaFor("{\"type\":\"string\",\"logicalType\":\"char\",\"maxLength\":" + ((CharTypeInfo)typeInfo).getLength() + "}");
                break;
            }
            case VARCHAR: {
                schema = AvroSerdeUtils.getSchemaFor("{\"type\":\"string\",\"logicalType\":\"varchar\",\"maxLength\":" + ((VarcharTypeInfo)typeInfo).getLength() + "}");
                break;
            }
            case BINARY: {
                schema = Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case BYTE: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case SHORT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case INT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case LONG: {
                schema = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case FLOAT: {
                schema = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case DOUBLE: {
                schema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case BOOLEAN: {
                schema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                String precision = String.valueOf(decimalTypeInfo.precision());
                String scale = String.valueOf(decimalTypeInfo.scale());
                schema = AvroSerdeUtils.getSchemaFor("{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":" + precision + "," + "\"scale\":" + scale + "}");
                break;
            }
            case DATE: {
                schema = AvroSerdeUtils.getSchemaFor("{\"type\":\"int\",\"logicalType\":\"date\"}");
                break;
            }
            case VOID: {
                schema = Schema.create((Schema.Type)Schema.Type.NULL);
                break;
            }
            default: {
                throw new UnsupportedOperationException(typeInfo + " is not supported.");
            }
        }
        return schema;
    }

    private Schema createAvroUnion(TypeInfo typeInfo) {
        ArrayList<Schema> childSchemas = new ArrayList<Schema>();
        for (TypeInfo childTypeInfo : ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos()) {
            Schema childSchema = this.createAvroSchema(childTypeInfo);
            if (childSchema.getType() == Schema.Type.UNION) {
                childSchemas.addAll(childSchema.getTypes());
                continue;
            }
            childSchemas.add(childSchema);
        }
        return Schema.createUnion(this.removeDuplicateNullSchemas(childSchemas));
    }

    private Schema createAvroRecord(TypeInfo typeInfo) {
        ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
        ArrayList<String> allStructFieldNames = ((StructTypeInfo)typeInfo).getAllStructFieldNames();
        ArrayList<TypeInfo> allStructFieldTypeInfos = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos();
        if (allStructFieldNames.size() != allStructFieldTypeInfos.size()) {
            throw new IllegalArgumentException("Failed to generate avro schema from hive schema. name and column type differs. names = " + allStructFieldNames + ", types = " + allStructFieldTypeInfos);
        }
        for (int i = 0; i < allStructFieldNames.size(); ++i) {
            TypeInfo childTypeInfo = (TypeInfo)allStructFieldTypeInfos.get(i);
            Schema.Field grandChildSchemaField = this.createAvroField((String)allStructFieldNames.get(i), childTypeInfo, childTypeInfo.toString());
            List<Schema.Field> grandChildFields = this.getFields(grandChildSchemaField);
            childFields.addAll(grandChildFields);
        }
        Schema recordSchema = Schema.createRecord((String)("record_" + this.recordCounter), (String)typeInfo.toString(), null, (boolean)false);
        ++this.recordCounter;
        recordSchema.setFields(childFields);
        return recordSchema;
    }

    private Schema createAvroMap(TypeInfo typeInfo) {
        TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
        if (((PrimitiveTypeInfo)keyTypeInfo).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UnsupportedOperationException("Key of Map can only be a String");
        }
        TypeInfo valueTypeInfo = ((MapTypeInfo)typeInfo).getMapValueTypeInfo();
        Schema valueSchema = this.createAvroSchema(valueTypeInfo);
        return Schema.createMap((Schema)valueSchema);
    }

    private Schema createAvroArray(TypeInfo typeInfo) {
        ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
        Schema listSchema = this.createAvroSchema(listTypeInfo.getListElementTypeInfo());
        return Schema.createArray((Schema)listSchema);
    }

    private List<Schema.Field> getFields(Schema.Field schemaField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        NullNode nullDefault = JsonNodeFactory.instance.nullNode();
        if (schemaField.schema().getType() == Schema.Type.RECORD) {
            for (Schema.Field field : schemaField.schema().getFields()) {
                fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), (JsonNode)nullDefault));
            }
        } else {
            fields.add(new Schema.Field(schemaField.name(), schemaField.schema(), schemaField.doc(), (JsonNode)nullDefault));
        }
        return fields;
    }

    private Schema wrapInUnionWithNull(Schema schema) {
        Schema wrappedSchema = schema;
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case UNION: {
                List<Schema> existingSchemas = this.removeDuplicateNullSchemas(schema.getTypes());
                wrappedSchema = Schema.createUnion(existingSchemas);
                break;
            }
            default: {
                wrappedSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
            }
        }
        return wrappedSchema;
    }

    private List<Schema> removeDuplicateNullSchemas(List<Schema> childSchemas) {
        ArrayList<Schema> prunedSchemas = new ArrayList<Schema>();
        boolean isNullPresent = false;
        for (Schema schema : childSchemas) {
            if (schema.getType() == Schema.Type.NULL) {
                isNullPresent = true;
                continue;
            }
            prunedSchemas.add(schema);
        }
        if (isNullPresent) {
            prunedSchemas.add(0, Schema.create((Schema.Type)Schema.Type.NULL));
        }
        return prunedSchemas;
    }
}

