/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.url.UrlFileName;

public class S3FileName
extends UrlFileName {
    private static final char[] USERNAME_RESERVED = new char[]{':', '@', '/'};
    private static final char[] PASSWORD_RESERVED = new char[]{'@', '/', '?', '+'};

    public S3FileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type, queryString);
    }

    public String getFriendlyURI() {
        return super.getFriendlyURI();
    }

    public FileName createName(String absPath, FileType type) {
        return new S3FileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), absPath, type, this.getQueryString());
    }

    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        if (addPassword) {
            this.appendCredentials(buffer, addPassword);
        }
        buffer.append(this.getHostName());
        if (this.getPort() != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.getPort());
        }
    }

    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        String userName = this.getUserName();
        String password = this.getPassword();
        if (addPassword && userName != null && userName.length() != 0) {
            try {
                userName = URLEncoder.encode(this.getUserName(), "UTF-8");
                buffer.append(userName);
            }
            catch (UnsupportedEncodingException e) {
                UriParser.appendEncoded((StringBuilder)buffer, (String)userName, (char[])USERNAME_RESERVED);
            }
            if (password != null && password.length() != 0) {
                buffer.append(':');
                try {
                    password = URLEncoder.encode(this.getPassword(), "UTF-8");
                    buffer.append(password);
                }
                catch (UnsupportedEncodingException e) {
                    UriParser.appendEncoded((StringBuilder)buffer, (String)password, (char[])PASSWORD_RESERVED);
                }
            }
            buffer.append('@');
        }
    }
}

