/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.pentaho.s3.vfs.S3FileSystem;

public class S3FileObject
extends AbstractFileObject {
    public static final String DELIMITER = "/";
    private S3Bucket bucket = null;
    private S3FileSystem fileSystem = null;
    protected Set<String> folders = new HashSet<String>();
    protected static Map<String, S3Object[]> s3ChildrenMap = new HashMap<String, S3Object[]>();

    protected S3FileObject(AbstractFileName name, S3FileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
    }

    protected String getS3BucketName() {
        String bucketName = this.getName().getPath();
        bucketName = bucketName.indexOf(DELIMITER, 1) > 1 ? bucketName.substring(1, bucketName.indexOf(DELIMITER, 1)) : bucketName.replaceAll(DELIMITER, "");
        return bucketName;
    }

    protected S3Bucket getS3Bucket() throws Exception {
        if (this.bucket == null) {
            String bucketName = this.getS3BucketName();
            S3Service s3Service = this.fileSystem.getS3Service();
            if (s3Service != null) {
                this.bucket = s3Service.getBucket(bucketName);
            } else {
                return null;
            }
        }
        return this.bucket;
    }

    S3Object getS3Object(boolean deleteIfAlreadyExists, boolean needContent) throws Exception {
        try {
            if (this.getName().getPath().indexOf(DELIMITER, 1) == -1) {
                return null;
            }
            String name = this.getBucketRelativeS3Path();
            if (!name.equals("")) {
                try {
                    S3Object object = this.getObjectFromS3(name, needContent);
                    if (deleteIfAlreadyExists) {
                        this.fileSystem.getS3Service().deleteObject(this.getS3BucketName(), name);
                        object = new S3Object(name);
                    }
                    return object;
                }
                catch (Exception e) {
                    S3Object object = new S3Object(name);
                    if (deleteIfAlreadyExists) {
                        this.fileSystem.getS3Service().deleteObject(this.getS3Bucket(), name);
                    }
                    return object;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private S3Object getObjectFromS3(String name, Boolean needContent) throws S3ServiceException, IOException {
        S3Object s3Object = this.fileSystem.getS3Service().getObject(this.getS3BucketName(), name);
        if (!needContent.booleanValue() && s3Object != null) {
            s3Object.closeDataInputStream();
        }
        return s3Object;
    }

    protected long doGetContentSize() throws Exception {
        return this.getS3Object(false, false).getContentLength();
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        final ByteArrayOutputStream output = new ByteArrayOutputStream();
        final PipedInputStream pis = new PipedInputStream();
        final Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)pis, (OutputStream)output);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
        PipedOutputStream pos = new PipedOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    t.join();
                    S3Object s3Object = S3FileObject.this.getS3Object(true, false);
                    byte[] bytes = output.toByteArray();
                    s3Object.setContentLength((long)bytes.length);
                    s3Object.setDataInputStream((InputStream)new ByteArrayInputStream(bytes));
                    S3FileObject.this.fileSystem.getS3Service().putObject(S3FileObject.this.getS3Bucket(), s3Object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        pis.connect(pos);
        return pos;
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.getS3Object(false, true).getDataInputStream();
    }

    protected FileType doGetType() throws Exception {
        S3Bucket bucket = null;
        try {
            bucket = this.getS3Bucket();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getName().getPath().equals("") || this.getName().getPath().equals(DELIMITER) || this.getName().getPath().endsWith(DELIMITER)) {
            return FileType.FOLDER;
        }
        String s3Path = this.getBucketRelativeS3Path();
        if (s3Path.isEmpty() && bucket != null) {
            return FileType.FOLDER;
        }
        if (!s3Path.endsWith(DELIMITER)) {
            s3Path = s3Path.concat(DELIMITER);
        }
        S3Object objectEndsWithDelimiter = null;
        try {
            objectEndsWithDelimiter = this.getObjectFromS3(s3Path, false);
        }
        catch (Exception e) {
            try {
                if (this.fileSystem.getS3Service().listObjects(this.getS3BucketName(), s3Path, null).length != 0) {
                    return FileType.FOLDER;
                }
            }
            catch (S3ServiceException s3ServiceException) {
                // empty catch block
            }
        }
        if (objectEndsWithDelimiter != null) {
            return FileType.FOLDER;
        }
        S3Object object = null;
        try {
            object = this.getS3Object(false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bucket == null && object == null) {
            return FileType.IMAGINARY;
        }
        if (bucket != null && object == null) {
            return FileType.FOLDER;
        }
        if (object.getBucketName() != null && object.getLastModifiedDate() != null) {
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    public void doCreateFolder() throws Exception {
        S3Object s3Object = this.getS3Object(false, false);
        if (s3Object == null) {
            this.bucket = this.fileSystem.getS3Service().getOrCreateBucket(this.getS3BucketName());
        } else {
            this.bucket = this.fileSystem.getS3Service().getOrCreateBucket(this.getS3BucketName());
            String name = this.getBucketRelativeS3Path() + DELIMITER;
            if (name.equals(DELIMITER)) {
                return;
            }
            S3Object obj = new S3Object(this.bucket, name);
            this.fileSystem.getS3Service().putObject(this.bucket, obj);
            ((S3FileObject)this.getParent()).folders.add(this.getName().getBaseName());
            s3ChildrenMap.remove(this.getS3BucketName());
        }
    }

    public boolean canRenameTo(FileObject newfile) {
        try {
            if (this.getType().equals((Object)FileType.FOLDER)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.canRenameTo(newfile);
    }

    public void doDelete() throws Exception {
        S3Object s3obj = this.getS3Object(false, false);
        this.bucket = this.getS3Bucket();
        if (s3obj == null) {
            if (this.bucket != null) {
                this.fileSystem.getS3Service().deleteBucket(this.getS3BucketName());
            }
            return;
        }
        if (this.getName().getPath().equals("") || this.getName().getPath().equals(DELIMITER)) {
            return;
        }
        String key = s3obj.getKey();
        FileType filetype = this.getName().getType();
        if (filetype.equals((Object)FileType.FILE)) {
            this.fileSystem.getS3Service().deleteObject(this.bucket, key);
        } else if (filetype.equals((Object)FileType.FOLDER)) {
            key = key + DELIMITER;
            this.fileSystem.getS3Service().deleteObject(this.bucket, key);
        } else {
            return;
        }
        ((S3FileObject)this.getParent()).folders.remove(this.getName().getBaseName());
        s3ChildrenMap.remove(this.getS3BucketName());
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (this.getType().equals((Object)FileType.FOLDER)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        S3Object s3Object = this.getS3Object(false, false);
        if (s3Object == null) {
            throw new FileSystemException("vfs.provider/rename.error", new Object[]{this, newfile});
        }
        s3Object.setKey(newfile.getName().getBaseName());
        this.fileSystem.getS3Service().renameObject(this.getS3BucketName(), this.getName().getBaseName(), (StorageObject)s3Object);
        s3ChildrenMap.remove(this.getS3BucketName());
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.getType() == FileType.FOLDER) {
            return -1L;
        }
        return this.getS3Object(false, false).getLastModifiedDate().getTime();
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        return true;
    }

    protected String[] doListChildren() throws Exception {
        S3Bucket bucket = this.getS3Bucket();
        if (bucket == null && (this.getName().getPath().equals("") || this.getName().getPath().equals(DELIMITER))) {
            S3Bucket[] buckets = this.fileSystem.getS3Service().listAllBuckets();
            String[] children = new String[buckets.length];
            for (int i = 0; i < buckets.length; ++i) {
                children[i] = buckets[i].getName();
            }
            return children;
        }
        if (s3ChildrenMap.get(this.getS3BucketName()) == null) {
            s3ChildrenMap.put(this.getS3BucketName(), this.fileSystem.getS3Service().listObjects(this.getS3BucketName()));
        }
        String s3Path = this.getBucketRelativeS3Path();
        S3Object[] s3Children = this.fileSystem.getS3Service().listObjects(this.getS3BucketName(), s3Path + DELIMITER, null);
        HashSet<String> vfsChildren = new HashSet<String>();
        if (s3Children != null && !"".equals(s3Path)) {
            for (S3Object obj : s3Children) {
                String key = obj.getKey();
                String pathSegment = key.substring(s3Path.length() + 1);
                int slashIndex = pathSegment.indexOf(DELIMITER);
                if (slashIndex > 0) {
                    String child = pathSegment.substring(0, slashIndex);
                    vfsChildren.add(child);
                    this.folders.add(child);
                    continue;
                }
                if ("".equalsIgnoreCase(pathSegment)) continue;
                vfsChildren.add(pathSegment);
            }
        } else {
            s3Children = s3ChildrenMap.get(this.getS3BucketName());
            if (s3Children == null) {
                return null;
            }
            for (S3Object aS3Children : s3Children) {
                String key = aS3Children.getKey();
                int slashIndex = key.indexOf(DELIMITER);
                if (slashIndex > 0) {
                    String child = key.substring(0, slashIndex);
                    vfsChildren.add(child);
                    this.folders.add(child);
                    continue;
                }
                vfsChildren.add(key);
            }
        }
        return vfsChildren.toArray(new String[0]);
    }

    private String getBucketRelativeS3Path() {
        if (this.getName().getPath().indexOf(DELIMITER, 1) >= 0) {
            return this.getName().getPath().substring(this.getName().getPath().indexOf(DELIMITER, 1) + 1);
        }
        return "";
    }

    protected void handleCreate(FileType newType) throws Exception {
        s3ChildrenMap.remove(this.getS3BucketName());
        super.handleCreate(newType);
    }

    protected void handleDelete() throws Exception {
        s3ChildrenMap.remove(this.getS3BucketName());
        super.handleDelete();
    }
}

