/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInject;
import org.pentaho.di.trans.steps.metainject.MetaInjectData;
import org.pentaho.di.trans.steps.metainject.MetaInjectMapping;
import org.pentaho.di.trans.steps.metainject.MetaInjectOutputField;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="MetaInject", image="org/pentaho/di/ui/trans/steps/metainject/img/GenericTransform.svg", name="i18n:org.pentaho.di.trans.step:BaseStep.TypeLongDesc.MetaInject", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Flow", documentationUrl="0L0/0Y0/0K0/ETL_Metadata_Injection")
@InjectionSupported(localizationPrefix="MetaInject.Injection.", groups={"SOURCE_OUTPUT_FIELDS", "MAPPING_FIELDS"})
public class MetaInjectMeta
extends BaseStepMeta
implements StepMetaInterface,
StepMetaChangeListenerInterface {
    private static Class<?> PKG = MetaInjectMeta.class;
    private static final String MAPPINGS = "mappings";
    private static final String MAPPING = "mapping";
    private static final String SPECIFICATION_METHOD = "specification_method";
    private static final String TRANS_OBJECT_ID = "trans_object_id";
    private static final String TRANS_NAME = "trans_name";
    private static final String FILENAME = "filename";
    private static final String DIRECTORY_PATH = "directory_path";
    private static final String TARGET_FILE = "target_file";
    private static final String NO_EXECUTION = "no_execution";
    private static final String SOURCE_STEP = "source_step";
    private static final String STREAM_SOURCE_STEP = "stream_source_step";
    private static final String STREAM_TARGET_STEP = "stream_target_step";
    private static final String TARGET_STEP_NAME = "target_step_name";
    private static final String TARGET_ATTRIBUTE_KEY = "target_attribute_key";
    private static final String TARGET_DETAIL = "target_detail";
    private static final String SOURCE_FIELD = "source_field";
    private static final String SOURCE_OUTPUT_FIELDS = "source_output_fields";
    private static final String SOURCE_OUTPUT_FIELD = "source_output_field";
    private static final String SOURCE_OUTPUT_FIELD_NAME = "source_output_field_name";
    private static final String SOURCE_OUTPUT_FIELD_TYPE = "source_output_field_type";
    private static final String SOURCE_OUTPUT_FIELD_LENGTH = "source_output_field_length";
    private static final String SOURCE_OUTPUT_FIELD_PRECISION = "source_output_field_precision";
    private static final String MAPPING_SOURCE_FIELD = "mapping_source_field";
    private static final String MAPPING_SOURCE_STEP = "mapping_source_step";
    private static final String MAPPING_TARGET_DETAIL = "mapping_target_detail";
    private static final String MAPPING_TARGET_ATTRIBUTE_KEY = "mapping_target_attribute_key";
    private static final String MAPPING_TARGET_STEP_NAME = "mapping_target_step_name";
    private static final String GROUP_AND_NAME_DELIMITER = ".";
    @Injection(name="TRANS_NAME")
    private String transName;
    @Injection(name="FILE_NAME")
    private String fileName;
    @Injection(name="DIRECTORY_PATH")
    private String directoryPath;
    private ObjectId transObjectId;
    @Injection(name="TRANS_SEPECIFICATION_METHOD")
    private ObjectLocationSpecificationMethod specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
    @Injection(name="SOURCE_STEP_NAME")
    private String sourceStepName;
    @InjectionDeep
    private List<MetaInjectOutputField> sourceOutputFields;
    private Map<TargetStepAttribute, SourceStepField> targetSourceMapping = new HashMap<TargetStepAttribute, SourceStepField>();
    @InjectionDeep
    private List<MetaInjectMapping> metaInjectMapping;
    @Injection(name="TARGET_FILE")
    private String targetFile;
    @Injection(name="NO_EXECUTION")
    private boolean noExecution;
    @Injection(name="STREAMING_SOURCE_STEP")
    private String streamSourceStepname;
    private StepMeta streamSourceStep;
    @Injection(name="STREAMING_TARGET_STEP")
    private String streamTargetStepname;

    public MetaInjectMeta() {
        this.sourceOutputFields = new ArrayList<MetaInjectOutputField>();
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
    }

    public String getXML() {
        this.actualizeMetaInjectMapping();
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)SPECIFICATION_METHOD, this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)TRANS_OBJECT_ID, this.transObjectId == null ? null : this.transObjectId.toString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)TRANS_NAME, (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)FILENAME, (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)DIRECTORY_PATH, (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)SOURCE_STEP, (String)this.sourceStepName));
        retval.append("    ").append(XMLHandler.openTag((String)SOURCE_OUTPUT_FIELDS));
        for (MetaInjectOutputField field : this.sourceOutputFields) {
            retval.append("      ").append(XMLHandler.openTag((String)SOURCE_OUTPUT_FIELD));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_NAME, (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_TYPE, (String)field.getTypeDescription()));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_LENGTH, (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_PRECISION, (int)field.getPrecision()));
            retval.append("      ").append(XMLHandler.closeTag((String)SOURCE_OUTPUT_FIELD));
        }
        retval.append("    ").append(XMLHandler.closeTag((String)SOURCE_OUTPUT_FIELDS));
        retval.append("    ").append(XMLHandler.addTagValue((String)TARGET_FILE, (String)this.targetFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)NO_EXECUTION, (boolean)this.noExecution));
        if (this.streamSourceStepname == null && this.streamSourceStep != null) {
            this.streamSourceStepname = this.streamSourceStep.getName();
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)STREAM_SOURCE_STEP, (String)this.streamSourceStepname));
        retval.append("    ").append(XMLHandler.addTagValue((String)STREAM_TARGET_STEP, (String)this.streamTargetStepname));
        retval.append("    ").append(XMLHandler.openTag((String)MAPPINGS));
        for (TargetStepAttribute target : this.targetSourceMapping.keySet()) {
            retval.append("      ").append(XMLHandler.openTag((String)MAPPING));
            SourceStepField source = this.targetSourceMapping.get(target);
            retval.append("        ").append(XMLHandler.addTagValue((String)TARGET_STEP_NAME, (String)target.getStepname()));
            retval.append("        ").append(XMLHandler.addTagValue((String)TARGET_ATTRIBUTE_KEY, (String)target.getAttributeKey()));
            retval.append("        ").append(XMLHandler.addTagValue((String)TARGET_DETAIL, (boolean)target.isDetail()));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_STEP, (String)source.getStepname()));
            retval.append("        ").append(XMLHandler.addTagValue((String)SOURCE_FIELD, (String)source.getField()));
            retval.append("      ").append(XMLHandler.closeTag((String)MAPPING));
        }
        retval.append("    ").append(XMLHandler.closeTag((String)MAPPINGS));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)SPECIFICATION_METHOD);
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)stepnode, (String)TRANS_OBJECT_ID);
            this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
            this.transName = XMLHandler.getTagValue((Node)stepnode, (String)TRANS_NAME);
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)FILENAME);
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)DIRECTORY_PATH);
            this.sourceStepName = XMLHandler.getTagValue((Node)stepnode, (String)SOURCE_STEP);
            Node outputFieldsNode = XMLHandler.getSubNode((Node)stepnode, (String)SOURCE_OUTPUT_FIELDS);
            List outputFieldNodes = XMLHandler.getNodes((Node)outputFieldsNode, (String)SOURCE_OUTPUT_FIELD);
            this.sourceOutputFields = new ArrayList<MetaInjectOutputField>();
            for (Node outputFieldNode : outputFieldNodes) {
                String name = XMLHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_NAME);
                String typeName = XMLHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_TYPE);
                int length = Const.toInt((String)XMLHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_LENGTH), (int)-1);
                int precision = Const.toInt((String)XMLHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_PRECISION), (int)-1);
                int type = ValueMetaFactory.getIdForValueMeta((String)typeName);
                this.sourceOutputFields.add(new MetaInjectOutputField(name, type, length, precision));
            }
            this.targetFile = XMLHandler.getTagValue((Node)stepnode, (String)TARGET_FILE);
            this.noExecution = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)NO_EXECUTION));
            this.streamSourceStepname = XMLHandler.getTagValue((Node)stepnode, (String)STREAM_SOURCE_STEP);
            this.streamTargetStepname = XMLHandler.getTagValue((Node)stepnode, (String)STREAM_TARGET_STEP);
            Node mappingsNode = XMLHandler.getSubNode((Node)stepnode, (String)MAPPINGS);
            int nrMappings = XMLHandler.countNodes((Node)mappingsNode, (String)MAPPING);
            for (int i = 0; i < nrMappings; ++i) {
                Node mappingNode = XMLHandler.getSubNodeByNr((Node)mappingsNode, (String)MAPPING, (int)i);
                String targetStepname = XMLHandler.getTagValue((Node)mappingNode, (String)TARGET_STEP_NAME);
                String targetAttributeKey = XMLHandler.getTagValue((Node)mappingNode, (String)TARGET_ATTRIBUTE_KEY);
                boolean targetDetail = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)mappingNode, (String)TARGET_DETAIL));
                String sourceStepname = XMLHandler.getTagValue((Node)mappingNode, (String)SOURCE_STEP);
                String sourceField = XMLHandler.getTagValue((Node)mappingNode, (String)SOURCE_FIELD);
                TargetStepAttribute target = new TargetStepAttribute(targetStepname, targetAttributeKey, targetDetail);
                SourceStepField source = new SourceStepField(sourceStepname, sourceField);
                this.targetSourceMapping.put(target, source);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            String method = rep.getStepAttributeString(id_step, SPECIFICATION_METHOD);
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = rep.getStepAttributeString(id_step, TRANS_OBJECT_ID);
            this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
            this.transName = rep.getStepAttributeString(id_step, TRANS_NAME);
            this.fileName = rep.getStepAttributeString(id_step, FILENAME);
            this.directoryPath = rep.getStepAttributeString(id_step, DIRECTORY_PATH);
            this.sourceStepName = rep.getStepAttributeString(id_step, SOURCE_STEP);
            this.streamSourceStepname = rep.getStepAttributeString(id_step, STREAM_SOURCE_STEP);
            this.streamTargetStepname = rep.getStepAttributeString(id_step, STREAM_TARGET_STEP);
            this.sourceOutputFields = new ArrayList<MetaInjectOutputField>();
            int nrSourceOutputFields = rep.countNrStepAttributes(id_step, SOURCE_OUTPUT_FIELD_NAME);
            for (int i = 0; i < nrSourceOutputFields; ++i) {
                String name = rep.getStepAttributeString(id_step, i, SOURCE_OUTPUT_FIELD_NAME);
                String typeName = rep.getStepAttributeString(id_step, i, SOURCE_OUTPUT_FIELD_TYPE);
                int length = (int)rep.getStepAttributeInteger(id_step, i, SOURCE_OUTPUT_FIELD_LENGTH);
                int precision = (int)rep.getStepAttributeInteger(id_step, i, SOURCE_OUTPUT_FIELD_PRECISION);
                int type = ValueMetaFactory.getIdForValueMeta((String)typeName);
                this.sourceOutputFields.add(new MetaInjectOutputField(name, type, length, precision));
            }
            this.targetFile = rep.getStepAttributeString(id_step, TARGET_FILE);
            this.noExecution = rep.getStepAttributeBoolean(id_step, NO_EXECUTION);
            int nrMappings = rep.countNrStepAttributes(id_step, MAPPING_TARGET_STEP_NAME);
            for (int i = 0; i < nrMappings; ++i) {
                String targetStepname = rep.getStepAttributeString(id_step, i, MAPPING_TARGET_STEP_NAME);
                String targetAttributeKey = rep.getStepAttributeString(id_step, i, MAPPING_TARGET_ATTRIBUTE_KEY);
                boolean targetDetail = rep.getStepAttributeBoolean(id_step, i, MAPPING_TARGET_DETAIL);
                String sourceStepname = rep.getStepAttributeString(id_step, i, MAPPING_SOURCE_STEP);
                String sourceField = rep.getStepAttributeString(id_step, i, MAPPING_SOURCE_FIELD);
                TargetStepAttribute target = new TargetStepAttribute(targetStepname, targetAttributeKey, targetDetail);
                SourceStepField source = new SourceStepField(sourceStepname, sourceField);
                this.targetSourceMapping.put(target, source);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, SPECIFICATION_METHOD, this.specificationMethod == null ? null : this.specificationMethod.getCode());
            rep.saveStepAttribute(id_transformation, id_step, TRANS_OBJECT_ID, this.transObjectId == null ? null : this.transObjectId.toString());
            rep.saveStepAttribute(id_transformation, id_step, FILENAME, this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, TRANS_NAME, this.transName);
            rep.saveStepAttribute(id_transformation, id_step, DIRECTORY_PATH, this.directoryPath);
            rep.saveStepAttribute(id_transformation, id_step, SOURCE_STEP, this.sourceStepName);
            rep.saveStepAttribute(id_transformation, id_step, STREAM_SOURCE_STEP, this.streamSourceStepname);
            rep.saveStepAttribute(id_transformation, id_step, STREAM_TARGET_STEP, this.streamTargetStepname);
            MetaInjectOutputField aField = null;
            for (int i = 0; i < this.sourceOutputFields.size(); ++i) {
                aField = this.sourceOutputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_OUTPUT_FIELD_NAME, aField.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_OUTPUT_FIELD_TYPE, aField.getTypeDescription());
                rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_OUTPUT_FIELD_LENGTH, (long)aField.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, SOURCE_OUTPUT_FIELD_PRECISION, (long)aField.getPrecision());
            }
            rep.saveStepAttribute(id_transformation, id_step, TARGET_FILE, this.targetFile);
            rep.saveStepAttribute(id_transformation, id_step, NO_EXECUTION, this.noExecution);
            ArrayList<TargetStepAttribute> keySet = new ArrayList<TargetStepAttribute>(this.targetSourceMapping.keySet());
            for (int i = 0; i < keySet.size(); ++i) {
                TargetStepAttribute target = (TargetStepAttribute)keySet.get(i);
                SourceStepField source = this.targetSourceMapping.get(target);
                rep.saveStepAttribute(id_transformation, id_step, i, MAPPING_TARGET_STEP_NAME, target.getStepname());
                rep.saveStepAttribute(id_transformation, id_step, i, MAPPING_TARGET_ATTRIBUTE_KEY, target.getAttributeKey());
                rep.saveStepAttribute(id_transformation, id_step, i, MAPPING_TARGET_DETAIL, target.isDetail());
                rep.saveStepAttribute(id_transformation, id_step, i, MAPPING_SOURCE_STEP, source.getStepname());
                rep.saveStepAttribute(id_transformation, id_step, i, MAPPING_SOURCE_FIELD, source.getField());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        rowMeta.clear();
        if (!Utils.isEmpty((CharSequence)this.sourceStepName)) {
            for (MetaInjectOutputField field : this.sourceOutputFields) {
                try {
                    rowMeta.addValueMeta(field.createValueMeta());
                }
                catch (KettlePluginException e) {
                    throw new KettleStepException("Error creating value meta for output field '" + field.getName() + "'", (Throwable)e);
                }
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MetaInject(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new MetaInjectData();
    }

    public Map<TargetStepAttribute, SourceStepField> getTargetSourceMapping() {
        return this.targetSourceMapping;
    }

    public void setTargetSourceMapping(Map<TargetStepAttribute, SourceStepField> targetSourceMapping) {
        this.targetSourceMapping = targetSourceMapping;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public ObjectId getTransObjectId() {
        return this.transObjectId;
    }

    public void setTransObjectId(ObjectId transObjectId) {
        this.transObjectId = transObjectId;
    }

    @Injection(name="TRANS_OBJECT_ID")
    public void setTransStringObjectId(String transStringObjectId) {
        this.transObjectId = new StringObjectId(transStringObjectId);
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    @Deprecated
    public static final synchronized TransMeta loadTransformationMeta(MetaInjectMeta mappingMeta, Repository rep, VariableSpace space) throws KettleException {
        return MetaInjectMeta.loadTransformationMeta(mappingMeta, rep, null, space);
    }

    public static final synchronized TransMeta loadTransformationMeta(MetaInjectMeta injectMeta, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        TransMeta mappingTransMeta = null;
        CurrentDirectoryResolver resolver = new CurrentDirectoryResolver();
        VariableSpace tmpSpace = resolver.resolveCurrentDirectory(injectMeta.getSpecificationMethod(), space, rep, injectMeta.getParentStepMeta(), injectMeta.getFileName());
        switch (injectMeta.getSpecificationMethod()) {
            case FILENAME: {
                String realFilename = tmpSpace.environmentSubstitute(injectMeta.getFileName());
                try {
                    mappingTransMeta = new TransMeta(realFilename, metaStore, rep, false, tmpSpace, null);
                    mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation was loaded from XML file [" + realFilename + "]"});
                    break;
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTransformationFromFile", (String[])new String[]{realFilename}), (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                String realTransname = tmpSpace.environmentSubstitute(injectMeta.getTransName());
                String realDirectory = tmpSpace.environmentSubstitute(injectMeta.getDirectoryPath());
                if (Utils.isEmpty((CharSequence)realTransname) || Utils.isEmpty((CharSequence)realDirectory) || rep == null) break;
                RepositoryDirectoryInterface repdir = rep.findDirectory(realDirectory);
                if (repdir != null) {
                    try {
                        mappingTransMeta = rep.loadTransformation(realTransname, repdir, null, true, null);
                        mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation [" + realTransname + "] was loaded from the repository"});
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Unable to load transformation [" + realTransname + "]", (Throwable)e);
                    }
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTransformationFromRepository", (String[])new String[]{realTransname, realDirectory}));
            }
            case REPOSITORY_BY_REFERENCE: {
                mappingTransMeta = rep.loadTransformation(injectMeta.getTransObjectId(), null);
                break;
            }
        }
        mappingTransMeta.copyVariablesFrom(space);
        mappingTransMeta.setRepository(rep);
        mappingTransMeta.setFilename(mappingTransMeta.getFilename());
        return mappingTransMeta;
    }

    TransMeta loadTransformationMeta(Repository rep, VariableSpace space) throws KettleException {
        return MetaInjectMeta.loadTransformationMeta(this, rep, null, space);
    }

    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.transName);
        ResourceReference reference = new ResourceReference((ResourceHolderInterface)stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Utils.isEmpty((CharSequence)realTransname)) {
            reference.getEntries().add(new ResourceEntry(realTransname, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            TransMeta executorTransMeta = this.loadTransformationMeta(repository, space);
            String proposedNewFilename = executorTransMeta.exportResources((VariableSpace)executorTransMeta, definitions, resourceNamingInterface, repository, metaStore);
            String newFilename = "${Internal.Transformation.Filename.Directory}/" + proposedNewFilename;
            executorTransMeta.setFilename(newFilename);
            executorTransMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
            this.fileName = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTrans", (String[])new String[]{this.fileName}));
        }
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public String getSourceStepName() {
        return this.sourceStepName;
    }

    public void setSourceStepName(String sourceStepName) {
        this.sourceStepName = sourceStepName;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isNoExecution() {
        return this.noExecution;
    }

    public void setNoExecution(boolean noExecution) {
        this.noExecution = noExecution;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"MetaInjectMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isTransformationDefined() {
        return !Utils.isEmpty((CharSequence)this.fileName) || this.transObjectId != null || !Utils.isEmpty((CharSequence)this.directoryPath) && !Const.isEmpty((String)this.transName);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isTransformationDefined()};
    }

    public String getActiveReferencedObjectDescription() {
        return BaseMessages.getString(PKG, (String)"MetaInjectMeta.ReferencedObjectAfterInjection.Description", (String[])new String[0]);
    }

    @Deprecated
    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        return this.loadReferencedObject(index, rep, null, space);
    }

    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return MetaInjectMeta.loadTransformationMeta(this, rep, metaStore, space);
    }

    public String getStreamSourceStepname() {
        return this.streamSourceStepname;
    }

    public void setStreamSourceStepname(String streamSourceStepname) {
        this.streamSourceStepname = streamSourceStepname;
    }

    public StepMeta getStreamSourceStep() {
        return this.streamSourceStep;
    }

    public void setStreamSourceStep(StepMeta streamSourceStep) {
        this.streamSourceStep = streamSourceStep;
    }

    public String getStreamTargetStepname() {
        return this.streamTargetStepname;
    }

    public void setStreamTargetStepname(String streamTargetStepname) {
        this.streamTargetStepname = streamTargetStepname;
    }

    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.streamSourceStep = StepMeta.findStep(steps, (String)this.streamSourceStepname);
    }

    public List<MetaInjectOutputField> getSourceOutputFields() {
        return this.sourceOutputFields;
    }

    public void setSourceOutputFields(List<MetaInjectOutputField> sourceOutputFields) {
        this.sourceOutputFields = sourceOutputFields;
    }

    public List<MetaInjectMapping> getMetaInjectMapping() {
        return this.metaInjectMapping;
    }

    public void setMetaInjectMapping(List<MetaInjectMapping> metaInjectMapping) {
        this.metaInjectMapping = metaInjectMapping;
    }

    public void actualizeMetaInjectMapping() {
        if (this.metaInjectMapping == null || this.metaInjectMapping.isEmpty()) {
            return;
        }
        Map<TargetStepAttribute, SourceStepField> targetToSourceMap = MetaInjectMeta.convertToMap(this.metaInjectMapping);
        this.setTargetSourceMapping(targetToSourceMap);
    }

    static Map<TargetStepAttribute, SourceStepField> convertToMap(List<MetaInjectMapping> metaInjectMapping) {
        HashMap<TargetStepAttribute, SourceStepField> targetToSourceMap = new HashMap<TargetStepAttribute, SourceStepField>();
        for (MetaInjectMapping mappingEntry : metaInjectMapping) {
            if (!MetaInjectMeta.isMappingEntryFilled(mappingEntry)) continue;
            TargetStepAttribute targetStepAttribute = MetaInjectMeta.createTargetStepAttribute(mappingEntry);
            SourceStepField sourceStepField = MetaInjectMeta.createSourceStepField(mappingEntry);
            targetToSourceMap.put(targetStepAttribute, sourceStepField);
        }
        return targetToSourceMap;
    }

    private static TargetStepAttribute createTargetStepAttribute(MetaInjectMapping mappingEntry) {
        String targetFieldName = mappingEntry.getTargetField();
        if (targetFieldName.contains(GROUP_AND_NAME_DELIMITER)) {
            String[] targetFieldGroupAndName = targetFieldName.split("\\.");
            return new TargetStepAttribute(mappingEntry.getTargetStep(), targetFieldGroupAndName[1], true);
        }
        return new TargetStepAttribute(mappingEntry.getTargetStep(), mappingEntry.getTargetField(), false);
    }

    private static boolean isMappingEntryFilled(MetaInjectMapping mappingEntry) {
        return mappingEntry.getSourceStep() != null && mappingEntry.getSourceField() != null && mappingEntry.getTargetStep() != null && mappingEntry.getTargetField() != null;
    }

    private static SourceStepField createSourceStepField(MetaInjectMapping mappingEntry) {
        return new SourceStepField(mappingEntry.getSourceStep(), mappingEntry.getSourceField());
    }

    public void onStepChange(TransMeta transMeta, StepMeta oldMeta, StepMeta newMeta) {
        for (int i = 0; i < transMeta.nrTransHops(); ++i) {
            StepMeta toStepMeta;
            TransHopMeta hopMeta = transMeta.getTransHop(i);
            if (!hopMeta.getFromStep().equals((Object)oldMeta) || !((toStepMeta = hopMeta.getToStep()).getStepMetaInterface() instanceof MetaInjectMeta) || !toStepMeta.equals((Object)this.getParentStepMeta())) continue;
            MetaInjectMeta toMeta = (MetaInjectMeta)toStepMeta.getStepMetaInterface();
            Map<TargetStepAttribute, SourceStepField> sourceMapping = toMeta.getTargetSourceMapping();
            for (Map.Entry<TargetStepAttribute, SourceStepField> entry : sourceMapping.entrySet()) {
                SourceStepField value = entry.getValue();
                if (!value.getStepname().equals(oldMeta.getName())) continue;
                value.setStepname(newMeta.getName());
            }
        }
    }
}

