/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.metainject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInject;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectOutputField;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class MetaInjectDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MetaInjectMeta.class;
    private MetaInjectMeta metaInjectMeta;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wFileTab;
    private ScrolledComposite wFileSComp;
    private Composite wFileComp;
    private CTabItem wOptionsTab;
    private ScrolledComposite wOptionsSComp;
    private Composite wOptionsComp;
    private CTabItem wInjectTab;
    private ScrolledComposite wInjectSComp;
    private Composite wInjectComp;
    private Group gTransGroup;
    private Button radioFilename;
    private Button wbbFilename;
    private TextVar wFilename;
    private Button radioByName;
    private TextVar wTransname;
    private TextVar wDirectory;
    private Button wbTrans;
    private Button radioByReference;
    private Button wbByReference;
    private TextVar wByReference;
    private Button wValidateTrans;
    private Button wEditTrans;
    private Button wNewTrans;
    private TransMeta injectTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private CCombo wSourceStep;
    private Label wlSourceFields;
    private TableView wSourceFields;
    private TextVar wTargetFile;
    private Button wNoExecution;
    private Label wlStreamingSourceStep;
    private CCombo wStreamingSourceStep;
    private Label wlStreamingTargetStep;
    private CCombo wStreamingTargetStep;
    private Tree wTree;
    private Map<TreeItem, TargetStepAttribute> treeItemTargetMap;
    private Map<TargetStepAttribute, SourceStepField> targetSourceMapping;

    public MetaInjectDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.metaInjectMeta = (MetaInjectMeta)((Object)in);
        this.transModified = false;
        this.targetSourceMapping = new HashMap<TargetStepAttribute, SourceStepField>();
        this.targetSourceMapping.putAll(this.metaInjectMeta.getTargetSourceMapping());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.metaInjectMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.metaInjectMeta.setChanged();
            }
        };
        this.changed = this.metaInjectMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, this.margin, null);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, this.margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -this.margin * 2);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.addFileTab();
        this.addOptionsTab();
        this.addInjectTab();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MetaInjectDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MetaInjectDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MetaInjectDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wTransname.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MetaInjectDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.metaInjectMeta.setChanged(this.changed);
        this.shell.open();
        this.checkInvalidMapping();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void checkInvalidMapping() {
        if (this.injectTransMeta == null) {
            try {
                if (!this.loadTransformation()) {
                    return;
                }
            }
            catch (KettleException e) {
                this.showErrorOnLoadTransformationDialog(e);
                return;
            }
        }
        Set<SourceStepField> unavailableSourceSteps = MetaInject.getUnavailableSourceSteps(this.targetSourceMapping, this.transMeta, this.stepMeta);
        Set<TargetStepAttribute> unavailableTargetSteps = MetaInject.getUnavailableTargetSteps(this.targetSourceMapping, this.injectTransMeta);
        Set<TargetStepAttribute> missingTargetKeys = MetaInject.getUnavailableTargetKeys(this.targetSourceMapping, this.injectTransMeta, unavailableTargetSteps);
        if (unavailableSourceSteps.isEmpty() && unavailableTargetSteps.isEmpty() && missingTargetKeys.isEmpty()) {
            return;
        }
        this.showInvalidMappingDialog(unavailableSourceSteps, unavailableTargetSteps, missingTargetKeys);
    }

    private void showInvalidMappingDialog(Set<SourceStepField> unavailableSourceSteps, Set<TargetStepAttribute> unavailableTargetSteps, Set<TargetStepAttribute> missingTargetKeys) {
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Question", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Title", (String[])new String[0]));
        int id = mb.open();
        if (id == 64) {
            MetaInject.removeUnavailableStepsFromMapping(this.targetSourceMapping, unavailableSourceSteps, unavailableTargetSteps);
            for (TargetStepAttribute target : missingTargetKeys) {
                this.targetSourceMapping.remove(target);
            }
        }
    }

    private void showErrorOnLoadTransformationDialog(KettleException e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
    }

    private void addFileTab() {
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.FileTab.TabTitle", (String[])new String[0]));
        this.wFileSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        this.wFileSComp.setLayout((Layout)new FillLayout());
        this.wFileComp = new Composite((Composite)this.wFileSComp, 0);
        this.props.setLook((Control)this.wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wFileComp.setLayout((Layout)fileLayout);
        this.gTransGroup = new Group(this.wFileComp, 16);
        this.gTransGroup.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.TransGroup.Label", (String[])new String[0]));
        this.gTransGroup.setBackground(this.shell.getBackground());
        FormLayout transGroupLayout = new FormLayout();
        transGroupLayout.marginLeft = this.margin * 2;
        transGroupLayout.marginTop = this.margin * 2;
        transGroupLayout.marginRight = this.margin * 2;
        transGroupLayout.marginBottom = this.margin * 2;
        this.gTransGroup.setLayout((Layout)transGroupLayout);
        this.radioFilename = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioFilename);
        this.radioFilename.setSelection(false);
        this.radioFilename.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioFile.Label", (String[])new String[0]));
        this.radioFilename.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioFile.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdFileRadio = new FormData();
        fdFileRadio.left = new FormAttachment(0, 0);
        fdFileRadio.right = new FormAttachment(100, 0);
        fdFileRadio.top = new FormAttachment(0, 0);
        this.radioFilename.setLayoutData((Object)fdFileRadio);
        this.radioFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.wbbFilename = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.radioFilename, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.selectFileTrans(true);
            }
        });
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(0, 25);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)this.wbbFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.radioByName = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByName);
        this.radioByName.setSelection(false);
        this.radioByName.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioRep.Label", (String[])new String[0]));
        this.radioByName.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioRep.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRepRadio = new FormData();
        fdRepRadio.left = new FormAttachment(0, 0);
        fdRepRadio.right = new FormAttachment(100, 0);
        fdRepRadio.top = new FormAttachment((Control)this.wbbFilename, 2 * this.margin);
        this.radioByName.setLayoutData((Object)fdRepRadio);
        this.radioByName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.wbTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbTrans);
        this.wbTrans.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Select.Button", (String[])new String[0]));
        this.wbTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbTrans = new FormData();
        fdbTrans.right = new FormAttachment(100, 0);
        fdbTrans.top = new FormAttachment((Control)this.radioByName, 2 * this.margin);
        this.wbTrans.setLayoutData((Object)fdbTrans);
        this.wbTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.selectRepositoryTrans();
            }
        });
        this.wDirectory = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.addModifyListener(this.lsMod);
        FormData fdTransDir = new FormData();
        fdTransDir.left = new FormAttachment(this.middle + (100 - this.middle) / 2, 0);
        fdTransDir.right = new FormAttachment((Control)this.wbTrans, -this.margin);
        fdTransDir.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wDirectory.setLayoutData((Object)fdTransDir);
        this.wDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.wTransname = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wTransname);
        this.wTransname.addModifyListener(this.lsMod);
        FormData fdTransName = new FormData();
        fdTransName.left = new FormAttachment(0, 25);
        fdTransName.right = new FormAttachment((Control)this.wDirectory, -this.margin);
        fdTransName.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wTransname.setLayoutData((Object)fdTransName);
        this.wTransname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.radioByReference = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByReference);
        this.radioByReference.setSelection(false);
        this.radioByReference.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioRepByReference.Label", (String[])new String[0]));
        this.radioByReference.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RadioRepByReference.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRadioByReference = new FormData();
        fdRadioByReference.left = new FormAttachment(0, 0);
        fdRadioByReference.right = new FormAttachment(100, 0);
        fdRadioByReference.top = new FormAttachment((Control)this.wTransname, 2 * this.margin);
        this.radioByReference.setLayoutData((Object)fdRadioByReference);
        this.radioByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.wbByReference = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbByReference);
        this.wbByReference.setImage(GUIResource.getInstance().getImageTransGraph());
        this.wbByReference.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SelectTrans.Tooltip", (String[])new String[0]));
        FormData fdbByReference = new FormData();
        fdbByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdbByReference.right = new FormAttachment(100, 0);
        this.wbByReference.setLayoutData((Object)fdbByReference);
        this.wbByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.selectTransformationByReference();
            }
        });
        this.wByReference = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18444);
        this.props.setLook((Control)this.wByReference);
        this.wByReference.addModifyListener(this.lsMod);
        FormData fdByReference = new FormData();
        fdByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdByReference.left = new FormAttachment(0, 25);
        fdByReference.right = new FormAttachment((Control)this.wbByReference, -this.margin);
        this.wByReference.setLayoutData((Object)fdByReference);
        this.wByReference.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetaInjectDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                MetaInjectDialog.this.setRadioButtons();
            }
        });
        this.wNewTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wNewTrans);
        this.wNewTrans.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.New.Button", (String[])new String[0]));
        FormData fdNewTrans = new FormData();
        fdNewTrans.left = new FormAttachment(0, 0);
        fdNewTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wNewTrans.setLayoutData((Object)fdNewTrans);
        this.wNewTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.newTransformation();
            }
        });
        this.wEditTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wEditTrans);
        this.wEditTrans.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Edit.Button", (String[])new String[0]));
        this.wEditTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdEditTrans = new FormData();
        fdEditTrans.left = new FormAttachment((Control)this.wNewTrans, 2 * this.margin);
        fdEditTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wEditTrans.setLayoutData((Object)fdEditTrans);
        this.wEditTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.editTrans();
            }
        });
        this.wValidateTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wValidateTrans);
        this.wValidateTrans.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Validate.Button", (String[])new String[0]));
        this.wValidateTrans.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Validate.Tooltip", (String[])new String[0]));
        FormData fdValidateTrans = new FormData();
        fdValidateTrans.left = new FormAttachment((Control)this.wEditTrans, 2 * this.margin);
        fdValidateTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wValidateTrans.setLayoutData((Object)fdValidateTrans);
        this.wValidateTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.validateTrans();
            }
        });
        FormData fdTransGroup = new FormData();
        fdTransGroup.left = new FormAttachment(0, 0);
        fdTransGroup.top = new FormAttachment((Control)this.wStepname, 2 * this.margin);
        fdTransGroup.right = new FormAttachment(100, 0);
        this.gTransGroup.setLayoutData((Object)fdTransGroup);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        this.wFileComp.setLayoutData((Object)fdFileComp);
        this.wFileComp.pack();
        Rectangle bounds = this.wFileComp.getBounds();
        this.wFileSComp.setContent((Control)this.wFileComp);
        this.wFileSComp.setExpandHorizontal(true);
        this.wFileSComp.setExpandVertical(true);
        this.wFileSComp.setMinWidth(bounds.width);
        this.wFileSComp.setMinHeight(bounds.height);
        this.wFileTab.setControl((Control)this.wFileSComp);
    }

    private void addOptionsTab() {
        this.wOptionsTab = new CTabItem(this.wTabFolder, 0);
        this.wOptionsTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.OptionsTab.TabTitle", (String[])new String[0]));
        this.wOptionsSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        this.wOptionsSComp.setLayout((Layout)new FillLayout());
        this.wOptionsComp = new Composite((Composite)this.wOptionsSComp, 0);
        this.props.setLook((Control)this.wOptionsComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wOptionsComp.setLayout((Layout)fileLayout);
        Label wlSourceStep = new Label(this.wOptionsComp, 131072);
        wlSourceStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SourceStep.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSourceStep);
        FormData fdlSourceStep = new FormData();
        fdlSourceStep.left = new FormAttachment(0, 0);
        fdlSourceStep.right = new FormAttachment(this.middle, 0);
        fdlSourceStep.top = new FormAttachment(0, 0);
        wlSourceStep.setLayoutData((Object)fdlSourceStep);
        this.wSourceStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wSourceStep);
        this.wSourceStep.addModifyListener(this.lsMod);
        FormData fdSourceStep = new FormData();
        fdSourceStep.left = new FormAttachment(this.middle, this.margin);
        fdSourceStep.top = new FormAttachment(0, 0);
        fdSourceStep.right = new FormAttachment(100, 0);
        this.wSourceStep.setLayoutData((Object)fdSourceStep);
        this.wSourceStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MetaInjectDialog.this.setActive();
            }
        });
        CCombo lastControl = this.wSourceStep;
        this.wlSourceFields = new Label(this.wOptionsComp, 131072);
        this.wlSourceFields.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSourceFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(this.middle, 0);
        fdlFields.top = new FormAttachment((Control)lastControl, this.margin);
        this.wlSourceFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.metaInjectMeta.getSourceOutputFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Fieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMeta.getAllTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wSourceFields = new TableView((VariableSpace)this.transMeta, this.wOptionsComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(this.middle, this.margin);
        fdFields.top = new FormAttachment((Control)lastControl, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)lastControl, this.margin + 300);
        this.wSourceFields.setLayoutData((Object)fdFields);
        lastControl = this.wSourceFields;
        Label wlTargetFile = new Label(this.wOptionsComp, 131072);
        wlTargetFile.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.TargetFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTargetFile);
        FormData fdlTargetFile = new FormData();
        fdlTargetFile.left = new FormAttachment(0, 0);
        fdlTargetFile.right = new FormAttachment(this.middle, 0);
        fdlTargetFile.top = new FormAttachment((Control)lastControl, this.margin);
        wlTargetFile.setLayoutData((Object)fdlTargetFile);
        this.wTargetFile = new TextVar((VariableSpace)this.transMeta, this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wTargetFile);
        this.wTargetFile.addModifyListener(this.lsMod);
        FormData fdTargetFile = new FormData();
        fdTargetFile.left = new FormAttachment(this.middle, this.margin);
        fdTargetFile.top = new FormAttachment((Control)lastControl, this.margin);
        fdTargetFile.right = new FormAttachment(100, 0);
        this.wTargetFile.setLayoutData((Object)fdTargetFile);
        lastControl = this.wTargetFile;
        Label wlNoExecution = new Label(this.wOptionsComp, 131072);
        wlNoExecution.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.NoExecution.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNoExecution);
        FormData fdlNoExecution = new FormData();
        fdlNoExecution.left = new FormAttachment(0, 0);
        fdlNoExecution.right = new FormAttachment(this.middle, 0);
        fdlNoExecution.top = new FormAttachment((Control)lastControl, this.margin);
        wlNoExecution.setLayoutData((Object)fdlNoExecution);
        this.wNoExecution = new Button(this.wOptionsComp, 32);
        this.props.setLook((Control)this.wNoExecution);
        FormData fdNoExecution = new FormData();
        fdNoExecution.left = new FormAttachment(this.middle, this.margin);
        fdNoExecution.top = new FormAttachment((Control)lastControl, this.margin);
        fdNoExecution.right = new FormAttachment(100, 0);
        this.wNoExecution.setLayoutData((Object)fdNoExecution);
        lastControl = this.wNoExecution;
        this.wlStreamingSourceStep = new Label(this.wOptionsComp, 131072);
        this.wlStreamingSourceStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingSourceStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStreamingSourceStep);
        FormData fdlStreamingSourceStep = new FormData();
        fdlStreamingSourceStep.left = new FormAttachment(0, 0);
        fdlStreamingSourceStep.right = new FormAttachment(this.middle, 0);
        fdlStreamingSourceStep.top = new FormAttachment((Control)lastControl, this.margin);
        this.wlStreamingSourceStep.setLayoutData((Object)fdlStreamingSourceStep);
        this.wStreamingSourceStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wStreamingSourceStep);
        FormData fdStreamingSourceStep = new FormData();
        fdStreamingSourceStep.left = new FormAttachment(this.middle, this.margin);
        fdStreamingSourceStep.top = new FormAttachment((Control)lastControl, this.margin);
        fdStreamingSourceStep.right = new FormAttachment(100, 0);
        this.wStreamingSourceStep.setLayoutData((Object)fdStreamingSourceStep);
        this.wStreamingSourceStep.setItems(this.transMeta.getStepNames());
        this.wStreamingSourceStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MetaInjectDialog.this.setActive();
            }
        });
        lastControl = this.wStreamingSourceStep;
        this.wlStreamingTargetStep = new Label(this.wOptionsComp, 131072);
        this.wlStreamingTargetStep.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingTargetStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStreamingTargetStep);
        FormData fdlStreamingTargetStep = new FormData();
        fdlStreamingTargetStep.left = new FormAttachment(0, 0);
        fdlStreamingTargetStep.right = new FormAttachment(this.middle, 0);
        fdlStreamingTargetStep.top = new FormAttachment((Control)lastControl, this.margin);
        this.wlStreamingTargetStep.setLayoutData((Object)fdlStreamingTargetStep);
        this.wStreamingTargetStep = new CCombo(this.wOptionsComp, 18436);
        this.props.setLook((Control)this.wStreamingTargetStep);
        FormData fdStreamingTargetStep = new FormData();
        fdStreamingTargetStep.left = new FormAttachment(this.middle, this.margin);
        fdStreamingTargetStep.top = new FormAttachment((Control)lastControl, this.margin);
        fdStreamingTargetStep.right = new FormAttachment(100, 0);
        this.wStreamingTargetStep.setLayoutData((Object)fdStreamingTargetStep);
        lastControl = this.wStreamingTargetStep;
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        fdOptionsComp.bottom = new FormAttachment(100, 0);
        this.wOptionsComp.setLayoutData((Object)fdOptionsComp);
        this.wOptionsComp.pack();
        Rectangle bounds = this.wOptionsComp.getBounds();
        this.wOptionsSComp.setContent((Control)this.wOptionsComp);
        this.wOptionsSComp.setExpandHorizontal(true);
        this.wOptionsSComp.setExpandVertical(true);
        this.wOptionsSComp.setMinWidth(bounds.width);
        this.wOptionsSComp.setMinHeight(bounds.height);
        this.wOptionsTab.setControl((Control)this.wOptionsSComp);
    }

    private void addInjectTab() {
        this.wInjectTab = new CTabItem(this.wTabFolder, 0);
        this.wInjectTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.TabTitle", (String[])new String[0]));
        this.wInjectSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        this.wInjectSComp.setLayout((Layout)new FillLayout());
        this.wInjectComp = new Composite((Composite)this.wInjectSComp, 0);
        this.props.setLook((Control)this.wInjectComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wInjectComp.setLayout((Layout)fileLayout);
        this.wTree = new Tree(this.wInjectComp, 68356);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.TargetStep", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.TargetDescription", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceStep", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceField", (String[])new String[0]), 2, false, true)};
        this.wTree.setHeaderVisible(true);
        for (int i = 0; i < colinf.length; ++i) {
            ColumnInfo columnInfo = colinf[i];
            TreeColumn treeColumn = new TreeColumn(this.wTree, columnInfo.getAllignement());
            treeColumn.setText(columnInfo.getName());
            treeColumn.setWidth(200);
        }
        this.wTree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    TargetStepAttribute target;
                    Point point = new Point(event.x, event.y);
                    TreeItem item = MetaInjectDialog.this.wTree.getItem(point);
                    if (item != null && (target = (TargetStepAttribute)MetaInjectDialog.this.treeItemTargetMap.get(item)) != null) {
                        String selectedStepField;
                        String key;
                        int index;
                        SourceStepField source = (SourceStepField)MetaInjectDialog.this.targetSourceMapping.get(target);
                        Object[] prevStepNames = MetaInjectDialog.this.transMeta.getPrevStepNames(MetaInjectDialog.this.stepMeta);
                        Arrays.sort(prevStepNames);
                        HashMap<String, SourceStepField> fieldMap = new HashMap<String, SourceStepField>();
                        for (Object prevStepName : prevStepNames) {
                            RowMetaInterface fields = MetaInjectDialog.this.transMeta.getStepFields((String)prevStepName);
                            for (ValueMetaInterface field : fields.getValueMetaList()) {
                                String key2 = MetaInjectDialog.this.buildStepFieldKey((String)prevStepName, field.getName());
                                fieldMap.put(key2, new SourceStepField((String)prevStepName, field.getName()));
                            }
                        }
                        Object[] sourceFields = fieldMap.keySet().toArray(new String[fieldMap.size()]);
                        Arrays.sort(sourceFields);
                        EnterSelectionDialog selectSourceField = new EnterSelectionDialog(MetaInjectDialog.this.shell, (String[])sourceFields, "Select source field", "Select the source field (cancel=clear)");
                        if (source != null && !Utils.isEmpty((CharSequence)source.getStepname()) && (index = Const.indexOfString((String)(key = MetaInjectDialog.this.buildStepFieldKey(source.getStepname(), source.getField())), (String[])sourceFields)) >= 0) {
                            selectSourceField.setSelectedNrs(new int[]{index});
                        }
                        if ((selectedStepField = selectSourceField.open()) != null) {
                            SourceStepField newSource = (SourceStepField)fieldMap.get(selectedStepField);
                            item.setText(2, newSource.getStepname());
                            item.setText(3, newSource.getField());
                            MetaInjectDialog.this.targetSourceMapping.put(target, newSource);
                        } else {
                            item.setText(2, "");
                            item.setText(3, "");
                            MetaInjectDialog.this.targetSourceMapping.remove(target);
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(MetaInjectDialog.this.shell, "Oops", "Unexpected Error", e);
                }
            }
        });
        FormData fdInjectComp = new FormData();
        fdInjectComp.left = new FormAttachment(0, 0);
        fdInjectComp.top = new FormAttachment(0, 0);
        fdInjectComp.right = new FormAttachment(100, 0);
        fdInjectComp.bottom = new FormAttachment(100, 0);
        this.wInjectComp.setLayoutData((Object)fdInjectComp);
        this.wInjectComp.pack();
        Rectangle bounds = this.wInjectComp.getBounds();
        this.wInjectSComp.setContent((Control)this.wInjectComp);
        this.wInjectSComp.setExpandHorizontal(true);
        this.wInjectSComp.setExpandVertical(true);
        this.wInjectSComp.setMinWidth(bounds.width);
        this.wInjectSComp.setMinHeight(bounds.height);
        this.wInjectTab.setControl((Control)this.wInjectSComp);
    }

    protected void selectTransformationByReference() {
        if (this.repository != null) {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository, true, false);
            sod.open();
            RepositoryElementMetaInterface repositoryObject = sod.getRepositoryObject();
            if (repositoryObject != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                this.getByReferenceData(repositoryObject);
                this.referenceObjectId = repositoryObject.getObjectId();
                this.setRadioButtons();
            }
        }
    }

    private void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                this.wFilename.setText("");
                this.wTransname.setText(this.injectTransMeta.getName());
                this.wDirectory.setText(this.injectTransMeta.getRepositoryDirectory().getPath());
                this.radioByName.setSelection(true);
                this.radioFilename.setSelection(false);
                this.validateTrans();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.injectTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.injectTransMeta.clearChanged();
    }

    private void selectFileTrans(boolean useVfs) {
        String curFile = this.wFilename.getText();
        if (useVfs) {
            FileObject root = null;
            try {
                root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
                VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
                FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
                if (file == null) {
                    return;
                }
                String fname = null;
                fname = file.getURL().getFile();
                if (fname != null) {
                    this.loadFileTrans(fname);
                    this.wFilename.setText(this.injectTransMeta.getFilename());
                    this.wTransname.setText(Const.NVL((String)this.injectTransMeta.getName(), (String)""));
                    this.wDirectory.setText("");
                    this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                    this.setRadioButtons();
                }
            }
            catch (IOException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)e);
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
            }
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.injectTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.injectTransMeta.clearChanged();
    }

    private void editTrans() {
        try {
            this.loadTransformation();
            SpoonInterface spoon = SpoonFactory.getInstance();
            if (spoon != null) {
                spoon.addTransGraph(this.injectTransMeta);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorShowingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorShowingTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void validateTrans() {
        try {
            this.loadTransformation();
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorValidatingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorValidatingTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private boolean loadTransformation() throws KettleException {
        switch (this.specificationMethod) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)this.wFilename.getText())) {
                    return false;
                }
                this.loadFileTrans(this.wFilename.getText());
                break;
            }
            case REPOSITORY_BY_NAME: {
                if (Utils.isEmpty((CharSequence)this.wDirectory.getText()) && Utils.isEmpty((CharSequence)this.wTransname.getText())) {
                    return false;
                }
                String realDirectory = this.transMeta.environmentSubstitute(this.wDirectory.getText());
                String realTransname = this.transMeta.environmentSubstitute(this.wTransname.getText());
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                if (this.referenceObjectId == null) {
                    return false;
                }
                this.injectTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.injectTransMeta.clearChanged();
                break;
            }
        }
        return true;
    }

    public void setActive() {
        boolean supportsReferences = this.repository != null && this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences();
        this.radioByName.setEnabled(this.repository != null);
        this.radioByReference.setEnabled(this.repository != null && supportsReferences);
        this.wFilename.setEnabled(this.radioFilename.getSelection());
        this.wTransname.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wDirectory.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wbTrans.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
        this.wbByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
        boolean outputCapture = !Utils.isEmpty((CharSequence)this.wSourceStep.getText());
        this.wlSourceFields.setEnabled(outputCapture);
        this.wSourceFields.setEnabled(outputCapture);
        boolean streaming = !Utils.isEmpty((CharSequence)this.wStreamingSourceStep.getText());
        this.wStreamingTargetStep.setEnabled(streaming);
        this.wlStreamingTargetStep.setEnabled(streaming);
    }

    protected void setRadioButtons() {
        this.radioFilename.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.FILENAME);
        this.radioByName.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.radioByReference.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.setActive();
    }

    private void getByReferenceData(RepositoryElementMetaInterface transInf) {
        String path = transInf.getRepositoryDirectory().getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + transInf.getName();
        this.wByReference.setText(path);
    }

    public void getData() {
        this.specificationMethod = this.metaInjectMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wFilename.setText(Const.NVL((String)this.metaInjectMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.wDirectory.setText(Const.NVL((String)this.metaInjectMeta.getDirectoryPath(), (String)""));
                this.wTransname.setText(Const.NVL((String)this.metaInjectMeta.getTransName(), (String)""));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.metaInjectMeta.getTransObjectId();
                this.wByReference.setText("");
                if (this.referenceObjectId == null) break;
                try {
                    RepositoryObject transInf = this.repository.getObjectInformation(this.metaInjectMeta.getTransObjectId(), RepositoryObjectType.TRANSFORMATION);
                    if (transInf == null) break;
                    this.getByReferenceData((RepositoryElementMetaInterface)transInf);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
                }
                break;
            }
        }
        this.wSourceStep.setText(Const.NVL((String)this.metaInjectMeta.getSourceStepName(), (String)""));
        int rownr = 0;
        for (MetaInjectOutputField field : this.metaInjectMeta.getSourceOutputFields()) {
            int colnr = 1;
            this.wSourceFields.setText(field.getName(), colnr++, rownr);
            this.wSourceFields.setText(field.getTypeDescription(), colnr++, rownr);
            this.wSourceFields.setText(field.getLength() < 0 ? "" : Integer.toString(field.getLength()), colnr++, rownr);
            this.wSourceFields.setText(field.getPrecision() < 0 ? "" : Integer.toString(field.getPrecision()), colnr++, rownr);
            ++rownr;
        }
        this.wTargetFile.setText(Const.NVL((String)this.metaInjectMeta.getTargetFile(), (String)""));
        this.wNoExecution.setSelection(this.metaInjectMeta.isNoExecution());
        this.wStreamingSourceStep.setText(Const.NVL(this.metaInjectMeta.getStreamSourceStep() == null ? null : this.metaInjectMeta.getStreamSourceStep().getName(), (String)""));
        this.wStreamingTargetStep.setText(Const.NVL((String)this.metaInjectMeta.getStreamTargetStepname(), (String)""));
        this.setRadioButtons();
        this.refreshTree();
        this.wTabFolder.setSelection(0);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected String buildStepFieldKey(String stepname, String field) {
        return stepname + " : " + field;
    }

    private void refreshTree() {
        try {
            this.loadTransformation();
            this.treeItemTargetMap = new HashMap<TreeItem, TargetStepAttribute>();
            this.wTree.removeAll();
            TreeItem transItem = new TreeItem(this.wTree, 0);
            transItem.setExpanded(true);
            transItem.setText(this.injectTransMeta.getName());
            ArrayList<StepMeta> injectSteps = new ArrayList<StepMeta>();
            for (StepMeta stepMeta : this.injectTransMeta.getUsedSteps()) {
                StepMetaInterface meta = stepMeta.getStepMetaInterface();
                if (meta.getStepMetaInjectionInterface() == null && !BeanInjectionInfo.isInjectionSupported(meta.getClass())) continue;
                injectSteps.add(stepMeta);
            }
            Collections.sort(injectSteps);
            for (StepMeta stepMeta : injectSteps) {
                TreeItem stepItem = new TreeItem(transItem, 0);
                stepItem.setText(stepMeta.getName());
                stepItem.setExpanded(true);
                StepMetaInterface metaInterface = stepMeta.getStepMetaInterface();
                if (BeanInjectionInfo.isInjectionSupported(metaInterface.getClass())) {
                    this.processNewMDIDescription(stepMeta, stepItem, metaInterface);
                    continue;
                }
                this.processOldMDIDescription(stepMeta, stepItem, metaInterface.getStepMetaInjectionInterface());
            }
        }
        catch (Throwable transItem) {
            // empty catch block
        }
        for (TreeItem item : this.wTree.getItems()) {
            this.expandItemAndChildren(item);
        }
        if (this.injectTransMeta != null) {
            Object[] sourceSteps = this.injectTransMeta.getStepNames();
            Arrays.sort(sourceSteps);
            this.wSourceStep.setItems((String[])sourceSteps);
            this.wStreamingTargetStep.setItems((String[])sourceSteps);
        }
    }

    private void processOldMDIDescription(StepMeta stepMeta, TreeItem stepItem, StepMetaInjectionInterface injection) throws KettleException {
        List entries = injection.getStepInjectionMetadataEntries();
        for (final StepInjectionMetaEntry entry : entries) {
            if (entry.getValueType() != 0) {
                TreeItem entryItem = new TreeItem(stepItem, 0);
                entryItem.setText(entry.getKey());
                entryItem.setText(1, entry.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), entry.getKey(), false);
                this.treeItemTargetMap.put(entryItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                entryItem.setText(2, Const.NVL((String)source.getStepname(), (String)""));
                entryItem.setText(3, Const.NVL((String)source.getField(), (String)""));
                continue;
            }
            TreeItem listsItem = new TreeItem(stepItem, 0);
            listsItem.setText(entry.getKey());
            listsItem.setText(1, entry.getDescription());
            StepInjectionMetaEntry listEntry = (StepInjectionMetaEntry)entry.getDetails().get(0);
            listsItem.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    System.out.println(entry.getKey() + " - " + entry.getDescription());
                }
            });
            for (StepInjectionMetaEntry me : listEntry.getDetails()) {
                TreeItem treeItem = new TreeItem(listsItem, 0);
                treeItem.setText(me.getKey());
                treeItem.setText(1, me.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), me.getKey(), true);
                this.treeItemTargetMap.put(treeItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                treeItem.setText(2, Const.NVL((String)source.getStepname(), (String)""));
                treeItem.setText(3, Const.NVL((String)source.getField(), (String)""));
            }
        }
    }

    private void processNewMDIDescription(StepMeta stepMeta, TreeItem stepItem, StepMetaInterface metaInterface) {
        BeanInjectionInfo stepInjectionInfo = new BeanInjectionInfo(metaInterface.getClass());
        for (BeanInjectionInfo.Group gr : stepInjectionInfo.getGroups()) {
            TreeItem groupItem;
            boolean rootGroup = StringUtils.isEmpty((String)gr.getName());
            if (!rootGroup) {
                groupItem = new TreeItem(stepItem, 0);
                groupItem.setText(gr.getName());
                groupItem.setText(1, gr.getDescription());
            } else {
                groupItem = null;
            }
            for (BeanInjectionInfo.Property property : gr.getGroupProperties()) {
                TreeItem treeItem = new TreeItem(rootGroup ? stepItem : groupItem, 0);
                treeItem.setText(property.getName());
                treeItem.setText(1, property.getDescription());
                TargetStepAttribute target = new TargetStepAttribute(stepMeta.getName(), property.getName(), !rootGroup);
                this.treeItemTargetMap.put(treeItem, target);
                SourceStepField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                treeItem.setText(2, Const.NVL((String)source.getStepname(), (String)""));
                treeItem.setText(3, Const.NVL((String)source.getField(), (String)""));
            }
        }
    }

    private void expandItemAndChildren(TreeItem item) {
        item.setExpanded(true);
        for (TreeItem item2 : item.getItems()) {
            this.expandItemAndChildren(item2);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.metaInjectMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.metaInjectMeta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                this.metaInjectMeta.setFileName(this.wFilename.getText());
                this.metaInjectMeta.setDirectoryPath(null);
                this.metaInjectMeta.setTransName(null);
                this.metaInjectMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.metaInjectMeta.setDirectoryPath(this.wDirectory.getText());
                this.metaInjectMeta.setTransName(this.wTransname.getText());
                this.metaInjectMeta.setFileName(null);
                this.metaInjectMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.metaInjectMeta.setFileName(null);
                this.metaInjectMeta.setDirectoryPath(null);
                this.metaInjectMeta.setTransName(null);
                this.metaInjectMeta.setTransObjectId(this.referenceObjectId);
                break;
            }
        }
        this.metaInjectMeta.setSourceStepName(this.wSourceStep.getText());
        this.metaInjectMeta.setSourceOutputFields(new ArrayList<MetaInjectOutputField>());
        for (int i = 0; i < this.wSourceFields.nrNonEmpty(); ++i) {
            TableItem item = this.wSourceFields.getNonEmpty(i);
            int colIndex = 1;
            String name = item.getText(colIndex++);
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(colIndex++));
            int length = Const.toInt((String)item.getText(colIndex++), (int)-1);
            int precision = Const.toInt((String)item.getText(colIndex++), (int)-1);
            this.metaInjectMeta.getSourceOutputFields().add(new MetaInjectOutputField(name, type, length, precision));
        }
        this.metaInjectMeta.setTargetFile(this.wTargetFile.getText());
        this.metaInjectMeta.setNoExecution(this.wNoExecution.getSelection());
        this.metaInjectMeta.setStreamSourceStep(this.transMeta.findStep(this.wStreamingSourceStep.getText()));
        this.metaInjectMeta.setStreamTargetStepname(this.wStreamingTargetStep.getText());
        this.metaInjectMeta.setTargetSourceMapping(this.targetSourceMapping);
        this.metaInjectMeta.setChanged(true);
        this.dispose();
    }

    protected void newTransformation() {
        TransMeta newTransMeta = new TransMeta();
        newTransMeta.getDatabases().addAll(this.transMeta.getDatabases());
        newTransMeta.setRepository(this.transMeta.getRepository());
        newTransMeta.setRepositoryDirectory(this.transMeta.getRepositoryDirectory());
        newTransMeta.setUsingUniqueConnections(this.transMeta.isUsingUniqueConnections());
        TransDialog transDialog = new TransDialog(this.shell, 0, newTransMeta, this.repository);
        if (transDialog.open() != null) {
            Spoon spoon = Spoon.getInstance();
            spoon.addTransGraph(newTransMeta);
            boolean saved = false;
            try {
                if (this.repository != null) {
                    if (!Utils.isEmpty((CharSequence)newTransMeta.getName())) {
                        this.wStepname.setText(newTransMeta.getName());
                    }
                    saved = spoon.saveToRepository((EngineMetaInterface)newTransMeta, false);
                    this.specificationMethod = this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences() ? ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE : ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                } else {
                    saved = spoon.saveToFile((EngineMetaInterface)newTransMeta);
                    this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error saving new transformation", e);
            }
            if (saved) {
                this.setRadioButtons();
                switch (this.specificationMethod) {
                    case FILENAME: {
                        this.wFilename.setText(Const.NVL((String)newTransMeta.getFilename(), (String)""));
                        break;
                    }
                    case REPOSITORY_BY_NAME: {
                        this.wTransname.setText(Const.NVL((String)newTransMeta.getName(), (String)""));
                        this.wDirectory.setText(newTransMeta.getRepositoryDirectory().getPath());
                        break;
                    }
                    case REPOSITORY_BY_REFERENCE: {
                        this.getByReferenceData(newTransMeta.getObjectId());
                        break;
                    }
                }
            }
        }
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.JOB);
            if (transInf != null) {
                this.getByReferenceData((RepositoryElementMetaInterface)transInf);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

