/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.server.FileRepository;
import mondrian.server.ImplicitRepository;
import mondrian.server.MondrianServerImpl;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.IdentityCatalogLocator;
import mondrian.util.LockBox;
import org.apache.log4j.Logger;

public class MondrianServerRegistry {
    public static final Logger logger = Logger.getLogger(MondrianServerRegistry.class);
    public static final MondrianServerRegistry INSTANCE = new MondrianServerRegistry();
    final LockBox lockBox = new LockBox();
    final MondrianServer staticServer = this.createWithRepository(null, null);

    public MondrianServer serverForId(String instanceId) {
        if (instanceId != null) {
            LockBox.Entry entry = this.lockBox.get(instanceId);
            if (entry == null) {
                throw Util.newError("No server instance has id '" + instanceId + "'");
            }
            return (MondrianServer)entry.getValue();
        }
        return this.staticServer;
    }

    public String getCopyrightYear() {
        return "2016";
    }

    public String getProductVersion() {
        return "3.13.0.0-25";
    }

    public MondrianServer.MondrianVersion getVersion() {
        StringBuilder sb;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" Vendor: Pentaho");
                String title = "mondrian";
                logger.debug((Object)"  Title: mondrian");
                String versionString = "3.13.0.0-25";
                logger.debug((Object)"Version: 3.13.0.0-25");
                int majorVersion = 3;
                logger.debug((Object)String.format("Major Version: %d", 3));
                int minorVersion = 130025;
                logger.debug((Object)String.format("Minor Version: %d", 130025));
            }
            sb = new StringBuilder();
            try {
                Integer.parseInt("3.13.0.0-25");
                sb.append("3.13.0.0-25");
            }
            catch (NumberFormatException e) {
                String versionMajor = String.valueOf(3);
                String versionMinor = String.valueOf(130025);
                if (versionMajor != null) {
                    sb.append(versionMajor);
                }
                if (versionMinor == null) break block4;
                sb.append(".").append(versionMinor);
            }
        }
        return new MondrianServer.MondrianVersion(){

            @Override
            public String getVersionString() {
                return sb.toString();
            }

            @Override
            public String getProductName() {
                return "mondrian";
            }

            @Override
            public int getMinorVersion() {
                return 130025;
            }

            @Override
            public int getMajorVersion() {
                return 3;
            }
        };
    }

    public MondrianServer createWithRepository(RepositoryContentFinder contentFinder, CatalogLocator catalogLocator) {
        Repository repository;
        if (catalogLocator == null) {
            catalogLocator = new IdentityCatalogLocator();
        }
        if (contentFinder == null) {
            if (this.staticServer != null) {
                return this.staticServer;
            }
            repository = new ImplicitRepository();
        } else {
            repository = new FileRepository(contentFinder, catalogLocator);
        }
        return new MondrianServerImpl(this, repository, catalogLocator);
    }
}

