/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.util.ArrayList;
import java.util.List;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentHeader;

public interface SegmentCache {
    public SegmentBody get(SegmentHeader var1);

    public List<SegmentHeader> getSegmentHeaders();

    public boolean put(SegmentHeader var1, SegmentBody var2);

    public boolean remove(SegmentHeader var1);

    public void tearDown();

    public void addListener(SegmentCacheListener var1);

    public void removeListener(SegmentCacheListener var1);

    public boolean supportsRichIndex();

    public static class SegmentCacheInjector {
        private static final List<SegmentCache> caches = new ArrayList<SegmentCache>();

        public static void addCache(SegmentCache cache) {
            caches.add(cache);
        }

        public static List<SegmentCache> getCaches() {
            return caches;
        }
    }

    public static interface SegmentCacheListener {
        public void handle(SegmentCacheEvent var1);

        public static interface SegmentCacheEvent {
            public EventType getEventType();

            public SegmentHeader getSource();

            public boolean isLocal();

            public static enum EventType {
                ENTRY_CREATED,
                ENTRY_DELETED;

            }
        }
    }
}

